/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.model.vo.TableCellObj;
import com.security.ireport.model.vo.TableObj;
import com.security.ireport.model.vo.group.TableCellNode;
import com.security.ireport.util.IReportConfigUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class CsvZipExporter {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final String TOKEN = ",";
    private static final String NEWLINE = "\n";
    private static final int MAXROW = 65535;
    private static final String SEPARATOR = "_";
    private static final String EXTENTION = ".csv";
    private int rowCount = 1;
    private int entrySuffix = 0;
    private ZipOutputStream gOut;
    private String charSet = "utf-8";
    private Map<String, List<String>> nameMap = new HashMap<String, List<String>>();

    public CsvZipExporter(OutputStream outStream, List<ReportSession> reportSessList) throws ProviderException {
        try {
            this.gOut = new ZipOutputStream(outStream);
            this.gOut.setEncoding(this.charSet);
            int pgSize = IReportConfigUtil.getInstance().getExportPageSize();
            for (int i = 0; i < reportSessList.size(); ++i) {
                ReportSession rsession = reportSessList.get(i);
                IReport report = reportSessList.get(i).getIReport();
                this.exportTable(rsession, report, pgSize);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"CsvZipExporter export Csv failed IOException");
            throw new ProviderException(e);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"CsvZipExporter export Csv failed RuntimeException");
            throw new ProviderException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error((Object)"close error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvZipExporter(List<TableObj> tabObjList, OutputStream outStream) throws IOException {
        try {
            this.gOut = new ZipOutputStream(outStream);
            this.gOut.setEncoding(this.charSet);
            for (int i = 0; i < tabObjList.size(); ++i) {
                this.put(tabObjList.get(i));
            }
        }
        finally {
            this.close();
        }
    }

    private void exportTable(ReportSession rsession, IReport report, int pgSize) throws IOException, ProviderException {
        List<IRTable> tableList = report.getIRTableList(rsession.getSwitchOption());
        for (int j = 0; j < tableList.size(); ++j) {
            long allCount = rsession.getAllCount(tableList.get(j).getDataSource());
            long pageCount = allCount / (long)pgSize;
            if (allCount % (long)pgSize != 0L) {
                ++pageCount;
            }
            int pgIndex = 1;
            while ((long)pgIndex <= pageCount) {
                TableObj tableObj = ExportReport.getTabObjList(rsession, tableList.get(j), pgIndex, pgSize);
                if (tableList.get(j).getGroupNum() > 1) {
                    this.putGroup(tableObj, tableList.get(j).getGroupNum());
                } else {
                    this.put(tableObj);
                }
                ++pgIndex;
            }
        }
    }

    private void putGroup(TableObj tableObj, int num) throws IOException {
        List<TableCellNode> tableCellNodeList;
        if (1 == this.rowCount) {
            this.newEntry(tableObj);
        }
        if (null == (tableCellNodeList = tableObj.getGroupTableCellNodeList()) || tableCellNodeList.isEmpty()) {
            return;
        }
        this.fillExportDataByGroup(tableCellNodeList, tableObj, new StringBuilder(), num, 0);
        this.rowCount = 1;
        this.entrySuffix = 0;
    }

    private boolean isListNotEmpty(List list) {
        return null != list && !list.isEmpty();
    }

    private void fillExportDataByGroup(List<TableCellNode> exportNodeList, TableObj tableObj, StringBuilder builder, int num, int currentIndex) throws IOException {
        List<Object> exportObjList = null;
        TableCellObj[] childObj = null;
        for (TableCellNode tempNode : exportNodeList) {
            exportObjList = tempNode.getExportObjList();
            if (this.isListNotEmpty(exportObjList)) {
                this.addTotalBarData(tableObj, builder, (Object[])exportObjList.get(0), tempNode, currentIndex);
                int tempNum = exportObjList.size();
                for (int index = 1; index < tempNum; ++index) {
                    if (this.rowCount > 65535) {
                        this.rowCount = 1;
                        this.newEntry(tableObj);
                    }
                    childObj = (TableCellObj[])exportObjList.get(index);
                    for (int i = 0; i < num; ++i) {
                        builder.append("").append(TOKEN);
                    }
                    for (TableCellObj tempCellObj : childObj) {
                        builder.append(new UnicodeString(AticUtil.htmlDecode((String)tempCellObj.getDataText()))).append(TOKEN);
                    }
                    this.addNewRowCount(builder);
                }
                continue;
            }
            if (!tableObj.isTotalBarDown() && null != tempNode.getTotalBarShowData()) {
                this.addTotalBarData(tableObj, builder, tempNode.getTotalBarShowData(), tempNode, currentIndex);
            }
            this.fillExportDataByGroup(tempNode.getChildNodeList(), tableObj, builder, num, currentIndex + 1);
            if (!tableObj.isTotalBarDown() || null == tempNode.getTotalBarShowData()) continue;
            this.addTotalBarData(tableObj, builder, tempNode.getTotalBarShowData(), tempNode, currentIndex);
        }
    }

    private void addTotalBarData(TableObj tableObj, StringBuilder builder, Object[] childObj, TableCellNode tableCellNode, int currentIndex) throws IOException {
        if (this.rowCount > 65535) {
            this.rowCount = 1;
            this.newEntry(tableObj);
        }
        TableCellNode parent = tableCellNode;
        int tempIndex = currentIndex;
        while (null != parent) {
            if (parent.isHasRowspan()) {
                for (int index = 0; index < tempIndex + 1; ++index) {
                    builder.insert(0, TOKEN).insert(0, "");
                }
                break;
            }
            parent.setHasRowspan(Boolean.TRUE);
            builder.insert(0, TOKEN).insert(0, new UnicodeString(AticUtil.htmlDecode((String)parent.getDataText())));
            parent = (TableCellNode)parent.getParent();
            --tempIndex;
        }
        for (Object tempCellObj : childObj) {
            builder.append(new UnicodeString(String.valueOf(tempCellObj))).append(TOKEN);
        }
        this.addNewRowCount(builder);
    }

    private void addNewRowCount(StringBuilder builder) throws IOException {
        builder.deleteCharAt(builder.length() - 1);
        builder.append(NEWLINE);
        this.gOut.write(builder.toString().getBytes(this.charSet));
        ++this.rowCount;
        builder.delete(0, builder.length());
    }

    private void put(TableObj tableObj) throws IOException {
        if (1 == this.rowCount) {
            this.newEntry(tableObj);
        }
        if (null == tableObj.getCellOjbListMap() || tableObj.getCellOjbListMap().isEmpty()) {
            return;
        }
        List<TableCellObj[]> dataset = null;
        Collection<String> groupKeys = tableObj.getCellOjbListMap().keySet();
        if (null != tableObj.getGroupKeyList() && tableObj.getGroupKeyList().size() > 0) {
            groupKeys = tableObj.getGroupKeyList();
        }
        for (String key : groupKeys) {
            dataset = tableObj.getCellOjbListMap().get(key);
            for (int i = 0; i < dataset.size(); ++i) {
                if (this.rowCount > 65535) {
                    this.rowCount = 1;
                    this.newEntry(tableObj);
                }
                this.gOut.write(this.getTableLine(dataset, i));
                ++this.rowCount;
            }
        }
        this.rowCount = 1;
        this.entrySuffix = 0;
    }

    private void close() throws IOException {
        this.gOut.flush();
        this.gOut.close();
    }

    private void newEntry(TableObj tableObj) throws IOException {
        String entryName = tableObj.getTitle() + SEPARATOR + this.entrySuffix;
        if (this.nameMap.containsKey(entryName)) {
            String tempName = entryName;
            entryName = entryName + "(" + this.nameMap.get(tempName).size() + ")";
            this.nameMap.get(tempName).add(entryName);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(entryName);
            this.nameMap.put(entryName, list);
        }
        this.gOut.putNextEntry(new ZipEntry(entryName + EXTENTION));
        this.gOut.write(new byte[]{-17, -69, -65});
        ++this.entrySuffix;
        this.gOut.write(this.getTableHeader(tableObj));
        ++this.rowCount;
    }

    private byte[] getTableHeader(TableObj tableObj) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer();
        List<IRColumn> columns = tableObj.getColumnList();
        if (!columns.isEmpty()) {
            for (IRColumn column : columns) {
                header.append(new UnicodeString(column.getHeader())).append(TOKEN);
            }
            header.deleteCharAt(header.length() - 1);
            header.append(NEWLINE);
        }
        return header.toString().getBytes(this.charSet);
    }

    private byte[] getTableLine(List<TableCellObj[]> dataset, int line) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer();
        if (dataset != null && !dataset.isEmpty()) {
            for (TableCellObj value : dataset.get(line)) {
                header.append(new UnicodeString(AticUtil.htmlDecode((String)value.toString()))).append(TOKEN);
            }
            header.deleteCharAt(header.length() - 1);
            header.append(NEWLINE);
        }
        return header.toString().getBytes(this.charSet);
    }
}

