/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.security.ireport.util.LocaleUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DateUtil {
    public static final String LAST_DST_RANGE_START = "start";
    public static final String LAST_DST_RANGE_END = "end";
    public static final String DAY_OF_WEEK = "dayOfWeek";
    public static final String SECOND = "second";
    public static final String MINUTE = "minute";
    public static final String HOUR = "hour";
    public static final String DAY = "day";
    public static final String MONTH = "month";
    public static final String YEAR = "year";
    private static final long D_1000_L = 1000L;
    private static Log log = LogFactory.getLog(DateUtil.class);
    private static final String TIME_PATTERN = "HH:mm";
    private static Map<String, Long> rs = null;
    private static Map<String, Long> rsEx = null;
    private static long intoDstTime = -1L;

    private DateUtil() {
    }

    public static Calendar getLocalCalendar() {
        TimeZone timeZone = TimeZone.getDefault();
        Locale locale = Locale.getDefault();
        return Calendar.getInstance(timeZone, locale);
    }

    public static boolean isDST() {
        boolean flag = true;
        Calendar cal = null;
        cal = DateUtil.getLocalCalendar();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        long localTime = cal.getTimeInMillis();
        cal.add(14, -(zoneOffset + dstOffset));
        if ((long)zoneOffset == localTime - cal.getTimeInMillis()) {
            flag = false;
        }
        return flag;
    }

    public static boolean isDST(long utcTime) {
        boolean flag = true;
        Calendar cal = null;
        cal = DateUtil.getLocalCalendar();
        cal.setTimeInMillis(utcTime * 1000L);
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        long localTimeTemp = cal.getTimeInMillis();
        cal.add(14, -(zoneOffset + dstOffset));
        if ((long)zoneOffset == localTimeTemp - cal.getTimeInMillis()) {
            flag = false;
        }
        return flag;
    }

    public static boolean isDST(Calendar cal) {
        Calendar calTmp = (Calendar)cal.clone();
        boolean flag = true;
        int zoneOffset = calTmp.get(15);
        int dstOffset = calTmp.get(16);
        long localTime = calTmp.getTimeInMillis();
        calTmp.add(14, -(zoneOffset + dstOffset));
        if ((long)zoneOffset == localTime - calTmp.getTimeInMillis()) {
            flag = false;
        }
        return flag;
    }

    public static String getDSTString(Long utcTime) {
        String strTime = null;
        if (null == utcTime) {
            strTime = "";
        } else {
            String dstFlag = " DST";
            Date date = null;
            date = new Date();
            date.setTime(utcTime * 1000L);
            strTime = DateUtil.getDateTime("yyyy-MM-dd HH:mm:ss", date);
            if (DateUtil.isDST(utcTime)) {
                strTime = strTime + " DST";
            }
        }
        return strTime;
    }

    public static String getDSTString(Date date) {
        String strTime = null;
        String dstFlag = " DST";
        Calendar cal = null;
        cal = DateUtil.getLocalCalendar();
        cal.setTime((Date)date.clone());
        strTime = DateUtil.getDateTime("yyyy-MM-dd HH:mm:ss", cal.getTime());
        if (DateUtil.isDST(cal)) {
            strTime = strTime + " DST";
        }
        return strTime;
    }

    public static Map<String, Integer> getUTCTime(Calendar cal) {
        HashMap<String, Integer> hs = new HashMap<String, Integer>();
        int year = DateUtil.getUTCYear(cal);
        int month = DateUtil.getUTCMonth(cal);
        int day = DateUtil.getUTCDay(cal);
        int hour = DateUtil.getUTCHour(cal);
        int minute = DateUtil.getUTCMinute(cal);
        int second = cal.get(13);
        int dayOfWeek = DateUtil.getUTCDayOfWeek(cal);
        hs.put(YEAR, year);
        hs.put(MONTH, month);
        hs.put(DAY, day);
        hs.put(HOUR, hour);
        hs.put(MINUTE, minute);
        hs.put(SECOND, second);
        hs.put(DAY_OF_WEEK, dayOfWeek);
        return hs;
    }

    public static Calendar getUTCCalendar(Calendar localeCalendar) {
        Calendar calendar = (Calendar)localeCalendar.clone();
        Map<String, Integer> utcTime = DateUtil.getUTCTime(calendar);
        calendar.set(1, utcTime.get(YEAR));
        calendar.set(2, utcTime.get(MONTH) - 1);
        calendar.set(5, utcTime.get(DAY));
        calendar.set(11, utcTime.get(HOUR));
        calendar.set(12, utcTime.get(MINUTE));
        calendar.set(13, utcTime.get(SECOND));
        return calendar;
    }

    public static Calendar getUTCCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public static int getUTCHour(Calendar cal) {
        int hourTemp = 0;
        int flag = 86400;
        int zoneOffset = cal.get(15) / 1000;
        int dstOffset = cal.get(16) / 1000;
        int hour = cal.get(11) * 3600;
        hourTemp = hour - (zoneOffset + dstOffset);
        if (hourTemp < 0) {
            hourTemp += 86400;
        } else if (hourTemp > 86400) {
            hourTemp -= 86400;
        } else if (hourTemp == 86400) {
            hourTemp = 0;
        }
        return hourTemp / 60 / 60;
    }

    public static int getUTCMinute(Calendar cal) {
        int flag = 3600;
        int dstOffset = cal.get(16) / 1000;
        int minute = 0;
        minute = cal.get(12) * 60;
        if ((minute -= dstOffset) < 0) {
            minute += 3600;
        } else if (minute > 3600) {
            minute -= 3600;
        } else if (minute == 3600) {
            minute = 0;
        }
        return minute / 60;
    }

    public static int getUTCDay(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        int hourTemp = 0;
        int flag = 86400;
        int day = 0;
        int zoneOffset = cal.get(15) / 1000;
        int dstOffset = cal.get(16) / 1000;
        int hour = cal.get(11) * 3600;
        hourTemp = hour - (zoneOffset + dstOffset);
        if (hourTemp < 0) {
            cal.add(5, -1);
            day = cal.get(5);
        } else if (hourTemp >= 86400) {
            cal.add(5, 1);
            day = cal.get(5);
        } else {
            day = cal.get(5);
        }
        return day;
    }

    public static int getUTCMonth(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        int hourTemp = 0;
        int flag = 86400;
        int monthNew = 0;
        int zoneOffset = cal.get(15) / 1000;
        int dstOffset = cal.get(16) / 1000;
        int hour = cal.get(11) * 3600;
        hourTemp = hour - (zoneOffset + dstOffset);
        if (hourTemp < 0) {
            cal.add(5, -1);
            monthNew = cal.get(2) + 1;
        } else if (hourTemp >= 86400) {
            cal.add(5, 1);
            monthNew = cal.get(2) + 1;
        } else {
            monthNew = cal.get(2) + 1;
        }
        return monthNew;
    }

    public static int getUTCYear(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        int hourTemp = 0;
        int flag = 86400;
        int year = 0;
        int zoneOffset = cal.get(15) / 1000;
        int dstOffset = cal.get(16) / 1000;
        int hour = cal.get(11) * 3600;
        hourTemp = hour - (zoneOffset + dstOffset);
        if (hourTemp < 0) {
            cal.add(5, -1);
            year = cal.get(1);
        } else if (hourTemp >= 86400) {
            cal.add(5, 1);
            year = cal.get(1);
        } else {
            year = cal.get(1);
        }
        return year;
    }

    public static int getUTCDayOfWeek(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        int hourTemp = 0;
        int flag = 86400;
        int day = cal.get(7);
        int zoneOffset = cal.get(15) / 1000;
        int dstOffset = cal.get(16) / 1000;
        int hour = cal.get(11) * 3600;
        hourTemp = hour - (zoneOffset + dstOffset);
        if (hourTemp < 0) {
            --day;
        } else if (hourTemp >= 86400) {
            ++day;
        }
        if (0 == day) {
            day = 7;
        } else if (8 == day) {
            day = 1;
        }
        return day;
    }

    public static String getDatePattern() {
        String defaultDatePattern;
        try {
            defaultDatePattern = LocaleUtil.getProperty("date.format");
        }
        catch (MissingResourceException mse) {
            defaultDatePattern = "MM/dd/yyyy";
            log.error((Object)"Failed to read resource key value. key='data.format'");
        }
        return defaultDatePattern;
    }

    public static String getDateTimePattern() {
        return DateUtil.getDatePattern() + " HH:mm:ss.S";
    }

    public static String getDate(Date aDate) {
        String returnValue = "";
        if (aDate != null) {
            SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static Date convertStringToDate(String aMask, String strDate) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(aMask);
        if (log.isDebugEnabled()) {
            log.debug((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
        }
        Date date = df.parse(strDate);
        return date;
    }

    public static String getTimeNow(Date theTime) {
        return DateUtil.getDateTime(TIME_PATTERN, theTime);
    }

    public static Calendar getToday() throws ParseException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
        String todayAsString = df.format(today);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.convertStringToDate(todayAsString));
        return cal;
    }

    public static String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static String convertDateToString(Date aDate) {
        return DateUtil.getDateTime(DateUtil.getDatePattern(), aDate);
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        Date aDate = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting date with pattern: " + DateUtil.getDatePattern()));
            }
            aDate = DateUtil.convertStringToDate(DateUtil.getDatePattern(), strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("Could not convert '" + strDate + "' to a date, throwing exception"));
            throw pe;
        }
        return aDate;
    }

    public static synchronized Map<String, Long> getLastDSTTimeInMillisRange() {
        if (null == rs) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, DateUtil.getLastDstMonth(calendar.get(1)));
            calendar.set(5, DateUtil.getLastDstDayOfMonth(calendar.get(1), calendar.get(2)));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Calendar endCal = (Calendar)calendar.clone();
            Calendar tmpCal = (Calendar)calendar.clone();
            endCal.add(5, 1);
            endCal.add(13, -1);
            boolean isDstTime = false;
            int dstOffset = 0;
            while (tmpCal.compareTo(endCal) <= 0) {
                if (tmpCal.get(16) != 0 && !isDstTime) {
                    dstOffset = tmpCal.get(16);
                    isDstTime = true;
                }
                if (isDstTime && tmpCal.get(16) == 0) break;
                tmpCal.add(13, 1);
            }
            rs = new HashMap<String, Long>();
            if (dstOffset == 0) {
                rs.put(LAST_DST_RANGE_START, 0L);
                rs.put(LAST_DST_RANGE_END, 0L);
                return rs;
            }
            rs.put(LAST_DST_RANGE_START, DateUtil.getIntoDstTime());
            rs.put(LAST_DST_RANGE_END, tmpCal.getTimeInMillis() - 1000L);
            return rs;
        }
        return rs;
    }

    public static synchronized Map<String, Long> getLastDSTTimeInMillisRangeEx() {
        if (null == rsEx) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, DateUtil.getLastDstMonth(calendar.get(1)));
            calendar.set(5, DateUtil.getLastDstDayOfMonth(calendar.get(1), calendar.get(2)));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Calendar endCal = (Calendar)calendar.clone();
            Calendar tmpCal = (Calendar)calendar.clone();
            endCal.add(5, 1);
            endCal.add(13, -1);
            boolean isDstTime = false;
            int dstOffset = 0;
            while (tmpCal.compareTo(endCal) <= 0) {
                if (tmpCal.get(16) != 0 && !isDstTime) {
                    dstOffset = tmpCal.get(16);
                    isDstTime = true;
                }
                if (isDstTime && tmpCal.get(16) == 0) break;
                tmpCal.add(13, 1);
            }
            rsEx = new HashMap<String, Long>();
            if (dstOffset == 0) {
                rsEx.put(LAST_DST_RANGE_START, 0L);
                rsEx.put(LAST_DST_RANGE_END, 0L);
                return rsEx;
            }
            rsEx.put(LAST_DST_RANGE_START, tmpCal.getTimeInMillis() - (long)dstOffset);
            rsEx.put(LAST_DST_RANGE_END, tmpCal.getTimeInMillis() - 1000L);
            return rsEx;
        }
        return rsEx;
    }

    public static int getLastDstMonth(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar tmpCal = (Calendar)calendar.clone();
        Calendar endCalendar = (Calendar)calendar.clone();
        endCalendar.add(1, 1);
        endCalendar.add(13, -1);
        boolean isDstTime = false;
        tmpCal.add(2, 1);
        tmpCal.add(13, -1);
        while (tmpCal.compareTo(endCalendar) <= 0) {
            if (tmpCal.get(16) != 0) {
                isDstTime = true;
            }
            if (tmpCal.get(16) == 0 && isDstTime) {
                return tmpCal.get(2);
            }
            tmpCal.add(13, 1);
            tmpCal.add(2, 1);
            tmpCal.add(13, -1);
        }
        return 0;
    }

    public static int getLastDstDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar tmpCal = (Calendar)calendar.clone();
        Calendar endCalendar = (Calendar)calendar.clone();
        endCalendar.add(2, 1);
        endCalendar.add(13, -1);
        boolean isDstTime = false;
        tmpCal.add(5, 1);
        tmpCal.add(13, -1);
        while (tmpCal.compareTo(endCalendar) <= 0) {
            if (tmpCal.get(16) != 0) {
                isDstTime = true;
            }
            if (tmpCal.get(16) == 0 && isDstTime) {
                return tmpCal.get(5);
            }
            tmpCal.add(13, 1);
            tmpCal.add(5, 1);
            tmpCal.add(13, -1);
        }
        return 1;
    }

    public static long getIntoDstTime() {
        if (intoDstTime != -1L) {
            return intoDstTime;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, DateUtil.getIntoDstMonth(calendar.get(1)));
        calendar.set(5, DateUtil.getIntoDstDayOfMonth(calendar.get(1), calendar.get(2)));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar endCal = (Calendar)calendar.clone();
        Calendar tmpCal = (Calendar)calendar.clone();
        endCal.add(5, 1);
        endCal.add(13, -1);
        intoDstTime = 0L;
        while (tmpCal.compareTo(endCal) <= 0) {
            if (tmpCal.get(16) != 0) {
                intoDstTime = tmpCal.getTimeInMillis();
                return intoDstTime;
            }
            tmpCal.add(13, 1);
        }
        return 0L;
    }

    public static int getIntoDstMonth(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar tmpCal = (Calendar)calendar.clone();
        Calendar endCalendar = (Calendar)calendar.clone();
        endCalendar.add(1, 1);
        endCalendar.add(13, -1);
        while (tmpCal.compareTo(endCalendar) <= 0) {
            tmpCal.add(2, 1);
            tmpCal.set(5, 1);
            tmpCal.set(11, 0);
            tmpCal.set(12, 0);
            tmpCal.set(13, 0);
            tmpCal.add(13, -1);
            if (tmpCal.get(16) != 0) {
                return tmpCal.get(2);
            }
            tmpCal.add(13, 1);
        }
        return 0;
    }

    public static int getIntoDstDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Calendar tmpCal = (Calendar)calendar.clone();
        Calendar endCalendar = (Calendar)calendar.clone();
        endCalendar.add(2, 1);
        endCalendar.add(13, -1);
        while (tmpCal.compareTo(endCalendar) <= 0) {
            if (tmpCal.get(16) != 0) {
                return tmpCal.get(5);
            }
            tmpCal.add(5, 1);
            tmpCal.add(13, -1);
        }
        return 1;
    }

    public static int getDstOffset() {
        Map<String, Long> lastDSTTimeInMillisRange = DateUtil.getLastDSTTimeInMillisRange();
        if (lastDSTTimeInMillisRange.get(LAST_DST_RANGE_START) == 0L) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(lastDSTTimeInMillisRange.get(LAST_DST_RANGE_START));
        return cal.get(16);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getDayNumOfMonth(int year, int month) {
        boolean isBigMonth2;
        boolean isBigMonth1 = month == 1 || month == 3 || month == 5 || month == 7;
        boolean bl = isBigMonth2 = month == 8 || month == 10 || month == 12;
        if (isBigMonth1 || isBigMonth2) {
            return 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (DateUtil.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 0;
    }
}

