/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

public final class HotSwapClassLoader
extends URLClassLoader {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static HotSwapClassLoader instance = null;
    private Map<String, Class<?>> classMap = new HashMap();

    private HotSwapClassLoader(URL[] urls) {
        super(urls);
    }

    private HotSwapClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HotSwapClassLoader getInstance() {
        Class<HotSwapClassLoader> clazz = HotSwapClassLoader.class;
        synchronized (HotSwapClassLoader.class) {
            if (null == instance) {
                try {
                    instance = AccessController.doPrivileged(new PrivilegedExceptionAction<HotSwapClassLoader>(){

                        @Override
                        public HotSwapClassLoader run() throws FileNotFoundException, MalformedURLException {
                            return new HotSwapClassLoader(new URL[]{new URL("file:/")}, Thread.currentThread().getContextClassLoader());
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error to get class loader. ");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Class<?> load(String name, String classPath) throws ClassNotFoundException {
        return this.load(name, false, classPath);
    }

    private Class<?> load(String name, boolean resolve, String classPath) throws ClassNotFoundException {
        if (this.classMap.containsKey(name)) {
            return this.classMap.get(name);
        }
        Class<?> loadedClass = super.findLoadedClass(name);
        if (null != loadedClass) {
            this.classMap.put(name, loadedClass);
            return loadedClass;
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
            if (clazz != null) {
                this.classMap.put(name, clazz);
                return clazz;
            }
            clazz = super.findClass(name);
            if (resolve) {
                this.classMap.put(name, clazz);
                super.resolveClass(clazz);
            }
            return clazz;
        }
        catch (RuntimeException e) {
            byte[] classbyte = this.loadClassData(classPath);
            clazz = this.defineClass(name, classbyte, 0, classbyte.length);
            if (clazz != null) {
                this.classMap.put(name, clazz);
            }
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(String classPath) {
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        byte[] data = null;
        try {
            fis = new FileInputStream(classPath);
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int count = 0;
            while (-1 != (count = fis.read(buf))) {
                baos.write(buf, 0, count);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error((Object)"loadClassData error");
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"loadClassData close fileInputStream error");
                }
            }
            if (null != baos) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close outputStream error");
                }
            }
        }
        return data;
    }
}

