/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.ExtendAttribute;
import com.security.ireport.engine.definition.HeaderColumn;
import com.security.ireport.engine.definition.HeaderRow;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRChartDataItem;
import com.security.ireport.engine.definition.IRColorMap;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRCover;
import com.security.ireport.engine.definition.IRDefine;
import com.security.ireport.engine.definition.IRFirstPage;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IRTextField;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.util.DBConnPool;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.SqlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;

public abstract class IReportUtil {
    public static final int BLKSIZ = 8192;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int INT_HALF = 2;
    private static final String KEY_PREFIX = "$R{";
    private static final String KEY_SUFFIX = "}";
    private static String realPath = "";

    public static void setRealPath(String path) {
        if (!IReportConfCheckUtil.isStringEmpty(path)) {
            realPath = path;
        }
    }

    public static String getRealPath() {
        if (!IReportConfCheckUtil.isStringEmpty(realPath)) {
            return realPath;
        }
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        try {
            String classPath = IReportUtil.class.getResource("/").toURI().getPath();
            String key = "/WEB-INF/";
            if (classPath.indexOf(key) >= 0) {
                realPath = windows ? classPath.substring(1, classPath.indexOf(key)) : classPath.substring(0, classPath.indexOf(key));
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Get opposite path fail");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Get opposite path fail");
        }
        return realPath;
    }

    public static String getPluginPath() {
        return IReportUtil.getRealPath() + "/iReport/iReportBiz/reportPlugins/";
    }

    public static String getJasperTemplatePath() {
        return IReportUtil.getRealPath() + "/iReport/iReportBiz/jasperTemplete/";
    }

    public static String getIReportTempImagePath() {
        return IReportUtil.getRealPath() + "/iReport/temp";
    }

    public static void cleanIReportTempImage() {
        String imagePath = IReportUtil.getIReportTempImagePath();
        boolean result = IReportUtil.deleteDirectory(imagePath);
        LOGGER.info((Object)("deleteDirectory; result=" + result));
        File file = new File(imagePath);
        result = file.mkdir();
        LOGGER.info((Object)("file.mkdir(); result=" + result));
    }

    public static String transTimeStr(long dateTime) {
        return IReportUtil.transTimeStr(dateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String transTimeStr(long dateTime, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        return format.format(dateTime);
    }

    public static boolean isStrValid(String allowChars, String testStr) {
        if (null == allowChars) {
            return true;
        }
        String normalizeTestStr = Normalizer.normalize(testStr, Normalizer.Form.NFKC);
        return Pattern.compile(allowChars).matcher(normalizeTestStr).find();
    }

    public static String copyDirectory(String sourPath, String desPath) {
        String result = null;
        try {
            File sourDirectory = new File(sourPath);
            if (sourDirectory.exists() && sourDirectory.isDirectory()) {
                File desDirectory = new File(desPath);
                if (desDirectory.exists()) {
                    return "report id " + desPath + "is used, please reset.";
                }
                if (!desDirectory.mkdirs()) {
                    return "mkdirs path=" + desPath + " failed.";
                }
                File[] sourFiles = sourDirectory.listFiles();
                IReportUtil.copyDirectory(sourFiles, desPath);
            } else {
                result = "source file directory :" + sourPath + "is not exist.";
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"copyDirectory error");
            result = e.getMessage();
        }
        return result;
    }

    private static void copyDirectory(File[] sourFiles, String desPath) throws IOException {
        if (sourFiles != null && sourFiles.length > 0) {
            for (File file : sourFiles) {
                if (file.getName().equalsIgnoreCase(".svn")) continue;
                IReportUtil.copyFileBuffered(file, desPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileBuffered(File oldFile, String newDirectoryPath) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(oldFile);
            os = new FileOutputStream(newDirectoryPath + File.separator + oldFile.getName());
            int count = 0;
            byte[] b = new byte[8192];
            while ((count = ((InputStream)is).read(b)) != -1) {
                os.write(b, 0, count);
            }
            os.flush();
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    public static void showErrorMessageBox(Component parentComponent, String msg) {
        JOptionPane.showMessageDialog(parentComponent, msg, LocaleUtil.getProperty("title.ErrorMessageBox"), 0);
    }

    public static void showErrorMessageBox(String msg) {
        JOptionPane.showMessageDialog(null, msg, LocaleUtil.getProperty("title.ErrorMessageBox"), 0);
    }

    public static String getFileNameNotSuffix(String fileName) {
        String fileNameNotSuffix = null;
        if (fileName != null) {
            fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
            int index = fileName.lastIndexOf(46);
            fileNameNotSuffix = fileName.substring(0, index);
        }
        return fileNameNotSuffix;
    }

    public static String getClassPackage(String fullClass) {
        String packgName = "";
        int lastDot = (fullClass = Normalizer.normalize(fullClass, Normalizer.Form.NFKC)).lastIndexOf(".");
        if (lastDot > 0) {
            packgName = fullClass.substring(0, lastDot);
        }
        return packgName;
    }

    public static String getSimpleClassName(String fullClass) {
        String simpleName = "";
        int lastDot = fullClass.lastIndexOf(".");
        simpleName = fullClass.substring(lastDot + 1);
        return simpleName;
    }

    public static void showDlgCenter(JDialog dlg) {
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension splashsize = dlg.getPreferredSize();
        if (splashsize != null) {
            int splashW = splashsize.width;
            int splashH = splashsize.height;
            int splashX = (screensize.width - splashW) / 2;
            int splashY = (screensize.height - splashH) / 2;
            dlg.setBounds(splashX, splashY, splashW, splashH);
            dlg.setVisible(true);
        }
    }

    public static void deleteFile(String path, List<String> fileNameList) {
        for (String fileName : fileNameList) {
            IReportUtil.deleteFile(path + File.separator + fileName);
        }
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            boolean result = file.delete();
            LOGGER.debug((Object)("del single file " + file.getName() + " : " + result));
            return result;
        }
        return true;
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        String normalizeDir = Normalizer.normalize(dir, Normalizer.Form.NFKC);
        if (!normalizeDir.endsWith(File.separator)) {
            normalizeDir = normalizeDir + File.separator;
        }
        if (!(dirFile = new File(normalizeDir)).exists() || !dirFile.isDirectory()) {
            LOGGER.error((Object)"delete directory failed .Directory is not exsit!");
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    try {
                        flag = IReportUtil.deleteFile(files[i].getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"getCanonicalPath():error");
                    }
                    if (flag) continue;
                    break;
                }
                try {
                    flag = IReportUtil.deleteDirectory(files[i].getCanonicalPath());
                }
                catch (IOException e) {
                    LOGGER.error((Object)"getCanonicalPath():error");
                }
                if (!flag) break;
            }
        }
        if (!flag) {
            LOGGER.error((Object)"del dir failed");
            return false;
        }
        if (dirFile.delete()) {
            LOGGER.debug((Object)"del dir successed!");
            return true;
        }
        LOGGER.error((Object)"del dir failed!");
        return false;
    }

    public static String getProperty(String key, String reportId, Locale locale) {
        String result = null;
        if (key != null && reportId != null) {
            if (IReportUtil.isPropertyKey(key)) {
                key = Normalizer.normalize(key, Normalizer.Form.NFKC);
                String propertyKey = key.substring(KEY_PREFIX.length(), key.length() - 1);
                result = LocaleUtil.getProperty(propertyKey, reportId, locale);
            } else {
                result = key;
            }
        }
        return result;
    }

    public static boolean isPropertyKey(String key) {
        if (null == key) {
            return false;
        }
        return (key = Normalizer.normalize(key, Normalizer.Form.NFKC)).startsWith(KEY_PREFIX) && key.endsWith(KEY_SUFFIX);
    }

    public static IReport setReportParamter(IReport ireport, Map<String, List<String>> paraMap) {
        IReport cloneObj = null;
        try {
            cloneObj = ireport.clone();
            for (IRDefine iRDefine : cloneObj.getIRDefineList()) {
                iRDefine.setTitle(IReportUtil.formatStrParameter(iRDefine.getTitle(), paraMap));
                iRDefine.setMainTitle(IReportUtil.formatStrParameter(iRDefine.getMainTitle(), paraMap));
            }
            if (cloneObj.getIRDefine() != null) {
                cloneObj.getIRDefine().setTitle(IReportUtil.formatStrParameter(cloneObj.getIRDefine().getTitle(), paraMap));
                cloneObj.getIRDefine().setMainTitle(IReportUtil.formatStrParameter(cloneObj.getIRDefine().getMainTitle(), paraMap));
            }
            cloneObj.getPageHeader().setPageHeaderTitle(IReportUtil.formatStrParameter(cloneObj.getPageHeader().getPageHeaderTitle(), paraMap));
            cloneObj.getPageHeader().setImageName(IReportUtil.trim(IReportUtil.formatStrParameter(cloneObj.getPageHeader().getImageName(), paraMap)));
            IReportUtil.setFirstPage(cloneObj.getFirstPage(), paraMap);
            IReportUtil.setCover(cloneObj.getCover(), paraMap);
            if (cloneObj.getIRDefine() != null) {
                cloneObj.getIRDefine().setTitle(IReportUtil.formatStrParameter(cloneObj.getIRDefine().getTitle(), paraMap));
            }
            IReportUtil.setChartParamter(cloneObj, paraMap);
            for (IRTable iRTable : cloneObj.getIRTableList()) {
                IReportUtil.setTableParamter(iRTable, paraMap);
            }
            for (IRTextField iRTextField : cloneObj.getTextFieldList()) {
                iRTextField.setText(IReportUtil.formatStrParameter(iRTextField.getText(), paraMap));
            }
            for (ComponentElement componentElement : cloneObj.getElementList()) {
                if (componentElement instanceof IRTable) {
                    IReportUtil.setTableParamter((IRTable)componentElement, paraMap);
                    continue;
                }
                if (componentElement instanceof IRChart) {
                    IReportUtil.setChartParamter((IRChart)componentElement, paraMap);
                    continue;
                }
                if (!(componentElement instanceof IRTextField)) continue;
                IRTextField temp = (IRTextField)componentElement;
                temp.setText(IReportUtil.formatStrParameter(temp.getText(), paraMap));
            }
        }
        catch (CloneNotSupportedException e) {
            cloneObj = new IReport();
        }
        return cloneObj;
    }

    private static void setFirstPage(IRFirstPage firstPage, Map<String, List<String>> paraMap) {
        firstPage.setTitle(IReportUtil.formatStrParameter(firstPage.getTitle(), paraMap));
        firstPage.setReportDesc(IReportUtil.formatStrParameter(firstPage.getReportDesc(), paraMap));
        firstPage.setReportType(IReportUtil.formatStrParameter(firstPage.getReportType(), paraMap));
        firstPage.setReportVersion(IReportUtil.formatStrParameter(firstPage.getReportVersion(), paraMap));
        firstPage.setCollectionName(IReportUtil.formatStrParameter(firstPage.getCollectionName(), paraMap));
        firstPage.setAuthorName(IReportUtil.formatStrParameter(firstPage.getAuthorName(), paraMap));
        firstPage.setDataTime(IReportUtil.formatStrParameter(firstPage.getDataTime(), paraMap));
        firstPage.setCreateTime(IReportUtil.formatStrParameter(firstPage.getCreateTime(), paraMap));
        firstPage.setLogImageUrl(IReportUtil.trim(IReportUtil.formatStrParameter(firstPage.getLogImageUrl(), paraMap)));
        if (null != firstPage.getExtendsAttributeList()) {
            for (ExtendAttribute temExtendAttribute : firstPage.getExtendsAttributeList()) {
                temExtendAttribute.setValue(IReportUtil.formatStrParameter(temExtendAttribute.getValue(), paraMap));
            }
        }
    }

    private static void setCover(IRCover cover, Map<String, List<String>> paraMap) {
        cover.setCoverMainTitle(IReportUtil.formatStrParameter(cover.getCoverMainTitle(), paraMap));
        cover.setCoverTitle(IReportUtil.formatStrParameter(cover.getCoverTitle(), paraMap));
        cover.setCoverReportCycle(IReportUtil.formatStrParameter(cover.getCoverReportCycle(), paraMap));
        cover.setCoverReportTime(IReportUtil.formatStrParameter(cover.getCoverReportTime(), paraMap));
    }

    private static void setChartParamter(IReport cloneObj, Map<String, List<String>> paraMap) {
        for (IRChart item : cloneObj.getIRChartList()) {
            IReportUtil.setChartParamter(item, paraMap);
        }
    }

    private static void setTableParamter(IRTable table, Map<String, List<String>> paraMap) {
        table.setTitle(IReportUtil.formatStrParameter(table.getTitle(), paraMap));
        for (IRColumn iRColumn : table.getIRColumnList()) {
            iRColumn.setHeader(IReportUtil.formatStrParameter(iRColumn.getHeader(), paraMap));
        }
        for (int i = 0; i < table.getHeaderRowList().size(); ++i) {
            HeaderRow row = table.getHeaderRowList().get(i);
            for (int j = 0; j < row.getHeaderColumnList().size(); ++j) {
                HeaderColumn headerColumn = row.getHeaderColumnList().get(j);
                headerColumn.setValue(IReportUtil.formatStrParameter(headerColumn.getValue(), paraMap));
            }
        }
    }

    private static void setChartParamter(IRChart item, Map<String, List<String>> paraMap) {
        String fillByTimeCycle;
        item.setTitle(IReportUtil.formatStrParameter(item.getTitle(), paraMap));
        item.setSubTitle(IReportUtil.formatStrParameter(item.getSubTitle(), paraMap));
        List<IRColorMap> colorMapList = item.getPlot().getColorMapList();
        for (IRColorMap colorMap : colorMapList) {
            colorMap.setKey(IReportUtil.formatStrParameter(colorMap.getKey(), paraMap));
        }
        item.getRangeAxis().setLabel(IReportUtil.formatStrParameter(item.getRangeAxis().getLabel(), paraMap));
        item.getDomainAxis().setLabel(IReportUtil.formatStrParameter(item.getDomainAxis().getLabel(), paraMap));
        item.getDomainAxis().setFormatType(IReportUtil.formatStrParameter(item.getDomainAxis().getFormatType(), paraMap));
        item.getDomainAxis().setFormatValue(IReportUtil.formatStrParameter(item.getDomainAxis().getFormatValue(), paraMap));
        if (!item.getIRDataSet().isAutoExpand()) {
            for (IRChartDataItem dataItem : item.getIRDataSet().getDataItemList()) {
                dataItem.setKey(IReportUtil.formatStrParameter(dataItem.getKey(), paraMap));
                dataItem.setSeries(IReportUtil.formatStrParameter(dataItem.getSeries(), paraMap));
            }
        }
        if (!IReportConfCheckUtil.isStringEmpty(fillByTimeCycle = item.getIRDataSet().getFillByTimeCycle())) {
            String normalizeFillByTimeCycle = Normalizer.normalize((fillByTimeCycle = IReportUtil.formatStrParameter(fillByTimeCycle, paraMap)).substring(0, 1), Normalizer.Form.NFKC);
            if (normalizeFillByTimeCycle.endsWith(" ")) {
                fillByTimeCycle = fillByTimeCycle.substring(1);
            }
            item.getIRDataSet().setFillByTimeCycle(IReportUtil.formatStrParameter(fillByTimeCycle, paraMap));
        }
    }

    public static IReport createCloneObj(IReport ireport, Locale locale) {
        IReport cloneObj = null;
        try {
            cloneObj = ireport.clone();
            cloneObj.setName(IReportUtil.formatStrResource(cloneObj.getName(), cloneObj.getId(), locale));
            for (IRDefine iRDefine : cloneObj.getIRDefineList()) {
                iRDefine.setTitle(IReportUtil.formatStrResource(iRDefine.getTitle(), cloneObj.getId(), locale));
                iRDefine.setMainTitle(IReportUtil.formatStrResource(iRDefine.getMainTitle(), cloneObj.getId(), locale));
            }
            cloneObj.getPageHeader().setPageHeaderTitle(IReportUtil.formatStrResource(cloneObj.getPageHeader().getPageHeaderTitle(), cloneObj.getId(), locale));
            cloneObj.getPageHeader().setImageName(IReportUtil.formatStrResource(cloneObj.getPageHeader().getImageName(), cloneObj.getId(), locale));
            IReportUtil.setFirstPageProperties(cloneObj.getFirstPage(), cloneObj.getId(), locale);
            IReportUtil.setCoverProperties(cloneObj.getCover(), cloneObj.getId(), locale);
            IReportUtil.setChartProperties(cloneObj, locale);
            for (IRTable iRTable : cloneObj.getIRTableList()) {
                IReportUtil.setTableProperties(iRTable, cloneObj.getId(), locale);
            }
            for (IRTextField iRTextField : cloneObj.getTextFieldList()) {
                iRTextField.setText(IReportUtil.formatStrResource(iRTextField.getText(), cloneObj.getId(), locale));
            }
            for (ComponentElement componentElement : cloneObj.getElementList()) {
                if (componentElement instanceof IRTable) {
                    IReportUtil.setTableProperties((IRTable)componentElement, cloneObj.getId(), locale);
                    continue;
                }
                if (componentElement instanceof IRChart) {
                    IReportUtil.setChartProperties((IRChart)componentElement, cloneObj.getId(), locale);
                    continue;
                }
                if (!(componentElement instanceof IRTextField)) continue;
                IRTextField temp = (IRTextField)componentElement;
                temp.setText(IReportUtil.formatStrResource(temp.getText(), cloneObj.getId(), locale));
            }
            for (IRChart iRChart : cloneObj.getTableCellIRChartMap().values()) {
                IReportUtil.setChartProperties(iRChart, cloneObj.getId(), locale);
            }
        }
        catch (CloneNotSupportedException e) {
            cloneObj = new IReport();
        }
        return cloneObj;
    }

    private static void setFirstPageProperties(IRFirstPage firstPage, String reportId, Locale locale) {
        firstPage.setAuthorName(IReportUtil.formatStrResource(firstPage.getAuthorName(), reportId, locale));
        firstPage.setCollectionName(IReportUtil.formatStrResource(firstPage.getCollectionName(), reportId, locale));
        firstPage.setCreateTime(IReportUtil.formatStrResource(firstPage.getCreateTime(), reportId, locale));
        firstPage.setDataTime(IReportUtil.formatStrResource(firstPage.getDataTime(), reportId, locale));
        firstPage.setReportDesc(IReportUtil.formatStrResource(firstPage.getReportDesc(), reportId, locale));
        firstPage.setReportType(IReportUtil.formatStrResource(firstPage.getReportType(), reportId, locale));
        firstPage.setReportVersion(IReportUtil.formatStrResource(firstPage.getReportVersion(), reportId, locale));
        firstPage.setLogImageUrl(IReportUtil.formatStrResource(firstPage.getLogImageUrl(), reportId, locale));
        if (null != firstPage.getExtendsAttributeList()) {
            for (ExtendAttribute temExtendAttribute : firstPage.getExtendsAttributeList()) {
                temExtendAttribute.setValue(IReportUtil.formatStrResource(temExtendAttribute.getValue(), reportId, locale));
            }
        }
    }

    private static void setCoverProperties(IRCover cover, String reportId, Locale locale) {
        cover.setCoverMainTitle(IReportUtil.formatStrResource(cover.getCoverMainTitle(), reportId, locale));
        cover.setCoverTitle(IReportUtil.formatStrResource(cover.getCoverTitle(), reportId, locale));
        cover.setCoverReportCycle(IReportUtil.formatStrResource(cover.getCoverReportCycle(), reportId, locale));
        cover.setCoverReportTime(IReportUtil.formatStrResource(cover.getCoverReportTime(), reportId, locale));
    }

    private static void setTableProperties(IRTable table, String reportId, Locale locale) {
        table.setTitle(IReportUtil.formatStrResource(table.getTitle(), reportId, locale));
        for (IRColumn iRColumn : table.getIRColumnList()) {
            iRColumn.setHeader(IReportUtil.formatStrResource(iRColumn.getHeader(), reportId, locale));
            iRColumn.setTotalExpression(IReportUtil.formatStrResource(iRColumn.getTotalExpression(), reportId, locale));
            iRColumn.setDataDrillTitle(IReportUtil.formatStrResource(iRColumn.getDataDrillTitle(), reportId, locale));
        }
        for (int i = 0; i < table.getHeaderRowList().size(); ++i) {
            HeaderRow row = table.getHeaderRowList().get(i);
            for (int j = 0; j < row.getHeaderColumnList().size(); ++j) {
                HeaderColumn headerColumn = row.getHeaderColumnList().get(j);
                headerColumn.setValue(IReportUtil.formatStrResource(headerColumn.getValue(), reportId, locale));
            }
        }
        table.setTableFooter(IReportUtil.formatStrResource(table.getTableFooter(), reportId, locale));
    }

    private static void setChartProperties(IRChart item, String reportId, Locale locale) {
        item.setTitle(IReportUtil.formatStrResource(item.getTitle(), reportId, locale));
        item.setSubTitle(IReportUtil.formatStrResource(item.getSubTitle(), reportId, locale));
        List<IRColorMap> colorMapList = item.getPlot().getColorMapList();
        for (IRColorMap colorMap : colorMapList) {
            colorMap.setKey(IReportUtil.formatStrResource(colorMap.getKey(), reportId, locale).trim());
        }
        item.getRangeAxis().setLabel(IReportUtil.formatStrResource(item.getRangeAxis().getLabel(), reportId, locale));
        item.getDomainAxis().setLabel(IReportUtil.formatStrResource(item.getDomainAxis().getLabel(), reportId, locale));
        if (!item.getIRDataSet().isAutoExpand()) {
            for (IRChartDataItem dataItem : item.getIRDataSet().getDataItemList()) {
                dataItem.setKey(IReportUtil.formatStrResource(dataItem.getKey(), reportId, locale));
                dataItem.setSeries(IReportUtil.formatStrResource(dataItem.getSeries(), reportId, locale));
            }
        }
    }

    private static void setChartProperties(IReport cloneObj, Locale locale) {
        for (IRChart item : cloneObj.getIRChartList()) {
            IReportUtil.setChartProperties(item, cloneObj.getId(), locale);
        }
    }

    public static String getProperty(String key, List<Properties> resList) {
        if (resList != null && !resList.isEmpty() && IReportUtil.isPropertyKey(key)) {
            String propertyKey = key.substring(KEY_PREFIX.length(), key.length() - 1);
            return IReportUtil.getPropertyByKey(propertyKey, resList);
        }
        return key;
    }

    private static String getPropertyByKey(String propertyKey, List<Properties> resList) {
        String value = null;
        for (Properties item : resList) {
            if (!item.containsKey(propertyKey)) continue;
            value = item.getProperty(propertyKey);
            break;
        }
        if (null == value) {
            value = propertyKey;
        }
        return value;
    }

    public static void delFile(String filePath) {
        LOGGER.info((Object)"start delFile");
        String upperFilePath = filePath.toUpperCase(Locale.US);
        upperFilePath = Normalizer.normalize(upperFilePath, Normalizer.Form.NFKC);
        if (upperFilePath.contains("ExportImgDataMaxErrorEn.PNG".toUpperCase(Locale.US)) || upperFilePath.contains("ImgDataMaxErrorEn.PNG".toUpperCase(Locale.US)) || upperFilePath.contains("ImgDataMaxError.PNG".toUpperCase(Locale.US)) || upperFilePath.contains("ExportImgDataMaxError.PNG".toUpperCase(Locale.US))) {
            LOGGER.info((Object)"not delFile");
            return;
        }
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            LOGGER.error((Object)("failed to del file: " + file.getName()));
        }
    }

    public static List<Integer> parsePageSize(String conf) {
        List<Object> pageSizeOption = new ArrayList<Integer>();
        if (IReportUtil.isPageSizeConfValid(conf)) {
            String[] pageSizeOptions = conf.trim().split(",");
            Object[] temp = new Integer[pageSizeOptions.length];
            for (int i = 0; i < pageSizeOptions.length; ++i) {
                temp[i] = Integer.valueOf(pageSizeOptions[i].trim());
            }
            Arrays.sort(temp);
            pageSizeOption = Arrays.asList(temp);
        } else {
            pageSizeOption.add(15);
            pageSizeOption.add(30);
            pageSizeOption.add(50);
        }
        return pageSizeOption;
    }

    public static String parseShowQueryReportType(String showQueryReportType) {
        if (showQueryReportType.equals("0") || showQueryReportType.equals("1")) {
            return showQueryReportType;
        }
        return "1";
    }

    private static boolean isPageSizeConfValid(String conf) {
        boolean result = true;
        try {
            String[] pageSizeOptions = conf.trim().split(",");
            ArrayList<Integer> pageSizeOption = new ArrayList<Integer>();
            for (int i = 0; i < pageSizeOptions.length; ++i) {
                Integer item = Integer.valueOf(pageSizeOptions[i].trim());
                if (item <= 0 || pageSizeOption.contains(item)) {
                    result = false;
                    break;
                }
                pageSizeOption.add(item);
            }
        }
        catch (RuntimeException e) {
            result = false;
        }
        return result;
    }

    public static String removeNullCond(String sql) {
        String[] sqlTxt = sql.split(" ");
        ArrayList<String> list = new ArrayList<String>();
        for (String item : sqlTxt) {
            if (item.isEmpty()) continue;
            IReportUtil.filterItem(list, item);
        }
        int whereIndex = list.indexOf("WHERE");
        if (whereIndex == list.size() - 1 || list.size() > whereIndex + 2 && ((String)list.get(whereIndex + 1)).equals("ORDER") && ((String)list.get(whereIndex + 2)).equals("BY")) {
            list.remove(whereIndex);
        }
        StringBuffer sqlBuf = new StringBuffer();
        for (String item : list) {
            sqlBuf.append(item).append(' ');
        }
        return sqlBuf.toString();
    }

    private static void filterItem(List<String> list, String item) {
        if (item.equals("?")) {
            list.remove(list.size() - 1);
            list.remove(list.size() - 1);
        } else if (item.equalsIgnoreCase("WHERE")) {
            list.add(item.toUpperCase(Locale.US));
        } else if (item.equalsIgnoreCase("BY")) {
            list.add(item.toUpperCase(Locale.US));
        } else if (item.equalsIgnoreCase("AND")) {
            if (!list.get(list.size() - 1).equalsIgnoreCase("WHERE")) {
                list.add(item.toUpperCase(Locale.US));
            }
        } else if (item.equalsIgnoreCase("ORDER")) {
            if (list.get(list.size() - 1).equalsIgnoreCase("AND")) {
                list.remove(list.size() - 1);
            }
            list.add(item.toUpperCase(Locale.US));
        } else {
            list.add(item);
        }
    }

    public static String getTaskName(Integer taskId) {
        String result = "";
        List<Object[]> resultState = null;
        String queryString = "SELECT TASK_NAME FROM IREPORT_TASK WHERE PKID=?";
        resultState = DBConnPool.find(queryString, new Object[]{taskId});
        if (!IReportConfCheckUtil.isListEmpty(resultState)) {
            result = resultState.get(0)[0].toString();
        }
        return result;
    }

    public static String formatUrl(String url, long row, IDataSourceCollector collector, long reportSessionId) {
        if (url.length() > 2048) {
            LOGGER.error((Object)"URL is too long");
            return "";
        }
        String[] sqlStrs = url.split("\\$P|\\$p");
        if (sqlStrs.length <= 1) {
            return url + "&reportSessionId=" + reportSessionId;
        }
        String temp = url.replaceAll("\\$P|\\$p", "");
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        Pattern p = Pattern.compile("''|'.*?'|\\{(.*?)(,.*?)?\\}|[^\\{\\}]+");
        Matcher m = p.matcher(temp);
        int paramIdx = 0;
        while (m.find()) {
            if (null == m.group(1)) {
                buff.append(m.group());
                continue;
            }
            String paramName = m.group(1);
            Object paramValue = collector.getValue(row, IReportConfCheckUtil.getObjectStr(paramName));
            String paramSets = m.group(2) != null ? m.group(2) : "";
            paramList.add(String.valueOf(paramValue));
            buff.append("{" + paramIdx + paramSets + KEY_SUFFIX);
            ++paramIdx;
        }
        return SqlUtil.formatStrSingleQuotes(buff.toString(), paramList.toArray()) + "&reportSessionId=" + reportSessionId;
    }

    public static String formatStrParameter(String str, Map<String, List<String>> paraMap) {
        if (IReportConfCheckUtil.isStringEmpty(str) || str.length() > 2048) {
            LOGGER.error((Object)"Paramter is invalid: str is empty or too long.");
            return "";
        }
        String[] sqlStrs = str.split("\\$P|\\$p");
        if (sqlStrs.length <= 1) {
            return str;
        }
        String temp = str.replaceAll("\\$P|\\$p", " ");
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        temp = Normalizer.normalize(temp, Normalizer.Form.NFKC);
        Pattern p = Pattern.compile("''|'.*?'|\\{(.*?)(,.*?)?\\}|[^\\{\\}]+");
        Matcher m = p.matcher(temp);
        int paramIdx = 0;
        while (m.find()) {
            if (null == m.group(1)) {
                buff.append(m.group());
                continue;
            }
            String paramName = m.group(1);
            String paramValue = paraMap.containsKey(paramName.trim()) && !paraMap.get(paramName.trim()).isEmpty() ? paraMap.get(paramName.trim()).get(0) : "";
            String paramSets = m.group(2) != null ? m.group(2) : "";
            paramList.add(paramValue);
            buff.append("{" + paramIdx + paramSets + KEY_SUFFIX);
            ++paramIdx;
        }
        return SqlUtil.formatStrSingleQuotes(buff.toString(), paramList.toArray());
    }

    public static String trim(String paramString) {
        String resultString = paramString;
        if (null != resultString) {
            resultString = resultString.trim();
        }
        return resultString;
    }

    public static String formatStrResource(String str, String reportId, Locale locale) {
        if (IReportConfCheckUtil.isStringEmpty(str) || str.length() > 2048) {
            LOGGER.error((Object)"Paramter is invalid: str is empty or too long.");
            return "";
        }
        String[] sqlStrs = str.split("\\$r|\\$R");
        if (sqlStrs.length <= 1) {
            return str;
        }
        String temp = str.replaceAll("\\$r|\\$R", " ");
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        Pattern p = Pattern.compile("''|'.*?'|\\{(.*?)(,.*?)?\\}|[^\\{\\}]+");
        Matcher m = p.matcher(temp);
        int paramIdx = 0;
        while (m.find()) {
            if (null == m.group(1)) {
                buff.append(m.group());
                continue;
            }
            String paramName = m.group(1);
            if (buff.toString().endsWith("$p") || buff.toString().endsWith("$P")) {
                buff.append("[" + paramName + "]");
                continue;
            }
            String paramValue = LocaleUtil.getProperty(paramName.trim(), reportId, locale);
            String paramSets = m.group(2) != null ? m.group(2) : "";
            paramList.add(paramValue);
            buff.append("{" + paramIdx + paramSets + KEY_SUFFIX);
            ++paramIdx;
        }
        String msg = SqlUtil.formatStrSingleQuotes(buff.toString(), paramList.toArray());
        msg = msg.replace('[', '{');
        msg = msg.replace("]", KEY_SUFFIX);
        return msg.trim();
    }

    public static String transToStr(List<String> list) {
        int len;
        StringBuffer sb = new StringBuffer();
        String result = "";
        if (list != null && !list.isEmpty()) {
            for (String item : list) {
                sb.append(item).append(',');
            }
        }
        if ((len = sb.length()) > 0) {
            result = sb.toString().substring(0, len - 1);
        }
        return result;
    }

    public static Integer tranToInteger(Object obj) {
        if (obj != null) {
            return Integer.valueOf(String.valueOf(obj));
        }
        return -1;
    }

    public static String transHtml(String str) {
        String result = null;
        result = null == str || str.trim().isEmpty() ? "&nbsp;" : str;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImageMap(String mapInfo, String filePath) {
        if (null == mapInfo || null == filePath) {
            return;
        }
        File file = new File(filePath);
        if (file.exists()) {
            LOGGER.warn((Object)"file is exist.");
            return;
        }
        ObjectOutput out = null;
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(filePath);
            out = new ObjectOutputStream(fOut);
            out.writeObject(mapInfo);
        }
        catch (IOException e) {
            LOGGER.error((Object)"writeImageMap IOException error");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"out not close");
            }
            try {
                if (fOut != null) {
                    fOut.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"fOut not close");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readImageMap(String filePath) {
        String mapInfo = "";
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(new File(filePath)));
            mapInfo = (String)in.readObject();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"readImageMap classNotFoundException");
        }
        catch (IOException e) {
            LOGGER.error((Object)"readImageMap IOException");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"out not close");
                }
            }
        }
        return mapInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObj(String filePath) {
        Object mapInfo = null;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(new File(filePath)));
            mapInfo = in.readObject();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"readObj classNotFoundException");
        }
        catch (IOException e) {
            LOGGER.error((Object)"readObj IOException");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"out not close");
                }
            }
        }
        return mapInfo;
    }

    public static String getPathWithoutSuffix(String filePath) {
        String normalizeFilePath = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        int length = normalizeFilePath.lastIndexOf(".");
        if (length >= 0) {
            return normalizeFilePath.substring(0, length);
        }
        return normalizeFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createChartFile(JFreeChart jfreechart, int width, int height, String filePath) throws IOException {
        try (OutputStream out = null;){
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            BufferedImage bufferedImage = jfreechart.createBufferedImage(width, height, info);
            byte[] image = EncoderUtil.encode((BufferedImage)bufferedImage, (String)"png");
            out = new FileOutputStream(new File(filePath));
            out.write(image);
            out.flush();
        }
    }

    public static String getcleanedMessage(String message) {
        if (null == message) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

