/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.atic.util.LocalizedTextUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LocaleUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static Map<String, Properties> resProperties = new ConcurrentHashMap<String, Properties>();

    public static String getLocaleText(String key) {
        Locale locale = LocaleUtil.getCurrentUserLocale();
        String value = LocalizedTextUtil.findDefaultText((String)key, (Locale)locale);
        value = value != null ? value : key;
        return value;
    }

    public static String getLocaleText(Locale locale, String key) {
        String value;
        Locale tempLocale = locale;
        if (null == tempLocale) {
            tempLocale = LocaleUtil.getCurrentUserLocale();
        }
        value = (value = LocalizedTextUtil.findDefaultText((String)key, (Locale)tempLocale)) != null ? value : key;
        return value;
    }

    public static String getLocaleText(String key, Object[] params) {
        Locale locale = LocaleUtil.getCurrentUserLocale();
        String value = LocalizedTextUtil.findDefaultText((String)key, (Locale)locale, (Object[])params);
        value = value != null ? value : key;
        return value;
    }

    public static Locale getCurrentUserLocale() {
        return ProductFaceUtil.getInstance().getUserLocale();
    }

    public static String getProperty(String propertyKey) {
        Properties prop = LocaleUtil.readProperty();
        String value = null;
        value = prop.containsKey(propertyKey) ? prop.getProperty(propertyKey) : propertyKey;
        return value;
    }

    public static String getProperty(String propertyKey, Locale locale) {
        Properties prop = LocaleUtil.readProperty(locale);
        String value = null;
        value = prop.containsKey(propertyKey) ? prop.getProperty(propertyKey) : propertyKey;
        return value;
    }

    private static Properties readProperty() {
        return LocaleUtil.readProperty(LocaleUtil.getCurrentUserLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProperty(Locale locale) {
        Properties prop = null;
        InputStream ins = null;
        try {
            String firstFileName = "/IReport";
            String postfix = ".properties";
            String propertiesFileName = null;
            String localeSplit = "_";
            propertiesFileName = locale.toString().startsWith("en") ? firstFileName + localeSplit + "en" + postfix : (locale.toString().equals("zh_CN") ? firstFileName + localeSplit + locale + postfix : firstFileName + postfix);
            if (resProperties.containsKey(propertiesFileName)) {
                prop = resProperties.get(propertiesFileName);
            } else {
                prop = new Properties();
                ins = LocaleUtil.class.getResourceAsStream(propertiesFileName);
                prop.load(ins);
                resProperties.put(propertiesFileName, prop);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"readProperty error");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"readProperty error");
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"inputStream close error");
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperty(String resPath) {
        Properties prop = new Properties();
        InputStream ins = null;
        try {
            if (resProperties.containsKey(resPath)) {
                prop = resProperties.get(resPath);
            } else {
                prop = new Properties();
                ins = new FileInputStream(new File(resPath));
                prop.load(ins);
                resProperties.put(resPath, prop);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File not found");
        }
        catch (IOException e) {
            LOGGER.error((Object)"readProperty IOException");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"readProperty RuntimeException");
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"inputStream close error");
            }
        }
        return prop;
    }

    public static String getProperty(String key, String reportId, Locale locale) {
        String value = null;
        if (key != null && reportId != null) {
            String filePath = LocaleUtil.getReportPropertyPath(reportId, locale);
            Properties prop = LocaleUtil.readProperty(filePath);
            value = prop.containsKey(key) ? prop.getProperty(key) : LocaleUtil.getReportPublicProperty(key, locale);
        }
        return value;
    }

    private static String getReportPropertyPath(String reportId, Locale locale) {
        String filePath = "/iReport/iReportBiz/reportPlugins/" + reportId + File.separator + LocaleUtil.getPropertiesFileName(locale);
        filePath = IReportUtil.getRealPath() + filePath;
        return filePath;
    }

    public static void removeReportRroperty(String reportId, Locale locale) {
        String filePath = LocaleUtil.getReportPropertyPath(reportId, locale);
        resProperties.remove(filePath);
    }

    public static void removeReportRroperty(String filePath) {
        resProperties.remove(filePath);
    }

    private static String getPublicPropertyPath(Locale locale) {
        String filePath = "/iReport/iReportBiz/resource/" + LocaleUtil.getPropertiesFileName(locale);
        filePath = IReportUtil.getRealPath() + filePath;
        return filePath;
    }

    public static String getReportPublicProperty(String key, Locale locale) {
        String value = null;
        String filePath = LocaleUtil.getPublicPropertyPath(locale);
        Properties prop = LocaleUtil.readProperty(filePath);
        value = prop.containsKey(key) ? prop.getProperty(key) : key;
        return value;
    }

    public static List<Properties> getPropertyList(String reportId, Locale locale) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        String reportResPath = LocaleUtil.getReportPropertyPath(reportId, locale);
        list.add(LocaleUtil.readProperty(reportResPath));
        String publicResPath = LocaleUtil.getPublicPropertyPath(locale);
        list.add(LocaleUtil.readProperty(publicResPath));
        return list;
    }

    public static String getPropertiesFileName(Locale locale) {
        String propertiesFileName = null;
        String firstFileName = "resources";
        String localeSplit = "_";
        String postfix = ".properties";
        propertiesFileName = locale.toString().startsWith("en") ? firstFileName + localeSplit + "en" + postfix : (locale.toString().equals("zh_CN") ? firstFileName + localeSplit + locale + postfix : firstFileName + postfix);
        return propertiesFileName;
    }

    public static String i18nElement(String resName, String key) {
        ResourceBundle bundle = null;
        String v = null;
        try {
            bundle = ResourceBundle.getBundle(resName, LocaleUtil.getCurrentUserLocale());
            if (StringUtils.isNotBlank(key)) {
                v = bundle.getString(key);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("i18nElement() key not exist:" + key + ". " + e.getMessage()));
            v = key;
        }
        return v;
    }

    public static String replaceParamValue(String source, String ... params) {
        if (null == source || source.trim().length() == 0) {
            return source;
        }
        StringBuilder target = new StringBuilder();
        int startIndex = source.indexOf("{");
        int endIndex = source.indexOf("}", startIndex);
        int temIndex = 0;
        int index = 0;
        while (startIndex != -1 && endIndex != -1) {
            target.append(source.substring(temIndex, startIndex));
            index = Integer.parseInt(source.substring(startIndex + 1, endIndex));
            target.append(params[index]);
            temIndex = endIndex + 1;
            startIndex = source.indexOf("{", endIndex);
            endIndex = source.indexOf("}", startIndex);
        }
        target.append(source.substring(temIndex));
        return target.toString();
    }
}

