/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ParseRemoteConf {
    private static final String PROP_NAME = "server-config.properites";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static Properties pro = new Properties();
    private static String serverIp;
    private static boolean useRemoteIp;
    private static ParseRemoteConf parseRemoteConfObj;

    public static ParseRemoteConf getInstance() {
        return parseRemoteConfObj;
    }

    private static void loadProperties() {
        InputStream input = null;
        try {
            input = ParseRemoteConf.class.getClassLoader().getResourceAsStream(PROP_NAME);
            pro.load(input);
            serverIp = pro.getProperty("server_ip") + ":" + pro.get("server_port");
            useRemoteIp = Boolean.valueOf(pro.getProperty("use_remote_ip"));
            LOGGER.info((Object)("config remote ip : " + serverIp));
        }
        catch (IOException e) {
            LOGGER.error((Object)("load remote-confi properties file exception : " + e.getMessage()));
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    public String getServerIp() {
        return serverIp;
    }

    public boolean isUseRemoteIp() {
        return useRemoteIp;
    }

    static {
        parseRemoteConfObj = new ParseRemoteConf();
        ParseRemoteConf.loadProperties();
    }
}

