/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.model.vo.BackTask;
import com.security.ireport.model.vo.ReportPlugVO;
import com.security.ireport.model.vo.SigTaskTimerConfig;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.TaskLogVO;
import com.security.ireport.model.vo.UserInfo;
import com.security.ireport.service.IReportProductAdapter;
import com.security.ireport.task.adapter.ITimerNameAdapter;
import com.security.ireport.util.IReportConfigUtil;
import com.security.logserver.module.condition.model.TreeNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

public final class ProductFaceUtil {
    public static final String LEVEL_DEBUG = "DEBUG";
    public static final String LEVEL_INFO = "INFO";
    public static final String LEVEL_ERROR = "ERROR";
    public static final String LEVEL_FATAL = "FATAL";
    private static ReentrantLock lock = new ReentrantLock();
    private static ProductFaceUtil instance = null;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private IReportProductAdapter adapter = null;
    private String adapterClassName = null;

    private ProductFaceUtil() {
        try {
            this.adapterClassName = IReportConfigUtil.getInstance().getConfig("adapterClassName");
            this.adapter = (IReportProductAdapter)Class.forName(this.adapterClassName).newInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Create product adpater failed: " + e.getMessage()));
        }
    }

    public void throwException(Throwable inThrowable) throws ProviderException {
        LOGGER.error((Object)inThrowable);
        throw new ProviderException(inThrowable.getMessage());
    }

    public void throwProductException(String message, String level, Throwable inThrowable) {
        this.adapter.throwException(message, level, inThrowable);
    }

    public boolean isBusinessException(Exception e) {
        return this.adapter.isBusinessException(e);
    }

    public String addReportMenu(ReportPlugVO report) {
        String result = "";
        try {
            boolean returnVal = this.adapter.addReportMenu(report);
            if (!returnVal) {
                result = "Add plugin id:" + report.getReportId() + " to service menu failed, maybe it has been exist!";
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("add menu record failed. " + e.getMessage()));
            result = e.getMessage();
        }
        return result;
    }

    public boolean delReportMenu(ReportPlugVO report) {
        boolean returnVal = false;
        try {
            returnVal = this.adapter.delReportMenu(report);
        }
        catch (Exception e) {
            LOGGER.error((Object)("del menu record failed. " + e.getMessage()));
        }
        return returnVal;
    }

    public TreeNode getReportNode() {
        String userName = this.getUserName();
        TreeNode tree = this.adapter.getMenuNode(userName);
        if (null != tree) {
            this.filtOutIReport(tree);
        }
        return tree;
    }

    public String getUserName() {
        return this.adapter.getUserName();
    }

    public Locale getUserLocale() {
        return this.adapter.getUserLocale();
    }

    public static ProductFaceUtil getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new ProductFaceUtil();
            }
            ProductFaceUtil productFaceUtil = instance;
            return productFaceUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public void recordOperationLog(SysOptLog sysOptLog) {
        this.adapter.recordOperationLog(sysOptLog);
    }

    public boolean backTask(long sessionId) {
        return this.adapter.backTask(sessionId);
    }

    public ITimerNameAdapter getTimerNameAdapter() {
        return this.adapter.getTimerNameAdapter();
    }

    private void filtOutIReport(TreeNode tree) {
        if (null == tree) {
            return;
        }
        TreeNode node = null;
        List<TreeNode> list = tree.getChildren();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            node = list.get(i);
            if (node.isLeaf()) {
                if (this.isIReportPlugin(node)) continue;
                list.remove(i);
                --i;
                continue;
            }
            this.filtOutIReport(node);
            if (node.getChildren() != null && !node.getChildren().isEmpty()) continue;
            list.remove(i);
            --i;
        }
    }

    private boolean isIReportPlugin(TreeNode tree) {
        boolean result = false;
        for (IReport report : PluginManager.getInstance().getReportPluginList().values()) {
            String treeNodeKey = tree.getKey();
            if (treeNodeKey == null || !treeNodeKey.equals(report.getId())) continue;
            result = true;
            tree.setKey(report.getId());
            tree.setValue("plugin");
            break;
        }
        return result;
    }

    public Connection getProductDBConn() {
        return this.adapter.getProductDBConn();
    }

    public String getProductName() {
        return this.adapter.getProductName();
    }

    public ConnWrapper getConnWrapper() {
        return new ConnWrapper(this.getProductDBConn());
    }

    public long getNextSessionId() {
        return this.adapter.getSessionId();
    }

    public UserInfo getUserInfo() {
        return this.adapter.getUserInfo();
    }

    public TaskLogVO addRpsConfCommTaskTimer(String cond, SigTaskTimerConfig timerConfig, String local) {
        return this.adapter.addRpsConfCommTaskTimer(cond, timerConfig, local);
    }

    public long addBackTask(BackTask backTask, long reportSessionId) {
        return this.adapter.addBackTask(backTask, reportSessionId);
    }

    public void setBaskTaskIsPrepare(long backTaskId) {
        this.adapter.setBaskTaskIsPrepare(backTaskId);
    }

    public int getTimeLevel(long reportSessionId) {
        return this.adapter.getTimeLevel(reportSessionId);
    }

    public List<String> getUserArea() {
        return this.adapter.getUserArea(this.getUserName());
    }

    public int getMenuAuth(String menuId) {
        return this.adapter.getMenuAuth(menuId, this.getUserName());
    }

    public void notifyReport(String authId, int taskId, int conditionId, String reportInfo, String reportName) {
        this.adapter.notifyReport(authId, taskId, conditionId, reportInfo, reportName);
    }

    public String notifySendEmail(String[] addressees, String theme, String content, String attachments) {
        return this.adapter.notifySendEmail(addressees, theme, content, attachments);
    }

    public static class ConnWrapper {
        private Connection conn;
        private Statement statement;

        public ConnWrapper(Connection conn) {
            this.conn = conn;
            try {
                if (null != conn) {
                    this.statement = conn.createStatement();
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)"ConnWrapper get Statement failed!");
            }
        }

        public void setCommit(boolean commit) throws SQLException {
            try {
                this.conn.setAutoCommit(commit);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"set AutoCommit failed!");
                throw e;
            }
        }

        public void rollback() {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rollback Connection failed!");
            }
        }

        public void commit() throws SQLException {
            this.conn.commit();
        }

        public Connection getConn() {
            return this.conn;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public void close() {
            if (null != this.statement) {
                try {
                    this.statement.clearBatch();
                    this.statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"close statement failed!");
                }
            }
            if (null != this.conn) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"close connection failed!");
                }
            }
        }
    }
}

