/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.security.ireport.util.IReportConfigUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexUtil {
    private static Pattern keyPattern = null;
    private static Pattern htmlKeyPattern = null;
    private static final String BASECHART = "[a-zA-Z0-9]";
    private static final String PUNCHART = "[\"#$&'*+,./:;<=>@^_`|~-]|\\(|\\)|\\[|\\]|\\{|\\}|\\!|\\?|\\%";
    private static final int DEFAULT_MAX_LENGTH = 25;
    private static final int DEFAULT_HTML_LENGTH = 17;
    private static final float DEFAULT_HTML_RATE = 6.46f;
    private static int showkeyLength;
    private static int printHtmlLength;

    public static MatchObject getMatchObject() {
        MatchObject matchObject = new MatchObject();
        matchObject.setMatcher(keyPattern.matcher(""));
        matchObject.setStrBuilder(new StringBuilder());
        return matchObject;
    }

    public static MatchObject getHtmlMatchObject() {
        MatchObject matchObject = new MatchObject();
        matchObject.setMatcher(htmlKeyPattern.matcher(""));
        matchObject.setStrBuilder(new StringBuilder());
        return matchObject;
    }

    public static String parseLend(String lend, MatchObject matchObject) {
        String tempLend = lend;
        if (null != tempLend && tempLend.length() > 0) {
            Matcher macher = matchObject.getMatcher();
            StringBuilder sb = matchObject.getStrBuilder();
            macher.reset(lend);
            sb.delete(0, sb.length());
            int startIndex = 0;
            int endIndex = 0;
            int tempIndex = 0;
            while (macher.find()) {
                startIndex = macher.start();
                endIndex = macher.end();
                sb.append(tempLend.substring(tempIndex, startIndex));
                sb.append(tempLend.substring(startIndex, endIndex)).append('\r');
                tempIndex = endIndex;
            }
            sb.append(tempLend.substring(endIndex));
            tempLend = sb.toString();
        }
        return tempLend;
    }

    public static void parseArray(MatchObject matchObject, List<Object[]> targets) {
        if (null != targets && !targets.isEmpty()) {
            Object tempObj = null;
            for (Object[] tempObjects : targets) {
                if (null == tempObjects) continue;
                int n = tempObjects.length;
                for (int index = tempObjects.length / 2; index < n; ++index) {
                    tempObj = tempObjects[index];
                    tempObjects[index] = RegexUtil.parseLend((String)tempObj, matchObject);
                }
            }
        }
    }

    public static void parseTableCell(int[] jasperCellLengths, List<Object[]> targets) {
        if (null != jasperCellLengths && jasperCellLengths.length != 0 && null != targets && !targets.isEmpty()) {
            MatchObject[] matchObjects = new MatchObject[jasperCellLengths.length];
            int[][] tempCache = new int[jasperCellLengths.length][2];
            int tempLength = 0;
            int cellJasperLength = 0;
            MatchObject tempMatchObject = null;
            boolean hasFlage = false;
            for (int index = 0; index < jasperCellLengths.length; ++index) {
                if (jasperCellLengths[index] == 0) {
                    matchObjects[index] = null;
                    continue;
                }
                cellJasperLength = RegexUtil.getMaxLength(jasperCellLengths[index]);
                for (int k = 0; k < tempLength; ++k) {
                    if (cellJasperLength != Integer.valueOf(tempCache[k][0])) continue;
                    matchObjects[index] = matchObjects[tempCache[k][1]];
                    hasFlage = true;
                    break;
                }
                if (!hasFlage) {
                    matchObjects[index] = tempMatchObject = RegexUtil.getTableHtmlMatchObject(cellJasperLength);
                    tempCache[tempLength++] = new int[]{cellJasperLength, index};
                }
                hasFlage = false;
            }
            Object tempObj = null;
            for (Object[] tempObjects : targets) {
                if (null == tempObjects) continue;
                int n = tempObjects.length;
                for (int index = 0; index < n; ++index) {
                    tempObj = tempObjects[index];
                    if (null == matchObjects[index]) continue;
                    tempObjects[index] = RegexUtil.parseLend((String)tempObj, matchObjects[index]);
                }
            }
        }
    }

    private static int getMaxLength(int jasperTableWide) {
        if (jasperTableWide <= 0) {
            return jasperTableWide;
        }
        float tempMaxLength = (float)jasperTableWide / 6.46f;
        return Math.round(tempMaxLength);
    }

    private static MatchObject getTableHtmlMatchObject(int htmlMaxLength) {
        Pattern pattern = Pattern.compile("([a-zA-Z0-9]|[\"#$&'*+,./:;<=>@^_`|~-]|\\(|\\)|\\[|\\]|\\{|\\}|\\!|\\?|\\%){" + htmlMaxLength + "}");
        MatchObject matchObject = new MatchObject();
        matchObject.setMatcher(pattern.matcher(""));
        matchObject.setStrBuilder(new StringBuilder());
        return matchObject;
    }

    static {
        String keyLengthStr = IReportConfigUtil.getInstance().getConfig("chart.lend.maxLength");
        showkeyLength = null != keyLengthStr && keyLengthStr.length() > 0 ? Integer.parseInt(keyLengthStr) : 25;
        keyPattern = Pattern.compile("([a-zA-Z0-9]|[\"#$&'*+,./:;<=>@^_`|~-]|\\(|\\)|\\[|\\]|\\{|\\}|\\!|\\?|\\%){" + showkeyLength + "}");
        String printHtmlLengthStr = IReportConfigUtil.getInstance().getConfig("table.value.printHtmlLength");
        printHtmlLength = null != printHtmlLengthStr && printHtmlLengthStr.length() > 0 ? Integer.parseInt(printHtmlLengthStr) : 17;
        htmlKeyPattern = Pattern.compile("([a-zA-Z0-9]|[\"#$&'*+,./:;<=>@^_`|~-]|\\(|\\)|\\[|\\]|\\{|\\}|\\!|\\?|\\%){" + printHtmlLength + "}");
    }

    public static class MatchObject {
        private Matcher matcher;
        private StringBuilder strBuilder;

        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setMatcher(Matcher matcher) {
            this.matcher = matcher;
        }

        public StringBuilder getStrBuilder() {
            return this.strBuilder;
        }

        public void setStrBuilder(StringBuilder strBuilder) {
            this.strBuilder = strBuilder;
        }
    }
}

