/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.dataset.Parameter;
import com.security.ireport.util.IOrder;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.OrderComparator;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SqlUtil {
    public static final String SQL_SELECT = "SELECT";
    public static final String SQL_FROM = "FROM";
    public static final String SQL_ORDER = "ORDER";
    public static final String SQL_BY = "BY";
    public static final String SQL_ASC = "ASC";
    public static final String SQL_DESC = "DESC";
    public static final String SQL_WHERE = "WHERE";
    public static final String SQL_AND = "AND";
    public static final String SQL_GROUP_BY = "GROUP BY";
    public static final String SQL_Q = "?";
    public static final int SELECT_INDEX = 0;
    public static final int WHERE_INDEX = 1;
    public static final int ORDER_INDEX = 2;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static List<String> decomposeSql(String sql) {
        ArrayList<String> list = new ArrayList<String>();
        String sqlTemp = SqlUtil.renewSql(sql);
        int whereIndex = sqlTemp.indexOf(SQL_WHERE);
        int orderIndex = sqlTemp.indexOf(SQL_ORDER);
        if (whereIndex > 0) {
            list.add(sqlTemp.substring(0, whereIndex).trim());
            list.add(sqlTemp.substring(whereIndex, orderIndex).trim());
        } else {
            list.add(sqlTemp.substring(0, orderIndex).trim());
            list.add("");
        }
        list.add(sqlTemp.substring(orderIndex).trim());
        return list;
    }

    private static String renewSql(String sql) {
        StringBuffer sb = new StringBuffer();
        if (!IReportConfCheckUtil.isStringEmpty(sql)) {
            String[] sqls = sql.split(" ");
            ArrayList<String> list = new ArrayList<String>();
            for (String str : sqls) {
                if (IReportConfCheckUtil.isStringEmpty(str)) continue;
                list.add(str);
            }
            for (String str : list) {
                sb.append(str).append(' ');
            }
        }
        return sb.toString().toUpperCase(Locale.US).trim();
    }

    public static List<String> getSqlSection(String sqlStr) {
        ArrayList<String> sqlSection = new ArrayList<String>();
        if (sqlStr != null && !sqlStr.trim().isEmpty()) {
            String[] sqlTxt = sqlStr.trim().toUpperCase(Locale.US).split(" ");
            int size = sqlTxt.length;
            for (int i = 0; i < size; ++i) {
                if (sqlTxt[i].trim().isEmpty()) continue;
                sqlSection.add(sqlTxt[i]);
            }
        }
        return sqlSection;
    }

    public static boolean isParamMatch(String sql, List<Parameter> paraList) {
        int num = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++num;
        }
        return num == paraList.size();
    }

    public static boolean isParaOrderValid(List<IOrder> paraList) {
        boolean isParaOrderValid = false;
        if (paraList != null && !paraList.isEmpty()) {
            try {
                IOrder item;
                int i;
                OrderComparator comparator = new OrderComparator();
                Collections.sort(paraList, comparator);
                Iterator<IOrder> iterator = paraList.iterator();
                for (i = 0; iterator.hasNext() && (item = iterator.next()).getFieldOrder() == i; ++i) {
                }
                if (i == paraList.size()) {
                    isParaOrderValid = true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("order is not start with 0 and continue. " + e.getMessage()));
            }
        } else {
            isParaOrderValid = true;
        }
        return isParaOrderValid;
    }

    public static String getTableNameFromSql(String sql) {
        String tableName = null;
        String[] sqlTxt = sql.split(" ");
        int size = sqlTxt.length;
        for (int i = 0; i < size; ++i) {
            if (!sqlTxt[i].equalsIgnoreCase(SQL_FROM) || i + 1 >= size) continue;
            tableName = sqlTxt[i + 1];
            break;
        }
        return tableName;
    }

    public static String getCreateFieldStr(List<FieldInfo> fieldsInfo) {
        StringBuilder createField = new StringBuilder();
        if (null != fieldsInfo && !fieldsInfo.isEmpty()) {
            for (FieldInfo fieldInfo : fieldsInfo) {
                String fieldType = "";
                if (fieldInfo.getFieldType().trim().equals("java.lang.String")) {
                    fieldType = "VARCHAR";
                } else if (fieldInfo.getFieldType().trim().equals("java.lang.Boolean")) {
                    fieldType = "TINYINT";
                } else if (fieldInfo.getFieldType().trim().equals("java.lang.Short")) {
                    fieldType = "SMALLINT";
                } else if (fieldInfo.getFieldType().trim().equals("java.lang.Integer")) {
                    fieldType = "INTEGER";
                } else if (fieldInfo.getFieldType().trim().equals("java.lang.Long")) {
                    fieldType = "BIGINT";
                } else if (fieldInfo.getFieldType().trim().equals("java.math.BigDecimal")) {
                    fieldType = "NUMERIC";
                } else if (fieldInfo.getFieldType().trim().equals("java.lang.Double")) {
                    fieldType = "DOUBLE";
                } else {
                    LOG.error((Object)("fieldType:" + fieldInfo.getFieldType() + " not support."));
                    return "";
                }
                createField.append(fieldInfo.getFieldName()).append(' ').append(fieldType).append(',');
            }
            return createField.substring(0, createField.length() - 1);
        }
        return "";
    }

    public static String transOrderFullSql(String originalSql, OrderInfo sortList) {
        String filterSql = originalSql.trim();
        if (sortList != null) {
            int orderIndex = filterSql.indexOf(" ORDER BY ");
            if (orderIndex > 0) {
                filterSql = filterSql.substring(0, orderIndex);
            }
            filterSql = filterSql + SqlUtil.transOrderSql(originalSql, sortList);
        }
        return filterSql;
    }

    private static String transOrderSql(String originalSql, OrderInfo sortInfo) {
        String orderSql = "";
        String filterSql = originalSql.trim();
        if (sortInfo != null) {
            String sortName = sortInfo.getOrderField();
            String sortType = sortInfo.getOrderType();
            String regular = "^[A-Za-z0-9|_]+$";
            if (Pattern.matches(regular, sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
                orderSql = " ORDER BY " + sortName + " " + sortType;
            }
        }
        int orderIndex = filterSql.indexOf(" ORDER BY ");
        if (orderSql.isEmpty() && orderIndex > 0) {
            orderSql = filterSql.substring(orderIndex);
        }
        return orderSql;
    }

    public static String formatSQL(String sql, Map<String, List<String>> queryCon) {
        if (StringUtils.isBlank(sql) || null == queryCon || sql.length() > 1024) {
            LOG.error((Object)"Failed to format sql. parameter");
            return null;
        }
        String[] sqlStrs = sql.split("\\$P|\\$p");
        if (sqlStrs.length <= 1) {
            return sql;
        }
        String temp = sql.replaceAll("\\$P|\\$p", " ");
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        temp = Normalizer.normalize(temp, Normalizer.Form.NFKC);
        Pattern p = Pattern.compile("''|'.*?'|\\{(.*?)(,.*?)?\\}|[^\\{\\}]+");
        Matcher m = p.matcher(temp);
        int paramIdx = 0;
        while (m.find()) {
            if (null == m.group(1)) {
                String tempGroup = m.group();
                tempGroup = Normalizer.normalize(tempGroup, Normalizer.Form.NFKC);
                int lastIndex = tempGroup.length();
                lastIndex = tempGroup.endsWith(" ") ? lastIndex - 1 : lastIndex;
                buff.append(tempGroup.substring(0, lastIndex));
                continue;
            }
            String paramName = m.group(1);
            String paramValue = queryCon.containsKey(paramName.trim()) && !queryCon.get(paramName.trim()).isEmpty() ? queryCon.get(paramName.trim()).get(0) : "";
            String paramSets = m.group(2) != null ? m.group(2) : "";
            paramList.add(paramValue);
            buff.append("{" + paramIdx + paramSets + "}");
            ++paramIdx;
        }
        return SqlUtil.formatStrSingleQuotes(buff.toString(), paramList.toArray());
    }

    public static String formatStrSingleQuotes(String formatStr, Object ... arguments) {
        if (null == formatStr || formatStr.isEmpty() || null == arguments) {
            return null;
        }
        String normalizeFormatStr = Normalizer.normalize(formatStr, Normalizer.Form.NFKC);
        if (normalizeFormatStr.contains("'")) {
            normalizeFormatStr = normalizeFormatStr.replaceAll("'", "@_@");
        }
        String result = MessageFormat.format(normalizeFormatStr, arguments);
        result = result.replaceAll("@_@", "'");
        return result;
    }

    public static String formatSQLSection(String sql, Map<String, List<String>> queryCon) {
        if (StringUtils.isBlank(sql) || sql.length() > 1024) {
            LOG.error((Object)"Failed to format SQLSection. Parameter \"sql\" is invalid.");
            return "";
        }
        String[] sqlStrs = sql.split("\\$P|\\$p");
        if (sqlStrs.length <= 1) {
            return sql;
        }
        String temp = sql.replaceAll("\\$P|\\$p", " ");
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        Pattern p = Pattern.compile("''|'.*?'|\\{(.*?)(,.*?)?\\}|[^\\{\\}]+");
        Matcher m = p.matcher(temp);
        int paramIdx = 0;
        while (m.find()) {
            String paramValue;
            if (null == m.group(1)) {
                buff.append(m.group());
                continue;
            }
            String paramName = m.group(1);
            String string = paramValue = queryCon.containsKey(paramName.trim()) && !queryCon.get(paramName.trim()).isEmpty() ? queryCon.get(paramName.trim()).get(0) : null;
            if (null == paramValue) {
                return null;
            }
            String paramSets = m.group(2) != null ? m.group(2) : "";
            paramList.add(paramValue);
            buff.append("{" + paramIdx + paramSets + "}");
            ++paramIdx;
        }
        return SqlUtil.formatStrSingleQuotes(buff.toString(), paramList.toArray());
    }

    public static List<Integer> getNullKeyIndex(Map<String, List<String>> condition, List<Parameter> paraList) {
        ArrayList<Integer> nullFlagList = new ArrayList<Integer>();
        if (paraList != null && !paraList.isEmpty()) {
            if (null == condition) {
                condition = new HashMap<String, List<String>>();
            }
            Iterator<Parameter> iterator = paraList.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                ++index;
                Parameter item = iterator.next();
                if (!condition.containsKey(item.getKey())) {
                    iterator.remove();
                    nullFlagList.add(index);
                    continue;
                }
                item.setValueList(condition.get(item.getKey()));
            }
        }
        return nullFlagList;
    }

    public static String removeWhereNullKey(String whereSql, List<Integer> nullFlagList) {
        String resultSql = "";
        if (!IReportConfCheckUtil.isStringEmpty(whereSql)) {
            int i;
            StringBuffer result = new StringBuffer();
            String[] condList = whereSql.toUpperCase(Locale.US).substring(SQL_WHERE.length()).split(SQL_AND);
            ArrayList<String> resultList = new ArrayList<String>();
            int index = 0;
            int size = condList.length;
            for (i = 0; i < size; ++i) {
                index = SqlUtil.removeWhereNullKeySubStr(condList[i], resultList, index, nullFlagList);
            }
            if (!resultList.isEmpty()) {
                result.append(SQL_WHERE);
                size = resultList.size();
                for (i = 0; i < size; ++i) {
                    result.append((String)resultList.get(i)).append(SQL_AND);
                }
                resultSql = result.toString();
                resultSql = resultSql.substring(0, resultSql.length() - SQL_AND.length()).trim();
            }
        }
        return resultSql;
    }

    private static int removeWhereNullKeySubStr(String cond, List<String> resultList, int index, List<Integer> nullFlagList) {
        if (cond != null && cond.indexOf(SQL_Q) != -1 && cond.indexOf(SQL_Q) != 0) {
            if (!nullFlagList.contains(++index)) {
                resultList.add(cond);
            }
        } else if (cond != null) {
            resultList.add(cond);
        }
        return index;
    }

    public static String replaceTableName(String sql, String tableName) {
        StringBuffer result = new StringBuffer();
        String[] sqlTxt = sql.split(" ");
        ArrayList<String> list = new ArrayList<String>();
        int size = sqlTxt.length;
        for (int i = 0; i < size; ++i) {
            if (sqlTxt[i].isEmpty()) continue;
            if (i > 0 && sqlTxt[i - 1].equalsIgnoreCase(SQL_FROM)) {
                list.add(tableName);
                continue;
            }
            list.add(sqlTxt[i]);
        }
        for (String item : list) {
            result.append(item).append(' ');
        }
        return result.toString().trim();
    }

    private static String transMySqlSql(String originalSql, long pgIndex, long pgSize, OrderInfo sortList) {
        String filterSql = SqlUtil.transOrderFullSql(originalSql, sortList);
        if (0L == pgIndex && 0L == pgSize) {
            return filterSql;
        }
        return filterSql + " limit " + (pgIndex - 1L) * pgSize + "," + pgSize;
    }

    private static String transMySqlSqlByStartEnd(String originalSql, long startIndex, long pgSize, OrderInfo sortList) {
        String filterSql = SqlUtil.transOrderFullSql(originalSql, sortList);
        return filterSql + " limit " + startIndex + "," + pgSize;
    }

    public static String getSqlFilterByDataTypeByStartEnd(String sql, long startIndex, long pgSize, OrderInfo sortList, String dataBaseType) {
        String filterSql = sql.trim();
        if ("mysql".equals(dataBaseType)) {
            return SqlUtil.transMySqlSqlByStartEnd(filterSql, startIndex, pgSize, sortList);
        }
        if ("oracle".equals(dataBaseType)) {
            return SqlUtil.transOracleSqlByStartEnd(filterSql, startIndex, pgSize, sortList);
        }
        if ("sqlserver".equals(dataBaseType)) {
            return SqlUtil.transSqlServerSqlByStartEnd(filterSql, startIndex, pgSize, sortList);
        }
        LOG.error((Object)("error dataBaseType:" + dataBaseType));
        return null;
    }

    public static String getSqlFilterByDataType(String sql, long pgIndex, long pgSize, OrderInfo sortList, String dataBaseType) {
        String filterSql = sql.trim();
        if ("mysql".equals(dataBaseType)) {
            return SqlUtil.transMySqlSql(filterSql, pgIndex, pgSize, sortList);
        }
        if ("oracle".equals(dataBaseType)) {
            return SqlUtil.transOracleSql(filterSql, pgIndex, pgSize, sortList);
        }
        if ("sqlserver".equals(dataBaseType)) {
            return SqlUtil.transSqlServerSql(filterSql, pgIndex, pgSize, sortList);
        }
        LOG.error((Object)("error dataBaseType:" + dataBaseType));
        return null;
    }

    private static String transOracleSql(String originalSql, long pgIndex, long pgSize, OrderInfo sortList) {
        String filterSql = SqlUtil.transOrderFullSql(originalSql, sortList);
        if (0L == pgIndex && 0L == pgSize) {
            return filterSql;
        }
        String oraclePre = "select * from (select A.*, ROWNUM RN from (";
        String oracleAfter = ") A where ROWNUM <= " + pgSize * pgIndex + ") where RN > " + pgSize * (pgIndex - 1L);
        return oraclePre + filterSql + oracleAfter;
    }

    private static String transOracleSqlByStartEnd(String originalSql, long startIndex, long pgSize, OrderInfo sortList) {
        String filterSql = SqlUtil.transOrderFullSql(originalSql, sortList);
        String oraclePre = "select * from (select A.*, ROWNUM RN from (";
        String oracleAfter = ") A where ROWNUM < " + (startIndex + pgSize) + ") where RN >= " + startIndex;
        return oraclePre + filterSql + oracleAfter;
    }

    private static String transSqlServerSql(String originalSql, long pgIndex, long pgSize, OrderInfo sortList) {
        String fullSql = null;
        if (0L == pgIndex && 0L == pgSize) {
            String filterSql;
            fullSql = filterSql = SqlUtil.transOrderFullSql(originalSql, sortList);
        } else {
            List<String> decomposeSql = SqlUtil.decomposeSql(originalSql, sortList);
            String firstSql = "SELECT *  FROM (SELECT TOP " + pgSize + " * from (";
            String midSql = decomposeSql.get(0).replaceFirst(SQL_SELECT, "SELECT TOP " + pgIndex * pgSize + " ");
            String orderStr = decomposeSql.get(1);
            boolean isDesc = (orderStr = Normalizer.normalize(orderStr, Normalizer.Form.NFKC)).endsWith(SQL_DESC);
            if (isDesc) {
                orderStr = orderStr.substring(0, orderStr.length() - SQL_DESC.length());
                fullSql = firstSql + midSql + " " + orderStr + " DESC ) as tempTable " + orderStr + " ) as tempTable " + orderStr + " DESC";
            } else {
                if (orderStr.endsWith(SQL_ASC)) {
                    orderStr = orderStr.substring(0, orderStr.length() - SQL_ASC.length());
                }
                fullSql = firstSql + midSql + " " + orderStr + ") as tempTable " + orderStr + " DESC ) as tempTable " + orderStr;
            }
        }
        return fullSql;
    }

    private static String transSqlServerSqlByStartEnd(String originalSql, long startIndex, long pgSize, OrderInfo sortList) {
        String fullSql = null;
        List<String> decomposeSql = SqlUtil.decomposeSql(originalSql, sortList);
        String firstSql = "SELECT *  FROM (SELECT TOP " + pgSize + " * from (";
        String midSql = decomposeSql.get(0).replaceFirst(SQL_SELECT, "SELECT TOP " + (startIndex + pgSize) + " ");
        String orderStr = decomposeSql.get(1);
        boolean isDesc = (orderStr = Normalizer.normalize(orderStr, Normalizer.Form.NFKC)).endsWith(SQL_DESC);
        if (isDesc) {
            orderStr = orderStr.substring(0, orderStr.length() - SQL_DESC.length());
            fullSql = firstSql + midSql + " " + orderStr + " DESC ) as tempTable " + orderStr + " ) as tempTable " + orderStr + " DESC";
        } else {
            if (orderStr.endsWith(SQL_ASC)) {
                orderStr = orderStr.substring(0, orderStr.length() - SQL_ASC.length());
            }
            fullSql = firstSql + midSql + " " + orderStr + ") as tempTable " + orderStr + " DESC ) as tempTable " + orderStr;
        }
        return fullSql;
    }

    public static List<String> decomposeSql(String originalSql, OrderInfo sortList) {
        ArrayList<String> list = new ArrayList<String>();
        String filterSql = originalSql.toUpperCase(Locale.US).trim();
        int orderIndex = filterSql.indexOf(" ORDER BY ");
        if (orderIndex > 0) {
            list.add(filterSql.substring(0, orderIndex).trim().toUpperCase(Locale.US));
        } else {
            list.add(filterSql);
        }
        list.add(SqlUtil.transOrderSql(filterSql, sortList).trim().toUpperCase(Locale.US));
        return list;
    }

    private static PreparedStatement preparedStatement(PreparedStatement pstmt, List<Parameter> parasList) throws SQLException {
        if (null != parasList && !parasList.isEmpty()) {
            int index = 0;
            for (int i = 0; i < parasList.size(); ++i) {
                index = SqlUtil.setPreparedStatement(parasList.get(i), pstmt, index);
            }
        }
        return pstmt;
    }

    private static int setPreparedStatement(Parameter para, PreparedStatement pstmt, int index) throws SQLException {
        List<String> value = para.getValueList();
        if (!value.isEmpty()) {
            int size = value.size();
            for (int k = 0; k < size; ++k) {
                pstmt.setObject(++index, value.get(k));
            }
        } else {
            LOG.error((Object)("parameter value is empty. parameter key =" + para.getKey()));
        }
        return index;
    }

    public static String replaceKeyMulValueSql(String whereSql, List<Parameter> parasList) {
        String resultSql = "";
        if (!IReportConfCheckUtil.isStringEmpty(whereSql)) {
            StringBuffer result = new StringBuffer();
            String[] condList = whereSql.toUpperCase(Locale.US).split(SQL_AND);
            int index = 0;
            int size = condList.length;
            for (int i = 0; i < size; ++i) {
                if (condList[i] != null && condList[i].indexOf(SQL_Q) != -1 && condList[i].indexOf(SQL_Q) != 0) {
                    condList[i] = SqlUtil.transQByValueSize(parasList.get(index), condList[i]);
                    ++index;
                }
                result.append(condList[i]).append(SQL_AND);
            }
            resultSql = result.toString();
            resultSql = resultSql.substring(0, resultSql.length() - SQL_AND.length()).trim();
        }
        return resultSql;
    }

    private static String transQByValueSize(Parameter param, String cond) {
        String result = cond;
        int paraValueSize = param.getValueList().size();
        if (paraValueSize > 1) {
            result = cond.replace(SQL_Q, SqlUtil.getSqlQ(paraValueSize));
        }
        return result;
    }

    private static String getSqlQ(int count) {
        String resultStr = "";
        if (count > 0) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                result.append(SQL_Q).append(',');
            }
            resultStr = result.toString();
            resultStr = resultStr.substring(0, resultStr.length() - 1);
        }
        return resultStr;
    }

    public static Object getValue(long row, String colName, List<Object[]> curPageData, List<FieldInfo> fieldsInfo) {
        Object result = null;
        int colIndex = SqlUtil.getColIndex(colName, fieldsInfo);
        if (colIndex > -1) {
            result = curPageData.get((int)row)[colIndex];
        } else {
            LOG.error((Object)("colName:" + colName + " is not exist."));
        }
        return result;
    }

    private static int getColIndex(String fieldName, List<FieldInfo> fieldsInfo) {
        int colIndex = -1;
        if (fieldsInfo != null && !fieldsInfo.isEmpty() && fieldName != null) {
            int size = fieldsInfo.size();
            for (int i = 0; i < size; ++i) {
                if (!fieldsInfo.get(i).getFieldName().equals(fieldName)) continue;
                colIndex = i;
                break;
            }
        }
        return colIndex;
    }

    public static List<Object[]> transResultSet(ResultSet rs) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            Object obj = null;
            while (rs.next()) {
                Object[] resultArray = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    obj = rs.getObject(i + 1);
                    resultArray[i] = obj == null ? "--" : obj;
                }
                list.add(resultArray);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("transResultSet failed. " + e.getMessage()));
            list.clear();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> execusePrepareQuery(String sql, Connection conn, List<Parameter> paraList, List<FieldInfo> fieldList) {
        List<Object[]> result = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (sql != null && conn != null) {
                pstmt = conn.prepareStatement(sql);
                pstmt = SqlUtil.preparedStatement(pstmt, paraList);
                rs = pstmt.executeQuery();
                result = SqlUtil.transResultSet(rs);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"execusePrepareQuery failed SQLException.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"execusePrepareQuery failed.");
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"execusePrepareQuery failed.");
            }
        }
        return result;
    }

    public static String getFullSql(List<String> sqlList) {
        return sqlList.get(0) + " " + sqlList.get(1) + " " + sqlList.get(2);
    }

    public static String getCountSql(List<String> sqlList) {
        String whereSql = sqlList.get(1);
        String fromSql = sqlList.get(0).substring(sqlList.get(0).indexOf(SQL_FROM));
        if (whereSql.indexOf(SQL_GROUP_BY) != -1) {
            return "SELECT COUNT(1) FROM (SELECT 1 " + fromSql + " " + whereSql + ") t ";
        }
        return "SELECT COUNT(1) " + fromSql + " " + whereSql;
    }
}

