/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.security.ireport.engine.definition.chart.ChartValue;
import com.security.ireport.engine.definition.chart.XYChartValue;
import com.security.ireport.util.IReportConfCheckUtil;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.data.xy.XYDataset;

public class IReportXYURLGenerator
extends StandardXYURLGenerator {
    private static final long serialVersionUID = 636190210691457205L;
    private String prefix;
    private String seriesParameterName;
    private String itemParameterName;
    private Map<String, Map<Double, String>> urlMap = new HashMap<String, Map<Double, String>>();

    public IReportXYURLGenerator() {
    }

    public IReportXYURLGenerator(String prefix, String seriesParameterName, String itemParameterName) {
        super(prefix, seriesParameterName, itemParameterName);
        this.prefix = prefix;
        this.itemParameterName = itemParameterName;
        this.seriesParameterName = seriesParameterName;
    }

    public String generateURL(XYDataset dataset, int series, int item) {
        String url = null;
        String seriesName = IReportConfCheckUtil.getObjectStr(dataset.getSeriesKey(series));
        Double value = dataset.getXValue(series, item);
        if (this.urlMap.containsKey(seriesName) && this.urlMap.get(seriesName).containsKey(value)) {
            url = this.urlMap.get(seriesName).get(value);
        }
        return url;
    }

    public void setChartValue(ChartValue[] values) {
        if (values != null && values.length > 1) {
            for (ChartValue item : values) {
                XYChartValue value = (XYChartValue)item;
                if (!this.urlMap.containsKey(value.getSeries())) {
                    this.urlMap.put(value.getSeries(), new HashMap());
                }
                this.urlMap.get(value.getSeries()).put(value.getValue(), item.getUrlText());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemParameterName == null ? 0 : this.itemParameterName.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.seriesParameterName == null ? 0 : this.seriesParameterName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return this.otherEquals(obj);
    }

    private boolean otherEquals(Object obj) {
        IReportXYURLGenerator other = (IReportXYURLGenerator)((Object)obj);
        if (this.itemParameterName == null ? other.itemParameterName != null : !this.itemParameterName.equals(other.itemParameterName)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        return !(this.seriesParameterName == null ? other.seriesParameterName != null : !this.seriesParameterName.equals(other.seriesParameterName));
    }
}

