/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ChartUtil;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.model.vo.LegendColor;
import com.security.ireport.util.EscapeUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;

public abstract class LegendUtil {
    public static final String FOUR_COL_LEGEND_SUBREPORT = "fourColLegendSubreport";
    public static final String TWO_COL_LEGEND_SUBREPORT = "twoColLegendSubreport";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final String FOUR_COL_LEGEND_TEMPLATE = "legendSubreportTemplate.jrxml";
    private static final String TWO_COL_LEGEND_TEMPLATE = "towColLegendSubreportTemplate.jrxml";
    private static final int DEFAULT_LEGENT_TOOTIP = 64;
    private static int toolTipValue = 24;

    public static List<FieldInfo> getFourColFieldList() {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        FieldInfo item = new FieldInfo();
        item.setFieldName("colorStyle1");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("colorStyle2");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("colorStyle3");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("colorStyle4");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("legendLabel1");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("legendLabel2");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("legendLabel3");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("legendLabel4");
        item.setFieldType("java.lang.String");
        fields.add(item);
        return fields;
    }

    public static List<Object[]> getFourColLegendData(List<LegendColor> legendColorList) {
        if (null == legendColorList || legendColorList.isEmpty()) {
            return new ArrayList<Object[]>();
        }
        ArrayList<Object[]> fourColLegendData = new ArrayList<Object[]>();
        int rowNum = legendColorList.size() / 4;
        int lastRowColNum = legendColorList.size() % 4;
        if (lastRowColNum != 0) {
            ++rowNum;
        } else {
            lastRowColNum = 4;
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            int index = i * 4;
            Object[] objList = LegendUtil.getFourColLegendData(legendColorList.get(index), legendColorList.get(index + 1), legendColorList.get(index + 2), legendColorList.get(index + 3));
            fourColLegendData.add(objList);
        }
        Object[] objList = LegendUtil.getFourColLastRowData(lastRowColNum, rowNum, legendColorList);
        fourColLegendData.add(objList);
        return fourColLegendData;
    }

    private static Object[] getFourColLastRowData(int lastRowColNum, int rowNum, List<LegendColor> legendColorList) {
        ArrayList<LegendColor> temp = new ArrayList<LegendColor>();
        for (int i = 0; i < lastRowColNum; ++i) {
            int index = (rowNum - 1) * 4 + i;
            temp.add(legendColorList.get(index));
        }
        LegendColor legendColor1 = (LegendColor)temp.get(0);
        LegendColor legendColor2 = temp.size() >= 2 ? (LegendColor)temp.get(1) : null;
        LegendColor legendColor3 = temp.size() >= 3 ? (LegendColor)temp.get(2) : null;
        LegendColor legendColor4 = temp.size() == 4 ? (LegendColor)temp.get(3) : null;
        Object[] objList = LegendUtil.getFourColLegendData(legendColor1, legendColor2, legendColor3, legendColor4);
        return objList;
    }

    private static Object[] getFourColLegendData(LegendColor legendColor1, LegendColor legendColor2, LegendColor legendColor3, LegendColor legendColor4) {
        Object[] objList = new Object[8];
        if (legendColor1 != null) {
            objList[0] = legendColor1.getColorStr();
            objList[4] = legendColor1.getLegend();
        }
        if (legendColor2 != null) {
            objList[1] = legendColor2.getColorStr();
            objList[5] = legendColor2.getLegend();
        }
        if (legendColor3 != null) {
            objList[2] = legendColor3.getColorStr();
            objList[6] = legendColor3.getLegend();
        }
        if (legendColor4 != null) {
            objList[3] = legendColor4.getColorStr();
            objList[7] = legendColor4.getLegend();
        }
        return objList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFourColLegendSubreport(List<String> colorList) throws JRException {
        String jasperTemplatePath = IReportUtil.getJasperTemplatePath();
        String jrxmlFile = jasperTemplatePath + "/" + FOUR_COL_LEGEND_SUBREPORT + ".jrxml";
        String jasperFile = jasperTemplatePath + "/" + FOUR_COL_LEGEND_SUBREPORT + ".jasper";
        String templatePath = jasperTemplatePath + "/" + FOUR_COL_LEGEND_TEMPLATE;
        String templateXml = LegendUtil.getSubreportTemplateXml(templatePath);
        String colorStyle = LegendUtil.getColorStyle(colorList);
        String colorStyleTextField1 = LegendUtil.getColorStyleTextField(colorList, 1);
        String colorStyleTextField2 = LegendUtil.getColorStyleTextField(colorList, 2);
        String colorStyleTextField3 = LegendUtil.getColorStyleTextField(colorList, 3);
        String colorStyleTextField4 = LegendUtil.getColorStyleTextField(colorList, 4);
        templateXml = templateXml.replace("${colorStyle}", colorStyle);
        templateXml = templateXml.replace("${colorStyle1TextField}", colorStyleTextField1);
        templateXml = templateXml.replace("${colorStyle2TextField}", colorStyleTextField2);
        templateXml = templateXml.replace("${colorStyle3TextField}", colorStyleTextField3);
        templateXml = templateXml.replace("${colorStyle4TextField}", colorStyleTextField4);
        Writer write = null;
        try {
            write = new OutputStreamWriter((OutputStream)new FileOutputStream(jrxmlFile), "UTF-8");
            write.write(templateXml);
            write.flush();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"createFourColLegendSubreport UnsupportedEncodingException error");
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File not found");
        }
        catch (IOException e) {
            LOGGER.error((Object)"createFourColLegendSubreport IOException error");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"createFourColLegendSubreport error");
        }
        finally {
            if (write != null) {
                try {
                    write.close();
                }
                catch (Exception e2) {
                    LOGGER.error((Object)"write close failed");
                }
            }
        }
        JasperCompileManager.compileReportToFile((String)jrxmlFile, (String)jasperFile);
    }

    public static List<FieldInfo> getTwoColFieldList() {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        FieldInfo item = new FieldInfo();
        item.setFieldName("colorStyle1");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("colorStyle2");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("legendLabel1");
        item.setFieldType("java.lang.String");
        fields.add(item);
        item = new FieldInfo();
        item.setFieldName("legendLabel2");
        item.setFieldType("java.lang.String");
        fields.add(item);
        return fields;
    }

    public static List<Object[]> getTwoColLegendData(List<LegendColor> legendColorList) {
        if (null == legendColorList || legendColorList.isEmpty()) {
            return new ArrayList<Object[]>();
        }
        ArrayList<Object[]> fourColLegendData = new ArrayList<Object[]>();
        int rowNum = legendColorList.size() / 2;
        int lastRowColNum = legendColorList.size() % 2;
        if (lastRowColNum != 0) {
            ++rowNum;
        } else {
            lastRowColNum = 2;
        }
        for (int i = 0; i < rowNum - 1; ++i) {
            int index = i * 2;
            Object[] objList = LegendUtil.getTwoColLegendData(legendColorList.get(index), legendColorList.get(index + 1));
            fourColLegendData.add(objList);
        }
        Object[] objList = LegendUtil.getTwoColLastRowData(lastRowColNum, rowNum, legendColorList);
        fourColLegendData.add(objList);
        return fourColLegendData;
    }

    private static Object[] getTwoColLastRowData(int lastRowColNum, int rowNum, List<LegendColor> legendColorList) {
        ArrayList<LegendColor> temp = new ArrayList<LegendColor>();
        for (int i = 0; i < lastRowColNum; ++i) {
            int index = (rowNum - 1) * 2 + i;
            temp.add(legendColorList.get(index));
        }
        LegendColor legendColor1 = (LegendColor)temp.get(0);
        LegendColor legendColor2 = temp.size() == 2 ? (LegendColor)temp.get(1) : null;
        Object[] objList = LegendUtil.getTwoColLegendData(legendColor1, legendColor2);
        return objList;
    }

    private static Object[] getTwoColLegendData(LegendColor legendColor1, LegendColor legendColor2) {
        Object[] objList = new Object[8];
        if (legendColor1 != null) {
            objList[0] = legendColor1.getColorStr();
            objList[2] = legendColor1.getLegend();
        }
        if (legendColor2 != null) {
            objList[1] = legendColor2.getColorStr();
            objList[3] = legendColor2.getLegend();
        }
        return objList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTwoColLegendSubreport(List<String> colorList) throws JRException {
        String jasperTemplatePath = IReportUtil.getJasperTemplatePath();
        String jrxmlFile = jasperTemplatePath + "/" + TWO_COL_LEGEND_SUBREPORT + ".jrxml";
        String jasperFile = jasperTemplatePath + "/" + TWO_COL_LEGEND_SUBREPORT + ".jasper";
        String templatePath = jasperTemplatePath + "/" + TWO_COL_LEGEND_TEMPLATE;
        String templateXml = LegendUtil.getSubreportTemplateXml(templatePath);
        String colorStyle = LegendUtil.getColorStyle(colorList);
        String colorStyleTextField1 = LegendUtil.getColorStyleTextField(colorList, 1);
        String colorStyleTextField2 = LegendUtil.getColorStyleTextField(colorList, 2);
        templateXml = templateXml.replace("${colorStyle}", colorStyle);
        templateXml = templateXml.replace("${colorStyle1TextField}", colorStyleTextField1);
        templateXml = templateXml.replace("${colorStyle2TextField}", colorStyleTextField2);
        Writer write = null;
        try {
            write = new OutputStreamWriter((OutputStream)new FileOutputStream(jrxmlFile), "UTF-8");
            write.write(templateXml);
            write.flush();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"createTwoColLegendSubreport UnsupportedEncodingException error");
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File not found");
        }
        catch (IOException e) {
            LOGGER.error((Object)"createTwoColLegendSubreport IOException error");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"createTwoColLegendSubreport RuntimeException error");
        }
        finally {
            if (write != null) {
                try {
                    write.close();
                }
                catch (Exception e2) {
                    LOGGER.error((Object)"write close failed");
                }
            }
        }
        JasperCompileManager.compileReportToFile((String)jrxmlFile, (String)jasperFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSubreportTemplateXml(String templatePath) {
        FileInputStream fis = null;
        StringBuffer fileContent = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            fis = new FileInputStream(templatePath);
            reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                fileContent.append(line).append('\n');
            }
            return fileContent.toString();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File read failed.");
            return fileContent.toString();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"File read failed UnsupportedEncodingException.");
            return fileContent.toString();
        }
        catch (IOException e) {
            LOGGER.error((Object)"File read failed IOException.");
            return fileContent.toString();
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"File read failed RuntimeException.");
            return fileContent.toString();
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (Exception e2) {
                LOGGER.error((Object)"fis close failed");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    LOGGER.error((Object)"reader close failed");
                }
            }
        }
    }

    private static String getColorStyle(List<String> colorList) {
        StringBuffer sb = new StringBuffer();
        if (colorList != null && !colorList.isEmpty()) {
            for (String color : colorList) {
                String tempColor = ChartUtil.getFontColor(color);
                sb.append("<style name=\"").append(tempColor).append("\" isDefault=\"false\" forecolor=\"").append(tempColor).append("\" />").append('\n');
            }
        }
        return sb.toString();
    }

    private static String getColorStyleTextField(List<String> colorList, int index) {
        StringBuffer sb = new StringBuffer();
        int xPos = 0;
        switch (index) {
            case 2: {
                xPos = 120;
                break;
            }
            case 3: {
                xPos = 240;
                break;
            }
            case 4: {
                xPos = 365;
                break;
            }
        }
        if (colorList != null && !colorList.isEmpty()) {
            for (String color : colorList) {
                String tempColor = ChartUtil.getFontColor(color);
                sb.append("<textField isStretchWithOverflow=\"true\" isBlankWhenNull=\"true\" >").append('\n').append("<reportElement style=\"" + tempColor + "\" mode=\"Opaque\" positionType=\"Float\" x=\"" + xPos + "\" y=\"0\" width=\"15\" height=\"30\"  stretchType=\"RelativeToBandHeight\" isRemoveLineWhenBlank=\"true\"/>").append('\n').append("<textElement textAlignment=\"Left\" verticalAlignment=\"Top\">").append('\n').append("<font pdfFontName=\"").append(IReportConfigUtil.getInstance().getJasperPdfFontName()).append("\" size=\"10\" isPdfEmbedded =\"true\" pdfEncoding =\"Identity-H\"/>").append('\n').append("</textElement>").append('\n').append("<textFieldExpression class=\"java.lang.String\"><![CDATA[$F{colorStyle" + index + "}.equals(\"" + tempColor + "\") ? \"\u25a0\"  : null]]></textFieldExpression>").append('\n').append("</textField>").append('\n');
            }
        }
        return sb.toString();
    }

    public static String getFourColLegendHtml(List<LegendColor> colorList) {
        if (null == colorList || colorList.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int legendSize = colorList.size();
        int rowNum = legendSize / 4;
        int lastRowColNum = legendSize % 4;
        if (lastRowColNum != 0) {
            ++rowNum;
        } else {
            lastRowColNum = 4;
        }
        for (int j = 0; j < rowNum - 1; ++j) {
            int index = j * 4;
            sb.append("<tr>");
            LegendUtil.appendLegendTag(sb, 20, colorList.get(index), colorList.get(index + 1), colorList.get(index + 2), colorList.get(index + 3));
            sb.append("</tr>");
        }
        ArrayList<LegendColor> temp = new ArrayList<LegendColor>();
        for (int i = 0; i < lastRowColNum; ++i) {
            int index = (rowNum - 1) * 4 + i;
            temp.add(colorList.get(index));
        }
        LegendColor legendColor1 = (LegendColor)temp.get(0);
        LegendColor legendColor2 = temp.size() >= 2 ? (LegendColor)temp.get(1) : null;
        LegendColor legendColor3 = temp.size() >= 3 ? (LegendColor)temp.get(2) : null;
        LegendColor legendColor4 = temp.size() == 4 ? (LegendColor)temp.get(3) : null;
        sb.append("<tr>");
        LegendUtil.appendLegendTag(sb, 20, legendColor1, legendColor2, legendColor3, legendColor4);
        sb.append("</tr>");
        return sb.toString();
    }

    public static String getTwoColLegendHtml(List<LegendColor> colorList) {
        if (null == colorList || colorList.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int legendSize = colorList.size();
        int rowNum = legendSize / 2;
        int lastRowColNum = legendSize % 2;
        if (lastRowColNum != 0) {
            ++rowNum;
        } else {
            lastRowColNum = 2;
        }
        for (int j = 0; j < rowNum - 1; ++j) {
            int index = j * 2;
            sb.append("<tr>");
            LegendUtil.appendLegendTag(sb, 45, colorList.get(index), colorList.get(index + 1));
            sb.append("</tr>");
        }
        ArrayList<LegendColor> temp = new ArrayList<LegendColor>();
        for (int i = 0; i < lastRowColNum; ++i) {
            int index = (rowNum - 1) * 2 + i;
            temp.add(colorList.get(index));
        }
        LegendColor legendColor1 = (LegendColor)temp.get(0);
        LegendColor legendColor2 = temp.size() == 2 ? (LegendColor)temp.get(1) : null;
        sb.append("<tr>");
        LegendUtil.appendLegendTag(sb, 45, legendColor1, legendColor2);
        sb.append("</tr>");
        return sb.toString();
    }

    private static void appendLegendTag(StringBuffer buffer, int width, LegendColor ... lengendColors) {
        for (LegendColor tempLegendColor : lengendColors) {
            if (null != tempLegendColor) {
                buffer.append("<td style=\"font-size:14px;font-family:'\u5b8b\u4f53';color:").append(tempLegendColor.getColorStr()).append("\" width=\"5%\">\u25a0</td>");
                LegendUtil.appendLegendInfo(buffer, width, tempLegendColor);
                continue;
            }
            buffer.append("<td width=\"5%\">&nbsp;</td>");
            buffer.append("<td width=\"").append(width).append("%\">&nbsp;</td>");
        }
    }

    private static void appendLegendInfo(StringBuffer buffer, int width, LegendColor legendColor) {
        buffer.append("<td width=\"").append(width).append("%\" title=\"");
        LegendUtil.appendLegendTitle(buffer, legendColor.getLegend());
        buffer.append('\"').append('>');
        buffer.append(LegendUtil.encode(LegendUtil.getByteLengthStr(legendColor.getLegend(), toolTipValue)));
        buffer.append("</td>");
    }

    private static String encode(String text) {
        text = text.replace("&", "&amp;");
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = text.replace("(", "&#x28;");
        text = text.replace(")", "&#x29;");
        return text;
    }

    public static String getByteLengthStr(String target, int byteLength) {
        int index;
        if (null == target || target.length() <= byteLength) {
            return target;
        }
        String result = null;
        int tempTotal = 0;
        char tempChar = '\u0000';
        int n = target.length();
        for (index = 0; index < n && tempTotal <= byteLength; tempTotal += ((tempChar = target.charAt(index)) & 0xFF80) == 0 ? 1 : 2, ++index) {
        }
        result = target.substring(0, --index);
        if (index != target.length()) {
            result = result + "...";
        }
        return result;
    }

    private static void appendLegendTitle(StringBuffer buffer, String legend) {
        if (null != legend) {
            int tempIndex = 0;
            int index = 0;
            int length = legend.length();
            while (index < length) {
                tempIndex = index;
                index = index + 64 > length ? length : index + 64;
                buffer.append(EscapeUtil.escapeHtmlValue(legend.substring(tempIndex, index)));
                if (index == length) continue;
                buffer.append('\r');
            }
        }
    }

    public static String changeToWOS(String url) {
        if (null == url) {
            return "";
        }
        return url;
    }

    static {
        String tooltipValue = IReportConfigUtil.getInstance().getConfig("char.lend.tooltip.byteMaxValue");
        if (null != tooltipValue && tooltipValue.length() > 0) {
            toolTipValue = Integer.parseInt(tooltipValue);
        }
    }
}

