/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.logserver.module.condition.cfg.ConditionConfigParser;
import com.security.logserver.module.condition.cfg.ConditionDefineParser;
import com.security.logserver.module.condition.cfg.parser.IParser;
import com.security.logserver.module.condition.cfg.parser.PareserFactory;
import com.security.logserver.module.condition.common.AjaxDataSourceMgr;
import com.security.logserver.module.condition.util.ElogConditionException;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ConditionParser {
    private static ConditionParser parser = null;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private Map<String, Object> conditionGroupMap = new HashMap<String, Object>();
    private Map<String, Map<String, String>> conditionGroupInfoMap = new HashMap<String, Map<String, String>>();
    private boolean parsed = false;

    private ConditionParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionParser immediateParse() throws ElogConditionException {
        List<String> configFiles = null;
        ConditionParser conditionParser = this;
        synchronized (conditionParser) {
            configFiles = ConditionConfigParser.getInstance().parse().getResource();
            for (String file : configFiles) {
                if (!StringUtils.isNotBlank(file)) continue;
                this.parseSingleFile(file);
            }
        }
        this.parsed = true;
        return this;
    }

    public void unloadReport(String reportId) {
        this.getConditionGroupMap().remove(reportId);
        this.getConditionGroupInfoMap().remove(reportId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseSingleFile(String path) {
        boolean flag = true;
        File file = new File(path);
        FileInputStream ins = null;
        Document doc = null;
        Element root = null;
        Element el = null;
        Iterator eit = null;
        Iterator ceit = null;
        Map<String, String> groupInfo = null;
        Map<String, Object> subGroup = null;
        String id = "";
        try {
            ins = new FileInputStream(file);
            SAXReader saxReader = new SAXReader();
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxReader.setValidation(true);
            saxReader.setEntityResolver((EntityResolver)new InnerClass());
            doc = saxReader.read((InputStream)ins);
            root = doc.getRootElement();
            eit = root.elementIterator("condition-group");
            while (eit.hasNext()) {
                el = (Element)eit.next();
                groupInfo = this.parseConditionGroupInfo(el);
                this.conditionGroupInfoMap.put(groupInfo.get("id"), groupInfo);
                id = el.attributeValue("id");
                ceit = el.elementIterator();
                ArrayList<Map<String, Object>> subGroupList = new ArrayList<Map<String, Object>>();
                int index = 0;
                while (ceit.hasNext()) {
                    Element temp = (Element)ceit.next();
                    subGroup = this.parserSubConditionGroup(temp, id, index);
                    subGroupList.add(subGroup);
                    ++index;
                }
                this.conditionGroupMap.put(id, subGroupList);
            }
        }
        catch (FileNotFoundException e) {
            flag = false;
            LOGGER.error((Object)("parse() " + file.getName() + " FileNotFoundException error!"));
        }
        catch (DocumentException e) {
            flag = false;
            LOGGER.error((Object)("parse() " + file.getName() + " DocumentException error!"));
        }
        catch (ElogConditionException e) {
            flag = false;
            LOGGER.error((Object)("parse() " + file.getName() + " ElogConditionException error!"));
        }
        catch (RuntimeException e) {
            flag = false;
            LOGGER.error((Object)("parse() " + file.getName() + " RuntimeException error!"));
        }
        catch (SAXException e) {
            flag = false;
            LOGGER.error((Object)("parse() " + file.getName() + " error!"));
        }
        finally {
            if (null != ins) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("FileInputStream close error:" + file.getName()));
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionParser parse() throws ElogConditionException {
        if (this.parsed) {
            Class<ConditionParser> clazz = ConditionParser.class;
            synchronized (ConditionParser.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return parser;
            }
        }
        return this.immediateParse();
    }

    private Map<String, Object> parserSubConditionGroup(Element subGroupEl, String groupId, int index) throws ElogConditionException {
        String name = subGroupEl.getName();
        HashMap<String, Object> subGroup = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> cdtInfoList = new ArrayList<Map<String, Object>>();
        if ("sub-group".equals(name)) {
            Iterator attrIt = subGroupEl.attributeIterator();
            while (attrIt.hasNext()) {
                Attribute attr = (Attribute)attrIt.next();
                subGroup.put(attr.getName(), attr.getText());
            }
            String subGroupId = IReportConfCheckUtil.getObjectStr(subGroup.get("id"));
            if (StringUtils.isBlank(subGroupId)) {
                subGroupId = "subGroup_" + index + "_" + groupId;
                subGroup.put("id", subGroupId);
            }
            Iterator elIt = subGroupEl.elementIterator();
            while (elIt.hasNext()) {
                Element temp = (Element)elIt.next();
                Map<String, Object> cdtInfoMap = this.parserConditionConfig(temp);
                if (cdtInfoMap == null) continue;
                cdtInfoMap.put("subGroupId", subGroupId);
                cdtInfoMap.put("groupId", groupId);
                AjaxDataSourceMgr.getInstance().add(cdtInfoMap);
                cdtInfoList.add(cdtInfoMap);
            }
            subGroup.put("subConditions", cdtInfoList);
        } else if ("help".equals(name)) {
            Iterator elIt = subGroupEl.elementIterator();
            while (elIt.hasNext()) {
                Element temp = (Element)elIt.next();
                HashMap<String, String> cdtInfoMap = new HashMap<String, String>();
                cdtInfoMap.put(temp.getName(), temp.getTextTrim());
                cdtInfoList.add(cdtInfoMap);
            }
            subGroup.put("help", cdtInfoList);
        } else {
            String subGroupId = "subGroup_" + index + "_" + groupId;
            subGroup.put("id", subGroupId);
            Map<String, Object> cdtInfoMap = this.parserConditionConfig(subGroupEl);
            if (cdtInfoMap != null) {
                cdtInfoMap.put("subGroupId", subGroupId);
                cdtInfoMap.put("groupId", groupId);
                cdtInfoList.add(cdtInfoMap);
                AjaxDataSourceMgr.getInstance().add(cdtInfoMap);
                subGroup.put("subConditions", cdtInfoList);
                subGroup.put("label", cdtInfoMap.get("label"));
            }
        }
        return subGroup;
    }

    private Map<String, Object> parserConditionConfig(Element el) throws ElogConditionException {
        String type = el.getName();
        Map<String, Object> cdtDefineInfo = ConditionDefineParser.getInstance().parse().getDefineInfoMap().get(type);
        if (null == cdtDefineInfo) {
            return null;
        }
        String parserName = IReportConfCheckUtil.getObjectStr(cdtDefineInfo.get("parser"));
        IParser cdtConfigParser = PareserFactory.getInstance().getParser(parserName);
        Map<String, Object> cdtInfoMap = cdtConfigParser.parse(el);
        cdtInfoMap.put("url", cdtDefineInfo.get("url"));
        return cdtInfoMap;
    }

    private Map<String, String> parseConditionGroupInfo(Element groupEl) {
        HashMap<String, String> groupInfo = new HashMap<String, String>();
        Iterator attrIt = groupEl.attributeIterator();
        while (attrIt.hasNext()) {
            Attribute attr = (Attribute)attrIt.next();
            groupInfo.put(attr.getName(), attr.getValue());
        }
        return groupInfo;
    }

    public static synchronized ConditionParser getInstance() {
        if (null == parser) {
            parser = new ConditionParser();
        }
        return parser;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public Map<String, Map<String, String>> getConditionGroupInfoMap() {
        return this.conditionGroupInfoMap;
    }

    public Map<String, Object> getConditionGroupMap() {
        try {
            if (ConditionConfigParser.getInstance().isDebug()) {
                this.parse();
            }
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("getConditionGroupMap(), error:" + e.getMessage()));
            this.conditionGroupMap = new HashMap<String, Object>();
        }
        return this.conditionGroupMap;
    }

    private static class InnerClass
    implements EntityResolver {
        private InnerClass() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputStream ism = ConditionParser.class.getResourceAsStream("condition-config.dtd");
            return new InputSource(ism);
        }
    }
}

