/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.cfg.parser;

import com.security.logserver.module.condition.cfg.parser.IParser;
import com.security.logserver.module.condition.common.AjaxDataSource;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;

public class BasicParser
implements IParser {
    @Override
    public Map<String, Object> parse(Element el) {
        HashMap<String, Object> cdtInfoMap = new HashMap<String, Object>();
        cdtInfoMap.put("type", el.getName());
        cdtInfoMap.put("id", el.attributeValue("id"));
        if (StringUtils.isNotBlank(el.attributeValue("triggerID"))) {
            cdtInfoMap.put("triggerID", el.attributeValue("triggerID"));
        }
        Iterator it = el.elementIterator();
        while (it.hasNext()) {
            Element temp = (Element)it.next();
            if ("ajaxDataSource".equals(temp.getName())) {
                cdtInfoMap.put("ajaxDataSource", this.parseAjaxDataSource(temp));
                continue;
            }
            cdtInfoMap.put(temp.getName(), this.convertSpeChar(temp.getTextTrim()));
        }
        return cdtInfoMap;
    }

    private String convertSpeChar(String text) {
        if (text.indexOf("\\") != -1) {
            text = StringUtils.replace(text, "\\", "\\\\");
        }
        if (text.indexOf("'") != -1) {
            text = StringUtils.replace(text, "'", "\\'");
        }
        return text;
    }

    protected AjaxDataSource parseAjaxDataSource(Element el) {
        if (!"ajaxDataSource".equals(el.getName())) {
            return null;
        }
        Iterator dataSourceIt = el.elementIterator();
        AjaxDataSource dataSrouce = new AjaxDataSource();
        while (dataSourceIt.hasNext()) {
            String paramTypes;
            Element dataSourceEl = (Element)dataSourceIt.next();
            String dataSourceElName = dataSourceEl.getName();
            if ("bean".equals(dataSourceElName)) {
                dataSrouce.setBeanName(dataSourceEl.getTextTrim());
                continue;
            }
            if ("interfaceClass".equals(dataSourceElName)) {
                dataSrouce.setInterfaceClass(dataSourceEl.getTextTrim());
                continue;
            }
            if ("class".equals(dataSourceElName)) {
                dataSrouce.setClassName(dataSourceEl.getTextTrim());
                continue;
            }
            if ("method".equals(dataSourceElName)) {
                dataSrouce.setMethodName(dataSourceEl.getTextTrim());
                continue;
            }
            if ("file".equals(dataSourceElName)) {
                dataSrouce.setFilePath(dataSourceEl.getTextTrim());
                continue;
            }
            if (!"paramTypes".equals(dataSourceElName) || StringUtils.isBlank(paramTypes = dataSourceEl.getTextTrim())) continue;
            dataSrouce.setParamTypes(paramTypes.split(","));
        }
        return dataSrouce;
    }
}

