/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.user.util.LoginMgrUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.restful.util.JacksonNullProviderUtil;
import com.security.logserver.module.condition.common.ActionResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

public class BaseAction
extends ActionSupport {
    public static final long serialVersionUID = -3178921932207057953L;
    public static final String FORWORD_JSON_RESULT = "jsonResult";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private ActionResult operateResult = new ActionResult(true);
    private SysOptLog optLog = new SysOptLog();

    public BaseAction() {
        this.initSysOptLog();
    }

    protected ActionContext getActionContext() {
        return ActionContext.getContext();
    }

    protected HttpServletRequest fetchRequest() {
        return ServletActionContext.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    public ActionResult getOperateResult() {
        return this.operateResult;
    }

    public void setOperateResult(ActionResult operateResult) {
        this.operateResult = operateResult;
    }

    protected SysOptLog getSysOptLog() {
        return this.optLog;
    }

    private void initSysOptLog() {
        SysOptLog olog = this.getSysOptLog();
        olog.setOperation("atic.report.ddos.downloadReport");
        olog.setModule("lego.dic.module.AticAnalysis");
        olog.setLevel(SysoplogLevel.warning.getValue());
        olog.setOperator(((User)this.fetchRequest().getSession().getAttribute("currentUser")).getUserName().trim());
        olog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        olog.setResult(0);
        olog.setDetail("atic.alarm.rule.params.length.error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResultObj(Object obj) {
        PrintWriter writer = null;
        try {
            this.getResponse().setCharacterEncoding("UTF-8");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setHeader("Cache-Control", "no-store");
            this.getResponse().setDateHeader("Expires", 0L);
            this.getResponse().setContentType("text/html;charset=UTF-8");
            writer = this.getResponse().getWriter();
            String s = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializerProvider((DefaultSerializerProvider)new JacksonNullProviderUtil());
            s = mapper.writeValueAsString(obj);
            writer.write(s);
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)("write response:" + obj.toString() + e.getMessage()));
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResult(String string) {
        PrintWriter writer = null;
        try {
            ServletActionContext.getResponse().setCharacterEncoding("UTF-8");
            ServletActionContext.getResponse().setHeader("Pragma", "no-cache");
            ServletActionContext.getResponse().setHeader("Cache-Control", "no-store");
            ServletActionContext.getResponse().setDateHeader("Expires", 0L);
            writer = ServletActionContext.getResponse().getWriter();
            writer.write(string);
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)("write response " + string + " errorInfo: " + e.getMessage()));
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    protected void writeOptLog() {
        SysOptLog olog = this.getSysOptLog();
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        if (null == sysOptLog) {
            LOGGER.error((Object)"parse rmi service fro sysLogService, return null.");
        } else {
            sysOptLog.writeOptLog(olog);
        }
    }

    protected void secoOptWithAttack() {
        LoginMgrUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
    }

    public boolean validateURLParameters(String whiteStr) {
        String str = whiteStr.replaceAll("\\s", "");
        String[] whiteList = str.split(",");
        if (null == this.fetchRequest().getParameterMap()) {
            return true;
        }
        Set ss = this.fetchRequest().getParameterMap().keySet();
        if (null == ss) {
            return true;
        }
        HashSet<String> whiteParaSet = new HashSet<String>();
        whiteParaSet.addAll(Arrays.asList("cfNameHF", "_dc", "start", "pageSize"));
        whiteParaSet.addAll(Arrays.asList(whiteList));
        return whiteParaSet.containsAll(ss);
    }

    public void validate() {
        Map fieldErrors = this.getFieldErrors();
        if (fieldErrors == null || fieldErrors.isEmpty()) {
            return;
        }
        User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        for (String key : fieldErrors.keySet()) {
            LOGGER.error((Object)("**************parameters validate error, key:-->" + key));
        }
        if (user == null) {
            throw new LegoSecurityException(206L);
        }
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog failOptLog = new SysOptLog();
        failOptLog.setOperation("lego.err.error");
        failOptLog.setModule("lego.dic.module.user");
        failOptLog.setLevel(SysoplogLevel.warning.getValue());
        failOptLog.setOperator(user.getUserName().trim());
        failOptLog.setTargetLocal(Boolean.valueOf(true));
        failOptLog.setTarget("lego.dic.module.user");
        failOptLog.setTerminalIp(((User)this.fetchRequest().getSession().getAttribute("currentUser")).getIpAdr());
        failOptLog.setResult(0);
        failOptLog.setDetail("lego.err.dataerror");
        sysOptLog.writeOptLog(failOptLog);
        this.fetchRequest().getSession().invalidate();
        failOptLog.setLevel(SysoplogLevel.info.getValue());
        failOptLog.setResult(1);
        failOptLog.setModule("lego.dic.module.user");
        failOptLog.setOperation("lego.lab.com.loginout");
        failOptLog.setOperator(user.getUserName());
        failOptLog.setTerminalIp(user.getIpAdr());
        failOptLog.setTarget(user.getUserName());
        failOptLog.setDetail("lego.err.dataerror");
        sysOptLog.writeOptLog(failOptLog);
        Iterator iterator = fieldErrors.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            throw new LegoSecurityException(206L, key);
        }
        throw new LegoSecurityException(206L);
    }
}

