/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.load;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.ConditionMgr;
import com.security.logserver.module.condition.common.AjaxDataSource;
import com.security.logserver.module.condition.common.BaseAction;
import com.security.logserver.module.condition.load.IApplicationContextAware;
import com.security.logserver.module.condition.load.paramparse.IInvokerParamParser;
import com.security.logserver.module.condition.load.paramparse.ParamsParserConfiParser;
import com.security.logserver.module.condition.util.ElogConditionException;
import com.security.logserver.module.condition.util.FileMapping;
import com.security.logserver.module.condition.util.Pair;
import com.security.logserver.module.condition.util.apache.JSONUtil;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConditionAjaxAction
extends BaseAction
implements ApplicationContextAware {
    private static final List<String> METHODS_ALLOWED = new ArrayList<String>();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final List<String> CLASS_PREFIX_ALLOWED;
    private static final long serialVersionUID = 2139703677975381050L;
    private String conditionGroupId = null;
    private String subConditionGroupId = null;
    private String conditionId = null;
    private String invokerParamString = null;
    private String interfaceClassMethod = null;
    private String interfaceClassMethodParamTypes = null;
    private Object[] invokParams = null;
    private transient ApplicationContext applicationContext = null;
    private transient AjaxDataSource dataSource = null;
    private String interfaceClass;

    public String changeGridDataSource() {
        if (!this.isSafeClass(this.interfaceClass)) {
            ElogConditionException ex = new ElogConditionException(5000, " Class name is invalid.", null);
            this.setError(ex);
            return "jsonResult";
        }
        AjaxDataSource ds = new AjaxDataSource();
        ds.setInterfaceClass(this.interfaceClass);
        ConditionMgr conditionMgr = ConditionMgr.getInstance();
        conditionMgr.setAjaxDataSource(this.conditionGroupId, this.subConditionGroupId, this.conditionId, ds);
        return "jsonResult";
    }

    public boolean validateq() {
        if (null != this.invokerParamString && !this.invokerParamString.isEmpty()) {
            if (this.invokerParamString.startsWith("[") && this.invokerParamString.endsWith("]")) {
                try {
                    int numberOfJson = this.invokerParamString.length();
                    if (numberOfJson > 4) {
                        Object obj = JSONUtil.deserialize(this.invokerParamString);
                        LOGGER.info((Object)("this json deserialize" + obj.toString()));
                    }
                    return true;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error((Object)("error is " + e.getMessage()));
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)("error is " + e.getMessage()));
                }
                catch (InvocationTargetException e) {
                    LOGGER.error((Object)("error is " + e.getMessage()));
                }
                catch (RuntimeException e) {
                    LOGGER.error((Object)("error is " + e.getMessage()));
                }
            }
            return false;
        }
        return false;
    }

    public String getAjaxData() {
        ConditionMgr conditionMgr = ConditionMgr.getInstance();
        this.dataSource = conditionMgr.getAjaxDataSource(this.conditionGroupId, this.subConditionGroupId, this.conditionId);
        if (null == this.dataSource) {
            return "jsonResult";
        }
        if (!StringUtils.isBlank(this.dataSource.getFilePath())) {
            this.fileTypeProcess();
        } else if (!StringUtils.isBlank(this.dataSource.getBeanName())) {
            this.reflectBeanInvoke();
        } else if (!StringUtils.isBlank(this.dataSource.getClassName())) {
            this.reflectClassInvoke();
        } else if (!StringUtils.isBlank(this.dataSource.getInterfaceClass())) {
            this.reflectInterfaceInvoke();
        }
        return "jsonResult";
    }

    private void reflectBeanInvoke() {
        Object entityObject = this.dataSource.getExecuteObj();
        if (null == entityObject) {
            entityObject = this.getBeanByName();
        }
        Method objMethod = null;
        if (null != entityObject) {
            objMethod = this.getExecuteMethod(entityObject, this.dataSource.getMethodName());
        }
        if (null == objMethod) {
            LOGGER.error((Object)"reflectInvoke() error: method not found!");
            ElogConditionException ex = new ElogConditionException(5000, this.dataSource.getMethodName() + " method not found.", null);
            this.setError(ex);
            return;
        }
        Object resultObj = null;
        try {
            resultObj = this.invokMethod(entityObject, objMethod);
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("reflectInvoke() error: " + e.getMessage()));
            this.setError(e);
            return;
        }
        this.getOperateResult().setData(resultObj);
        this.getOperateResult().setMsg("success");
    }

    private void reflectClassInvoke() {
        Object entityObject = this.dataSource.getExecuteObj();
        if (null == entityObject) {
            entityObject = this.getClassObject();
        }
        Method objMethod = null;
        if (null != entityObject) {
            objMethod = this.getExecuteMethod(entityObject, this.dataSource.getMethodName());
        }
        if (null == objMethod) {
            LOGGER.error((Object)"reflectInvoke() error: method not found!");
            ElogConditionException ex = new ElogConditionException(5000, this.dataSource.getMethodName() + " method not found.", null);
            this.setError(ex);
            return;
        }
        Object resultObj = null;
        try {
            resultObj = this.invokMethod(entityObject, objMethod);
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("reflectInvoke() error: " + e.getMessage()));
            this.setError(e);
            return;
        }
        this.getOperateResult().setData(resultObj);
        this.getOperateResult().setMsg("success");
    }

    private void reflectInterfaceInvoke() {
        if (StringUtils.isBlank(this.interfaceClassMethod)) {
            LOGGER.error((Object)"reflectInterfaceInvoke error: interfaceClassMethod is empty.");
            ElogConditionException ex = new ElogConditionException(5000, " method not found.", null);
            this.setError(ex);
            return;
        }
        if (!this.isSafeMethod(this.interfaceClassMethod)) {
            LOGGER.error((Object)("reflectInterfaceInvoke error: method " + this.interfaceClassMethod + " is not allowed."));
            ElogConditionException ex = new ElogConditionException(5000, " method name is invalid.", null);
            this.setError(ex);
            return;
        }
        Object entityObject = this.dataSource.getExecuteObj();
        try {
            if (null == entityObject) {
                entityObject = this.getInterfaceObject();
            }
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("reflectInvoke error:" + e.getMessage()));
            this.setError(e);
        }
        if (null == entityObject) {
            LOGGER.error((Object)"reflectInterfaceInvoke error: Cannot getInterfaceObject defined.");
            return;
        }
        Method objMethod = null;
        objMethod = this.getExecuteMethod(entityObject, this.interfaceClassMethod);
        if (null == objMethod) {
            LOGGER.error((Object)"reflectInterfaceInvoke error: method not found!");
            ElogConditionException ex = new ElogConditionException(5000, this.dataSource.getMethodName() + " method not found.", null);
            this.setError(ex);
            return;
        }
        Object resultObj = null;
        try {
            resultObj = this.invokMethod(entityObject, objMethod);
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("reflectInvoke() error: " + e.getMessage()));
            this.setError(e);
            return;
        }
        this.getOperateResult().setData(resultObj);
        this.getOperateResult().setMsg("success");
    }

    private void fileTypeProcess() {
        String language = ProductFaceUtil.getInstance().getUserLocale().getLanguage();
        StringBuilder sb = new StringBuilder(language);
        String xmlFileName = this.dataSource.getFilePath();
        if (xmlFileName.startsWith("/")) {
            xmlFileName = xmlFileName.substring(1);
        }
        sb.append('/').append(xmlFileName);
        List<Pair<String, String>> list = FileMapping.getInstance().getMappingList(sb.toString());
        this.getOperateResult().setData(list);
        this.getOperateResult().setSuccess(Boolean.TRUE);
    }

    private Object getBeanByName() {
        Object executeObjNew = null;
        if (!StringUtils.isBlank(this.dataSource.getBeanName())) {
            executeObjNew = this.applicationContext.getBean(this.dataSource.getBeanName());
        }
        return executeObjNew;
    }

    private Object getClassObject() {
        Object executeObjNew = null;
        String className = this.dataSource.getClassName();
        if (StringUtils.isBlank(className)) {
            return executeObjNew;
        }
        try {
            executeObjNew = Class.forName(className).newInstance();
            Class<?>[] interfaces = executeObjNew.getClass().getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                for (Class<?> ifNew : interfaces) {
                    if (!ifNew.getName().endsWith("IApplicationContextAware")) continue;
                    ((IApplicationContextAware)executeObjNew).setApplicationContext(this.applicationContext);
                }
            }
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"create execute object fail classNotFoundException");
        }
        return executeObjNew;
    }

    private boolean isSafeClass(String className) {
        boolean bSafe = false;
        for (int i = 0; i < CLASS_PREFIX_ALLOWED.size(); ++i) {
            if (!className.startsWith(CLASS_PREFIX_ALLOWED.get(i))) continue;
            bSafe = true;
            break;
        }
        return bSafe;
    }

    private boolean isSafeMethod(String methodName) {
        boolean bSafe = false;
        if (METHODS_ALLOWED.indexOf(methodName) != -1 && !"system".equals(methodName.toLowerCase(Locale.getDefault()))) {
            bSafe = true;
        }
        return bSafe;
    }

    private Object getInterfaceObject() throws ElogConditionException {
        Object executeObjNew = null;
        if (StringUtils.isBlank(this.dataSource.getInterfaceClass())) {
            return executeObjNew;
        }
        String className = this.dataSource.getInterfaceClass();
        if (!this.isSafeClass(className)) {
            ElogConditionException ex = new ElogConditionException(5000, " Class name is invalid.", null);
            this.setError(ex);
            return executeObjNew;
        }
        try {
            executeObjNew = Class.forName(className).newInstance();
            Class<?>[] interfaces = executeObjNew.getClass().getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                for (Class<?> ifNew : interfaces) {
                    if (!ifNew.getName().endsWith("IApplicationContextAware")) continue;
                    ((IApplicationContextAware)executeObjNew).setApplicationContext(this.applicationContext);
                }
            }
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
            throw new ElogConditionException(6000, " create execute object " + this.dataSource.getClassName() + " fail.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("create execute object fail:" + e.getMessage()));
            throw new ElogConditionException(6000, " create execute object " + this.dataSource.getClassName() + " fail.", e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"create execute object fail classNotFoundException");
            throw new ElogConditionException(6000, " create execute object " + this.dataSource.getClassName() + " fail.", e);
        }
        return executeObjNew;
    }

    private Object[] getInvokParams() throws ElogConditionException {
        String[] paramTypes = this.dataSource.getParamTypes();
        if (!StringUtils.isBlank(this.dataSource.getInterfaceClass())) {
            paramTypes = this.interfaceClassMethodParamTypes.split(",");
        }
        if (null == paramTypes || 0 == paramTypes.length) {
            return new Object[0];
        }
        List arguments = null;
        try {
            arguments = (List)JSONUtil.deserialize(this.invokerParamString);
            if (null == arguments || arguments.size() != paramTypes.length) {
                throw new ElogConditionException(2000, "invoker params count not match", null);
            }
            this.invokParams = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Object argument;
                String type = paramTypes[i];
                IInvokerParamParser parser = ParamsParserConfiParser.getInstance().parse().getArgumentsParserMap().get(type);
                this.invokParams[i] = argument = parser.parse(arguments.get(i));
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)("get invoker params error:" + e.getMessage()));
            throw new ElogConditionException(3000, "get invoker params error", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("get invoker params error:" + e.getMessage()));
            throw new ElogConditionException(3000, "get invoker params error", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)("get invoker params error:" + e.getMessage()));
            throw new ElogConditionException(3000, "get invoker params error", e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("get invoker params error:" + e.getMessage()));
            throw new ElogConditionException(3000, "get invoker params error", e);
        }
        return this.invokParams;
    }

    private void setError(ElogConditionException ex) {
        LOGGER.error((Object)("setError():" + ex.getMessage()));
        this.getOperateResult().setSuccess(false);
        this.getOperateResult().setReturnCode(ex.getErrorCode());
        this.getOperateResult().setMsg(ex.getMsg());
    }

    private Object invokMethod(Object entityObj, Method method) throws ElogConditionException {
        Object[] invokParams1 = this.getInvokParams();
        Object resultObj = null;
        try {
            resultObj = 0 == invokParams1.length ? method.invoke(entityObj, new Object[0]) : method.invoke(entityObj, invokParams1);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("execute method fail:" + e.getMessage()));
            throw new ElogConditionException(5001, LocaleUtil.replaceParamValue(LocaleUtil.getProperty("condtion.ajaxdatasource.error", ProductFaceUtil.getInstance().getUserLocale()), this.dataSource.getMethodName()), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("execute method fail:" + e.getMessage()));
            throw new ElogConditionException(5001, LocaleUtil.replaceParamValue(LocaleUtil.getProperty("condtion.ajaxdatasource.error", ProductFaceUtil.getInstance().getUserLocale()), this.dataSource.getMethodName()), e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)("execute method fail:" + e.getMessage()));
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                if (ProductFaceUtil.getInstance().isBusinessException((Exception)targetException)) {
                    ProductFaceUtil.getInstance().throwProductException(e.getTargetException().getMessage(), "INFO", e.getTargetException());
                }
                throw new ElogConditionException(5001, LocaleUtil.replaceParamValue(LocaleUtil.getProperty("condtion.ajaxdatasource.error", ProductFaceUtil.getInstance().getUserLocale()), this.dataSource.getMethodName()), e);
            }
            LOGGER.error((Object)"Object targetException is not Exception.");
        }
        return resultObj;
    }

    private Method getExecuteMethod(Object obj, String methodName) {
        Method[] methodArr = obj.getClass().getMethods();
        Method method = null;
        for (int i = 0; i < methodArr.length; ++i) {
            if (!methodArr[i].getName().equals(methodName)) continue;
            method = methodArr[i];
            return method;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getConditionGroupId() {
        return this.conditionGroupId;
    }

    public void setConditionGroupId(String conditionGroupId) {
        this.conditionGroupId = conditionGroupId;
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(String conditionId) {
        this.conditionId = conditionId;
    }

    public String getInvokerParamString() {
        return this.invokerParamString;
    }

    public void setInvokerParamString(String invokerParamString) {
        this.invokerParamString = invokerParamString;
    }

    public String getSubConditionGroupId() {
        return this.subConditionGroupId;
    }

    public void setSubConditionGroupId(String subConditionGroupId) {
        this.subConditionGroupId = subConditionGroupId;
    }

    public String getInterfaceClassMethod() {
        return this.interfaceClassMethod;
    }

    public void setInterfaceClassMethod(String interfaceClassMethod) {
        this.interfaceClassMethod = interfaceClassMethod;
    }

    public String getInterfaceClassMethodParamTypes() {
        return this.interfaceClassMethodParamTypes;
    }

    public void setInterfaceClassMethodParamTypes(String interfaceClassMethodParamTypes) {
        this.interfaceClassMethodParamTypes = interfaceClassMethodParamTypes;
    }

    public String getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(String interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    static {
        METHODS_ALLOWED.add("getGirdColumnModels");
        METHODS_ALLOWED.add("getGridData");
        CLASS_PREFIX_ALLOWED = new ArrayList<String>();
        CLASS_PREFIX_ALLOWED.add("com.huawei.");
    }
}

