/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.load.paramparse;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.logserver.module.condition.cfg.ConditionConfigParser;
import com.security.logserver.module.condition.load.paramparse.IInvokerParamParser;
import com.security.logserver.module.condition.util.ElogConditionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class ParamsParserConfiParser {
    public static final String PATH = "com/security/logserver/module/condition/load/paramparse/params-parser.xml";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ParamsParserConfiParser parser;
    private Map<String, IInvokerParamParser> argumentsParserMap;
    private boolean isParsed = false;

    private ParamsParserConfiParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamsParserConfiParser parse() {
        if (this.isParsed) {
            try {
                if (!ConditionConfigParser.getInstance().isDebug()) {
                    return this;
                }
            }
            catch (ElogConditionException e) {
                LOGGER.error((Object)("parse():" + e.getMessage()));
            }
        }
        InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(PATH);
        try {
            this.argumentsParserMap = new HashMap<String, IInvokerParamParser>();
            SAXReader saxReader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            Document doc = saxReader.read(ins);
            Element root = doc.getRootElement();
            IInvokerParamParser parserNew = null;
            List els = root.elements("param");
            for (Element el : els) {
                String type = el.element("type").getTextTrim();
                String parserName = el.element("parser").getTextTrim();
                try {
                    parserNew = null;
                    parserNew = (IInvokerParamParser)Class.forName(parserName).newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.error((Object)"parse() error");
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)"parse() error");
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error((Object)"parse() error");
                }
                this.argumentsParserMap.put(type, parserNew);
                this.isParsed = true;
            }
        }
        catch (DocumentException e) {
            LOGGER.error((Object)"parse() error");
        }
        catch (SAXException e) {
            LOGGER.error((Object)"parse() error");
        }
        finally {
            if (null != ins) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"parse() error");
                }
            }
        }
        return this;
    }

    public static synchronized ParamsParserConfiParser getInstance() {
        if (null == parser) {
            parser = new ParamsParserConfiParser();
        }
        return parser;
    }

    public Map<String, IInvokerParamParser> getArgumentsParserMap() {
        try {
            if (ConditionConfigParser.getInstance().isDebug()) {
                this.parse();
            }
        }
        catch (ElogConditionException e) {
            LOGGER.error((Object)("getArgumentsParserMap():" + e.getMessage()));
        }
        return this.argumentsParserMap;
    }

    public void setArgumentsParserMap(Map<String, IInvokerParamParser> argumentsParserMap) {
        this.argumentsParserMap = argumentsParserMap;
    }
}

