/*
 * Decompiled with CFR 0.152.
 */
package com.security.logserver.module.condition.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportConfigUtil;
import com.security.logserver.module.condition.common.BaseAction;
import com.security.logserver.module.condition.util.apache.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceProcessAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final long serialVersionUID = 8695541318500171640L;

    public String getReportPluginResource() {
        Properties pro = new Properties();
        String baseNames = IReportConfigUtil.getInstance().getConfig("ireport.resource.baseName");
        Map session = this.getActionContext().getSession();
        Locale locale = (Locale)session.get("WW_TRANS_I18N_LOCALE");
        if (null == locale) {
            locale = this.getLocale();
        }
        try {
            if (StringUtils.isNotBlank(baseNames)) {
                String[] names;
                for (String name : names = baseNames.split(",")) {
                    ResourceBundle bundle = ResourceBundle.getBundle(name, locale);
                    Set<String> keys = bundle.keySet();
                    for (String key : keys) {
                        pro.setProperty(key, bundle.getString(key));
                    }
                }
            }
        }
        catch (MissingResourceException e) {
            LOGGER.error((Object)"load report plugin resource fail ");
        }
        catch (Exception e) {
            LOGGER.error((Object)("load report plugin resource fail :" + e.getMessage()));
        }
        this.getOperateResult().setSuccess(Boolean.TRUE);
        this.getOperateResult().setData(pro);
        return "jsonResult";
    }
}

