/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.alarm.entity.AlarmDevInfo;
import com.hs.atic.alarm.entity.AlarmZoneInfo;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LogAlarmHandler {
    private static Map<Long, AlarmZoneInfo> zoneCache = new HashMap<Long, AlarmZoneInfo>();
    private static Map<String, AlarmDevInfo> deviceCache = new HashMap<String, AlarmDevInfo>();
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private IAlarmService alarmService;
    private IAticDeviceService aticDeviceService;
    private IZoneService zoneService;
    private IZoneDeviceService zoneDeviceService;
    private IZonePolicyApplyService zonePolicyApplyService;

    private AlarmDevInfo getDeviceFromCache(String deviceIp) {
        if (deviceCache.containsKey(deviceIp)) {
            return deviceCache.get(deviceIp);
        }
        AticDevice device = null;
        if (null != this.aticDeviceService) {
            device = this.aticDeviceService.getDeviceByIp(deviceIp);
        }
        if (null != device) {
            AlarmDevInfo info = new AlarmDevInfo();
            info.setDevName(device.getName());
            info.setMoId(Long.valueOf(device.getMoId()));
            deviceCache.put(deviceIp, info);
            return info;
        }
        return null;
    }

    private AlarmZoneInfo getZoneFromCache(long zoneId) {
        if (zoneCache.containsKey(zoneId)) {
            return zoneCache.get(zoneId);
        }
        ZoneInfoForm form = this.zoneService.getZoneNOIpById(Long.valueOf(zoneId));
        if (null != form) {
            AlarmZoneInfo info = new AlarmZoneInfo();
            info.setMoId(form.getMoId().longValue());
            info.setZoneType(form.getZoneType().intValue());
            info.setZoneName(form.getZoneDesc());
            ZonePolicyApplyForm applyForm = this.zonePolicyApplyService.queryByZoneId(Long.valueOf(zoneId));
            if (null == applyForm) {
                info.setDefendMode(0);
            } else {
                info.setDefendMode(applyForm.getDefendMode().intValue());
            }
            zoneCache.put(zoneId, info);
            return info;
        }
        return null;
    }

    private String[] assembleSyslogAbnormalInfo(NfaAnomalyEntity entity) {
        String[] paramTemp = new String[8];
        String deviceIp = entity.getDevIp();
        String zoneName = "--";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("currentUserId", "1");
        queryMap.put("currentUserIsAdmin", "true");
        queryMap.put("queryIpAddress", entity.getDstIp1());
        Paging result = this.zoneService.queryByPage(queryMap, 0, 10);
        List zoneInfos = result.getData();
        Long zoneMoId = 0L;
        if (!zoneInfos.isEmpty()) {
            ZoneInfoForm zoneInfo = (ZoneInfoForm)zoneInfos.get(0);
            zoneName = zoneInfo.getZoneDesc();
            zoneMoId = zoneInfo.getMoId();
        } else {
            Long defaultZoneId = this.zoneDeviceService.getDefaultZoneIdByDevId(Long.valueOf(entity.getDeviceId()));
            if (null != defaultZoneId) {
                AlarmZoneInfo zoneInfo = this.getZoneFromCache(defaultZoneId);
                if (null != zoneInfo) {
                    zoneName = zoneInfo.getZoneName();
                    zoneMoId = zoneInfo.getMoId();
                } else {
                    this.logger.error((Object)"zoneInfo is null");
                    return paramTemp;
                }
            }
        }
        String dstIp = entity.getDstIp1();
        String attackType = entity.getSubType();
        String threshold = entity.getThreshold() + entity.getUnit();
        String current = entity.getCurrent() + entity.getUnit();
        paramTemp[0] = deviceIp;
        paramTemp[1] = zoneName;
        paramTemp[2] = dstIp;
        paramTemp[3] = attackType;
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("1", "SYN Flood");
        typeMap.put("2", "SYN-ACK Flood");
        typeMap.put("3", "FIN/RST Flood");
        typeMap.put("4", "HTTP Flood");
        typeMap.put("5", "New Connections Flood");
        typeMap.put("6", "UDP Bandwidth Overflow");
        typeMap.put("7", "UDP Flood");
        typeMap.put("8", "TCP Flood");
        typeMap.put("9", "ICMP Abnormal");
        typeMap.put("10", "Fragment Flood");
        typeMap.put("11", "DNS Flood");
        typeMap.put("12", "SIP Flood");
        for (Map.Entry key : typeMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)key.getKey()), (CharSequence)attackType)) continue;
            paramTemp[3] = (String)typeMap.get(key.getKey());
            break;
        }
        paramTemp[4] = threshold;
        paramTemp[5] = current;
        paramTemp[6] = zoneMoId.toString();
        paramTemp[7] = null == entity.getSeverity() || "".equals(entity.getSeverity()) ? "--" : entity.getSeverity();
        return paramTemp;
    }

    private AticAlarmObject generateSyslogAbnormalAlarm(NfaAnomalyEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        String[] param = this.assembleSyslogAbnormalInfo(entity);
        alarmObject.setAlarmId("0x0000000803240816");
        alarmObject.setAlarmParam(param);
        if (entity.getStatus().trim().equalsIgnoreCase("Ongoing")) {
            alarmObject.setIsAlarm(Boolean.valueOf(true));
        } else {
            alarmObject.setIsAlarm(Boolean.valueOf(false));
        }
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.getSeverity((int)3));
        if ("0".equals(param[6])) {
            String deviceName = "";
            String devIp = entity.getDevIp();
            AlarmDevInfo device = this.getDeviceFromCache(devIp);
            if (null != device) {
                deviceName = device.getDevName();
            }
            alarmObject.setMoId(Long.valueOf(entity.getDeviceId()));
            alarmObject.setExtendMoId(Long.valueOf(param[6]));
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(devIp);
        } else {
            alarmObject.setMoId(Long.valueOf(param[6]));
            alarmObject.setExtendMoId(Long.valueOf(entity.getDeviceId()));
            alarmObject.setMoName(param[1]);
            alarmObject.setMoIp(entity.getDstIp1());
        }
        alarmObject.setAlertTime(entity.getAticTime() * 1000L);
        return alarmObject;
    }

    public void syslogAbnormalAlarm(List<NfaAnomalyEntity> nfaList) {
        if (!nfaList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (NfaAnomalyEntity entity : nfaList) {
                AticAlarmObject obj = this.generateSyslogAbnormalAlarm(entity);
                alarmObjectList.add(obj);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    public void deviceSrcIpIsFull(AticDevice device, String[] param) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x0000000803240878");
            alarmObject.setAlarmParam(param);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            if (null != device) {
                alarmObject.setMoId(Long.valueOf(device.getMoId()));
                alarmObject.setMoName(device.getName());
                alarmObject.setMoIp(device.getIpAddress());
            } else {
                alarmObject.setMoId(Long.valueOf(0L));
            }
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("deviceSrcIpIsFull error:" + this.getcleanedMessage(device.getName())));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("deviceSrcIpIsFull error. " + e.getMessage()));
        }
    }

    public void deviceDstIpIsFull(AticDevice device, String[] param) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x0000000803240877");
            alarmObject.setAlarmParam(param);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            if (null != device) {
                alarmObject.setMoId(Long.valueOf(device.getMoId()));
                alarmObject.setMoName(device.getName());
                alarmObject.setMoIp(device.getIpAddress());
            } else {
                alarmObject.setMoId(Long.valueOf(0L));
            }
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("deviceDstIpIsFull error:" + this.getcleanedMessage(device.getName())));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("deviceDstIpIsFull error. " + e.getMessage()));
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }
}

