/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.analysis.util.SysOptLogAnalysisUtil;
import com.hs.atic.bis.util.LogBisUtil;
import com.hs.atic.sdk.syslog.service.IDevSyslogService;
import com.hs.atic.system.util.SystemUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.Date;

public class DevSyslogHoldManager {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private IDevSyslogService devSyslogService;

    public void deleteDevSyslogData() {
        try {
            this.logger.info((Object)"start deleteDevsyslog");
            this.devSyslogService = LogBisUtil.getDevSyslogService();
            Integer devSyslogHoldTime = SystemUtil.getLogHoldTime().getDevSyslogTime();
            Long dataKeepTime = SystemUtil.getDataKeepTime((int)1, (int)devSyslogHoldTime);
            Long currentTime = System.currentTimeMillis() / 1000L;
            Long endTime = currentTime - dataKeepTime;
            int totalNum = this.devSyslogService.delectLog(endTime);
            String logTime = AticUtil.convertTimeLong((Long)endTime);
            this.logger.info((Object)("deleteDevsyslog totalNum" + totalNum + ", the time before " + logTime));
            this.processOpeLog(totalNum, true, logTime, "", "atic.system.devsyslog.panle.title", true);
        }
        catch (LegoCheckedException lego) {
            this.logger.error((Object)("deleteDevsyslog error. " + lego.getMessage()));
            this.processOpeLog(0, false, "", "lego.err." + lego.getErrorCode(), "atic.system.devsyslog.panle.title", true);
        }
        catch (Exception e) {
            this.logger.error((Object)("deleteDevsyslog error. " + e.getMessage()));
            this.processOpeLog(0, false, "", "lego.err.570507", "atic.system.devsyslog.panle.title", true);
        }
    }

    private void processOpeLog(int num, Boolean sucess, String time, String errorInfo, String target, boolean targetLocal) {
        ISysOptLog sysOptLogMgr = SysOptLogAnalysisUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation("atic.system.devsyslog.timeDel");
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("atic.system.devsyslog.timeDel.success");
            String[] para = new String[]{time, String.valueOf(num)};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(errorInfo);
        }
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }
}

