/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog;

import com.hs.atic.bis.service.LogAlarmHandler;
import com.hs.atic.syslog.ParseSyslogRuleXml;
import com.hs.atic.syslog.SyslogRepository;
import com.hs.atic.syslog.entity.DevSendSysLogEntity;
import com.hs.atic.syslog.entity.DevSrcOrDstIpFullEntity;
import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.atic.syslog.entity.SyslogRuleEntity;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.model.SyslogBean;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.secsyslog.SysLogObj;
import com.huawei.secsyslog.SysLogServer;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyslogReceiveThread
extends Thread {
    private static Map<String, Long> deviceMap = new HashMap<String, Long>();
    private static long nextRefreshTime = System.currentTimeMillis();
    private static int intervalTime = 10000;
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private SysLogServer tcpSysLogServer = null;
    private SysLogServer udpSysLogServer = null;
    private IAticDeviceService aticDeviceService;
    private List<SyslogRuleEntity> syslogRuleList = new ArrayList<SyslogRuleEntity>();
    private ISyslogSendService syslogSendService;
    private String protocol = "udp";
    private int maxBufferSize = 100000;
    private List<String> whiteList = new ArrayList<String>();
    private LogAlarmHandler logAlarmHandler;

    public ISyslogSendService getSyslogSendService() {
        return this.syslogSendService;
    }

    public void setSyslogSendService(ISyslogSendService syslogSendService) {
        this.syslogSendService = syslogSendService;
    }

    public void dealRecvData(List<SysLogObj> data) {
        try {
            String srcIp = null;
            String msg = null;
            String csn = Charset.defaultCharset().name();
            Map keysAndValuesMap = this.syslogSendService.getSyslogServerMapKeysAndValues();
            List keys = (List)keysAndValuesMap.get("keys");
            List values = (List)keysAndValuesMap.get("values");
            HashMap syslogServerMap = new HashMap();
            if (null == keys || keys.size() == 0) {
                syslogServerMap = null;
            } else {
                for (int i = 0; i < keys.size(); ++i) {
                    syslogServerMap.put(keys.get(i), values.get(i));
                }
            }
            for (SysLogObj sysLogObj : data) {
                srcIp = sysLogObj.getSrcIp();
                Object obj = this.dealwithPacket(srcIp, msg = sysLogObj.getMsg());
                if (obj == null) continue;
                if (obj instanceof DevSrcOrDstIpFullEntity) {
                    this.processDevSrcOrDstIpFullObj(obj);
                    continue;
                }
                SyslogRepository.addSyslog(obj);
                byte[] syslog = msg.getBytes(csn);
                if (obj instanceof DevSendSysLogEntity) {
                    DevSendSysLogEntity tempObj = (DevSendSysLogEntity)obj;
                    if (tempObj.getUser().equals("_system_") || null == syslogServerMap || syslogServerMap.isEmpty()) continue;
                    for (Map.Entry serverMap : syslogServerMap.entrySet()) {
                        SyslogServerEntity server = (SyslogServerEntity)serverMap.getValue();
                        if (1 != server.getDeviceSyslog()) continue;
                        SyslogBean syslogBean = new SyslogBean(syslog);
                        this.syslogSendService.sendSyslog((String)serverMap.getKey(), syslogBean);
                    }
                    continue;
                }
                if (!(obj instanceof NfaAnomalyEntity) || null == syslogServerMap || syslogServerMap.isEmpty()) continue;
                for (Map.Entry serverMap : syslogServerMap.entrySet()) {
                    SyslogServerEntity server = (SyslogServerEntity)serverMap.getValue();
                    if (1 != server.getThirdSyslog()) continue;
                    SyslogBean syslogBean = new SyslogBean(syslog);
                    this.syslogSendService.sendSyslog((String)serverMap.getKey(), syslogBean);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("SyslogReceiveThread run error. " + e.getMessage()));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("SyslogReceiveThread run error. " + e.getMessage()));
        }
    }

    private void processDevSrcOrDstIpFullObj(Object obj) {
        DevSrcOrDstIpFullEntity entity = (DevSrcOrDstIpFullEntity)obj;
        entity.setLogTime(AticUtil.convertDevSyslogTime((String)entity.getLogTime()));
        String srcOrDstIp = entity.getMsg();
        String devName = entity.getDevIp();
        AticDevice device = this.aticDeviceService.getDeviceByIp(entity.getDevIp());
        if (null != device) {
            devName = device.getName();
        }
        String[] param = new String[]{devName, entity.getDevIp(), entity.getSlotId(), entity.getCpuId()};
        if ("The SrcIP monitored table is full".equalsIgnoreCase(srcOrDstIp)) {
            this.logAlarmHandler.deviceSrcIpIsFull(device, param);
        } else if ("The DstIP monitored table is full".equalsIgnoreCase(srcOrDstIp) || "The DestIP monitored table is full".equalsIgnoreCase(srcOrDstIp)) {
            this.logAlarmHandler.deviceDstIpIsFull(device, param);
        }
    }

    @Override
    public void run() {
        try {
            this.syslogRuleList = ParseSyslogRuleXml.getInstance().parse();
        }
        catch (Exception e) {
            this.logger.error((Object)("parse syslog rule xml failed. " + e.getMessage()));
        }
        while (true) {
            try {
                while (true) {
                    ArrayList<SysLogObj> data = new ArrayList<SysLogObj>();
                    if (null != this.tcpSysLogServer) {
                        data.addAll(this.tcpSysLogServer.fetchMsgList());
                    }
                    if (null != this.udpSysLogServer) {
                        data.addAll(this.udpSysLogServer.fetchMsgList());
                    }
                    this.dealRecvData(data);
                    if (System.currentTimeMillis() > nextRefreshTime) {
                        this.refreshDeviceSet();
                        if (null != this.tcpSysLogServer) {
                            this.tcpSysLogServer.setWhiteList(this.whiteList);
                        }
                        if (null != this.udpSysLogServer) {
                            this.udpSysLogServer.setWhiteList(this.whiteList);
                        }
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("SyslogReceiveThread catch InterruptedException" + e.getMessage()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exp) {
                    this.logger.error((Object)("SyslogReceiveThread run error. " + exp.getMessage()));
                }
                continue;
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("SyslogReceiveThread catch RuntimeException" + e.getMessage()));
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException exp) {
                    this.logger.error((Object)("SyslogReceiveThread run error" + exp.getMessage()));
                    continue;
                }
            }
            break;
        }
    }

    private Object dealwithPacket(String deviceIp, String msg) {
        msg = msg.trim();
        Object syslogObj = null;
        boolean matched = false;
        for (SyslogRuleEntity ruleEntity : this.syslogRuleList) {
            Pattern pattern = Pattern.compile(ruleEntity.getRule(), 2);
            Matcher matcher = pattern.matcher(msg);
            if (!matcher.matches()) continue;
            matched = true;
            this.logger.info((Object)("Syslog matched succeed. log: " + this.getcleanedMessage(msg)));
            if (!deviceMap.containsKey(deviceIp) || null == deviceMap.get(deviceIp)) {
                return null;
            }
            long deviceId = deviceMap.get(deviceIp);
            String clazzName = ruleEntity.getClazzName();
            Map<String, Integer> paramMap = ruleEntity.getParamMap();
            try {
                Class<?> clazz = Class.forName(clazzName);
                Field[] fields = clazz.getDeclaredFields();
                syslogObj = clazz.newInstance();
                for (Field eachField : fields) {
                    eachField.setAccessible(true);
                    String fieldName = eachField.getName();
                    Integer index = paramMap.get(fieldName);
                    if (index == null || index > matcher.groupCount()) continue;
                    eachField.set(syslogObj, matcher.group(index).trim());
                }
                Field devIpFileld = syslogObj.getClass().getDeclaredField("devIp");
                devIpFileld.setAccessible(true);
                devIpFileld.set(syslogObj, deviceIp);
                try {
                    Field devIdFileld = syslogObj.getClass().getDeclaredField("deviceId");
                    devIdFileld.setAccessible(true);
                    devIdFileld.set(syslogObj, deviceId);
                }
                catch (Exception e) {
                    this.logger.error((Object)("getDeclaredField deviceId error." + e.getMessage()));
                }
                Field detailFileld = syslogObj.getClass().getDeclaredField("detail");
                detailFileld.setAccessible(true);
                detailFileld.set(syslogObj, msg);
                Field aticTimeFileld = syslogObj.getClass().getDeclaredField("aticTime");
                aticTimeFileld.setAccessible(true);
                aticTimeFileld.set(syslogObj, System.currentTimeMillis() / 1000L);
            }
            catch (InstantiationException e) {
                this.logger.error((Object)("DealwithPacket error. " + e.getMessage()));
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)"DealwithPacket ClassNotFoundException error");
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)("DealwithPacket error. " + e.getMessage()));
            }
            catch (NoSuchFieldException e) {
                this.logger.error((Object)("DealwithPacket error. " + e.getMessage()));
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("DealwithPacket error. " + e.getMessage()));
            }
            break;
        }
        if (!matched) {
            this.logger.info((Object)("Syslog matched failed. SrcIP:" + deviceIp + ";  log: " + msg));
        }
        return syslogObj;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void refreshDeviceSet() {
        if (this.aticDeviceService != null) {
            List devieList = this.aticDeviceService.getAllDevice();
            deviceMap.clear();
            this.whiteList.clear();
            if (null != devieList && !devieList.isEmpty()) {
                for (AticDevice device : devieList) {
                    deviceMap.put(device.getIpAddress(), device.getMoId());
                    this.whiteList.add(device.getIpAddress());
                    if (AticUtil.isNull((String)device.getLogIp()) || deviceMap.containsKey(device.getLogIp())) continue;
                    deviceMap.put(device.getLogIp(), device.getMoId());
                    this.whiteList.add(device.getLogIp());
                }
            }
        }
        nextRefreshTime = System.currentTimeMillis() + (long)intervalTime;
    }

    public SysLogServer getTcpSysLogServer() {
        return this.tcpSysLogServer;
    }

    public void setTcpSysLogServer(SysLogServer tcpSysLogServer) {
        this.tcpSysLogServer = tcpSysLogServer;
    }

    public SysLogServer getUdpSysLogServer() {
        return this.udpSysLogServer;
    }

    public void setUdpSysLogServer(SysLogServer udpSysLogServer) {
        this.udpSysLogServer = udpSysLogServer;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public LogAlarmHandler getLogAlarmHandler() {
        return this.logAlarmHandler;
    }

    public void setLogAlarmHandler(LogAlarmHandler logAlarmHandler) {
        this.logAlarmHandler = logAlarmHandler;
    }
}

