/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog;

import com.hs.atic.bis.service.LogAlarmHandler;
import com.hs.atic.syslog.NfaAnomalyPool;
import com.hs.atic.syslog.dao.DevSysLogDao;
import com.hs.atic.syslog.dao.NfaAnomalyDao;
import com.hs.atic.syslog.entity.DevSendSysLogEntity;
import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SyslogRepository
extends Thread {
    public static final int MAX_SIZE_CACHE = 10000;
    public static final double RATE = 0.8;
    private static List<Object> syslogList = new ArrayList<Object>();
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private List<String> nfaListBuffer = new ArrayList<String>();
    private NfaAnomalyPool nfaAnomalyPool;
    private DevSysLogDao devSysLogDao;
    private NfaAnomalyDao nfaAnomalyDao;
    private LogAlarmHandler alarmHandler;
    private long maxNum = 0L;
    private int limitNum = 0;
    private int systemUserView = 0;

    @Override
    public void run() {
        try {
            Map<String, String> map = this.getConfigData();
            String max = map.get("maxNum");
            String limit = map.get("limitNum");
            String systemView = map.get("sysUser");
            if (!("".equals(max) || "".equals(limit) || "".equals(systemView) || systemView == null)) {
                this.maxNum = Long.parseLong(max);
                this.limitNum = Integer.parseInt(limit);
                this.systemUserView = Integer.parseInt(systemView);
            } else {
                this.maxNum = 30000000L;
                this.limitNum = 10000;
                this.systemUserView = 0;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("SyslogRepository thread run error. " + e.getMessage()));
        }
        while (true) {
            try {
                this.process();
            }
            catch (Exception e) {
                this.logger.error((Object)("SyslogRepository thread run error. " + e.getMessage()));
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("SyslogRepository thread run error. " + e.getMessage()));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        ArrayList<Object> list = null;
        List<Object> list2 = syslogList;
        synchronized (list2) {
            if (syslogList.isEmpty()) {
                return;
            }
            list = new ArrayList<Object>();
            list.addAll(syslogList);
            syslogList.clear();
        }
        ArrayList<NfaAnomalyEntity> nfaList = new ArrayList<NfaAnomalyEntity>();
        ArrayList<NfaAnomalyEntity> nfaAlarmList = new ArrayList<NfaAnomalyEntity>();
        for (Object e : list) {
            long totalNum;
            DevSendSysLogEntity entity;
            if (e instanceof DevSendSysLogEntity) {
                entity = (DevSendSysLogEntity)e;
                entity.setLogTime(AticUtil.convertDevSyslogTime((String)entity.getLogTime()));
                if (this.systemUserView == 0 && entity.getUser().equals("_system_")) continue;
                totalNum = this.devSysLogDao.getTotalCount();
                if (totalNum > this.maxNum) {
                    this.devSysLogDao.deleteByTime(this.limitNum);
                    this.writeSyslogForTcp();
                }
                this.devSysLogDao.saveOrUpdate(entity);
                continue;
            }
            if (!(e instanceof NfaAnomalyEntity)) continue;
            entity = (NfaAnomalyEntity)e;
            entity.setCreationTime(AticUtil.convertNfaTime((String)entity.getCreationTime()));
            entity.setUpdateTime(AticUtil.convertNfaTime((String)entity.getUpdateTime()));
            totalNum = this.nfaAnomalyDao.getTotalCount();
            if ((double)totalNum > (double)this.maxNum * 0.8) {
                this.logger.error((Object)("The total number of data is about to exceed. total is" + totalNum));
            }
            if (totalNum >= this.maxNum) {
                this.nfaAnomalyDao.deleteByTime(this.limitNum);
                this.writeSyslogForUdp();
            }
            this.nfaAnomalyDao.saveOrUpdate(entity);
            nfaList.add((NfaAnomalyEntity)entity);
            this.checkNfaAlarm((NfaAnomalyEntity)entity, nfaAlarmList);
        }
        try {
            if (!nfaAlarmList.isEmpty()) {
                this.alarmHandler.syslogAbnormalAlarm(nfaAlarmList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("transform alarm data error. " + e.getMessage()));
        }
        this.nfaAnomalyPool.add(nfaList);
    }

    private void writeSyslogForUdp() {
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.log.auto.syslog.delete");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp("127.0.0.1");
        sysLog.setTarget("atic.bis.divert.tactics.log.auto.syslog.data");
        sysLog.setTargetLocal(Boolean.valueOf(true));
        sysLog.setOperator("system");
        String[] para = new String[]{String.valueOf(this.limitNum)};
        sysLog.setDetail("atic.bis.divert.tactics.log.auto.syslog.delete.success");
        sysLog.setDetailPara(para);
        sysLog.setResult(1);
        sysOptLog.writeOptLog(sysLog);
    }

    private void writeSyslogForTcp() {
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.log.auto.device.syslog.delete");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp("127.0.0.1");
        sysLog.setTarget("atic.bis.divert.tactics.log.auto.device.syslog.data");
        sysLog.setTargetLocal(Boolean.valueOf(true));
        sysLog.setOperator("system");
        String[] para = new String[]{String.valueOf(this.limitNum)};
        sysLog.setDetail("atic.bis.divert.tactics.log.auto.device.syslog.delete.success");
        sysLog.setDetailPara(para);
        sysLog.setResult(1);
        sysOptLog.writeOptLog(sysLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getConfigData() {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream iStream = null;
        try {
            iStream = SyslogRepository.class.getResourceAsStream("/confUser.properties");
            Properties properties = new Properties();
            properties.load(iStream);
            String sysMaxNum = properties.getProperty("sysLogMaxNumber");
            String sysLimitNum = properties.getProperty("sysLogLimitNuber");
            String sysAverageNum = properties.getProperty("sysLogAverageNumber");
            String sysUserView = properties.getProperty("systemUserView");
            map.put("maxNum", sysMaxNum);
            map.put("limitNum", sysLimitNum);
            map.put("averageNum", sysAverageNum);
            map.put("sysUser", sysUserView);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"FileInputStream is error.");
        }
        catch (IOException e) {
            this.logger.error((Object)"properties load data is error.");
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"InputStream close is error.");
            }
        }
        return map;
    }

    private void checkNfaAlarm(NfaAnomalyEntity entity, List<NfaAnomalyEntity> nfaAlarmList) {
        String nfa = entity.getDevIp() + entity.getDstIp1() + entity.getSubType();
        Boolean isContain = this.nfaListBuffer.contains(nfa);
        Boolean isAttackEnd = AticUtil.isAttackEnd((String)entity.getStatus());
        if (isContain.booleanValue() && isAttackEnd.booleanValue()) {
            nfaAlarmList.add(entity);
            this.nfaListBuffer.remove(nfa);
        } else {
            if (isContain.booleanValue() && !isAttackEnd.booleanValue()) {
                return;
            }
            if (!isContain.booleanValue() && !isAttackEnd.booleanValue()) {
                nfaAlarmList.add(entity);
                this.nfaListBuffer.add(nfa);
            } else if (!isContain.booleanValue() && isAttackEnd.booleanValue()) {
                nfaAlarmList.add(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSyslog(Object obj) {
        List<Object> list = syslogList;
        synchronized (list) {
            if (syslogList.size() < 10000) {
                syslogList.add(obj);
            }
        }
    }

    public DevSysLogDao getDevSysLogDao() {
        return this.devSysLogDao;
    }

    public NfaAnomalyDao getNfaAnomalyDao() {
        return this.nfaAnomalyDao;
    }

    public NfaAnomalyPool getNfaAnomalyPool() {
        return this.nfaAnomalyPool;
    }

    public void setDevSysLogDao(DevSysLogDao devSysLogDao) {
        this.devSysLogDao = devSysLogDao;
    }

    public void setNfaAnomalyDao(NfaAnomalyDao nfaAnomalyDao) {
        this.nfaAnomalyDao = nfaAnomalyDao;
    }

    public void setNfaAnomalyPool(NfaAnomalyPool nfaAnomalyPool) {
        this.nfaAnomalyPool = nfaAnomalyPool;
    }

    public LogAlarmHandler getAlarmHandler() {
        return this.alarmHandler;
    }

    public void setAlarmHandler(LogAlarmHandler alarmHandler) {
        this.alarmHandler = alarmHandler;
    }
}

