/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.LogBisUtil;
import com.hs.atic.sdk.syslog.service.INfaAnomalyService;
import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.util.AticInstallUtil;
import com.opencsv.CSVWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class SyslogLinkageAction
extends BaseAction {
    public static final String SORT_NAME = "sortName";
    public static final String SORT_TYPE = "sortType";
    private static final int EXPORT_MAX = 100000;
    private static final long serialVersionUID = 8879719434362610743L;
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private String startTime;
    private String endTime;
    private String syslogDetail;
    private String sortType;
    private String sortField;
    private String idStr;
    private String downFileName;
    private String chargest = "UTF-8";
    private NfaAnomalyEntity nfaAnomalyEntity;
    private List<NfaAnomalyEntity> syslogLinkage;
    private String exprotType;

    public String getExprotType() {
        return this.exprotType;
    }

    public void setExprotType(String exprotType) {
        this.exprotType = exprotType;
    }

    public NfaAnomalyEntity getNfaAnomalyEntity() {
        return this.nfaAnomalyEntity;
    }

    public void setNfaAnomalyEntity(NfaAnomalyEntity nfaAnomalyEntity) {
        this.nfaAnomalyEntity = nfaAnomalyEntity;
    }

    public List<NfaAnomalyEntity> getSyslogLinkage() {
        return this.syslogLinkage;
    }

    public void setSyslogLinkage(List<NfaAnomalyEntity> syslogLinkage) {
        this.syslogLinkage = syslogLinkage;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getSyslogDetail() {
        return this.syslogDetail;
    }

    public void setSyslogDetail(String syslogDetail) {
        this.syslogDetail = syslogDetail;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public String getChargest() {
        return this.chargest;
    }

    public void setChargest(String chargest) {
        this.chargest = chargest;
    }

    public String listSyslogLinkage() {
        this.syslogLinkage = this.getSyslogLinkageLog();
        return "success";
    }

    private List<NfaAnomalyEntity> getSyslogLinkageLog() {
        Map<String, String> queryMap = this.getSysLinkConditions();
        INfaAnomalyService nfaAnomalyService = this.getNfaAnomalyService();
        Paging result = nfaAnomalyService.queryByPage(queryMap, this.start, this.pageSize);
        List syslogLinkages = result.getData();
        this.setTotal(result.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.pageSize);
        this.getSession().setAttribute("start", (Object)this.start);
        return syslogLinkages;
    }

    private INfaAnomalyService getNfaAnomalyService() {
        return LogBisUtil.getNfaAnomalyService();
    }

    public boolean validateViewSyslogLinkageParamete() {
        if (!this.validateEndTime()) {
            return false;
        }
        if (!this.validateStartTime()) {
            return false;
        }
        if (!this.validategetDevIp()) {
            return false;
        }
        return this.validateDetailParamete();
    }

    private boolean validategetDevIp() {
        if (null != this.nfaAnomalyEntity && null != this.nfaAnomalyEntity.getDevIp() && !"".equals(this.nfaAnomalyEntity.getDevIp())) {
            String[] ips;
            for (String ip : ips = this.nfaAnomalyEntity.getDevIp().split(",")) {
                if (IPUtil.isIpv4((String)ip.trim()) || IPUtil.isIpv6((String)ip.trim())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateDetailParamete() {
        if (null != this.nfaAnomalyEntity && null != this.nfaAnomalyEntity.getDetail()) {
            if (this.nfaAnomalyEntity.getDetail().trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (!"".equals(this.nfaAnomalyEntity.getDetail())) {
                String detailRegex = "^(?!\\s*null$)[\\w|\\!|\\@|\\#|\\$|\\%|\\^|\\*|\\+|\\-|\\=|\\||\\}|\\{|\\]\\[|\\:|\\;|\\?|\\/|\\.|\\,]*$";
                if (!String.valueOf(this.nfaAnomalyEntity.getDetail()).matches(detailRegex) || this.nfaAnomalyEntity.getDetail().length() > 31) {
                    return false;
                }
            }
        }
        return true;
    }

    private Map<String, String> getSysLinkConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.startTime) {
            queryMap.put("startTime", String.valueOf(AticUtil.convertTimeString((String)this.startTime)));
        }
        if (null != this.endTime) {
            queryMap.put("endTime", String.valueOf(AticUtil.convertTimeString((String)this.endTime)));
        }
        if (null != this.nfaAnomalyEntity) {
            if (null != this.nfaAnomalyEntity.getDevIp()) {
                queryMap.put("devIp", String.valueOf(this.nfaAnomalyEntity.getDevIp()));
            }
            if (null != this.nfaAnomalyEntity.getDetail()) {
                queryMap.put("detail", this.nfaAnomalyEntity.getDetail());
            }
        }
        queryMap.put(SORT_NAME, this.sortField);
        queryMap.put(SORT_TYPE, this.sortType);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    public void exportSysLinkLog() {
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.exportSysLinkLog)) {
            throw new LegoCheckedException(570516L);
        }
        try {
            boolean ret;
            String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
            File file = new File(downloadPath);
            if (!file.exists() && !(ret = file.mkdir())) {
                if (this.idStr != null) {
                    this.systemOpeLog("atic.system.sysloglinkage.export.select", "lego.dic.module.AticBis", true, new String[0], "atic.system.check.filepath.error", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, null);
                } else {
                    this.systemOpeLog("atic.system.sysloglinkage.export.all", "lego.dic.module.AticBis", true, new String[0], "atic.system.check.filepath.error", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, null);
                }
                return;
            }
            Long dateTime = System.currentTimeMillis();
            String fileNameTmp = "SyslogLinkageLogs_" + dateTime + ".csv";
            this.addListElementInSession("SyslogLinkageLog", fileNameTmp);
            downloadPath = downloadPath + File.separator + fileNameTmp;
            if (this.idStr != null) {
                if (!"".equals(this.idStr)) {
                    String tempStr = this.idStr.substring(0, this.idStr.length() - 1);
                    this.syslogLinkage = this.getNfaAnomalyService().getLogsByIdS(tempStr);
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    if (null != this.syslogLinkage) {
                        for (NfaAnomalyEntity tempItem : this.syslogLinkage) {
                            moIdList.add(tempItem.getDeviceId());
                        }
                    }
                    BisUtil.checkUserSecurity(moIdList);
                }
            } else {
                this.syslogLinkage = this.getNfaAnomalyService().queryByPage(this.getSysLinkConditions(), 0, 100000).getData();
            }
            List<List<String>> data = new ArrayList<List<String>>();
            if (null != this.syslogLinkage) {
                data = this.sysLinklogToStr(this.syslogLinkage);
            }
            this.writeCsvFile(data, downloadPath, LogBisUtil.generateSysLinkExportTitles());
            String[] args = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            args = 1 == version ? downloadPath.split("/") : downloadPath.split("\\\\");
            this.responseResult(args[args.length - 1]);
        }
        catch (LegoCheckedException e) {
            if (this.idStr != null) {
                this.systemOpeLog("atic.system.sysloglinkage.export.select", "lego.dic.module.AticBis", true, new String[0], "defense.err.1002", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, (Exception)((Object)e));
            } else {
                this.systemOpeLog("atic.system.sysloglinkage.export.all", "lego.dic.module.AticBis", true, new String[0], "defense.err.1002", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, (Exception)((Object)e));
            }
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (this.idStr != null) {
                this.systemOpeLog("atic.system.sysloglinkage.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, e);
            } else {
                this.systemOpeLog("atic.system.sysloglinkage.export.all", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, e);
            }
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            if (this.idStr != null) {
                this.systemOpeLog("atic.system.sysloglinkage.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, e);
            } else {
                this.systemOpeLog("atic.system.sysloglinkage.export.all", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, e);
            }
            throw new LegoCheckedException(102L);
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.exportSysLinkLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsvFile(List<List<String>> dataLst, String downloadPath, String[] titles) {
        CSVWriter writer = null;
        FileOutputStream fos = null;
        OutputStreamWriter os = null;
        PrintWriter pw = null;
        try {
            fos = new FileOutputStream(downloadPath);
            byte[] uft8bom = new byte[]{-17, -69, -65};
            fos.write(uft8bom);
            os = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.chargest));
            pw = new PrintWriter(os);
            writer = new CSVWriter((Writer)pw);
            int iIndex = 0;
            writer.writeNext(titles, false);
            for (List<String> lstStr : dataLst) {
                iIndex = 0;
                String[] arrTemps = new String[lstStr.size()];
                for (String strTemp : lstStr) {
                    arrTemps[iIndex++] = " " + strTemp;
                }
                writer.writeNext(arrTemps, false);
            }
            IOUtils.closeQuietly((Closeable)writer);
            if (null != pw) {
                pw.close();
            }
            this.closeOutputStreamWriter(os);
            this.closeFileOutputStream(fos);
        }
        catch (IOException e) {
            this.logger.error((Object)"writeCsvFile error");
        }
        finally {
            IOUtils.closeQuietly(writer);
            if (null != pw) {
                pw.close();
            }
            this.closeOutputStreamWriter(os);
            this.closeFileOutputStream(fos);
        }
    }

    private void closeFileOutputStream(FileOutputStream fileOutputStream) {
        if (null != fileOutputStream) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"close FileOutputStream error");
            }
            finally {
                fileOutputStream = null;
            }
        }
    }

    private void closeOutputStreamWriter(OutputStreamWriter outputStreamWriter) {
        if (null != outputStreamWriter) {
            try {
                outputStreamWriter.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"close OutputStreamWriter error");
            }
            finally {
                outputStreamWriter = null;
            }
        }
    }

    private List<List<String>> sysLinklogToStr(List<NfaAnomalyEntity> syslogLinkages) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (NfaAnomalyEntity each : syslogLinkages) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(each.getAticTimeString());
            tempLst.add(each.getDevIp());
            tempLst.add(each.getDetail());
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    public void downSysLinkLog() {
        String onlyFileName = this.downFileName;
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        this.downFileName = exportFolderPath + File.separator + this.downFileName;
        try {
            if (!this.existListElementInSession("SyslogLinkageLog", onlyFileName)) {
                this.logger.error((Object)"SyslogLinkageLog aggressive download request!");
                return;
            }
            if (AticUtil.isNull((String)onlyFileName)) {
                this.systemOpeLog(this.getOperation(), "lego.dic.module.AticBis", true, new String[0], "lego.dic.operationstatus.failure", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            if (!AticUtil.checkFileName((String)onlyFileName, (String)"csv")) {
                this.systemOpeLog(this.getOperation(), "lego.dic.module.AticBis", true, new String[0], "lego.dic.operationstatus.failure", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            if (!onlyFileName.contains("SyslogLinkageLogs")) {
                this.systemOpeLog(this.getOperation(), "lego.dic.module.AticBis", true, new String[0], "lego.dic.operationstatus.failure", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            if (!AticUtil.checkFilePath((String)exportFolderPath, (String)this.downFileName)) {
                this.systemOpeLog(this.getOperation(), "lego.dic.module.AticBis", true, new String[0], "lego.dic.operationstatus.failure", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), false, null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            String downloadFileName = "";
            try {
                downloadFileName = new String(this.getDownFileName().getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new LegoCheckedException(102L);
            }
            String fileNameTmp = "SyslogLinkageLogs_" + this.transferlong2String(System.currentTimeMillis()) + ".csv";
            this.getResponse().setContentType("application/x-download");
            this.getResponse().addHeader("Content-Disposition", "attachment;filename=" + fileNameTmp);
            this.getResponse().setCharacterEncoding("windows-1251");
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            FileInputStream fileInput = null;
            try {
                int bytesRead;
                fileInput = new FileInputStream(downloadFileName);
                bis = new BufferedInputStream(fileInput);
                bos = new BufferedOutputStream((OutputStream)this.getResponse().getOutputStream());
                byte[] buff = new byte[0x100000];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
                this.systemOpeLog(this.getOperation(), "lego.dic.module.AticBis", true, new String[0], "lego.dic.operationstatus.success", "atic.system.sysloglinkage.panle.title", SysoplogLevel.info.getValue(), true, null);
                this.closeInputStream(fileInput);
                this.closeInputStream(bis);
                this.closeOutputStream(bos);
            }
            catch (IOException e) {
                try {
                    throw new LegoCheckedException(102L);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(fileInput);
                    this.closeInputStream(bis);
                    this.closeOutputStream(bos);
                    throw throwable;
                }
            }
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog("atic.system.devsyslog.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.dic.operationstatus.failure", "atic.system.devsyslog.panle.title", SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.systemOpeLog("atic.system.devsyslog.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.system.devsyslog.panle.title", SysoplogLevel.normal.getValue(), false, e);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            this.systemOpeLog("atic.system.devsyslog.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.system.devsyslog.panle.title", SysoplogLevel.normal.getValue(), false, e);
            throw new LegoCheckedException(102L);
        }
        finally {
            this.removeListElementInSession("SyslogLinkageLog", onlyFileName);
            AticUtil.deleteTempFile((String)this.downFileName);
        }
    }

    private String getOperation() {
        String operation = null;
        operation = "all".equals(this.exprotType) ? "atic.system.sysloglinkage.export.all" : ("select".equals(this.exprotType) ? "atic.system.sysloglinkage.export.select" : "atic.system.sysloglinkage.panle.title");
        return operation;
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                input = null;
            }
            finally {
                input = null;
            }
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                output = null;
            }
            finally {
                output = null;
            }
        }
    }

    private String transferlong2String(Long time) {
        if (time == null) {
            return "";
        }
        Date d = new Date(time);
        SimpleDateFormat formate = new SimpleDateFormat("yyyyMMddHHmmss");
        return formate.format(d);
    }

    public void exportSysTooMuch() {
        Paging result = this.getNfaAnomalyService().queryByPage(this.getSysLinkConditions(), this.start, this.pageSize);
        int count = result.getCount();
        if (count > 100000) {
            this.responseResult("TOO MUCH");
        } else {
            this.responseResult("SUCCESS");
        }
    }

    public String viewSyslogDetail() {
        INfaAnomalyService nfaAnomalyService = this.getNfaAnomalyService();
        List<NfaAnomalyEntity> nfaAnomalyList = nfaAnomalyService.getLogsByIdS(this.idStr);
        if (null != nfaAnomalyList && !nfaAnomalyList.isEmpty()) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(nfaAnomalyList.get(0).getDeviceId());
            BisUtil.checkUserSecurity(moIdList);
            this.syslogDetail = nfaAnomalyList.get(0).getDetail();
        }
        return "success";
    }

    public boolean validateViewIdStr() {
        try {
            if (AticUtil.isNull((String)this.idStr) || Integer.parseInt(this.idStr) < 0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"Integer format is error");
            return false;
        }
        return true;
    }

    public boolean validateTempStr() {
        if (null != this.idStr) {
            String[] idStrs;
            for (String id : idStrs = this.idStr.split(",")) {
                try {
                    if (!AticUtil.isNull((String)id) && Integer.parseInt(id) >= 0) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    this.logger.error((Object)"Integer format is error");
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateStartTime() {
        if (null == this.startTime || "".equals(this.startTime)) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.startTime);
    }

    public boolean validateEndTime() {
        if ("".equals(this.endTime) || null == this.endTime) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.endTime);
    }
}

