/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.sdk.syslog.service.ISyslogServerService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.xml.sax.SAXException;

public class InitAticLogLifeCycle
extends Thread {
    public static final String MYSQL = "mysql";
    private static final Long SLEEP_TIME = 2000L;
    private static Boolean checkReadDBFile = false;
    private static final String DB_PATH = "legoPlatInstalled.xml";
    private static String url = "";
    private static String userName = "";
    private static String password = "";
    private static String driveClass = "";
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private ISyslogServerService initSyslogServerService;

    @Override
    public void run() {
        this.start();
    }

    public void startSyslogReceiveThread() {
        Connection connection = null;
        while (true) {
            try {
                connection = this.getConnection();
                this.initSyslogServerService.initSyslogReceiveThread();
            }
            catch (Exception e) {
                this.logger.error((Object)("startSyslogReceiveThread error." + e.getMessage()));
                try {
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"close connection error.");
                }
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (InterruptedException ex) {
                    this.logger.error((Object)("sleep error." + e.getMessage()));
                }
                continue;
            }
            break;
        }
        try {
            if (null != connection) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)"close connection error.");
        }
    }

    public void startSyslogServer() {
        Connection connection = null;
        while (true) {
            try {
                connection = this.getConnection();
                this.initSyslogServerService.initSyslogServer();
            }
            catch (Exception e) {
                this.logger.error((Object)("startSyslogServer error." + e.getMessage()));
                try {
                    if (null != connection) {
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"close connection error.");
                }
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (InterruptedException ex) {
                    this.logger.error((Object)("sleep error." + e.getMessage()));
                }
                continue;
            }
            break;
        }
        try {
            if (null != connection) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)"close connection error.");
        }
    }

    @Override
    public void start() {
        this.startSyslogReceiveThread();
        this.startSyslogServer();
    }

    public ISyslogServerService getInitSyslogServerService() {
        return this.initSyslogServerService;
    }

    public void setInitSyslogServerService(ISyslogServerService initSyslogServerService) {
        this.initSyslogServerService = initSyslogServerService;
    }

    private Connection getConnection() {
        Connection conn = null;
        try {
            this.readDBFile();
            Class.forName(driveClass);
            conn = DriverManager.getConnection(url, userName, password);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"driver class not found.");
        }
        catch (SQLException e) {
            this.logger.error((Object)"get connection failed.");
        }
        catch (Exception e) {
            this.logger.error((Object)"failed.");
        }
        if (null == conn) {
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException e) {
                conn = this.getConnection();
            }
            if (null == conn) {
                conn = this.getConnection();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDBFile() {
        if (!checkReadDBFile.booleanValue()) {
            FileInputStream fileInputStream = null;
            try {
                File file = new File(this.getDBFilePath());
                fileInputStream = new FileInputStream(file);
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setExpandEntityReferences(false);
                dbf.setXIncludeAware(false);
                dbf.setValidating(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = new DOMReader().read(db.parse(fileInputStream));
                if (null == document) {
                    this.logger.error((Object)"document is null");
                    return;
                }
                Element root = document.getRootElement();
                List elementsList = root.element("propMap").elements("entry");
                if (null != elementsList && !elementsList.isEmpty()) {
                    this.readXmlElement(elementsList);
                }
                checkReadDBFile = true;
                this.logger.info((Object)"read legoPlatInstalled success");
            }
            catch (SAXException e) {
                this.logger.error((Object)"SAXException error");
            }
            catch (ParserConfigurationException e) {
                this.logger.error((Object)"ParserConfigurationException error");
            }
            catch (IOException e) {
                this.logger.error((Object)"IOException error");
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)"fileInputStream.close() fail");
                    }
                }
            }
        }
    }

    private String getDBFilePath() {
        String installPathStr = ".";
        try {
            String calpath = new File(installPathStr).getCanonicalPath();
            String osName = System.getProperty("os.name");
            installPathStr = osName.equals("Linux") ? calpath.substring(0, calpath.lastIndexOf(File.separator + "components" + File.separator) + 1) : calpath.substring(0, calpath.lastIndexOf(File.separator + "Runtime" + File.separator) + 1);
        }
        catch (IOException e) {
            this.logger.error((Object)"IOException error");
        }
        boolean isSpLinux = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("/");
        boolean isSpWindows = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("\\");
        if (!isSpLinux && !isSpWindows) {
            installPathStr = installPathStr + File.separator;
        }
        String filePath = installPathStr + DB_PATH;
        return filePath;
    }

    private void readXmlElement(List<Element> elementsList) {
        for (Element element : elementsList) {
            String keyString = element.elementText("string");
            if (keyString.equalsIgnoreCase("lego.db.driver")) {
                driveClass = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
            }
            if (keyString.equalsIgnoreCase("lego.db.url")) {
                url = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
                this.logger.info((Object)"readXmlElement");
                if (null != url && url.contains("?")) {
                    String partOne = url.substring(0, url.indexOf("?"));
                    url = partOne + "/lego?createDatabaseIfNotExist=true&autoReconnect=true&useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=" + AticUtil.curTimeZone();
                    this.logger.info((Object)"readXmlElement [if] url");
                } else {
                    url = url + "/lego?createDatabaseIfNotExist=true&autoReconnect=true&useUnicode=true&characterEncoding=utf-8&useSSL=false&serverTimezone=" + AticUtil.curTimeZone();
                    this.logger.info((Object)"readXmlElement [else] url");
                }
            }
            if (keyString.equalsIgnoreCase("esight.db.nmsdbuser")) {
                userName = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
            }
            if (!keyString.equalsIgnoreCase("esight.db.nmsdbpassword.encrypt")) continue;
            password = DataProtectServiceConst.sdpDecryptLocal((String)element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value"));
        }
    }
}

