/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.compmoniservice;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.IAppManager;
import com.hs.lego.core.sdk.base.model.AppInfo;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LegoProperties;
import com.hs.lego.core.system.sysmonitor.sdk.model.SyslogOptType;
import com.hs.lego.core.system.sysmonitor.service.compmoniservice.ICompMonitor;
import com.hs.lego.core.system.sysmonitor.service.compmoniservice.LogTranslateObject;
import java.util.ArrayList;
import java.util.List;

public class CompMonitorImpl
implements ICompMonitor {
    public static final String KEY_HIDE_SERVICES = "hide_services";
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private IAppManager appManager;
    private String[] filterApp = null;

    public CompMonitorImpl() {
        String hideServices = LegoProperties.getInstance().getProperty(KEY_HIDE_SERVICES, "DomainApplicaton,webnms,mediation,discover");
        this.filterApp = hideServices.split(",");
    }

    @Override
    public void stopBundle(List<String> lstBundle) {
        for (String sBundle : lstBundle) {
            this.appManager.stop(sBundle);
        }
    }

    public IAppManager getAppManager() {
        return this.appManager;
    }

    public void setAppManager(IAppManager appManager) {
        this.appManager = appManager;
    }

    @Override
    public void startBundle(List<String> lstBundle) {
        for (String sBundle : lstBundle) {
            this.appManager.start(sBundle);
        }
    }

    private boolean findFilterAppName(AppInfo ai) {
        for (String s : this.filterApp) {
            if (!s.equals(ai.getAppName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SyslogOptType> getBundles() {
        List<AppInfo> tmpAppInfo = this.appManager.getAppList();
        ArrayList<AppInfo> returnAppInfo = new ArrayList<AppInfo>();
        try {
            for (AppInfo ai : tmpAppInfo) {
                if (this.findFilterAppName(ai)) continue;
                returnAppInfo.add(ai);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)(e.getMessage() + 653110169305088L));
        }
        return LogTranslateObject.translateAppInfoToBundle(returnAppInfo);
    }
}

