/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.dbmoniservice;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseFileInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.hs.lego.core.system.sysmonitor.service.dbmoniservice.IDbResourceDao;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class DbResourceDao
extends HibernateDaoSupport
implements IDbResourceDao {
    protected static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int VERSION_MAIN = 5;
    private static final int VERSION_SUB_MAIN = 1;
    private static final int VERSION_SUB = 25;
    private static String sqlversion = "";
    private String sqlTypeName = "";
    private boolean checkMysqlVersion = Boolean.FALSE;
    private boolean checkSustainDataFree = Boolean.FALSE;

    @Override
    public List<DataBaseInfo> getDbInfo() throws SQLException {
        ArrayList<DataBaseInfo> databaseList = null;
        if (null == this.sqlTypeName || this.sqlTypeName.equalsIgnoreCase("")) {
            this.getSqlType();
        }
        String sqlTyepe = this.sqlTypeName;
        String hsql = this.getSql(this.sqlTypeName);
        if ("".equals(hsql)) {
            return databaseList;
        }
        List<?> rs = null;
        rs = this.findBySql(hsql);
        if (null == rs) {
            return databaseList;
        }
        int rsindex = rs.size();
        databaseList = new ArrayList<DataBaseInfo>();
        for (int i = 0; i < rsindex; ++i) {
            Object[] objs = (Object[])rs.get(i);
            DataBaseInfo tempInfo = this.getDatabaseInfos(objs, sqlTyepe);
            if (null == tempInfo) continue;
            databaseList.add(tempInfo);
        }
        return databaseList;
    }

    private String getSql(String sqlType) {
        String sql = "";
        if ("MySQL".equals(sqlType)) {
            sql = "select table_schema, sum(`DATA_LENGTH`),sum(`DATA_FREE`) from information_schema.`TABLES` group by table_schema";
        } else if ("Microsoft SQL Server".equals(sqlType)) {
            sql = "sp_helpdb";
        } else if ("ORACLE".equals(sqlType)) {
            sql = "";
        }
        return sql;
    }

    private DataBaseInfo getDatabaseInfos(Object[] objs, String sqlType) {
        DataBaseInfo tempInfo = null;
        if ("MySQL".equals(sqlType)) {
            tempInfo = this.getDatabaseInfo(objs, "");
            if (null != tempInfo) {
                tempInfo.setSqlTypeName("MySQL " + this.getMySqlVersion());
            }
        } else if ("Microsoft SQL Server".equals(sqlType)) {
            String dbName = objs[0].toString();
            List<?> rs = null;
            String hsql = "select log,data,total from (select log=sum(size * 8) from " + dbName + ".dbo.sysfiles where status& 0x40 = 0x40 ) a,(select data=sum(size * 8) from " + dbName + ".dbo.sysfiles where status& 0x40 != 0x40) b,(select total=sum(size * 8) from " + dbName + ".dbo.sysfiles) c";
            rs = this.findBySql(hsql);
            if (null == rs) {
                return tempInfo;
            }
            if (!rs.isEmpty()) {
                int rsindex = rs.size();
                for (int i = 0; i < rsindex; ++i) {
                    Object[] tempObjs = (Object[])rs.get(i);
                    tempInfo = this.getDatabaseInfo(tempObjs, dbName);
                    if (null == tempInfo) continue;
                    tempInfo.setSqlTypeName("Microsoft SQL Server");
                }
            }
        }
        return tempInfo;
    }

    private DataBaseFileInfo getSqlserverFileInfo(DataBaseInfo tempInfo) {
        DataBaseFileInfo fileInfo = new DataBaseFileInfo();
        String dbName = tempInfo.getDataBaseName();
        String hsql = "select name,status,maxsize,filename from " + dbName + ".dbo.sysfiles";
        List<?> rs = null;
        rs = this.findBySql(hsql);
        if (null == rs) {
            return fileInfo;
        }
        boolean autoIncrease = false;
        if (!rs.isEmpty()) {
            int rsindex = rs.size();
            for (int i = 0; i < rsindex; ++i) {
                Object[] tempObjs = (Object[])rs.get(i);
                String maxSize = tempObjs[2].toString();
                fileInfo.setMaxSize(Long.parseLong(maxSize));
                fileInfo.setFileName(tempObjs[3].toString());
                if (!maxSize.equalsIgnoreCase("-1")) continue;
                autoIncrease = true;
                fileInfo.setAutoIncrease(Boolean.TRUE.booleanValue());
                break;
            }
        }
        tempInfo.setAutoIncrease(Boolean.valueOf(autoIncrease));
        tempInfo.setBaseFileInfo(fileInfo);
        return fileInfo;
    }

    private DataBaseFileInfo getMySqlDataBaseFileInfo(DataBaseInfo tempInfo) {
        String hsql = "SELECT * from performance_schema.GLOBAL_VARIABLES where VARIABLE_NAME = 'datadir'";
        List<?> rs = null;
        DataBaseFileInfo fileInfo = new DataBaseFileInfo();
        if (!this.sustainDataFree()) {
            return fileInfo;
        }
        rs = this.findBySql(hsql);
        if (null == rs) {
            return fileInfo;
        }
        if (!rs.isEmpty()) {
            int rsindex = rs.size();
            for (int i = 0; i < rsindex; ++i) {
                Object[] tempObjs = (Object[])rs.get(i);
                String filePath = tempObjs[1].toString();
                fileInfo.setFileName(filePath);
                fileInfo.setMaxSize(-1L);
            }
        }
        tempInfo.setAutoIncrease(Boolean.valueOf(true));
        tempInfo.setBaseFileInfo(fileInfo);
        return fileInfo;
    }

    private DataBaseInfo getDatabaseInfo(Object[] objs, String dateBaseName) {
        DataBaseFileInfo fileInfo;
        DataBaseInfo dataBaseInfo = null;
        if (null == objs || objs.length < 3) {
            return new DataBaseInfo();
        }
        if ("MySQL".equals(this.sqlTypeName) && null != (dataBaseInfo = this.getMysqlDatabaseInfo(objs))) {
            fileInfo = this.getMySqlDataBaseFileInfo(dataBaseInfo);
            dataBaseInfo.setBaseFileInfo(fileInfo);
        }
        if ("Microsoft SQL Server".equals(this.sqlTypeName) && null != (dataBaseInfo = this.getSQLServerDatabaseInfo(objs, dateBaseName))) {
            fileInfo = this.getSqlserverFileInfo(dataBaseInfo);
            dataBaseInfo.setBaseFileInfo(fileInfo);
        }
        return dataBaseInfo;
    }

    private DataBaseInfo getSQLServerDatabaseInfo(Object[] objs, String dateBaseName) {
        boolean dbNameVal;
        DataBaseInfo dataBaseInfo = null;
        if (null == dateBaseName || dateBaseName.isEmpty()) {
            return dataBaseInfo;
        }
        boolean dbNameVal1 = dateBaseName.equals("master") || dateBaseName.equals("tempdb") || dateBaseName.equals("model");
        boolean dbNameVal2 = dateBaseName.equals("msdb") || dateBaseName.equals("public static final String REPORT_MSDB") || dateBaseName.equals("ReportServer") || dateBaseName.equals("ReportServerTempDB");
        boolean bl = dbNameVal = dbNameVal1 || dbNameVal2;
        if (dbNameVal) {
            LOGGER.debug((Object)"system database");
            return dataBaseInfo;
        }
        String dataTotal = objs[2].toString().trim();
        double dbRemainCapacity = 0.0;
        double dbCapacity = Float.valueOf(dataTotal).floatValue() / 1024.0f;
        dbCapacity = MathUtil.getDoubleValue((double)dbCapacity);
        List<?> rs = null;
        String hsql = dateBaseName + ".dbo.sp_spaceused";
        rs = this.findBySql(hsql);
        if (null != rs) {
            int rsindex = rs.size();
            for (int i = 0; i < rsindex; ++i) {
                Object[] tempObjs = (Object[])rs.get(i);
                String tempdbR = tempObjs[2].toString();
                String temp = "";
                temp = tempdbR.contains("MB") ? tempdbR.replace(" MB", "") : tempdbR.trim();
                dbRemainCapacity = Double.valueOf(temp);
            }
        }
        double used = MathUtil.getDoubleValue((double)(dbCapacity - dbRemainCapacity));
        double pecent = MathUtil.getDoubleValue((double)(used / dbCapacity)) * 100.0;
        dbRemainCapacity = MathUtil.getDoubleValue((double)dbRemainCapacity);
        dataBaseInfo = new DataBaseInfo();
        dataBaseInfo.setDataBaseName(dateBaseName);
        dataBaseInfo.setTotal(dbCapacity + " MB");
        dataBaseInfo.setRemainCapacity(dbRemainCapacity + " MB");
        dataBaseInfo.setRemain(dbRemainCapacity + " MB");
        dataBaseInfo.setUsed(used + " MB");
        dataBaseInfo.setPercent(pecent + "%");
        return dataBaseInfo;
    }

    private DataBaseInfo getMysqlDatabaseInfo(Object[] objs) {
        DataBaseInfo dataBaseInfo = null;
        String dbName = objs[0].toString();
        if (dbName.isEmpty() || dbName.equals("information_schema") || dbName.equals("mysql") || dbName.equals("performance_schema")) {
            LOGGER.debug((Object)"system database");
            return dataBaseInfo;
        }
        try {
            double dbCapacity = Long.parseLong(objs[1].toString());
            double dbRemainCapacity = Long.parseLong(objs[2].toString());
            double dbCapacityMb = dbCapacity / 1048576.0;
            dbCapacityMb = MathUtil.getDoubleValue((double)dbCapacityMb);
            double tempRemainCapMb = dbRemainCapacity / 1048576.0;
            tempRemainCapMb = MathUtil.getDoubleValue((double)tempRemainCapMb);
            double total = dbCapacityMb + tempRemainCapMb;
            double percent = 0.0;
            if (dbCapacityMb > 0.0) {
                percent = MathUtil.getDoubleValue((double)(dbCapacityMb / total)) * 100.0;
            }
            dataBaseInfo = new DataBaseInfo();
            dataBaseInfo.setDataBaseName(dbName);
            dataBaseInfo.setTotal(total + " MB");
            dataBaseInfo.setUsed(dbCapacityMb + " MB");
            if (this.sustainDataFree()) {
                LOGGER.debug((Object)("current dataBase version is " + this.getMySqlVersion()));
                dataBaseInfo.setRemainCapacity(tempRemainCapMb + " MB");
                dataBaseInfo.setRemain(tempRemainCapMb + " MB");
                dataBaseInfo.setPercent(percent + "%");
            } else {
                dataBaseInfo.setRemainCapacity("N/A");
                dataBaseInfo.setRemain("N/A");
                dataBaseInfo.setPercent("N/A");
                dataBaseInfo.setVersion(this.getMySqlVersion());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return dataBaseInfo;
    }

    public String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public void setSqlTypeName(String sqlTypeName) {
        this.sqlTypeName = sqlTypeName;
    }

    private String getMySqlVersion() {
        String hsql;
        if ((sqlversion == null || sqlversion.equalsIgnoreCase("")) && !(hsql = "SELECT VERSION()").equals("")) {
            List<?> rs = null;
            rs = this.findBySql(hsql);
            if (null != rs) {
                int rsindex = rs.size();
                for (int i = 0; i < rsindex; ++i) {
                    sqlversion = rs.get(i).toString();
                }
            }
        }
        return sqlversion;
    }

    private boolean sustainDataFree() {
        boolean enable = false;
        String mysqlVersion = this.getMySqlVersion();
        if (!this.checkMysqlVersion) {
            this.checkMysqlVersion = Boolean.TRUE;
            if (null == mysqlVersion || mysqlVersion.equals("")) {
                return enable;
            }
            String[] version = mysqlVersion.split("-");
            String[] vers = version[0].split("\\.");
            int version1 = 0;
            int version2 = 0;
            int version3 = 0;
            if (vers.length == 3) {
                version1 = Integer.parseInt(vers[0]);
                version2 = Integer.parseInt(vers[1]);
                version3 = Integer.parseInt(vers[2]);
            } else if (vers.length == 2) {
                version1 = Integer.parseInt(vers[0]);
                version2 = Integer.parseInt(vers[1]);
            } else if (vers.length == 1) {
                version1 = Integer.parseInt(vers[0]);
            }
            if (version1 > 5) {
                enable = true;
            } else if (version1 == 5) {
                if (version2 > 1) {
                    enable = true;
                } else if (version2 == 1 && version3 >= 25) {
                    enable = true;
                }
            }
            this.checkSustainDataFree = enable;
        }
        return this.checkSustainDataFree;
    }

    private void getSqlType() {
    }

    private List<?> findBySql(String sql) {
        FindBySqlCallBack callback = new FindBySqlCallBack(sql);
        return (List)super.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    @Override
    public ResourceUse queryResource(String tableSpacePath) {
        return null;
    }

    private static final class FindBySqlCallBack
    implements HibernateCallback {
        private String sql;

        public FindBySqlCallBack(String sql) {
            this.sql = sql;
        }

        public Object doInHibernate(Session session) {
            List list = session.createSQLQuery(this.sql).list();
            return list;
        }
    }
}

