/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.cert.model.CertManagementForm;
import com.hs.atic.cert.service.ICertManagementService;
import com.hs.atic.sdk.bis.form.ConfigBlackholeApiForm;
import com.hs.atic.sdk.bis.service.IConfigBlackholeService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlackHoleApiAction
extends BaseAction {
    private static final long serialVersionUID = -3252467176042936430L;
    private static final String ALL_NET = "1";
    private static final String OTHER_DOMESTIC = "2";
    private static final String OTHER_FOREIGN = "3";
    private static final String OTHER = "4";
    private static final int NAME_MAX_LENGTH = 64;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private ConfigBlackholeApiForm configBlackholeApiForm;
    private List<LangPair> serviceProviderList;
    private String url;
    private String userName;
    private String password;
    private String serviceProvider;
    private String serviceProviderLabel;
    private String serviceProviderValue;
    private Integer enableStatus;
    private List<LangPair> defaultPolicyList;
    private String defaultScopeLabel;
    private String defaultScopeValue;
    private IConfigBlackholeService configBlackholeService;
    private List<CertManagementForm> allCertList;
    private ICertManagementService certManagementService;
    private String alias;

    public void setConfigBlackholeService(IConfigBlackholeService configBlackholeService) {
        this.configBlackholeService = configBlackholeService;
    }

    public String showConfigBlackholeApi() {
        this.configBlackholeApiForm = this.configBlackholeService.getBlackHoleApiConfig();
        if (null == this.configBlackholeApiForm) {
            this.configBlackholeApiForm = new ConfigBlackholeApiForm();
        }
        this.initServiceProviderList(this.configBlackholeApiForm);
        this.initCombobox();
        this.certManagementService = (ICertManagementService)ServiceContext.getInstance().getService("certManagementService", ICertManagementService.class);
        this.allCertList = this.certManagementService.queryAllCerts();
        return "success";
    }

    private void initServiceProviderList(ConfigBlackholeApiForm configBlackholeApiForms) {
        this.serviceProviderList = new ArrayList<LangPair>();
        this.serviceProviderList.add(new LangPair(this.getText("atic.bis.blackhole.api.sp.ctcc"), "CTCC"));
        this.setServiceProviderLabelAndValue(configBlackholeApiForms.getServiceProvider());
    }

    private void initCombobox() {
        this.defaultPolicyList = new ArrayList<LangPair>();
        LangPair allnet = new LangPair(this.getText("atic.bis.cloudclean.default.policy.all"), ALL_NET);
        LangPair otherDe = new LangPair(this.getText("atic.bis.cloudclean.default.policy.other.domestic.provider"), OTHER_DOMESTIC);
        LangPair otherFo = new LangPair(this.getText("atic.bis.cloudclean.default.policy.other.foreign.provider"), OTHER_FOREIGN);
        LangPair other = new LangPair(this.getText("atic.bis.cloudclean.default.policy.other"), OTHER);
        this.defaultPolicyList.add(allnet);
        this.defaultPolicyList.add(otherDe);
        this.defaultPolicyList.add(otherFo);
        this.defaultPolicyList.add(other);
        if (null != this.configBlackholeApiForm) {
            this.setActionLabelAndValue(Integer.valueOf(null == this.configBlackholeApiForm.getDefendScope() ? ALL_NET : this.configBlackholeApiForm.getDefendScope()));
        }
    }

    private void setActionLabelAndValue(Integer value) {
        switch (value) {
            case 1: {
                this.setDefaultScopeLabel(this.getText("atic.bis.cloudclean.default.policy.all"));
                this.setDefaultScopeValue(ALL_NET);
                break;
            }
            case 2: {
                this.setDefaultScopeLabel(this.getText("atic.bis.cloudclean.default.policy.other.domestic.provider"));
                this.setDefaultScopeValue(OTHER_DOMESTIC);
                break;
            }
            case 3: {
                this.setDefaultScopeLabel(this.getText("atic.bis.cloudclean.default.policy.other.foreign.provider"));
                this.setDefaultScopeValue(OTHER_FOREIGN);
                break;
            }
            case 4: {
                this.setDefaultScopeLabel(this.getText("atic.bis.cloudclean.default.policy.other"));
                this.setDefaultScopeValue(OTHER);
                break;
            }
        }
    }

    private void setServiceProviderLabelAndValue(String value) {
        if (null == value) {
            this.setServiceProviderLabel(this.getText("atic.bis.blackhole.api.sp.ctcc"));
            this.setServiceProviderValue("CTCC");
        }
        if ("BJCT".equals(value)) {
            this.setServiceProviderLabel(this.getText("atic.bis.blackhole.api.sp.bjct"));
            this.setServiceProviderValue(value);
        } else if ("SHCT".equals(value)) {
            this.setServiceProviderLabel(this.getText("atic.bis.blackhole.api.sp.shct"));
            this.setServiceProviderValue(value);
        } else if ("CTCC".equals(value)) {
            this.setServiceProviderLabel(this.getText("atic.bis.blackhole.api.sp.ctcc"));
            this.setServiceProviderValue(value);
        }
    }

    public void configBlackholeApi() {
        ConfigBlackholeApiForm configBlackholeApiForms = this.getConfigBlackholeApiForm();
        configBlackholeApiForms.setEnableStatus(this.enableStatus);
        String isp = "--";
        if ("CTCC".equals(configBlackholeApiForms.getServiceProvider())) {
            isp = "atic.bis.blackhole.api.sp.ctcc";
        }
        String[] detailPara = new String[]{isp};
        try {
            if (null != configBlackholeApiForms.getPassword()) {
                StringBuffer pwStringBuffer = new StringBuffer();
                pwStringBuffer.append(configBlackholeApiForms.getPassword());
                configBlackholeApiForms.setPassword(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)pwStringBuffer));
            }
            this.configBlackholeService.saveApi(configBlackholeApiForms);
            this.systemOpeLog("atic.public.button.blackhole.api.configure", "lego.dic.module.AticBis", true, detailPara, "atic.public.button.blackhole.api.configure.detail", "atic.bis.blackhole.api.sp.ctcc", SysoplogLevel.normal.getValue(), true, null);
        }
        catch (Exception e) {
            logger.error((Object)("configBlackholeApi method error. " + e.getMessage()));
            this.systemOpeLog("atic.public.button.blackhole.api.configure", "lego.dic.module.AticBis", true, detailPara, "lego.err.570507", "atic.bis.blackhole.api.sp.ctcc", SysoplogLevel.normal.getValue(), false, null);
            this.responseResult(this.getText("lego.err.570507"));
        }
    }

    public void changeServiceProvider() {
        if (!"".equals(this.serviceProvider)) {
            this.configBlackholeApiForm = this.configBlackholeService.getConfigApi(this.serviceProvider);
            if ("".equals(this.configBlackholeApiForm.getDefendScope())) {
                this.configBlackholeApiForm.setDefendScope(ALL_NET);
            }
        }
        Integer enable = this.configBlackholeApiForm.getEnableStatus() == null ? Integer.valueOf(0) : this.configBlackholeApiForm.getEnableStatus();
        String urlStr = this.configBlackholeApiForm.getUrl() == null ? "" : this.configBlackholeApiForm.getUrl();
        String userNameStr = this.configBlackholeApiForm.getUserName() == null ? "" : this.configBlackholeApiForm.getUserName();
        String passWord = this.configBlackholeApiForm.getPassword() == null ? "" : this.configBlackholeApiForm.getPassword();
        Integer timeOut = this.configBlackholeApiForm.getUnblockTime() == null ? Integer.valueOf(0) : this.configBlackholeApiForm.getUnblockTime();
        String defaultScope = this.configBlackholeApiForm.getDefendScope() == null ? "" : this.configBlackholeApiForm.getDefendScope();
        String configContent = "[['" + enable + "'],['" + urlStr + "'],['" + userNameStr + "'],['" + passWord + "'],['" + timeOut + "'],['" + defaultScope + "']]";
        logger.info((Object)"changeServiceProvider configApiContent");
        this.responseResult(configContent);
    }

    public void testBlackHoleApiConfig() {
        String isp = "--";
        try {
            Map<String, String> map;
            StringBuffer pwd = new StringBuffer();
            if ("********".equals(this.password)) {
                ConfigBlackholeApiForm blackholeApiForm = this.configBlackholeService.getBlackHoleApiConfig();
                if (null != blackholeApiForm) {
                    pwd.append(blackholeApiForm.getPassword());
                }
            } else if (null != this.password) {
                pwd.append(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.password)));
            }
            if ("CTCC".equals(this.serviceProvider)) {
                this.serviceProvider = "DamDDoS";
                isp = "atic.bis.blackhole.api.sp.ctcc";
            }
            if (null != (map = this.configBlackholeService.testBlackHoleApiConfig(this.serviceProvider, this.url, new StringBuffer(this.userName), pwd, this.alias))) {
                this.systemOpeLog("atic.bis.blackhole.api.config.test.log", "lego.dic.module.AticBis", true, null, "atic.bis.blackhole.api.config.test.success", isp, SysoplogLevel.normal.getValue(), true, null);
                this.responseResult("success");
            } else {
                this.systemOpeLog("atic.bis.blackhole.api.config.test.log", "lego.dic.module.AticBis", true, null, "atic.bis.blackhole.api.config.test.failed", isp, SysoplogLevel.normal.getValue(), false, null);
                this.responseResult("failed");
            }
        }
        catch (LegoCheckedException e) {
            this.systemOpeLog("atic.bis.blackhole.api.config.test.log", "lego.dic.module.AticBis", true, null, "atic.bis.blackhole.api.config.test.failed", isp, SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            this.systemOpeLog("atic.bis.blackhole.api.config.test.log", "lego.dic.module.AticBis", true, null, "atic.bis.blackhole.api.config.test.failed", isp, SysoplogLevel.normal.getValue(), false, e);
            logger.error((Object)"testBlackHoleApiConfig error");
        }
    }

    private boolean validateParams(ConfigBlackholeApiForm form) {
        int enableStatusNum = form.getEnableStatus();
        if (enableStatusNum != 0 && enableStatusNum != 1) {
            return false;
        }
        String defendScope = form.getDefendScope();
        if (null == defendScope || defendScope.isEmpty() || !defendScope.matches("^(1|2|3|4)$")) {
            return false;
        }
        String paramUrl = form.getUrl();
        if (null == paramUrl) {
            return false;
        }
        int unblockTime = form.getUnblockTime();
        if (Integer.valueOf(unblockTime) < 5 || Integer.valueOf(unblockTime) > 1400) {
            return false;
        }
        return this.validateNameAndPwd(form);
    }

    private boolean validateNameAndPwd(ConfigBlackholeApiForm form) {
        String paramUserName = form.getUserName();
        if (null == paramUserName || paramUserName.isEmpty()) {
            return false;
        }
        if (paramUserName.length() > 64) {
            return false;
        }
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        if (!paramUserName.matches(regex)) {
            return false;
        }
        String pwd = form.getPassword();
        return AticUtil.isNullForVpn((String)pwd) || pwd.length() <= 64 && AticUtil.validatePwd((String)pwd);
    }

    public ConfigBlackholeApiForm getConfigBlackholeApiForm() {
        return this.configBlackholeApiForm;
    }

    public void setConfigBlackholeApiForm(ConfigBlackholeApiForm configBlackholeApiForm) {
        this.configBlackholeApiForm = configBlackholeApiForm;
    }

    public List<LangPair> getServiceProviderList() {
        return this.serviceProviderList;
    }

    public void setServiceProviderList(List<LangPair> serviceProviderList) {
        this.serviceProviderList = serviceProviderList;
    }

    public String getServiceProviderLabel() {
        return this.serviceProviderLabel;
    }

    public void setServiceProviderLabel(String serviceProviderLabel) {
        this.serviceProviderLabel = serviceProviderLabel;
    }

    public String getServiceProviderValue() {
        return this.serviceProviderValue;
    }

    public void setServiceProviderValue(String serviceProviderValue) {
        this.serviceProviderValue = serviceProviderValue;
    }

    public Integer getEnableStatus() {
        return this.enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(String serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public List<LangPair> getDefaultPolicyList() {
        return this.defaultPolicyList;
    }

    public void setDefaultPolicyList(List<LangPair> defaultPolicyList) {
        this.defaultPolicyList = defaultPolicyList;
    }

    public String getDefaultScopeLabel() {
        return this.defaultScopeLabel;
    }

    public void setDefaultScopeLabel(String defaultScopeLabel) {
        this.defaultScopeLabel = defaultScopeLabel;
    }

    public String getDefaultScopeValue() {
        return this.defaultScopeValue;
    }

    public void setDefaultScopeValue(String defaultScopeValue) {
        this.defaultScopeValue = defaultScopeValue;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean validateConfigBlackholeApiParameter() {
        ConfigBlackholeApiForm configBlackholeApiForms = this.getConfigBlackholeApiForm();
        configBlackholeApiForms.setEnableStatus(this.enableStatus);
        return this.validateParams(configBlackholeApiForms);
    }

    public boolean validateCertAlias(String certAlias) {
        if (AticUtil.isNull((String)certAlias)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(?!_)(?![0-9])[a-zA-Z_0-9]+$");
        Matcher matcher = pattern.matcher(certAlias);
        if (!matcher.matches()) {
            return false;
        }
        return certAlias.length() > 0 && certAlias.length() <= 128;
    }

    public boolean validateCertAliasListStr(String allCertAlias) {
        return AticUtil.isNull((String)allCertAlias);
    }

    public List<CertManagementForm> getAllCertList() {
        return this.allCertList;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

