/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.sdk.bis.form.ConfigBlackholeApiForm;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.service.IConfigBlackholeService;
import com.hs.atic.sdk.bis.service.IDivertBlackholeService;
import com.hs.atic.ui.model.RadioGroupVO;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.SessionInvalidException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;

public class BlackHoleDivertAction
extends BaseAction {
    public static final String BLACKHOLE_CREATE = "atic.bis.blackhole.divert.operation.create";
    public static final String BLACKHOLEAPI_CREATE = "atic.bis.blackhole.divert.operation.create.api";
    public static final String BLACKHOLE_CREATE_ENABLE = "atic.bis.blackhole.divert.operation.create.and.enable";
    public static final String BLACKHOLEAPI_CREATE_ENABLE = "atic.bis.blackhole.divert.operation.create.and.enable.api";
    public static final String BLACKHOLE_DELETE = "atic.bis.blackhole.divert.operation.delete";
    public static final String BLACKHOLEAPI_DELETE = "atic.bis.blackhole.divert.operation.delete.api";
    public static final String BLACKHOLE_ENABLE = "atic.bis.blackhole.divert.operation.enable";
    public static final String BLACKHOLEAPI_ENABLE = "atic.bis.blackhole.divert.operation.enable.api";
    public static final String BLACKHOLE_DISABLE = "atic.bis.blackhole.divert.operation.disable";
    public static final String BLACKHOLEAPI_DISABLE = "atic.bis.blackhole.divert.operation.disable.api";
    public static final String DISABLE = "atic.bis.blackhole.divert.disable";
    public static final String ENABLE = "atic.bis.blackhole.divert.enable";
    public static final String UNKNOWN = "atic.bis.blackhole.divert.unknown";
    static Comparator<AticDevice> comparator = new Comparator<AticDevice>(){

        @Override
        public int compare(AticDevice fw1, AticDevice fw2) {
            return fw1.getName().toLowerCase(Locale.ENGLISH).compareTo(fw2.getName().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = -549722260215615942L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    List<AticDevice> firewallList;
    private List<DivertBlackholeForm> blackHoleList = new ArrayList<DivertBlackholeForm>();
    private String sortType = null;
    private String sortField = null;
    private long deviceId = 0L;
    private String vpnName = null;
    private Long[] ids;
    private String[] names;
    private String ip = null;
    private String mask;
    private String deviceName = null;
    private boolean autoAvailble = false;
    private String nexthopIP = null;
    private List<LangPair> strListDeviceSearchComb;
    private transient IAticDeviceService aticDeviceService;
    private transient IDivertBlackholeService divertBlackholeService;
    private transient IConfigBlackholeService configBlackholeService;
    private transient ISysOptLog sysLogService;
    private Long zoneId;
    private String defDeviceName;
    private String defDeviceId;
    private String dynamicEnable;
    private String threshold;
    private String timeout;
    private List<RadioGroupVO> modeList;
    private DivertBlackholeForm divertBlackholeForm;
    private String serviceProviderLabel;
    private String serviceProviderValue;
    private List<LangPair> serviceProviderList;
    private Integer blackholeMode;
    private String serviceProvider;

    public String blackHoleDivertList() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.queryCommonReatime(map);
        }
        catch (Exception e) {
            this.blackHoleList = new ArrayList<DivertBlackholeForm>();
            this.total = 0;
            logger.error((Object)("blackHoleList:" + e.getMessage()));
        }
        finally {
            map.clear();
        }
        return "success";
    }

    private boolean checkMaxBlackHoleDivert() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("blackholeMode", "0,1");
        List<DivertBlackholeForm> forms = this.divertBlackholeService.getDivertByBlackHoleMode(map);
        if (forms.size() >= 10000) {
            logger.error((Object)("blackHoleDivert_list_num exceed 10000, blackHoleDivert_list_num=" + (forms.size() + 1)));
            return false;
        }
        return true;
    }

    private void queryCommonReatime(Map<String, String> map) {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        map.put("currentUserId", String.valueOf(currentUser.getUserID()));
        map.put("userName", currentUser.getUserName());
        map.put("currentUserIsAdmin", currentUser.getIsAdmin());
        if (null == this.sortType) {
            this.sortType = "desc";
            this.sortField = "createTime";
        }
        map.put("sortName", this.sortField);
        map.put("sortType", this.sortType);
        logger.info((Object)("queryCommonReatime" + this.start + this.pageSize));
        Paging paging1 = this.divertBlackholeService.queryByPage(map, this.start, this.pageSize);
        this.blackHoleList = paging1.getData();
        for (DivertBlackholeForm form : this.blackHoleList) {
            if (null == form.getBlackIP() || "--".equals(form.getBlackIP())) continue;
            form.setBlackIP(IPUtil4Atic.compressIP((String)form.getBlackIP()));
            if (!AticUtil.isNull((String)form.getVpn())) continue;
            form.setVpn("--");
        }
        this.total = paging1.getCount();
    }

    public String showCteatePage() {
        this.initRadioGroup();
        this.initDefaultValue();
        this.initDevicesComb();
        this.initServiceProviderList();
        return "success";
    }

    private void initRadioGroup() {
        this.modeList = new ArrayList<RadioGroupVO>();
        RadioGroupVO cleanDevice = new RadioGroupVO();
        cleanDevice.setKey(Integer.valueOf(0));
        cleanDevice.setLabel(this.getText("atic.bis.blackhole.route"));
        RadioGroupVO sp = new RadioGroupVO();
        sp.setKey(Integer.valueOf(1));
        sp.setLabel(this.getText("atic.bis.blackhole.api.tp"));
        RadioGroupVO intefaceBoard = new RadioGroupVO();
        intefaceBoard.setKey(Integer.valueOf(2));
        intefaceBoard.setLabel(this.getText("lego.fault.severity.rule.diversion.interfaceBoard.blackHole"));
        this.modeList.add(cleanDevice);
        this.modeList.add(sp);
        this.modeList.add(intefaceBoard);
    }

    private void initDefaultValue() {
        if (null == this.divertBlackholeForm) {
            this.divertBlackholeForm = new DivertBlackholeForm();
            this.divertBlackholeForm.setBlackholeMode(0);
        }
    }

    public void enableBlackholeDivert() {
        DivertBlackholeForm divertBlackholeFormAfter = null;
        String deviceIP = "--";
        Integer enableState = null;
        String divertStatus = "--";
        String blackMask = "--";
        String dirvertIp = "--";
        ArrayList<String> target = new ArrayList<String>();
        logger.info((Object)("enableBlackholeDivert ids.length:" + this.ids.length));
        List<BatchOperation> batchOpList = this.batchOperate();
        try {
            this.batchOperationResult = this.divertBlackholeService.startDivertBlackholes(batchOpList);
            List batchOpResult = this.batchOperationResult.getResult();
            for (BatchOperation result : batchOpResult) {
                String errorCode = "lego.err." + result.getErrorCode();
                divertBlackholeFormAfter = (DivertBlackholeForm)result.getExtTargetId();
                String vpn = "--";
                if (null != divertBlackholeFormAfter) {
                    enableState = divertBlackholeFormAfter.getEnableStatus();
                    divertStatus = this.getDivertStatus(enableState);
                    deviceIP = divertBlackholeFormAfter.getDeviceIP();
                    dirvertIp = divertBlackholeFormAfter.getBlackIP();
                    blackMask = divertBlackholeFormAfter.getBlackMask();
                    String string = vpn = AticUtil.isNull((String)divertBlackholeFormAfter.getVpn()) ? "--" : divertBlackholeFormAfter.getVpn();
                }
                if (result.getErrorCode() == 0L) {
                    String[] params = result.getTargetName().split(";");
                    target.clear();
                    target.add(params[1]);
                    target.add(vpn);
                    target.add(IPUtil.compressIPv6((String)dirvertIp));
                    target.add(params[4]);
                    String sp = params[3];
                    if ("CTCC".equals(sp)) {
                        sp = "atic.bis.blackhole.api.sp.ctcc";
                    }
                    target.add(sp);
                    String opertion = "--";
                    opertion = null != divertBlackholeFormAfter ? this.getEnableOperateName(divertBlackholeFormAfter.getBlackholeMode()) : ("--".equals(params[3]) ? BLACKHOLE_ENABLE : BLACKHOLEAPI_ENABLE);
                    this.successProcessOpeLog(deviceIP, target, opertion, divertStatus);
                } else {
                    String[] targetParams = result.getTargetName().split(";");
                    String param0 = targetParams[1];
                    String param1 = deviceIP;
                    String param2 = targetParams[2];
                    String param3 = targetParams[4];
                    String param4 = targetParams[3];
                    if ("CTCC".equals(param4)) {
                        param4 = "atic.bis.blackhole.api.sp.ctcc";
                    }
                    String param5 = "--";
                    param5 = null != divertBlackholeFormAfter ? this.getEnableOperateName(divertBlackholeFormAfter.getBlackholeMode()) : ("--".equals(param4) ? BLACKHOLE_ENABLE : BLACKHOLEAPI_ENABLE);
                    String param6 = divertStatus;
                    String param7 = errorCode;
                    String[] params = new String[]{param0, param1, vpn, param2, param3, param4, param5, param6, param7};
                    this.failedProcessOpeLog(params, result.getDetailParam());
                }
                String operationObject = IPUtil.compressIPv6((String)dirvertIp) + "/" + blackMask;
                Object[] failDetail = result.getDetailParam();
                boolean failResult = Arrays.toString(failDetail).contains("Error: Authentication fail\r\n\r\nUsername");
                if (failResult) {
                    failDetail = new String[]{"Error: Authentication fail"};
                    result.setDetailParam((String[])failDetail);
                }
                result.setTargetName(operationObject);
            }
            this.bathResult(this.batchOperationResult);
            this.responseResult("error");
        }
        catch (RuntimeException e) {
            this.systemOpeLog(BLACKHOLE_ENABLE, "lego.dic.module.AticBis", true, null, null, IPUtil.compressIPv6((String)dirvertIp), SysoplogLevel.normal.getValue(), false, e);
            throw e;
        }
        catch (Exception e) {
            this.systemOpeLog(BLACKHOLE_ENABLE, "lego.dic.module.AticBis", true, null, null, IPUtil.compressIPv6((String)dirvertIp), SysoplogLevel.normal.getValue(), false, e);
            throw e;
        }
    }

    private String getDivertStatus(Integer status) {
        String divertStatus = "";
        divertStatus = null == status ? UNKNOWN : (status == 0 ? DISABLE : (status == 1 ? ENABLE : UNKNOWN));
        return divertStatus;
    }

    private String getOperateName(boolean autoAvailbleBool, Integer blackHoleMode) {
        String operateName = BLACKHOLEAPI_CREATE;
        if (1 == blackHoleMode && autoAvailbleBool) {
            operateName = BLACKHOLEAPI_CREATE_ENABLE;
        }
        if (0 == blackHoleMode && !autoAvailbleBool) {
            operateName = BLACKHOLE_CREATE;
        }
        if (0 == blackHoleMode && autoAvailbleBool) {
            operateName = BLACKHOLE_CREATE_ENABLE;
        }
        if (2 == blackHoleMode && !autoAvailbleBool) {
            operateName = "atic.bis.blackhole.divert.operation.board.create";
        }
        if (2 == blackHoleMode && autoAvailbleBool) {
            operateName = "atic.bis.blackhole.divert.operation.board.create.and.enable";
        }
        return operateName;
    }

    private String getEnableOperateName(Integer blackHoleMode) {
        String operateName = BLACKHOLEAPI_ENABLE;
        if (0 == blackHoleMode) {
            operateName = BLACKHOLE_ENABLE;
        }
        if (2 == blackHoleMode) {
            operateName = "atic.bis.blackhole.divert.operation.board.enable";
        }
        return operateName;
    }

    private String getDisableOperateName(Integer blackHoleMode) {
        String operateName = BLACKHOLEAPI_DISABLE;
        if (0 == blackHoleMode) {
            operateName = BLACKHOLE_DISABLE;
        }
        if (2 == blackHoleMode) {
            operateName = "atic.bis.blackhole.divert.operation.board.disable";
        }
        return operateName;
    }

    private String getDeleteOperateName(Integer blackHoleMode) {
        String operateName = BLACKHOLEAPI_DELETE;
        if (0 == blackHoleMode) {
            operateName = BLACKHOLE_DELETE;
        }
        if (2 == blackHoleMode) {
            operateName = "atic.bis.blackhole.divert.operation.board.delete";
        }
        return operateName;
    }

    public void disableBlackholeDivert() {
        DivertBlackholeForm divertBlackholeFormAfter = null;
        String deviceIP = "--";
        Integer enableState = null;
        String divertStatus = "--";
        String blackMask = "--";
        String dirvertIp = "--";
        ArrayList<String> target = new ArrayList<String>();
        logger.info((Object)("disableBlackholeDivert ids.length:" + this.ids.length));
        try {
            List<BatchOperation> batchOpList = this.batchOperate();
            this.batchOperationResult = this.divertBlackholeService.stopDivertBlackholes(batchOpList);
            List batchOpResult = this.batchOperationResult.getResult();
            for (BatchOperation result : batchOpResult) {
                String errorCode = "lego.err." + result.getErrorCode();
                divertBlackholeFormAfter = (DivertBlackholeForm)result.getExtTargetId();
                String vpn = "--";
                if (null != divertBlackholeFormAfter) {
                    enableState = divertBlackholeFormAfter.getEnableStatus();
                    divertStatus = this.getDivertStatus(enableState);
                    deviceIP = divertBlackholeFormAfter.getDeviceIP();
                    blackMask = divertBlackholeFormAfter.getBlackMask();
                    dirvertIp = divertBlackholeFormAfter.getBlackIP();
                    String string = vpn = AticUtil.isNull((String)divertBlackholeFormAfter.getVpn()) ? "--" : divertBlackholeFormAfter.getVpn();
                }
                if (result.getErrorCode() == 0L) {
                    String[] params = result.getTargetName().split(";");
                    target.clear();
                    target.add(params[1]);
                    target.add(vpn);
                    target.add(IPUtil.compressIPv6((String)dirvertIp));
                    target.add(params[4]);
                    String isp = params[3];
                    if ("CTCC".equals(isp)) {
                        isp = "atic.bis.blackhole.api.sp.ctcc";
                    }
                    target.add(isp);
                    String opertion = "--";
                    opertion = null != divertBlackholeFormAfter ? this.getDisableOperateName(divertBlackholeFormAfter.getBlackholeMode()) : ("--".equals(params[3]) ? BLACKHOLE_DISABLE : BLACKHOLEAPI_DISABLE);
                    this.successProcessOpeLog(deviceIP, target, opertion, divertStatus);
                } else {
                    String[] targetParams = result.getTargetName().split(";");
                    String deviceNameStr = targetParams[1];
                    String iP = deviceIP;
                    String divertIP = targetParams[2];
                    String ipMask = targetParams[4];
                    String serviceProviderStr = targetParams[3];
                    if ("CTCC".equals(serviceProviderStr)) {
                        serviceProviderStr = "atic.bis.blackhole.api.sp.ctcc";
                    }
                    String operation = "--";
                    operation = null != divertBlackholeFormAfter ? this.getDisableOperateName(divertBlackholeFormAfter.getBlackholeMode()) : ("--".equals(serviceProviderStr) ? BLACKHOLE_DISABLE : BLACKHOLEAPI_DISABLE);
                    String status = divertStatus;
                    String error = errorCode;
                    String[] params = new String[]{deviceNameStr, iP, vpn, divertIP, ipMask, serviceProviderStr, operation, status, error};
                    this.failedProcessOpeLog(params, result.getDetailParam());
                }
                String operationObject = IPUtil.compressIPv6((String)dirvertIp) + "/" + blackMask;
                Object[] failDetail = result.getDetailParam();
                boolean failResult = Arrays.toString(failDetail).contains("Error: Authentication fail\r\n\r\nUsername");
                if (failResult) {
                    failDetail = new String[]{"Error: Authentication fail"};
                    result.setDetailParam((String[])failDetail);
                }
                result.setTargetName(operationObject);
            }
            this.bathResult(this.batchOperationResult);
            this.responseResult("error");
        }
        catch (RuntimeException e) {
            this.systemOpeLog(BLACKHOLE_DISABLE, "lego.dic.module.AticBis", true, null, null, IPUtil.compressIPv6((String)dirvertIp), SysoplogLevel.normal.getValue(), false, e);
            throw e;
        }
        catch (Exception e) {
            this.systemOpeLog(BLACKHOLE_DISABLE, "lego.dic.module.AticBis", true, null, null, IPUtil.compressIPv6((String)dirvertIp), SysoplogLevel.normal.getValue(), false, e);
            throw e;
        }
    }

    public void deleteBlackholeDivert() {
        DivertBlackholeForm divertBlackholeFormAfter = null;
        String deviceIP = "--";
        String blackMask = "--";
        String dirvertIp = "--";
        Integer enableState = null;
        String divertStatus = "--";
        String serviceProviderStr = "--";
        ArrayList<String> target = new ArrayList<String>();
        logger.info((Object)("deleteBlackholeDivert ids.length:" + this.ids.length));
        try {
            List<BatchOperation> batchOpList = this.batchOperate();
            this.batchOperationResult = this.divertBlackholeService.stopAndDeleteDivertBlackholes(batchOpList);
            List batchOpResult = this.batchOperationResult.getResult();
            for (BatchOperation result : batchOpResult) {
                String errorCode = "lego.err." + result.getErrorCode();
                divertBlackholeFormAfter = (DivertBlackholeForm)result.getExtTargetId();
                String vpn = "--";
                if (null != divertBlackholeFormAfter) {
                    enableState = divertBlackholeFormAfter.getEnableStatus();
                    divertStatus = this.getDivertStatus(enableState);
                    deviceIP = divertBlackholeFormAfter.getDeviceIP();
                    blackMask = divertBlackholeFormAfter.getBlackMask();
                    dirvertIp = divertBlackholeFormAfter.getBlackIP();
                    serviceProviderStr = divertBlackholeFormAfter.getServiceProvider();
                    if ("CTCC".equals(serviceProviderStr)) {
                        serviceProviderStr = "atic.bis.blackhole.api.sp.ctcc";
                    }
                    String string = vpn = AticUtil.isNull((String)divertBlackholeFormAfter.getVpn()) ? "--" : divertBlackholeFormAfter.getVpn();
                }
                if (result.getErrorCode() == 0L) {
                    String[] params = result.getTargetName().split(";");
                    target.clear();
                    target.add(params[1]);
                    target.add(vpn);
                    target.add(IPUtil.compressIPv6((String)dirvertIp));
                    target.add(blackMask);
                    target.add(serviceProviderStr);
                    String opertion = "--";
                    opertion = null != divertBlackholeFormAfter ? this.getDeleteOperateName(divertBlackholeFormAfter.getBlackholeMode()) : ("--".equals(serviceProviderStr) ? BLACKHOLE_DELETE : BLACKHOLEAPI_DELETE);
                    this.successProcessOpeLog(deviceIP, target, opertion, divertStatus);
                } else {
                    String[] targetParams = result.getTargetName().split(";");
                    String deviceNameStr = targetParams[1];
                    String iP = deviceIP;
                    String divertIPAdd = dirvertIp;
                    String ipMask = blackMask;
                    String sp = serviceProviderStr;
                    if (targetParams.length > 3) {
                        ipMask = targetParams[3];
                        sp = targetParams[4];
                        if ("CTCC".equals(serviceProviderStr)) {
                            serviceProviderStr = "atic.bis.blackhole.api.sp.ctcc";
                        }
                    }
                    String opertion = "--";
                    opertion = null != divertBlackholeFormAfter ? this.getDeleteOperateName(divertBlackholeFormAfter.getBlackholeMode()) : ("--".equals(serviceProviderStr) ? BLACKHOLE_DELETE : BLACKHOLEAPI_DELETE);
                    opertion = "--".equals(serviceProviderStr) ? BLACKHOLE_DELETE : BLACKHOLEAPI_DELETE;
                    opertion = "--".equals(serviceProviderStr) ? BLACKHOLE_DELETE : BLACKHOLEAPI_DELETE;
                    String status = divertStatus;
                    String error = errorCode;
                    String[] params = new String[]{deviceNameStr, iP, vpn, IPUtil.compressIPv6((String)divertIPAdd), ipMask, sp, opertion, status, error};
                    this.failedProcessOpeLog(params, result.getDetailParam());
                }
                String operationObject = IPUtil.compressIPv6((String)dirvertIp) + "/" + blackMask;
                Object[] failDetail = result.getDetailParam();
                boolean failResult = Arrays.toString(failDetail).contains("Error: Authentication fail\r\n\r\nUsername");
                if (failResult) {
                    failDetail = new String[]{"Error: Authentication fail"};
                    result.setDetailParam((String[])failDetail);
                }
                result.setTargetName(operationObject);
            }
            this.bathResult(this.batchOperationResult);
            this.responseResult("error");
        }
        catch (SessionInvalidException e) {
            this.systemOpeLog(BLACKHOLE_DELETE, "lego.dic.module.AticBis", true, null, null, IPUtil.compressIPv6((String)dirvertIp), SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            this.responseResult(e.getMessage());
        }
        catch (Exception e) {
            this.systemOpeLog(BLACKHOLE_DELETE, "lego.dic.module.AticBis", true, null, null, IPUtil.compressIPv6((String)dirvertIp), SysoplogLevel.normal.getValue(), false, e);
            throw e;
        }
    }

    public void createBlackholeDivert() {
        DivertBlackholeForm divertBlackholeForms = new DivertBlackholeForm();
        User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        AticDevice firewall = null;
        String deviceNameStr = "--";
        String deviceIp = "--";
        if (this.deviceId != 0L) {
            firewall = this.aticDeviceService.getDeviceByMoid(this.deviceId);
            if (null == firewall) {
                SysOptLog sysLog = new SysOptLog();
                sysLog.setLevel(SysoplogLevel.normal.getValue());
                sysLog.setOperation(this.getOperateName(this.autoAvailble, divertBlackholeForms.getBlackholeMode()));
                sysLog.setModule("lego.dic.module.AticBis");
                sysLog.setDate(new Date());
                sysLog.setTerminalIp(user.getIpAdr());
                sysLog.setOperator(user.getUserName());
                sysLog.setResult(0);
                sysLog.setDetail("atic.bis.blackhole.divert.operation.create.failed");
                sysLog.setTargetLocal(Boolean.valueOf(true));
                sysLog.setTarget(sysLog.getOperation());
                this.sysLogService.writeOptLog(sysLog);
                throw new LegoCheckedException(571811L);
            }
            ArrayList<Long> moIDList = new ArrayList<Long>();
            moIDList.add(this.deviceId);
            BisUtil.checkUserSecurity(moIDList);
            divertBlackholeForms.setDeviceId(this.deviceId);
            divertBlackholeForms.setDeviceName(deviceNameStr);
            divertBlackholeForms.setDeviceIP(firewall.getIpAddress());
            deviceNameStr = firewall.getName();
            deviceIp = firewall.getIpAddress();
        }
        this.validateIPMask();
        if (this.serviceProvider.equals("")) {
            this.serviceProvider = "--";
        }
        this.ip = IPUtil.compressIPv6((String)this.ip);
        divertBlackholeForms.setBlackholeMode(this.blackholeMode);
        divertBlackholeForms.setServiceProvider(this.serviceProvider);
        divertBlackholeForms.setBlackIP(this.ip);
        divertBlackholeForms.setBlackMask(this.mask);
        Integer enableState = null;
        String operateName = "--";
        String deviceIP = "--";
        String divertStatus = "--";
        if (AticUtil.isNull((String)this.vpnName)) {
            this.vpnName = "--";
        }
        divertBlackholeForms.setVpn(this.vpnName);
        ArrayList<String> targetName = new ArrayList<String>();
        deviceIP = divertBlackholeForms.getDeviceIP();
        operateName = this.getOperateName(this.autoAvailble, divertBlackholeForms.getBlackholeMode());
        String status = divertStatus;
        String errorCode = "--";
        String isp = divertBlackholeForms.getServiceProvider();
        if ("CTCC".equals(isp)) {
            isp = "atic.bis.blackhole.api.sp.ctcc";
        }
        targetName.add(deviceNameStr);
        targetName.add(deviceIP);
        targetName.add(this.vpnName);
        targetName.add(this.ip);
        targetName.add(divertBlackholeForms.getBlackMask());
        targetName.add(divertBlackholeForms.getServiceProvider());
        String opertion = operateName;
        targetName.add(opertion);
        targetName.add(status);
        targetName.add(errorCode);
        if (!this.checkMaxBlackHoleDivert()) {
            this.responseResult("574001");
            return;
        }
        try {
            DivertBlackholeForm retDivertBlackholeForm;
            if (this.autoAvailble) {
                retDivertBlackholeForm = this.divertBlackholeService.createAndDeployDivertBlackhole(divertBlackholeForms);
            } else {
                if (this.blackholeMode == 1) {
                    divertBlackholeForms.setBlackholeMode(1);
                    divertBlackholeForms.setServiceProvider(this.serviceProvider);
                } else if (this.blackholeMode == 0 || this.blackholeMode == 2) {
                    divertBlackholeForms.setServiceProvider("--");
                }
                retDivertBlackholeForm = this.divertBlackholeService.createDivertBlackhole(divertBlackholeForms);
            }
            if (null != retDivertBlackholeForm) {
                operateName = this.getOperateName(this.autoAvailble, divertBlackholeForms.getBlackholeMode());
                enableState = retDivertBlackholeForm.getEnableStatus();
                divertStatus = this.getDivertStatus(enableState);
                targetName.clear();
                targetName.add(deviceNameStr);
                targetName.add(this.vpnName);
                targetName.add(this.ip);
                targetName.add(divertBlackholeForms.getBlackMask());
                targetName.add(isp);
            }
            this.successProcessOpeLog(deviceIp, targetName, operateName, divertStatus);
        }
        catch (LegoCheckedException e) {
            enableState = divertBlackholeForms.getEnableStatus();
            divertStatus = this.getDivertStatus(enableState);
            deviceIP = divertBlackholeForms.getDeviceIP();
            String error = "lego.err." + e.getErrorCode();
            targetName.clear();
            operateName = this.getOperateName(this.autoAvailble, divertBlackholeForms.getBlackholeMode());
            targetName.add(deviceNameStr);
            if (!"--".equals(divertBlackholeForms.getServiceProvider())) {
                deviceIP = "--";
            }
            targetName.add(deviceIP);
            targetName.add(this.vpnName);
            targetName.add(this.ip);
            targetName.add(divertBlackholeForms.getBlackMask());
            targetName.add(isp);
            targetName.add(operateName);
            targetName.add(divertStatus);
            targetName.add(error);
            String[] params1 = targetName.toArray(new String[0]);
            this.failedProcessOpeLog(params1, e.getParameters());
            throw e;
        }
        catch (Exception e) {
            enableState = divertBlackholeForms.getEnableStatus();
            divertStatus = this.getDivertStatus(enableState);
            deviceIP = divertBlackholeForms.getDeviceIP();
            String error = "lego.err.102";
            targetName.clear();
            operateName = this.getOperateName(this.autoAvailble, divertBlackholeForms.getBlackholeMode());
            targetName.add(deviceNameStr);
            if (!"--".equals(divertBlackholeForms.getServiceProvider())) {
                deviceIP = "--";
            }
            targetName.add(deviceIP);
            targetName.add(this.vpnName);
            targetName.add(this.ip);
            targetName.add(divertBlackholeForms.getBlackMask());
            targetName.add(isp);
            targetName.add(operateName);
            targetName.add(divertStatus);
            targetName.add(error);
            String[] params1 = targetName.toArray(new String[0]);
            this.failedProcessOpeLog(params1, null);
            throw e;
        }
        this.responseResult("success");
    }

    public void getVpnListFromDB() {
        AticDevice firewall = null;
        List vpnList = new ArrayList();
        if (this.deviceId != 0L) {
            firewall = this.aticDeviceService.getDeviceByMoid(this.deviceId);
            if (null == firewall) {
                throw new LegoCheckedException(571811L);
            }
            ArrayList<Long> moIDList = new ArrayList<Long>();
            moIDList.add(this.deviceId);
            BisUtil.checkUserSecurity(moIDList);
            vpnList = this.aticDeviceService.getVpnListFromDB(firewall.getMoId());
        }
        String json = JSONUtil.getInstance().toJSON(vpnList);
        this.responseResult(json);
    }

    public boolean validateServiceProvider() {
        if (null != this.serviceProvider) {
            String regex = "^(|nothing|CTCC|BJCT|SHCT){1}$";
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher(this.serviceProvider).matches();
        }
        return false;
    }

    private void validateIPMask() {
        User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.blackhole.divert.create");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(user.getIpAdr());
        sysLog.setOperator(user.getUserName());
        sysLog.setResult(0);
        sysLog.setDetail("atic.bis.blackhole.divert.operation.create.failed");
        sysLog.setTarget(this.deviceName);
        if (this.blackholeMode == 1) {
            if ("nothing".equals(this.serviceProvider)) {
                logger.error((Object)"validate blackholeApi sp is null");
                this.sysLogService.writeOptLog(sysLog);
                throw new LegoCheckedException(572214L);
            }
            if ("CTCC".equals(this.serviceProvider) || "BJCT".equals(this.serviceProvider)) {
                if (!IPUtil.isIpv4((String)this.ip)) {
                    this.sysLogService.writeOptLog(sysLog);
                    throw new LegoCheckedException(572216L);
                }
                if (!BlackHoleDivertAction.isNumber(this.mask)) {
                    logger.error((Object)("validateIPMask IPV4 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                    this.sysLogService.writeOptLog(sysLog);
                    throw new LegoCheckedException(572212L);
                }
            } else if ("SHCT".equals(this.serviceProvider)) {
                if (IPUtil.isIpv4((String)this.ip) && !FilterUtil.isIpv4Mask((String)this.mask)) {
                    logger.error((Object)("validateIPMask IPV4 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                    this.sysLogService.writeOptLog(sysLog);
                    throw new LegoCheckedException(572215L);
                }
                if (!FilterUtil.isIpv6Mask((String)this.mask)) {
                    logger.error((Object)("validateIPMask IPV6 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                    this.sysLogService.writeOptLog(sysLog);
                    throw new LegoCheckedException(572211L);
                }
            }
        } else if (this.blackholeMode == 0) {
            if (!IPUtil.isIpv4((String)this.ip) && !IPUtil.isIpv6((String)this.ip)) {
                throw new LegoCheckedException(570505L);
            }
            if (IPUtil.isIpv4((String)this.ip)) {
                if (this.mask.length() >= 1 && this.mask.length() <= 2) {
                    if (!FilterUtil.isIpv4Mask((String)this.mask)) {
                        logger.error((Object)("validateIPMask IPV4 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                        this.sysLogService.writeOptLog(sysLog);
                        throw new LegoCheckedException(572210L);
                    }
                } else if (this.mask.length() > 2 && !BlackHoleDivertAction.isNetmask(this.mask)) {
                    logger.error((Object)("validateIPMask IPV4 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                    this.sysLogService.writeOptLog(sysLog);
                    throw new LegoCheckedException(572210L);
                }
            }
            if (IPUtil.isIpv6((String)this.ip) && !FilterUtil.isIpv6Mask((String)this.mask)) {
                logger.error((Object)("validateIPMask IPV6 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                this.sysLogService.writeOptLog(sysLog);
                throw new LegoCheckedException(572211L);
            }
        } else if (this.blackholeMode == 2) {
            if (!IPUtil.isIpv4((String)this.ip)) {
                this.sysLogService.writeOptLog(sysLog);
                throw new LegoCheckedException(572217L);
            }
            if (IPUtil.isIpv4((String)this.ip)) {
                if (this.mask.length() >= 1 && this.mask.length() <= 2) {
                    if (!FilterUtil.isIpv4Mask((String)this.mask)) {
                        logger.error((Object)("black hole validateIPv4Mask IPV4 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                        this.sysLogService.writeOptLog(sysLog);
                        throw new LegoCheckedException(572210L);
                    }
                } else if (this.mask.length() > 2 && !BlackHoleDivertAction.isNetmask(this.mask)) {
                    logger.error((Object)("black hole validateIPv4Mask IPV4 mask is " + AticUtil.getcleanedMessage((String)this.mask)));
                    this.sysLogService.writeOptLog(sysLog);
                    throw new LegoCheckedException(572210L);
                }
            }
        } else {
            logger.error((Object)("validateIPMask mask is " + AticUtil.getcleanedMessage((String)this.mask)));
            this.sysLogService.writeOptLog(sysLog);
            throw new LegoCheckedException(572213L);
        }
    }

    private static boolean isNetmask(String netmask) {
        String mask = "^(255|254|252|248|240|224|192|128|0)\\.0\\.0\\.0|255\\.(255|254|252|248|240|224|192|128|0)\\.0\\.0|255\\.255\\.(255|254|252|248|240|224|192|128|0)\\.0|255\\.255\\.255\\.(255|254|252|248|240|224|192|128|0)$";
        Pattern pattern = Pattern.compile(mask);
        Matcher matcher = pattern.matcher(netmask);
        return matcher.matches();
    }

    private static boolean isNumber(String mask) {
        String regex = "^32$";
        return !FilterUtil.isNull((String)mask) && mask.matches(regex);
    }

    public String simpleQuery() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (!(this.ip == null || this.ip.isEmpty() || IPUtil.isIpv4((String)this.ip) || IPUtil.isIpv6((String)this.ip))) {
            throw new LegoCheckedException(570505L);
        }
        if (AticUtil.isNull((String)this.ip)) {
            queryMap.put("blackIP", this.ip);
        } else {
            queryMap.put("blackIP", IPUtil.compressIPv6((String)this.ip));
        }
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
        queryMap.put("userName", currentUser.getUserName());
        queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        if (null == this.sortType) {
            this.sortType = "desc";
            this.sortField = "createTime";
        }
        queryMap.put("sortName", this.sortField);
        queryMap.put("sortType", this.sortType);
        Paging paging = this.divertBlackholeService.queryByPage(queryMap, this.start, this.pageSize);
        this.blackHoleList = paging.getData();
        if (!AticUtil.isNull((String)this.ip) && IPUtil.isIpv6((String)this.ip) && !IPUtil.compressIPv6((String)this.ip).equals(IPUtil.convert2CompleteIpV6AllZero((String)this.ip))) {
            queryMap.put("blackIP", IPUtil.convert2CompleteIpV6AllZero((String)this.ip));
            paging = this.divertBlackholeService.queryByPage(queryMap, this.start, this.pageSize);
            this.blackHoleList.addAll(paging.getData());
        }
        for (DivertBlackholeForm form : this.blackHoleList) {
            if (null == form.getBlackIP() || "--".equals(form.getBlackIP())) continue;
            form.setBlackIP(IPUtil4Atic.compressIP((String)form.getBlackIP()));
            if (!AticUtil.isNull((String)form.getVpn())) continue;
            form.setVpn("--");
        }
        this.total = paging.getCount();
        return "success";
    }

    private List<BatchOperation> batchOperate() {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            this.checkUltraVires(this.ids[i]);
            bo.setTargetId(this.ids[i].longValue());
            String filterTargetName = this.filterTargetName(this.names[i]);
            String[] keyAndValues = filterTargetName.split(";");
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < keyAndValues.length; ++j) {
                String[] keyAndValue = keyAndValues[j].split(":");
                if (j == keyAndValues.length - 1) {
                    buf.append(keyAndValue[1]);
                    continue;
                }
                buf.append(keyAndValue[1]);
                buf.append(';');
            }
            String values = buf.toString();
            bo.setTargetName(values);
            batchOpList.add(bo);
            logger.info((Object)("batch operate targetName = " + this.getcleanedMessage(bo.getTargetName())));
        }
        return batchOpList;
    }

    private void checkUltraVires(Long id) {
        DivertBlackholeForm divertBlackhole = this.divertBlackholeService.getDivertBlackholeById(id);
        Long deviceID = divertBlackhole.getDeviceId();
        ArrayList<Long> deviceList = new ArrayList<Long>();
        if (null != deviceID) {
            deviceList.add(deviceID);
        }
        BisUtil.checkUserSecurity(deviceList);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String filterTargetName(String targetName) {
        if (null == targetName) {
            return "";
        }
        return targetName;
    }

    private void initDevicesComb() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        ArrayList devicesList = this.aticDeviceService.getCleanDevice(currentUser.getUserID());
        if (null == devicesList) {
            devicesList = new ArrayList();
        }
        this.firewallList = devicesList;
        Collections.sort(this.firewallList, comparator);
        this.strListDeviceSearchComb = new ArrayList<LangPair>();
        if (null != this.firewallList && !this.firewallList.isEmpty()) {
            for (int i = 0; i < this.firewallList.size(); ++i) {
                AticDevice firewall = this.firewallList.get(i);
                if (null == firewall) continue;
                LangPair ld = new LangPair(firewall.getName(), String.valueOf(firewall.getMoId()));
                this.strListDeviceSearchComb.add(ld);
            }
        }
    }

    private void initServiceProviderList() {
        this.serviceProviderList = new ArrayList<LangPair>();
        List<ConfigBlackholeApiForm> configBlackholeApiForms = this.configBlackholeService.getServiceProvider();
        for (ConfigBlackholeApiForm configBlackholeApiForm : configBlackholeApiForms) {
            String serviceProviderStr = configBlackholeApiForm.getServiceProvider();
            if ("BJCT".equals(serviceProviderStr)) {
                this.serviceProviderList.add(new LangPair(this.getText("atic.bis.blackhole.api.sp.bjct"), "BJCT"));
                continue;
            }
            if ("SHCT".equals(serviceProviderStr)) {
                this.serviceProviderList.add(new LangPair(this.getText("atic.bis.blackhole.api.sp.shct"), "SHCT"));
                continue;
            }
            if (!"CTCC".equals(serviceProviderStr)) continue;
            this.serviceProviderList.add(new LangPair(this.getText("atic.bis.blackhole.api.sp.ctcc"), "CTCC"));
        }
    }

    private void successProcessOpeLog(String deviceIP, List<String> targetName, String operation, String enableState) {
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String operator = "";
        String terminalIp = "127.0.0.1";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            if (null == currentUser) {
                throw new SessionInvalidException("SEESION-INVALIDA");
            }
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget(targetName.get(2));
        sysOptLogLego.setResult(1);
        targetName.add(0, operation);
        targetName.add(2, deviceIP);
        targetName.add(enableState);
        sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.enable.success");
        String[] para = targetName.toArray(new String[0]);
        sysOptLogLego.setDetailPara(para);
        sysOptLogLego.setTerminalIp(terminalIp);
        this.sysLogService.writeOptLog(sysOptLogLego);
    }

    private void failedProcessOpeLog(String[] params, String[] exparams) {
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        String deviceNameStr = params[0];
        String deviceIP = params[1];
        String vpn = params[2];
        String divertIp = params[3];
        String ipMask = params[4];
        String serviceProviderStr = params[5];
        String operation = params[6];
        String enableState = params[7];
        String errorCode = params[8];
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget(divertIp);
        sysOptLogLego.setResult(0);
        String deviceResult = "";
        String[] para = new String[]{operation, deviceNameStr, deviceIP, vpn, divertIp, ipMask, serviceProviderStr, enableState, errorCode, deviceResult};
        sysOptLogLego.setDetailPara(para);
        sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.failed");
        sysOptLogLego.setTerminalIp(terminalIp);
        if (errorCode.equalsIgnoreCase("lego.err.571813")) {
            sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.cmd.failed");
            String cmdError = "-";
            if (exparams != null && exparams.length > 0 && exparams[0] != null && (cmdError = exparams[0].replaceAll("\r\n", " ")).contains("Error: Authentication fail  Username:")) {
                cmdError = "Error: Authentication fail";
            }
            para[8] = cmdError;
            sysOptLogLego.setDetailPara(para);
        }
        this.sysLogService.writeOptLog(sysOptLogLego);
    }

    public String getDynamicEnable() {
        return this.dynamicEnable;
    }

    public void setDynamicEnable(String dynamicEnable) {
        this.dynamicEnable = dynamicEnable;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public List<DivertBlackholeForm> getBlackHoleList() {
        return this.blackHoleList;
    }

    public void setBlackHoleList(List<DivertBlackholeForm> blackHoleList) {
        this.blackHoleList = blackHoleList;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public Long[] getIds() {
        if (null != this.ids) {
            return (Long[])this.ids.clone();
        }
        return new Long[0];
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public String[] getNames() {
        if (null != this.names) {
            return (String[])this.names.clone();
        }
        return new String[0];
    }

    public void setNames(String[] names) {
        this.names = null != names ? (String[])names.clone() : null;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public boolean isAutoAvailble() {
        return this.autoAvailble;
    }

    public void setAutoAvailble(boolean autoAvailble) {
        this.autoAvailble = autoAvailble;
    }

    public String getNexthopIP() {
        return this.nexthopIP;
    }

    public void setNexthopIP(String nexthopIP) {
        this.nexthopIP = nexthopIP;
    }

    public List<LangPair> getStrListDeviceSearchComb() {
        return this.strListDeviceSearchComb;
    }

    public void setStrListDeviceSearchComb(List<LangPair> strListDeviceSearchComb) {
        this.strListDeviceSearchComb = strListDeviceSearchComb;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public String getDefDeviceName() {
        return this.defDeviceName;
    }

    public void setDefDeviceName(String defDeviceName) {
        this.defDeviceName = defDeviceName;
    }

    public String getDefDeviceId() {
        return this.defDeviceId;
    }

    public void setDefDeviceId(String defDeviceId) {
        this.defDeviceId = defDeviceId;
    }

    public List<RadioGroupVO> getModeList() {
        return this.modeList;
    }

    public void setModeList(List<RadioGroupVO> modeList) {
        this.modeList = modeList;
    }

    public String getServiceProviderLabel() {
        return this.serviceProviderLabel;
    }

    public void setServiceProviderLabel(String serviceProviderLabel) {
        this.serviceProviderLabel = serviceProviderLabel;
    }

    public String getServiceProviderValue() {
        return this.serviceProviderValue;
    }

    public void setServiceProviderValue(String serviceProviderValue) {
        this.serviceProviderValue = serviceProviderValue;
    }

    public List<LangPair> getServiceProviderList() {
        return this.serviceProviderList;
    }

    public void setServiceProviderList(List<LangPair> serviceProviderList) {
        this.serviceProviderList = serviceProviderList;
    }

    public DivertBlackholeForm getDivertBlackholeForm() {
        return this.divertBlackholeForm;
    }

    public void setDivertBlackholeForm(DivertBlackholeForm divertBlackholeForm) {
        this.divertBlackholeForm = divertBlackholeForm;
    }

    public Integer getBlackholeMode() {
        return this.blackholeMode;
    }

    public void setBlackholeMode(Integer blackholeMode) {
        this.blackholeMode = blackholeMode;
    }

    public String getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(String serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public String getVpnName() {
        return this.vpnName;
    }

    public void setVpnName(String vpnName) {
        this.vpnName = vpnName;
    }

    public boolean validateIds() {
        if (null == this.ids) {
            return false;
        }
        if (this.ids.length > 100) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateIp() {
        if (AticUtil.isNullForVpn((String)this.ip)) {
            return true;
        }
        if (!IPUtil.isIpv4((String)this.ip) && !IPUtil.isIpv6((String)this.ip)) {
            return false;
        }
        return !this.ip.equals("0:0:0:0:0:0:0:0");
    }

    public boolean validateIpAndMask() {
        if (AticUtil.isNullForVpn((String)this.ip)) {
            return false;
        }
        if (!AticUtil.validateIpv4((String)this.ip) && !IPUtil.isIpv6((String)this.ip)) {
            return false;
        }
        return !this.ip.equals("0:0:0:0:0:0:0:0");
    }

    public boolean validateNames() {
        if (null != this.names) {
            if (this.names.length > 100) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                String nameRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|\\-|_|!|@|#|$|*|&|:|,|%|;|.|+|}|{|(|)]*$";
                if (null == this.names[i]) {
                    return false;
                }
                if (this.names[i].matches(nameRegex) && this.names[i].length() <= 256) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean validateDevicesName() {
        if (!AticUtil.isNullForVpn((String)this.deviceName)) {
            if (this.deviceName.equalsIgnoreCase("null")) {
                return false;
            }
            String nameRegex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            if (!this.deviceName.matches(nameRegex) || this.deviceName.length() > 32) {
                return false;
            }
        }
        return true;
    }

    public boolean validateIsExist() {
        if (null == this.blackholeMode || this.blackholeMode != 1 && this.blackholeMode != 0 && this.blackholeMode != 2) {
            return false;
        }
        if (this.blackholeMode == 1) {
            if (null == this.serviceProvider || "".equals(this.serviceProvider) || "nothing".equals(this.serviceProvider)) {
                return false;
            }
            if (null == this.ip || "".equals(this.ip)) {
                return false;
            }
            if (null == this.mask || "".equals(this.mask)) {
                return false;
            }
        } else {
            if (null == this.ip || "".equals(this.ip)) {
                return false;
            }
            if (null == this.mask || "".equals(this.mask)) {
                return false;
            }
            if (this.deviceId < 0L) {
                return false;
            }
            if (null == this.deviceName || "".equals(this.deviceName)) {
                return false;
            }
        }
        return true;
    }

    public void setDivertBlackholeService(IDivertBlackholeService divertBlackholeService) {
        this.divertBlackholeService = divertBlackholeService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public void setConfigBlackholeService(IConfigBlackholeService configBlackholeService) {
        this.configBlackholeService = configBlackholeService;
    }
}

