/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.bis.util.BisConstants;
import com.hs.atic.bis.util.BisDivertUtil;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.DivertTacticsQueryBean;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.bis.service.ISysQueryDetail;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.IpStateDataBuffer;
import com.hs.atic.util.MaskCombClass;
import com.hs.atic.util.SysQueryFactory;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.service.ZoneDeviceServiceImpl;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.flowspec.bgp.FlowSpecUtil;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.util.RadioBean;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpSession;

public class DivertTacticsAction
extends BaseAction {
    static Comparator<AticDevice> comparator = new Comparator<AticDevice>(){

        @Override
        public int compare(AticDevice fw1, AticDevice fw2) {
            return fw1.getName().toLowerCase(Locale.ENGLISH).compareTo(fw2.getName().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = -4274073939254636520L;
    private static final int NE_OFF_LINE = -1;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    String divertDetail;
    List<AticDevice> firewallList;
    private ISysOptLog sysLogService;
    private ILicenseOutboundService licenseOutboundService;
    private String nfaId;
    private List<DivertTacticsForm> divertTacticsFormList;
    private IDivertTacticsService divertTacticsService;
    private IZoneService zoneService;
    private AticDeviceServiceImpl aticDeviceService;
    private ZoneDeviceServiceImpl zoneDeviceService;
    private String sortField;
    private String sortType;
    private AticDevice firewall;
    private List<MaskCombClass> subNetMaskList;
    private MaskCombClass subNetMask;
    private DivertTacticsForm divertTacticsForm;
    private Long[] ids;
    private String[] names;
    private List<ZoneInfoForm> zoneFormList;
    private ZoneInfoForm zoneInfoForm;
    private DivertTacticsQueryBean queryBean;
    private String allQueryDisplay;
    private List<LangPair> modeCombData;
    private List<LangPair> statusCombData;
    private String source;
    private String showTaskType;
    private String selDev;
    private List<ZoneInfoForm> queryZoneFormList;
    private List<RadioBean> radioGroupList;
    private Long zoneId;
    private String ip;
    private Integer mask;
    private Integer maskBit;
    private Integer gridId;
    private Integer initRadioId;
    private StringBuffer submitToken = new StringBuffer();
    private String showDivertType;
    private String zoneName;
    private List<LangPair> strListDeviceSearchComb;
    private String defDeviceName;
    private String defDeviceId;
    private String creatStart;
    private String neId;
    private Long dashBoardZoneId;
    private Long dashBoardDeviceId;
    private String dashBoardDivertIp;
    private boolean supportOutbound = false;
    private boolean supportOutboundDivert = false;
    private boolean supportFlowSpec = false;
    private int direction;

    public void addDivertTactics() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        try {
            block11: {
                this.validatePermissions(this.divertTacticsForm.getZoneId(), this.divertTacticsForm.getDeviceId());
                this.processBeforeSave();
                if (AticUtil.isReSubmit((HttpSession)this.getSession(), (StringBuffer)this.submitToken)) {
                    return;
                }
                this.divertTacticsForm.setOperator(currentUser.getUserName());
                this.divertTacticsForm.setClientIp(currentUser.getIpAdr());
                if (!AticUtil.isNull((String)this.creatStart)) {
                    if ("true".equals(this.creatStart)) {
                        this.divertTacticsService.deployAndSaveDivertTactics(this.divertTacticsForm, 0, false);
                    } else {
                        try {
                            this.divertTacticsService.createDivertTactics(this.divertTacticsForm);
                        }
                        catch (LegoCheckedException e) {
                            if (e.getErrorCode() == 571205L) {
                                this.fillDivertLog(this.getTacticsLog(this.divertTacticsForm), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "no.device");
                                throw new LegoCheckedException(571205L);
                            }
                            if (e.getErrorCode() != 571204L) break block11;
                            this.fillDivertLog(this.getTacticsLog(this.divertTacticsForm), AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "ip.conflit");
                            throw new LegoCheckedException(571204L);
                        }
                    }
                }
            }
            LOG.info((Object)("deploy and save divert tactics : ip = " + this.divertTacticsForm.getDivertIp() + ", mask = " + this.divertTacticsForm.getMask() + " successfully."));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            sysLog.setDetail("atic.bis.divert.tactics.log.result.success");
            sysLog.setResult(1);
            sysLog.setTarget(this.divertTacticsForm.getDivertIp());
            this.sysLogService.writeOptLog(sysLog);
            this.responseResult("success");
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("LegoCheckedException addDivertTactics " + e.getMessage()));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            sysLog.setDetail("atic.bis.divert.tactics.title.add.failure");
            sysLog.setResult(0);
            sysLog.setTarget(this.divertTacticsForm.getDivertIp());
            this.sysLogService.writeOptLog(sysLog);
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("RuntimeException addDivertTactics " + e.getMessage()));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            sysLog.setDetail("atic.bis.divert.tactics.title.add.failure");
            sysLog.setResult(0);
            sysLog.setTarget(this.divertTacticsForm.getDivertIp());
            this.sysLogService.writeOptLog(sysLog);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception addDivertTactics " + e.getMessage()));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            sysLog.setDetail("atic.bis.divert.tactics.title.add.failure");
            sysLog.setResult(0);
            sysLog.setTarget(this.divertTacticsForm.getDivertIp());
            this.sysLogService.writeOptLog(sysLog);
            throw new LegoCheckedException(102L);
        }
    }

    public void fillDivertLog(DivertTacticsLogForm divertTacticsLogForm, int operType, int logLevel, int result, String remark) {
        if (null == divertTacticsLogForm) {
            return;
        }
        divertTacticsLogForm.setOperType(operType);
        divertTacticsLogForm.setLevel(logLevel);
        divertTacticsLogForm.setRemark(remark);
        divertTacticsLogForm.setResult(result);
        DivertTacticsLog divertTacticsLog = (DivertTacticsLog)AticUtil.copyProperties((Object)divertTacticsLogForm, (Object)new DivertTacticsLog());
        divertTacticsLog.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTacticsLog.getStartIp()));
        divertTacticsLog.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTacticsLog.getEndIp()));
        this.divertTacticsService.saveOrUpdateDivertTacticsLog(divertTacticsLog);
    }

    private DivertTacticsLogForm getTacticsLog(DivertTacticsForm divertTacticsForm) {
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        DivertTacticsLogForm divertTacticsLogForm = new DivertTacticsLogForm();
        divertTacticsLogForm.setZoneId(divertTactics.getZoneId());
        divertTacticsLogForm.setDeviceId(divertTactics.getDeviceId());
        divertTacticsLogForm.setOperator(divertTactics.getOperator());
        divertTacticsLogForm.setClientIp(divertTactics.getClientIp());
        String ipAddress = divertTactics.getDivertIp();
        if (ipAddress.contains("/")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("/"));
        }
        divertTacticsLogForm.setDivertIp(ipAddress);
        divertTactics.setDivertIp(ipAddress);
        String[] ipRange = IPUtil.getSubnetRange((String)ipAddress, (int)divertTactics.getMask());
        if (ipRange != null && ipRange.length == 2) {
            divertTacticsLogForm.setStartIp(ipRange[0]);
            divertTacticsLogForm.setEndIp(ipRange[1]);
        }
        if (!AticUtil.isNull((String)divertTactics.getVpnName())) {
            divertTacticsLogForm.setVpnName(divertTactics.getVpnName());
        } else {
            divertTacticsLogForm.setVpnName("--");
        }
        divertTacticsLogForm.setMask(divertTactics.getMask());
        divertTacticsLogForm.setLogTime(System.currentTimeMillis() / 1000L);
        divertTacticsLogForm.setDivertMode(divertTactics.getDivertMode());
        return divertTacticsLogForm;
    }

    public void batchAddDivertTactics() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        try {
            this.validatePermissions(this.zoneId, Long.parseLong(AticUtil.stringFilter((String)this.neId)));
            this.validateIdsAndNames();
            List<BatchOperation> batchOpList = this.batchOperateAdd();
            this.zoneId = null;
            Paging page = this.divertTacticsService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
            int diverTacticsListNum = page.getCount();
            if (10000 < diverTacticsListNum + batchOpList.size()) {
                LOG.error((Object)("diverTactics_list_num exceed 10000, diverTactics_list_num=" + diverTacticsListNum + batchOpList.size()));
                this.writeSysLog();
                this.responseResult("574001");
                return;
            }
            if (!AticUtil.isNull((String)this.creatStart)) {
                this.batchOperationResult = "true".equals(this.creatStart) ? this.divertTacticsService.batchAddDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr()) : this.divertTacticsService.batchCreateDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
            }
            LOG.info((Object)("batch deploy and save divert tactics . total =" + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            if (this.batchOperationResult.getSucceedCount() > 0) {
                sysLog.setResult(1);
            } else {
                sysLog.setResult(0);
            }
            List batchList = this.batchOperationResult.getResult();
            String target = "divert";
            for (BatchOperation b : batchList) {
                sysLog.setTarget(b.getTargetName());
                if (b.getErrorCode() == 0L) {
                    sysLog.setResult(1);
                    sysLog.setDetail("atic.bis.divert.tactics.log.result.success");
                    this.sysLogService.writeOptLog(sysLog);
                    continue;
                }
                sysLog.setResult(0);
                long errorCode = b.getErrorCode();
                sysLog.setDetail("lego.err." + errorCode);
                this.sysLogService.writeOptLog(sysLog);
            }
            sysLog.setTarget(target);
            this.bathResult(this.batchOperationResult);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("LegoCheckedException batchAddDivertTactics " + e.getMessage()));
            this.fillDivertLog(this.getTacticsLog(this.divertTacticsForm), AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 3, 0, "lego.err." + e.getErrorCode());
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("LegoCheckedException batchAddDivertTactics " + e.getMessage()));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            sysLog.setResult(0);
            sysLog.setDetail("atic.bis.divert.tactics.title.add.failure");
            this.sysLogService.writeOptLog(sysLog);
        }
        catch (Exception e) {
            LOG.error((Object)("LegoCheckedException batchAddDivertTactics " + e.getMessage()));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("atic.bis.divert.tactics.title.add");
            sysLog.setModule("lego.dic.module.AticBis");
            sysLog.setDate(new Date());
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            sysLog.setResult(0);
            sysLog.setDetail("atic.bis.divert.tactics.title.add.failure");
            this.sysLogService.writeOptLog(sysLog);
        }
    }

    private void validatePermissions(Long zoneId, Long deviceId) {
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (null == zoneId || 0L == zoneId) {
            LOG.error((Object)"Zone does not exist: zone Id is invalid.");
            throw new LegoCheckedException(570505L);
        }
        moIDList.add(ZoneBisUtil.getMoidByZoneid((Long)zoneId));
        if (null == deviceId || 0L == deviceId) {
            LOG.error((Object)"Device does not exist: device Id is invalid.");
            throw new LegoCheckedException(570505L);
        }
        moIDList.add(deviceId);
        BisUtil.checkUserSecurity(moIDList);
    }

    public void writeSysLog() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.title.add");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(currentUser.getIpAdr());
        sysLog.setOperator(currentUser.getUserName());
        sysLog.setResult(0);
        sysLog.setTarget("com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title");
        sysLog.setTargetLocal(Boolean.valueOf(true));
        sysLog.setDetail("com.hs.vsm.secservice.ddos.policy.divert.max.num");
        this.sysLogService.writeOptLog(sysLog);
    }

    private List<BatchOperation> batchOperate() {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            bo.setTargetName(this.filterTargetName(this.names[i]));
            batchOpList.add(bo);
            LOG.info((Object)("batch operate targetName = " + this.getcleanedMessage(bo.getTargetName())));
        }
        return batchOpList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<BatchOperation> batchOperateAdd() {
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        Long moId = ZoneBisUtil.getMoidByZoneid((Long)this.zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        Long zId = this.zoneId;
        Long dId = null;
        if (null != this.neId) {
            dId = Long.parseLong(AticUtil.stringFilter((String)this.neId));
        }
        String vpnString = "";
        if (null != zId && null != dId) {
            Boolean isExistZoneBoundNe;
            ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zId, dId);
            if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                vpnString = zoneDeviceForm.getVpnName();
            }
            if (!(isExistZoneBoundNe = this.zoneService.isExistConn(zId, dId)).booleanValue()) {
                LOG.error((Object)"This Zone is not bound to any NEs.");
                throw new LegoCheckedException(571213L);
            }
        }
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            String data = this.names[i];
            String[] ipA = data.split(";");
            String targetName = "Device:" + this.filterTargetName(ipA[1]) + ",IP:" + ipA[2] + ",Mask:" + ipA[3];
            bo.setTargetName(targetName);
            bo.setExtTargetId((Object)this.prepareData(data, zId, vpnString));
            batchOpList.add(bo);
            LOG.info((Object)("batch operate Add Divert targetName = " + this.getcleanedMessage(bo.getTargetName())));
        }
        return batchOpList;
    }

    public Map<String, String> createQueryMap() {
        ZoneInfoForm zoneInfo;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.sortField && null != this.sortType) {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        } else {
            queryMap.put("sortName", "createTime");
            queryMap.put("sortType", "desc");
        }
        if (null != this.queryBean) {
            String divertIp;
            queryMap.put("deviceId", null == this.queryBean.getDeviceId() ? null : this.queryBean.getDeviceId().toString());
            queryMap.put("zoneId", String.valueOf(this.queryBean.getZoneId()));
            zoneInfo = this.zoneService.getById(this.queryBean.getZoneId());
            if (null != zoneInfo) {
                this.queryBean.setZoneDesc(zoneInfo.getZoneDesc());
            }
            String string = divertIp = this.queryBean.getDivertIp() == null ? null : IPUtil4Atic.convert2CompleteIp((String)this.queryBean.getDivertIp());
            if (!AticUtil.isNull((String)divertIp)) {
                queryMap.put("divertIp", divertIp);
            }
            queryMap.put("startTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getStartTime())));
            queryMap.put("endTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getEndTime())));
            queryMap.put("divertMode", this.queryBean.getDivertMode());
            queryMap.put("divertStatus", this.queryBean.getDivertStatus());
            queryMap.put("detail", this.queryBean.getDetail());
        } else {
            this.processDashBoardDivert(queryMap);
            if (null != this.zoneId) {
                if (null == this.queryBean) {
                    this.queryBean = new DivertTacticsQueryBean();
                }
                this.queryBean.setZoneId(this.zoneId);
                queryMap.put("zoneId", String.valueOf(this.queryBean.getZoneId()));
                zoneInfo = this.zoneService.getById(this.queryBean.getZoneId());
                if (null != zoneInfo) {
                    this.queryBean.setZoneDesc(zoneInfo.getZoneDesc());
                }
            }
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private void processDashBoardDivert(Map<String, String> queryMap) {
        if (null != this.dashBoardZoneId) {
            if (null == this.queryBean) {
                this.queryBean = new DivertTacticsQueryBean();
            }
            this.queryBean.setZoneId(this.dashBoardZoneId);
            queryMap.put("zoneId", String.valueOf(this.queryBean.getZoneId()));
            ZoneInfoForm zoneInfo = this.zoneService.getById(this.queryBean.getZoneId());
            if (null != zoneInfo) {
                this.queryBean.setZoneDesc(zoneInfo.getZoneDesc());
            }
        }
        if (null != this.dashBoardDeviceId) {
            if (null == this.queryBean) {
                this.queryBean = new DivertTacticsQueryBean();
            }
            this.queryBean.setDeviceId(this.dashBoardDeviceId);
            queryMap.put("deviceId", String.valueOf(this.dashBoardDeviceId));
        }
        if (null != this.dashBoardDivertIp) {
            if (null == this.queryBean) {
                this.queryBean = new DivertTacticsQueryBean();
            }
            this.queryBean.setDivertIp(this.dashBoardDivertIp);
            queryMap.put("divertIp", this.dashBoardDivertIp);
        }
    }

    public void deleteDivertTactics() {
        this.validateIdsAndNames();
        List<BatchOperation> batchOpList = this.batchOperate();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.batchOperationResult = this.divertTacticsService.deleteDivertTactics(batchOpList, false, currentUser.getUserName(), currentUser.getIpAdr());
        LOG.info((Object)("delete divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
        this.systemOpeLogBatch("atic.bis.divert.tactics.operate.type.delete", "lego.dic.module.AticBis", true, 1, batchOpList);
        this.bathResult(this.batchOperationResult);
    }

    public void deleteAllDivertTactics() {
        Long[] divertIds = new Long[]{0L};
        Set<Long> devIds = this.divertTacticsService.getDevIdsByDivertIds(divertIds);
        if (null == devIds) {
            this.bathResult(new BatchOperationResult());
        }
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != devIds) {
            ArrayList<Long> deviceList = new ArrayList<Long>(devIds);
            BisUtil.checkUserSecurity(deviceList);
            for (Long devId : devIds) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(devId.longValue());
                batchOpList.add(bo);
                LOG.info((Object)("batch operate device id = " + bo.getTargetId()));
            }
        }
        IpStateDataBuffer.getInstance().clearAllDivertList();
        this.batchOperationResult = this.divertTacticsService.deleteAllDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
        LOG.info((Object)("delete all divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
        this.systemOpeLog("atic.bis.divert.tactics.operate.type.delete.all", "lego.dic.module.AticBis", true, new String[0], "atic.bis.divert.tactics.log.result.success", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.info.getValue(), true, null);
        this.bathResult(this.batchOperationResult);
    }

    private void fillDivertDetail(List<DivertTacticsForm> divertList) {
        ISysQueryDetail sysQuery = (ISysQueryDetail)SysQueryFactory.getInstance().getThirdServiceByName("ISysQueryDetail");
        if (null != sysQuery) {
            for (DivertTacticsForm each : divertList) {
                if (null != each.getZoneId() && each.getNfaId() != 0L) {
                    String detail = sysQuery.queryNfaDetailById(each.getNfaId());
                    each.setDetail(detail);
                    continue;
                }
                each.setDetail("--");
            }
        }
        for (DivertTacticsForm each : divertList) {
            each.setDivertIp(IPUtil4Atic.compressIP((String)each.getDivertIp()));
        }
    }

    private String filterTargetName(String targetName) {
        if (null == targetName) {
            return "";
        }
        return targetName;
    }

    public String getAllQueryDisplay() {
        return this.allQueryDisplay;
    }

    public void getBitByMask() {
        this.responseResult(this.mask.toString());
    }

    public String getCreatStart() {
        return this.creatStart;
    }

    public String getDefDeviceId() {
        return this.defDeviceId;
    }

    public String getDefDeviceName() {
        return this.defDeviceName;
    }

    public DivertTacticsForm getDivertTacticsForm() {
        return this.divertTacticsForm;
    }

    public List<DivertTacticsForm> getDivertTacticsFormList() {
        return this.divertTacticsFormList;
    }

    public AticDevice getFirewall() {
        return this.firewall;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public Integer getGridId() {
        return this.gridId;
    }

    public Integer getInitRadioId() {
        return this.initRadioId;
    }

    public String getIp() {
        return this.ip;
    }

    public void getIpByZoneId() {
        if (null != this.zoneId) {
            Long moId = ZoneBisUtil.getMoidByZoneid((Long)this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
        }
        this.zoneInfoForm = this.zoneService.getById(this.zoneId);
        if (null == this.zoneInfoForm) {
            LOG.warn((Object)("view zone. zone : " + this.zoneId + "has not been existed."));
            throw new LegoCheckedException(570609L);
        }
        List zifList = this.zoneInfoForm.getZoneIpFormList();
        StringBuffer json = new StringBuffer("{data : [");
        if (null != zifList) {
            for (ZoneIpForm zoneIpForm : zifList) {
                json.append('{').append("ip : \"").append(zoneIpForm.getZoneIp()).append('\"').append(',').append("mask : \"").append(zoneIpForm.getMask()).append('\"').append("},");
            }
        } else {
            LOG.error((Object)"convertToJson: parameter zoneInfoFormList is null");
        }
        json.append("]}");
        LOG.info((Object)("zone ip json : " + json));
        this.responseResult(json.toString());
    }

    public Integer getMask() {
        return this.mask;
    }

    public Integer getMaskBit() {
        return this.maskBit;
    }

    public List<LangPair> getModeCombData() {
        return this.modeCombData;
    }

    public String getNeId() {
        return this.neId;
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    public DivertTacticsQueryBean getQueryBean() {
        return this.queryBean;
    }

    public List<ZoneInfoForm> getQueryZoneFormList() {
        return this.queryZoneFormList;
    }

    public List<RadioBean> getRadioGroupList() {
        return this.radioGroupList;
    }

    public String getSelDev() {
        return this.selDev;
    }

    public String getShowDivertType() {
        return this.showDivertType;
    }

    public String getShowTaskType() {
        return this.showTaskType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public String getSource() {
        return this.source;
    }

    public List<LangPair> getStatusCombData() {
        return this.statusCombData;
    }

    public List<LangPair> getStrListDeviceSearchComb() {
        return this.strListDeviceSearchComb;
    }

    public String getSubmitToken() {
        return this.submitToken.toString();
    }

    public MaskCombClass getSubNetMask() {
        return this.subNetMask;
    }

    public List<MaskCombClass> getSubNetMaskList() {
        return this.subNetMaskList;
    }

    public String getZoneByDevId() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.selDev = this.selDev.split(",")[0];
        this.source = this.source.split(",")[0];
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        if ("0".equals(this.selDev)) {
            Paging page = this.zoneService.getPageDeployZoneInfo(queryMap, this.getStart(), this.getPageSize());
            this.queryZoneFormList = page.getData();
            this.setTotal(page.getCount());
            this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
            this.getSession().setAttribute("start", (Object)this.getStart());
            this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
            this.getSession().setAttribute("sortField", (Object)this.sortField);
            this.getSession().setAttribute("sortType", (Object)this.sortType);
        } else {
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.selDev));
            BisUtil.checkUserSecurity(deviceList);
            queryMap.put("deviceId", AticUtil.stringFilter((String)this.selDev));
            Paging page = this.zoneService.getPageDeployZoneInfo(queryMap, this.getStart(), this.getPageSize());
            this.queryZoneFormList = page.getData();
            this.setTotal(page.getCount());
            this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
            this.getSession().setAttribute("start", (Object)this.getStart());
            this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
            this.getSession().setAttribute("sortField", (Object)this.sortField);
            this.getSession().setAttribute("sortType", (Object)this.sortType);
        }
        return "list";
    }

    public boolean validateSelDev() {
        if (AticUtil.isNullForVpn((String)this.selDev)) {
            return true;
        }
        String testSelDev = this.selDev.split(",")[0];
        try {
            if (Long.parseLong(testSelDev) >= 0L) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Integer format is error");
            return false;
        }
        return false;
    }

    public boolean validateSource() {
        if (null != this.source) {
            String sourceRegex = "^(pcap|divert|addpcap|zoneTaskReport|zoneReport|[a-zA-Z0-9]+)$";
            String testSource = this.source.split(",")[0];
            if (!testSource.matches(sourceRegex)) {
                return false;
            }
        }
        return true;
    }

    public List<ZoneInfoForm> getZoneFormList() {
        return this.zoneFormList;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public ZoneInfoForm getZoneInfoForm() {
        return this.zoneInfoForm;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    private void initDevicesComb(boolean isQuery) {
        this.inputFirewallList();
        this.strListDeviceSearchComb = new ArrayList<LangPair>();
        if (isQuery) {
            LangPair ld = new LangPair("", this.getText("atic.bis.packet.task.all"));
            this.strListDeviceSearchComb.add(ld);
        }
        if (null != this.firewallList && !this.firewallList.isEmpty()) {
            Collections.sort(this.firewallList, comparator);
            for (int i = 0; i < this.firewallList.size(); ++i) {
                AticDevice fireWall = this.firewallList.get(i);
                if (null == fireWall) continue;
                if (i == 0) {
                    this.defDeviceId = String.valueOf(fireWall.getMoId());
                    this.defDeviceName = fireWall.getName();
                }
                LangPair ld = new LangPair(String.valueOf(fireWall.getMoId()), fireWall.getName());
                this.strListDeviceSearchComb.add(ld);
            }
        }
        this.allQueryDisplay = this.getText("atic.public.query.all");
    }

    private void inputFirewallList() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        ArrayList<AticDevice> devicesList = this.aticDeviceService.getCleanDevice(currentUser.getUserID());
        if (null == this.firewallList) {
            this.firewallList = new ArrayList<AticDevice>();
        }
        if (null == devicesList) {
            devicesList = new ArrayList<AticDevice>();
        }
        if ("policy".equals(this.showDivertType)) {
            List zoneDeviceForms = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(this.zoneId);
            HashSet<Long> deviceIds = new HashSet<Long>();
            if (null != zoneDeviceForms) {
                for (ZoneDeviceForm form : zoneDeviceForms) {
                    deviceIds.add(form.getDeviceId());
                }
            }
            for (AticDevice fireWall : devicesList) {
                if (!deviceIds.contains(fireWall.getMoId())) continue;
                this.firewallList.add(fireWall);
            }
        } else {
            this.firewallList = devicesList;
        }
    }

    private void initDivertTypeRadioGroup() {
        this.radioGroupList = new ArrayList<RadioBean>();
        RadioBean appointIpRadio = new RadioBean();
        appointIpRadio.setKey(Integer.valueOf(1));
        appointIpRadio.setLabel(this.getText("atic.bis.divert.input.choose"));
        this.radioGroupList.add(appointIpRadio);
        RadioBean zoneIpRadio = new RadioBean();
        zoneIpRadio.setKey(Integer.valueOf(2));
        zoneIpRadio.setLabel(this.getText("atic.bis.divert.input.manual"));
        this.radioGroupList.add(zoneIpRadio);
        this.initRadioId = 1;
    }

    private void initQueryBean() {
        if (null != this.queryBean) {
            AticDevice fireWall;
            if (!AticUtil.isNull((String)this.queryBean.getDivertMode())) {
                Map<Integer, String> divertModeMap = BisDivertUtil.getDivertModeMap();
                this.queryBean.setDivertModeName(divertModeMap.get(Integer.valueOf(this.queryBean.getDivertMode())));
            }
            if (!AticUtil.isNull((String)this.queryBean.getDivertStatus())) {
                Map<Integer, String> divertStateMap = BisDivertUtil.getDivertStateMap();
                this.queryBean.setDivertStatusName(divertStateMap.get(Integer.valueOf(this.queryBean.getDivertStatus())));
            }
            if (null != this.queryBean.getDeviceId() && null != (fireWall = this.aticDeviceService.getDeviceByMoid(this.queryBean.getDeviceId().longValue()))) {
                this.queryBean.setDeviceName(fireWall.getName());
            }
        }
    }

    public void isDevOnLine() {
        if (null != this.ids) {
            Set<Long> devIds = this.divertTacticsService.getDevIdsByDivertIds(this.ids);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.addAll(devIds);
            BisUtil.checkUserSecurity(moIdList);
            if (!devIds.isEmpty()) {
                StringBuffer offLineDevNames = new StringBuffer();
                for (Long each : devIds) {
                    AticDevice ne = this.aticDeviceService.getDeviceByMoid(each.longValue());
                    if (this.aticDeviceService.getStatusByMoid(each.longValue()) != -1) continue;
                    offLineDevNames.append(ne.getName());
                    offLineDevNames.append(',');
                }
                if (offLineDevNames.length() > 0) {
                    String result = offLineDevNames.toString().substring(0, offLineDevNames.length() - 1).trim();
                    this.responseResult(this.htmlEncodeCore(result));
                } else {
                    this.responseResult("success");
                }
            } else {
                this.responseResult("success");
            }
        }
    }

    private void isExist(DivertTacticsForm divertTacticsForms) {
        if (this.divertTacticsService.isExist(divertTacticsForms)) {
            LOG.error((Object)"the divert tactics has been existed!");
            throw new LegoCheckedException(571204L);
        }
    }

    public String listDivertTactics() {
        if (null != this.zoneId) {
            Long moId = ZoneBisUtil.getMoidByZoneid((Long)this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
        }
        Paging page = this.divertTacticsService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.divertTacticsFormList = page.getData();
        this.fillDivertDetail(this.divertTacticsFormList);
        this.setZoneNameAndDeviceName(this.divertTacticsFormList);
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.initDevicesComb(true);
        this.modeCombData = BisDivertUtil.getDivertModeCombData();
        this.statusCombData = BisDivertUtil.getDivertStatusCombData();
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (null != this.queryBean && null != this.queryBean.getZoneId() && 0L != this.queryBean.getZoneId()) {
            moIDList.add(ZoneBisUtil.getMoidByZoneid((Long)this.queryBean.getZoneId()));
        }
        if (null != this.queryBean && null != this.queryBean.getDeviceId() && 0L != this.queryBean.getDeviceId()) {
            moIDList.add(this.queryBean.getDeviceId());
        }
        BisUtil.checkUserSecurity(moIDList);
        this.initQueryBean();
        LOG.info((Object)("query divert tactics list, size = " + this.divertTacticsFormList.size()));
        this.allQueryDisplay = this.getText("atic.public.query.all");
        if ("policy".equals(this.showDivertType)) {
            return "listforpolicy";
        }
        return "list";
    }

    private DivertTacticsForm prepareData(String data, Long zoneID, String vpnName) {
        DivertTacticsForm divertForm = new DivertTacticsForm();
        String[] ipA = data.split(";");
        Long deviceId = Long.parseLong(AticUtil.stringFilter((String)ipA[0]));
        String deviceName = ipA[1];
        String ipAddress = ipA[2];
        String ipMask = ipA[3];
        divertForm.setDivertIp(ipAddress);
        divertForm.setMask(Integer.valueOf(Integer.parseInt(ipMask)));
        divertForm.setDeviceId(deviceId);
        divertForm.setDeviceName(deviceName);
        divertForm.setZoneId(zoneID);
        divertForm.setVpnName(vpnName);
        if (ipAddress.contains("/")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("/"));
        }
        String[] rangeIps = IPUtil.getSubnetRange((String)ipAddress, (int)Integer.parseInt(ipMask));
        divertForm.setStartIp(rangeIps[0]);
        divertForm.setEndIp(rangeIps[1]);
        divertForm.setCreateTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L));
        divertForm.setDivertMode(Integer.valueOf(2));
        return divertForm;
    }

    private void processBeforeSave() {
        this.validateAndFillParams();
        this.isExist(this.divertTacticsForm);
    }

    public String queryAllZone() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        if (this.direction == 1) {
            this.selDev = this.selDev.split(",")[0];
            if (Integer.parseInt(this.selDev) > 0) {
                ArrayList<Long> deviceList = new ArrayList<Long>();
                deviceList.add(Long.valueOf(this.selDev));
                BisUtil.checkUserSecurity(deviceList);
            }
            queryMap.put("deviceId", AticUtil.stringFilter((String)this.selDev));
        }
        Paging page = this.zoneService.getConnectZoneInfo(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        return "list";
    }

    public String queryConnectZoneByDevId() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        if (AticUtil.isNull((String)this.selDev)) {
            return "list";
        }
        this.selDev = this.selDev.split(",")[0];
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        if (null == this.selDev || this.selDev.isEmpty()) {
            return "list";
        }
        if (Integer.parseInt(this.selDev) > 0) {
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.selDev));
            BisUtil.checkUserSecurity(deviceList);
        }
        queryMap.put("deviceId", AticUtil.stringFilter((String)this.selDev));
        Paging page = this.zoneService.getConnectZoneInfo(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        return "list";
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public void setCreatStart(String creatStart) {
        this.creatStart = creatStart;
    }

    public void setDefDeviceId(String defDeviceId) {
        this.defDeviceId = defDeviceId;
    }

    public void setDefDeviceName(String defDeviceName) {
        this.defDeviceName = defDeviceName;
    }

    public void setDivertTacticsForm(DivertTacticsForm divertTacticsForm) {
        this.divertTacticsForm = divertTacticsForm;
    }

    public void setDivertTacticsFormList(List<DivertTacticsForm> divertTacticsFormList) {
        this.divertTacticsFormList = divertTacticsFormList;
    }

    public void setFirewall(AticDevice firewall) {
        this.firewall = firewall;
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public void setGridId(Integer gridId) {
        this.gridId = gridId;
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public void setInitRadioId(Integer initRadioId) {
        this.initRadioId = initRadioId;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setMask(Integer mask) {
        this.mask = mask;
    }

    public void setMaskBit(Integer maskBit) {
        this.maskBit = maskBit;
    }

    public void setModeCombData(List<LangPair> modeCombData) {
        this.modeCombData = modeCombData;
    }

    public void setNames(String[] names) {
        this.names = null != names ? (String[])names.clone() : null;
    }

    public void setNeId(String neId) {
        this.neId = neId;
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public void setQueryBean(DivertTacticsQueryBean queryBean) {
        this.queryBean = queryBean;
    }

    public void setQueryZoneFormList(List<ZoneInfoForm> queryZoneFormList) {
        this.queryZoneFormList = queryZoneFormList;
    }

    public void setRadioGroupList(List<RadioBean> radioGroupList) {
        this.radioGroupList = radioGroupList;
    }

    public void setSelDev(String selDev) {
        this.selDev = selDev;
    }

    public void setShowDivertType(String showDivertType) {
        this.showDivertType = showDivertType;
    }

    public void setShowTaskType(String showTaskType) {
        this.showTaskType = showTaskType;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setStatusCombData(List<LangPair> statusCombData) {
        this.statusCombData = statusCombData;
    }

    public void setStrListDeviceSearchComb(List<LangPair> strListDeviceSearchComb) {
        this.strListDeviceSearchComb = strListDeviceSearchComb;
    }

    public void setSubmitToken(String submitToken) {
        this.submitToken = new StringBuffer(submitToken);
    }

    public void setSubNetMask(MaskCombClass subNetMask) {
        this.subNetMask = subNetMask;
    }

    public void setSubNetMaskList(List<MaskCombClass> subNetMaskList) {
        this.subNetMaskList = subNetMaskList;
    }

    public void setZoneFormList(List<ZoneInfoForm> zoneFormList) {
        this.zoneFormList = zoneFormList;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public void setZoneInfoForm(ZoneInfoForm zoneInfoForm) {
        this.zoneInfoForm = zoneInfoForm;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    private void setZoneNameAndDeviceName(List<DivertTacticsForm> divertTacticsFormLists) {
        HashMap<Long, String> firewallMap = new HashMap<Long, String>();
        HashMap<Long, String> zoneMap = new HashMap<Long, String>();
        for (DivertTacticsForm divertTacticsForms : divertTacticsFormLists) {
            if (null == divertTacticsForms.getDeviceId() || null == divertTacticsForms.getZoneId()) continue;
            if (firewallMap.containsKey(divertTacticsForms.getDeviceId())) {
                divertTacticsForms.setDeviceName((String)firewallMap.get(divertTacticsForms.getDeviceId()));
            } else {
                AticDevice fireWall = this.aticDeviceService.getDeviceByMoid(divertTacticsForms.getDeviceId().longValue());
                if (null != fireWall) {
                    divertTacticsForms.setDeviceName(fireWall.getName());
                    firewallMap.put(divertTacticsForms.getDeviceId(), fireWall.getName());
                }
            }
            if (BisConstants.ADD_DIVERT_ZONE_ID.equals(divertTacticsForms.getZoneId())) {
                divertTacticsForms.setZoneDesc("--");
                continue;
            }
            if (zoneMap.containsKey(divertTacticsForms.getZoneId())) {
                divertTacticsForms.setZoneDesc((String)zoneMap.get(divertTacticsForms.getZoneId()));
                continue;
            }
            ZoneInfoForm zoneInfoForms = this.zoneService.getZoneNOIpById(divertTacticsForms.getZoneId());
            if (null == zoneInfoForms) continue;
            divertTacticsForms.setZoneDesc("".equals(zoneInfoForms.getZoneDesc()) ? null : zoneInfoForms.getZoneDesc());
            zoneMap.put(divertTacticsForms.getZoneId(), zoneInfoForms.getZoneDesc());
        }
    }

    public String showAddDivertTactics() {
        LOG.info((Object)"prepare to add divert tactics");
        this.initDevicesComb(false);
        this.initDivertTypeRadioGroup();
        this.submitToken = new StringBuffer(UUID.randomUUID().toString());
        if ("policy".equals(this.showDivertType)) {
            if (null != this.zoneId) {
                Long moId = ZoneBisUtil.getMoidByZoneid((Long)this.zoneId);
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(moId);
                BisUtil.checkUserSecurity(moIdList);
                ZoneInfoForm zoneInfo = this.zoneService.getById(this.zoneId);
                if (null != zoneInfo) {
                    this.zoneName = zoneInfo.getZoneDesc();
                }
            }
            return "addforpolicy";
        }
        return "add";
    }

    public String showDivertPanel() {
        this.supportOutbound = this.licenseOutboundService.isSupportOutbound();
        this.supportOutbound = true;
        this.fetchRequest().setAttribute("supportOutbound", (Object)String.valueOf(this.supportOutbound));
        this.supportOutboundDivert = this.licenseOutboundService.isSupportOutboundDivert();
        this.supportOutboundDivert = true;
        this.fetchRequest().setAttribute("supportOutboundDivert", (Object)String.valueOf(this.supportOutboundDivert));
        this.supportFlowSpec = FlowSpecUtil.isSupportFlowSpec();
        this.fetchRequest().setAttribute("supportFlowSpec", (Object)String.valueOf(this.supportFlowSpec));
        if ("policy".equals(this.showDivertType)) {
            return "listforpolicy";
        }
        return "list";
    }

    public String showSplitIp() {
        LOG.info((Object)"prepare to show split ip");
        if (null != this.showDivertType && "policy".equals(this.showDivertType)) {
            return "addforpolicy";
        }
        return "add";
    }

    public void splitIpByMask() {
        List splitIpList = new ArrayList();
        Integer splitMask = null;
        if (null != this.ip && null != this.mask && null != this.maskBit) {
            if (this.ip.contains("/")) {
                this.ip = this.ip.split("/")[0];
            }
            LOG.info((Object)("prepare to split ip .ipAddress = " + this.ip + " ,mask = " + this.mask + " , maskBit = " + this.maskBit));
            Integer maskLength = this.mask;
            if (this.maskBit > maskLength + 8 || this.maskBit <= maskLength) {
                this.responseResult("failure");
                return;
            }
            splitMask = this.maskBit;
            splitIpList = IPUtil.spiltNetworkSegmentByMask((String)(this.ip + "/" + this.mask), (int)this.maskBit);
        } else {
            LOG.error((Object)"ip or mask or maskDigit is null");
        }
        LOG.info((Object)("get Subnet mask = " + splitMask + " by Mask Length = " + this.maskBit));
        StringBuffer json = new StringBuffer("{data : [");
        if (null != splitIpList) {
            for (String splitIpTemp : splitIpList) {
                String splitIp = splitIpTemp;
                if (splitIp.contains("/")) {
                    splitIp = splitIp.split("/")[0];
                }
                json.append('{').append("ip : \"").append(splitIp).append('\"').append(',').append("mask : \"").append(splitMask).append('\"').append("},");
            }
        } else {
            LOG.error((Object)"convertToJson: parameter splitIpList is null");
        }
        json.append("]}");
        LOG.info((Object)("split ip json : " + json));
        this.responseResult(json.toString());
    }

    public void startDivertTactics() {
        try {
            this.validateIdsAndNames();
            List<BatchOperation> batchOpList = this.batchOperate();
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            this.batchOperationResult = this.divertTacticsService.startDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
            LOG.info((Object)("start divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
            this.systemOpeLogBatch("atic.bis.divert.tactics.operate.type.start", "lego.dic.module.AticBis", true, SysoplogLevel.info.getValue(), batchOpList);
            this.bathResult(this.batchOperationResult);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("LegoCheckedException startDivertTactics " + e.getMessage()));
            String[] detailPara = new String[]{};
            String[] para = e.getParameters();
            if (null != para && para.length > 0) {
                detailPara = para;
            }
            this.systemOpeLog("atic.bis.divert.tactics.operate.type.start", "lego.dic.module.AticBis", true, detailPara, "atic.bis.divert.tactics.log.result.fail", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("LegoCheckedException startDivertTactics " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.operate.type.start", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.normal.getValue(), false, e);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            LOG.error((Object)("LegoCheckedException startDivertTactics " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.operate.type.start", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.normal.getValue(), false, e);
            throw new LegoCheckedException(102L);
        }
    }

    private void checkUltraVires(Long id) {
        DivertTacticsForm divertTactics = this.divertTacticsService.getDivertPolicy(id);
        Long deviceId = divertTactics.getDeviceId();
        Long zoneID = divertTactics.getZoneId();
        if (null != zoneID) {
            Long moId = ZoneBisUtil.getMoidByZoneid((Long)zoneID);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
        }
        if (null != deviceId) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(deviceId);
            BisUtil.checkUserSecurity(moIdList);
        }
    }

    private void checkSecurity(Long nfaID) {
        DivertTacticsForm diverForm = this.divertTacticsService.getDivertPolicy(nfaID);
        Long deviceId = diverForm.getDeviceId();
        Long zoneID = diverForm.getZoneId();
        Long moId = ZoneBisUtil.getMoidByZoneid((Long)zoneID);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        if (0L != moId) {
            moIdList.add(moId);
        }
        BisUtil.checkUserSecurity(moIdList);
        ArrayList<Long> deviceList = new ArrayList<Long>();
        if (null != deviceId) {
            deviceList.add(deviceId);
        }
        BisUtil.checkUserSecurity(deviceList);
    }

    public void stopDivertTactics() {
        try {
            this.validateIdsAndNames();
            List<BatchOperation> batchOpList = this.batchOperate();
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            this.batchOperationResult = this.divertTacticsService.stopDivertTactics(batchOpList, currentUser.getUserName(), currentUser.getIpAdr());
            LOG.info((Object)("stop divert tactics result. total = " + this.batchOperationResult.getTotalCount() + ", success = " + this.batchOperationResult.getSucceedCount() + ", fail = " + this.batchOperationResult.getFailCount()));
            this.systemOpeLogBatch("atic.bis.divert.tactics.operate.type.stop", "lego.dic.module.AticBis", true, SysoplogLevel.info.getValue(), batchOpList);
            this.bathResult(this.batchOperationResult);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("LegoCheckedException stopDivertTactics " + e.getMessage()));
            String[] detailPara = new String[]{};
            String[] para = e.getParameters();
            if (null != para && para.length > 0) {
                detailPara = para;
            }
            this.systemOpeLog("atic.bis.divert.tactics.operate.type.stop", "lego.dic.module.AticBis", true, detailPara, "atic.bis.divert.tactics.log.result.fail", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("LegoCheckedException stopDivertTactics " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.operate.type.stop", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.normal.getValue(), false, e);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            LOG.error((Object)("LegoCheckedException stopDivertTactics " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.operate.type.stop", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "com.hs.vsm.secservice.ddos.policy.action.trafficDivert.title", SysoplogLevel.normal.getValue(), false, e);
            throw new LegoCheckedException(102L);
        }
    }

    private void validateAndFillParams() {
        if (null == this.divertTacticsForm || null == this.divertTacticsForm.getDeviceId() || AticUtil.isNull((String)this.divertTacticsForm.getDivertIp()) || this.divertTacticsForm.getMask() == null || null == this.divertTacticsForm.getZoneId()) {
            LOG.error((Object)"params errors");
            throw new LegoCheckedException(570505L);
        }
        String ipAddress = this.divertTacticsForm.getDivertIp();
        Integer ipMask = this.divertTacticsForm.getMask();
        String[] rangeIps = IPUtil.getSubnetRange((String)ipAddress, (int)ipMask);
        this.divertTacticsForm.setDivertIp(rangeIps[0]);
        this.divertTacticsForm.setStartIp(rangeIps[0]);
        this.divertTacticsForm.setEndIp(rangeIps[1]);
        this.divertTacticsForm.setCreateTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L));
        this.divertTacticsForm.setDivertMode(Integer.valueOf(2));
        LOG.info((Object)("prepare to add divert tactics : startIp = " + rangeIps[0] + ", endIp = " + rangeIps[1]));
        Boolean isExistZoneBoundNe = this.zoneService.isExistConn(this.divertTacticsForm.getZoneId(), this.divertTacticsForm.getDeviceId());
        if (!isExistZoneBoundNe.booleanValue()) {
            LOG.error((Object)"This Zone is not bound to any NEs.");
            throw new LegoCheckedException(571213L);
        }
    }

    private boolean validateContain(List<ZoneIpForm> zoneIps, String startIp, String endIp) {
        if (zoneIps == null) {
            return false;
        }
        for (ZoneIpForm ipForm : zoneIps) {
            String[] rangeIps = IPUtil.getSubnetRange((String)ipForm.getZoneIp(), (int)ipForm.getMask());
            String startIpExist = rangeIps[0];
            String endIpExist = rangeIps[1];
            if (IPUtil4Atic.convert2CompleteIp((String)startIp).compareTo(IPUtil4Atic.convert2CompleteIp((String)startIpExist)) < 0 || IPUtil4Atic.convert2CompleteIp((String)endIp).compareTo(IPUtil4Atic.convert2CompleteIp((String)endIpExist)) > 0) continue;
            return true;
        }
        return false;
    }

    private void validateIdsAndNames() {
        for (Long id : this.ids) {
            this.checkUltraVires(id);
        }
    }

    public void validateIp() {
        if (null != this.zoneId && !AticUtil.isNull((String)this.ip) && this.mask != null) {
            Long moId = ZoneBisUtil.getMoidByZoneid((Long)this.zoneId);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
            Boolean isDefaultZone = this.zoneService.isDefaultZone(this.zoneId.longValue());
            String[] rangeIps = IPUtil.getSubnetRange((String)this.ip, (int)this.mask);
            String startIp = rangeIps[0];
            String endIp = rangeIps[1];
            if (!isDefaultZone.booleanValue()) {
                List zIpList = this.zoneService.findIpByZoneId(this.zoneId);
                if (this.validateContain(zIpList, startIp, endIp)) {
                    this.responseResult("success");
                } else {
                    this.responseResult("notzone");
                }
            } else {
                this.responseResult("success");
            }
        }
    }

    public String viewDivertDetail() {
        this.checkSecurity(Long.valueOf(this.nfaId));
        ISysQueryDetail sysQuery = (ISysQueryDetail)SysQueryFactory.getInstance().getThirdServiceByName("ISysQueryDetail");
        if (sysQuery != null) {
            this.divertDetail = sysQuery.queryNfaDetailById(Long.parseLong(this.nfaId));
        } else {
            LOG.error((Object)"service SysQueryDetail is null");
        }
        return "success";
    }

    public String getNfaId() {
        return this.nfaId;
    }

    public void setNfaId(String nfaId) {
        this.nfaId = nfaId;
    }

    public String getDivertDetail() {
        return this.divertDetail;
    }

    public void setDivertDetail(String divertDetail) {
        this.divertDetail = divertDetail;
    }

    public Long getDashBoardZoneId() {
        return this.dashBoardZoneId;
    }

    public void setDashBoardZoneId(Long dashBoardZoneId) {
        this.dashBoardZoneId = dashBoardZoneId;
    }

    public Long getDashBoardDeviceId() {
        return this.dashBoardDeviceId;
    }

    public void setDashBoardDeviceId(Long dashBoardDeviceId) {
        this.dashBoardDeviceId = dashBoardDeviceId;
    }

    public String getDashBoardDivertIp() {
        return this.dashBoardDivertIp;
    }

    public void setDashBoardDivertIp(String dashBoardDivertIp) {
        this.dashBoardDivertIp = dashBoardDivertIp;
    }

    public boolean validateZoneId() {
        if (null == this.zoneId) {
            return true;
        }
        return this.zoneId >= 0L;
    }

    public boolean validateIds() {
        if (null == this.ids) {
            return false;
        }
        if (this.ids.length > 256) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateQueryBeanZoneId() {
        if (null != this.queryBean) {
            if (null == this.queryBean.getZoneId()) {
                return true;
            }
            if (this.queryBean.getZoneId() < 0L) {
                return false;
            }
        }
        return true;
    }

    public boolean validateQueryBeanDeviceId() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getDeviceId()) {
            return true;
        }
        return this.queryBean.getDeviceId() >= 0L;
    }

    public boolean validateQueryBeanDivertIp() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getDivertIp()) || IPUtil.isIpv4((String)this.queryBean.getDivertIp()) || IPUtil.isIpv6((String)this.queryBean.getDivertIp());
    }

    public boolean validateQueryBeanStartTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getStartTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getStartTime());
    }

    public boolean validateQueryBeanEndTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getEndTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getEndTime());
    }

    public boolean validateQueryBeanDeviceName() {
        if (null == this.queryBean) {
            return true;
        }
        if (AticUtil.isNullForVpn((String)this.queryBean.getDeviceName())) {
            return true;
        }
        if (this.queryBean.getDeviceName().length() > 32) {
            return false;
        }
        if (this.queryBean.getDeviceName().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return this.queryBean.getDeviceName().matches(nameRegex);
    }

    public boolean validateQueryBeanZoneDesc() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getZoneDesc() || "".equals(this.queryBean.getZoneDesc().trim())) {
            return true;
        }
        if (this.queryBean.getZoneDesc().length() > 64) {
            return false;
        }
        if (this.queryBean.getZoneDesc().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
        return this.queryBean.getZoneDesc().matches(nameRegex);
    }

    public boolean validateQueryBeanDetail() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getDetail() || "".equals(this.queryBean.getDetail().trim())) {
            return true;
        }
        if (this.queryBean.getDetail().length() > 64) {
            return false;
        }
        if (this.queryBean.getDetail().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!\\s*null$)(?![\\s\\S]*[\\s]+null$)(?!\\s*null\\s{1}[\\s\\S]*$)(?![\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\\u4e00-\\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-]*$";
        return this.queryBean.getDetail().matches(nameRegex);
    }

    public boolean validataZoneName() {
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            String nameRegex = "^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
            if (!this.zoneInfoForm.getZoneName().matches(nameRegex) || this.zoneInfoForm.getZoneName().length() > 32) {
                return false;
            }
        }
        return true;
    }

    public boolean validateSplitIpByMask() {
        if (AticUtil.isNull((String)this.ip) || null == this.mask) {
            return false;
        }
        if (AticUtil.validateIpv4((String)this.ip) && this.mask > 0 && this.mask <= 32) {
            return true;
        }
        return IPUtil.isIpv6((String)this.ip) && this.mask > 0 && this.mask <= 128;
    }

    public boolean validateNames() {
        if (null != this.names) {
            if (this.names.length > 256) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                String nameRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|\\-|_|!|@|#|$|*|&|:|,|%|;|.|+|}|{|(|)]*$";
                if (null == this.names[i]) {
                    return false;
                }
                if (this.names[i].matches(nameRegex) && this.names[i].length() <= 256) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean validateOnLineNames() {
        if (null != this.names) {
            if (this.names.length > 100) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                String nameRegex = "^[\\w|\\s|\u4e00-\u9fa5|=|\\-|_|!|@|#|$|*|&|:|,|%|;|.|+|}|{|(|)]*$";
                if (null == this.names[i]) {
                    return false;
                }
                if (this.names[i].matches(nameRegex) && this.names[i].length() <= 256) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateHomePageDivertTactics(String idStr) {
        String dashBoardId = this.fetchRequest().getParameter(idStr);
        if (!AticUtil.isNullForVpn((String)dashBoardId)) {
            try {
                if (Long.parseLong(dashBoardId) < 0L) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Integer format is error");
                return false;
            }
        }
        return true;
    }

    public boolean validateDashBoardDivertIp() {
        return AticUtil.isNullForVpn((String)this.dashBoardDivertIp) || AticUtil.validateIpv4((String)this.dashBoardDivertIp) || IPUtil.isIpv6((String)this.dashBoardDivertIp);
    }

    public boolean checkIpAndMask() {
        if (AticUtil.isNull((String)this.ip) || null == this.mask) {
            return false;
        }
        try {
            IPUtil.getSubnetRange((String)this.ip, (int)this.mask);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (LegoCheckedException e) {
            return false;
        }
        return true;
    }

    public boolean validateDivertTacticsForm() {
        if (null != this.divertTacticsForm && !AticUtil.isNullForVpn((String)this.divertTacticsForm.getDivertIpAndMask())) {
            String[] ipTemp = this.divertTacticsForm.getDivertIpAndMask().split("/");
            if (ipTemp.length != 2) {
                return false;
            }
            try {
                IPUtil.getSubnetRange((String)ipTemp[0], (int)Integer.parseInt(ipTemp[1]));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Integer format is error");
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (LegoCheckedException e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateDivertTacticsFormDeviceName() {
        if (null != this.divertTacticsForm && !AticUtil.isNullForVpn((String)this.divertTacticsForm.getDeviceName())) {
            if (this.divertTacticsForm.getDeviceName().length() > 32) {
                return false;
            }
            if (this.divertTacticsForm.getDeviceName().trim().equalsIgnoreCase("null")) {
                return false;
            }
            String nameRegex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            if (!this.divertTacticsForm.getDeviceName().matches(nameRegex)) {
                return false;
            }
        }
        return true;
    }

    public boolean isSupportOutbound() {
        return this.supportOutbound;
    }

    public void setSupportOutbound(boolean supportOutbound) {
        this.supportOutbound = supportOutbound;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void setAticDeviceService(AticDeviceServiceImpl aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public void setZoneDeviceService(ZoneDeviceServiceImpl zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

