/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.bis.util.BisDivertUtil;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.DivertTacticsQueryBean;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsLogService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.user.util.LoginMgrUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.io.FileUtils;

public class DivertTacticsLogAction
extends BaseAction {
    static Comparator<AticDevice> comparator = new Comparator<AticDevice>(){

        @Override
        public int compare(AticDevice o1, AticDevice o2) {
            return o1.getName().toLowerCase(Locale.ENGLISH).compareTo(o2.getName().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = -703739437386447818L;
    private String divertLogRemark;
    private String logId;
    private List<DivertTacticsLogForm> divertTacticsLogFormList;
    private IDivertTacticsLogService divertTacticsLog;
    private IZoneService zoneService;
    private AticDeviceServiceImpl aticDeviceService;
    private List<AticDevice> firewallList;
    private String sortField;
    private String sortType;
    private DivertTacticsQueryBean queryBean;
    private AticDevice firewall;
    private Integer exportStart;
    private Integer exportEnd;
    private String allQueryDisplay;
    private List<LangPair> modeCombData;
    private List<LangPair> logLevelCombData;
    private ZoneInfoForm zoneInfoForm;
    private List<ZoneInfoForm> queryZoneFormList;
    private String downFileName;
    private String idStr;
    private String isQuery = "false";
    private int direction;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);

    public String listDivertTacticsLog() {
        if (!(null == this.queryBean || null == this.queryBean.getDivertIp() || this.queryBean.getDivertIp().isEmpty() || IPUtil.isIpv4((String)this.queryBean.getDivertIp()) || IPUtil.isIpv6((String)this.queryBean.getDivertIp()))) {
            this.logger.error((Object)"queryBean divertIp format is error!");
            return null;
        }
        Paging page = this.divertTacticsLog.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.divertTacticsLogFormList = page.getData();
        this.processRemark(this.divertTacticsLogFormList);
        this.initDevicesComb();
        this.modeCombData = BisDivertUtil.getDivertModeCombData();
        this.logLevelCombData = BisDivertUtil.getDivertLogCombData();
        if (null != this.queryBean) {
            ArrayList<Long> moIDList = new ArrayList<Long>();
            if (null != this.queryBean.getZoneId() && 0L != this.queryBean.getZoneId()) {
                moIDList.add(ZoneBisUtil.getMoidByZoneid((Long)this.queryBean.getZoneId()));
            }
            if (null != this.queryBean.getDeviceId() && 0L != this.queryBean.getDeviceId()) {
                moIDList.add(this.queryBean.getDeviceId());
            }
            BisUtil.checkUserSecurity(moIDList);
            this.isQuery = "true";
        } else {
            this.isQuery = "false";
        }
        this.setZoneNameAndDeviceNameForLog(this.divertTacticsLogFormList);
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("queryBean", (Object)this.queryBean);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        this.logger.info((Object)("query divert tactics log. size = " + this.divertTacticsLogFormList.size()));
        this.allQueryDisplay = this.getText("atic.public.query.all");
        return "list";
    }

    private void processRemark(List<DivertTacticsLogForm> divertTacticsLogFormLists) {
        for (DivertTacticsLogForm divertTacticsLogForm : divertTacticsLogFormLists) {
            divertTacticsLogForm.setDivertIp(IPUtil4Atic.compressIP((String)divertTacticsLogForm.getDivertIp()));
            String remark = divertTacticsLogForm.getRemark();
            if (AticUtil.isNull((String)remark)) continue;
            if (remark.contains(".") && !remark.contains(":") && !remark.contains(" ")) {
                divertTacticsLogForm.setRemark(this.getText("atic.bis.divert.tactics.log.remark." + remark));
                continue;
            }
            if (!remark.matches("[0-9]+")) continue;
            divertTacticsLogForm.setRemark(this.getText("lego.err." + remark));
        }
    }

    public String showExportDivertTacticsLog() {
        this.logger.info((Object)"prepare to export divert tactics log");
        this.queryBean = (DivertTacticsQueryBean)this.getSession().getAttribute("queryBean");
        this.setTotal((Integer)this.getSession().getAttribute("total"));
        this.sortField = (String)this.getSession().getAttribute("sortField");
        this.sortType = (String)this.getSession().getAttribute("sortType");
        return "export";
    }

    public void exportDivertTacticsLog() {
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.exportDivert)) {
            throw new LegoCheckedException(570516L);
        }
        try {
            String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
            if (!this.createFile(downloadPath)) {
                return;
            }
            Long dateTime = System.currentTimeMillis();
            String fileNameTmp = "divertLog_" + dateTime + ".xls";
            downloadPath = downloadPath + File.separator + fileNameTmp;
            if (this.idStr != null) {
                String tempStr = this.idStr;
                if (!"".equals(tempStr)) {
                    tempStr = tempStr.substring(0, tempStr.length() - 1);
                    this.divertTacticsLogFormList = this.divertTacticsLog.getLogsByDivertTacticsLogIdS(tempStr);
                }
                this.systemOpeLog("atic.bis.divert.tactics.log.export.select", "lego.dic.module.AticBis", true, null, "atic.bis.divert.tactics.log.export.select", "atic.bis.divert.tactics.log.list", SysoplogLevel.info.getValue(), true, null);
            } else {
                this.divertTacticsLogFormList = this.divertTacticsLog.queryByPage(this.createQueryMap(), 0, 65535).getData();
                this.systemOpeLog("atic.bis.divert.tactics.log.export.all", "lego.dic.module.AticBis", true, null, "atic.bis.divert.tactics.log.export.all", "atic.bis.divert.tactics.log.list", SysoplogLevel.info.getValue(), true, null);
            }
            if (null == this.divertTacticsLogFormList) {
                this.logger.error((Object)"exportDivertTacticsLog(), divertTacticsLogFormList is null!");
                this.systemOpeLog("atic.bis.divert.tactics.log.export.select", "lego.dic.module.AticBis", true, null, "atic.bis.divert.tactics.log.list.noExist", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
                return;
            }
            ArrayList<Long> moIDList = new ArrayList<Long>();
            for (DivertTacticsLogForm form : this.divertTacticsLogFormList) {
                moIDList.add(form.getDeviceId());
                moIDList.add(ZoneBisUtil.getMoidByZoneid((Long)form.getZoneId()));
            }
            BisUtil.checkUserSecurity(moIDList);
            this.setZoneNameAndDeviceNameForLog(this.divertTacticsLogFormList);
            this.processRemark(this.divertTacticsLogFormList);
            this.exportDivertTacticsLog0(BisDivertUtil.generateDivertExportTitles(), this.divertTacticsLogFormList, downloadPath);
            this.logger.info((Object)"export divert tactics log successfully.");
            String[] args = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            args = 1 == version ? downloadPath.split("/") : downloadPath.split("\\\\");
            this.addListElementInSession("ExportDivertTacticsFile", args[args.length - 1]);
            this.responseResult(args[args.length - 1]);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("LegoCheckedException exportDivertTacticsLog " + e.getMessage()));
            String[] detailPara = new String[]{};
            String[] para = e.getParameters();
            if (null != para && para.length > 0) {
                detailPara = para;
            }
            this.systemOpeLog("atic.bis.divert.tactics.log.export.select", "lego.dic.module.AticBis", true, detailPara, "atic.bis.divert.tactics.log.list.noExist", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("RuntimeException exportDivertTacticsLog " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.log.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception exportDivertTacticsLog " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.log.export.select", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
            throw new LegoCheckedException(102L);
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.exportDivert);
        }
    }

    public String getZoneForDivertLog() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        Paging page = this.zoneService.queryByPage(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        return "list";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDivertTacticsLog0(String[] titles, List<DivertTacticsLogForm> divertTacticsLogFormLists, String downloadPath) {
        this.logger.info((Object)"begin to export DivertTacticsLog");
        WritableWorkbook workBook = null;
        FileOutputStream writeFileOut = null;
        try {
            writeFileOut = new FileOutputStream(downloadPath);
            workBook = Workbook.createWorkbook((OutputStream)writeFileOut);
            WritableSheet sheet = workBook.createSheet("divertLog", 0);
            for (int i = 0; i < titles.length; ++i) {
                sheet.addCell((WritableCell)new Label(i, 0, titles[i]));
            }
            int rowNum = 1;
            Map<Integer, String> operTypeMap = BisDivertUtil.getDiveretLogOperTypeMap();
            Map<Integer, String> resultsMap = BisDivertUtil.getDiveretLogResultsMap();
            Map<Integer, String> modeMap = BisDivertUtil.getDivertModeMap();
            Map<Integer, String> levelMap = BisDivertUtil.getLogLevelMap();
            for (DivertTacticsLogForm divertTacticsLogForm : divertTacticsLogFormLists) {
                sheet.addCell((WritableCell)new Label(0, rowNum, " " + divertTacticsLogForm.getDeviceName()));
                sheet.addCell((WritableCell)new Label(1, rowNum, " " + divertTacticsLogForm.getZoneDesc()));
                sheet.addCell((WritableCell)new Label(2, rowNum, " " + divertTacticsLogForm.getDivertIp()));
                sheet.addCell((WritableCell)new Label(3, rowNum, String.valueOf(divertTacticsLogForm.getMask())));
                sheet.addCell((WritableCell)new Label(4, rowNum, " " + divertTacticsLogForm.getVpnName()));
                sheet.addCell((WritableCell)new Label(5, rowNum, divertTacticsLogForm.getLogTimeStr()));
                sheet.addCell((WritableCell)new Label(6, rowNum, " " + divertTacticsLogForm.getOperator()));
                sheet.addCell((WritableCell)new Label(7, rowNum, " " + divertTacticsLogForm.getClientIp()));
                sheet.addCell((WritableCell)new Label(8, rowNum, operTypeMap.get(divertTacticsLogForm.getOperType())));
                sheet.addCell((WritableCell)new Label(9, rowNum, resultsMap.get(divertTacticsLogForm.getResult())));
                sheet.addCell((WritableCell)new Label(10, rowNum, modeMap.get(divertTacticsLogForm.getDivertMode())));
                sheet.addCell((WritableCell)new Label(11, rowNum, levelMap.get(divertTacticsLogForm.getLevel())));
                sheet.addCell((WritableCell)new Label(12, rowNum, " " + divertTacticsLogForm.getRemark()));
                ++rowNum;
            }
            workBook.write();
            writeFileOut.flush();
        }
        catch (WriteException e) {
            this.logger.error((Object)"exportDivertLog WriteException ");
        }
        catch (IOException e) {
            this.logger.error((Object)"exportDivertLog IOException ");
        }
        finally {
            if (null != workBook) {
                try {
                    workBook.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"close workBook Exception");
                }
                workBook = null;
            }
            if (null != writeFileOut) {
                try {
                    writeFileOut.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"close writeFileOut Exception");
                }
                writeFileOut = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadNameFile() {
        try {
            String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
            String onlyFileName = this.downFileName;
            this.downFileName = exportFolderPath + File.separator + this.downFileName;
            try {
                if (!this.existListElementInSession("ExportDivertTacticsFile", onlyFileName)) {
                    this.logger.error((Object)"aggressive download request!");
                    return;
                }
                if (!AticUtil.checkFileName((String)onlyFileName, (String)"xls")) {
                    LoginMgrUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                    return;
                }
                if (!AticUtil.checkFilePath((String)exportFolderPath, (String)this.downFileName)) {
                    LoginMgrUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                    return;
                }
                File file = FileUtils.getFile((String[])new String[]{this.downFileName});
                if (file.exists() && !AticUtil.checkFileType((File)file, (String)"D0CF11E0")) {
                    LoginMgrUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                    return;
                }
                this.downloadFile(this.getResponse());
            }
            catch (Exception e) {
                this.systemOpeLog("atic.bis.divert.tactics.log.export", "lego.dic.module.AticBis", true, null, "atic.bis.divert.tactics.log.export", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
                LoginMgrUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
            }
            finally {
                AticUtil.deleteTempFile((String)this.downFileName);
                this.removeListElementInSession("ExportDivertTacticsFile", onlyFileName);
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("LegoCheckedException downloadNameFile " + e.getMessage()));
            String errorInfo = this.getText("lego.err." + e.getErrorCode());
            String[] detailPara = new String[]{};
            Object[] para = e.getParameters();
            if (null != para && para.length > 0) {
                detailPara = para;
                errorInfo = MessageFormat.format(errorInfo, para);
            }
            this.systemOpeLog("atic.bis.divert.tactics.log.export", "lego.dic.module.AticBis", true, detailPara, "atic.bis.divert.tactics.log.export.failed", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("RuntimeException downloadNameFile " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.log.export", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception downloadNameFile " + e.getMessage()));
            this.systemOpeLog("atic.bis.divert.tactics.log.export", "lego.dic.module.AticBis", true, new String[0], "lego.err.102", "atic.bis.divert.tactics.log.list", SysoplogLevel.normal.getValue(), false, null);
            throw new LegoCheckedException(102L);
        }
    }

    private void downloadFile(HttpServletResponse response) {
        String downloadFileName = "";
        try {
            downloadFileName = new String(this.getDownFileName().getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("downloadFile: " + e.getMessage()));
            return;
        }
        response.setContentType("application/x-download");
        response.addHeader("Content-Disposition", "attachment;filename=divertLog.xls");
        response.setCharacterEncoding("windows-1251");
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            this.closeInputStream(fileInput);
            this.closeInputStream(bis);
            this.closeOutputStream(bos);
        }
        catch (IOException e) {
            try {
                this.logger.error((Object)"downloadFile write IOException error ");
                throw new LegoSecurityException(206L);
            }
            catch (Throwable throwable) {
                this.closeInputStream(fileInput);
                this.closeInputStream(bis);
                this.closeOutputStream(bos);
                throw throwable;
            }
        }
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"closeInputStream IOException");
            }
            finally {
                input = null;
            }
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"closeOutputStream IOException");
            }
            finally {
                output = null;
            }
        }
    }

    private boolean createFile(String downloadPath) {
        File file = new File(downloadPath);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    private Map<String, String> createQueryMap() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.sortField && null != this.sortType) {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        } else {
            queryMap.put("sortName", "logTime");
            queryMap.put("sortType", "desc");
        }
        if (null != this.queryBean) {
            String divertIp;
            queryMap.put("deviceId", null == this.queryBean.getDeviceId() ? null : this.queryBean.getDeviceId().toString());
            String string = divertIp = this.queryBean.getDivertIp() == null ? null : IPUtil4Atic.convert2CompleteIp((String)this.queryBean.getDivertIp());
            if (!AticUtil.isNull((String)divertIp)) {
                queryMap.put("divertIp", divertIp);
            }
            queryMap.put("startTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getStartTime())));
            queryMap.put("endTime", String.valueOf(AticUtil.convertTimeString((String)this.queryBean.getEndTime())));
            queryMap.put("divertMode", this.queryBean.getDivertMode());
            queryMap.put("level", this.queryBean.getLevel());
            queryMap.put("zoneId", null == this.queryBean.getZoneId() ? null : this.queryBean.getZoneId().toString());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private void setZoneNameAndDeviceNameForLog(List<DivertTacticsLogForm> divertTacticsLogFormLists) {
        HashMap<Long, String> firewallMap = new HashMap<Long, String>();
        HashMap<Long, String> zoneMap = new HashMap<Long, String>();
        for (DivertTacticsLogForm divertTacticsLogForm : divertTacticsLogFormLists) {
            if (null == divertTacticsLogForm.getDeviceId() || null == divertTacticsLogForm.getZoneId()) continue;
            if (firewallMap.containsKey(divertTacticsLogForm.getDeviceId())) {
                divertTacticsLogForm.setDeviceName((String)firewallMap.get(divertTacticsLogForm.getDeviceId()));
            } else {
                AticDevice fireWall = this.aticDeviceService.getDeviceByMoid(divertTacticsLogForm.getDeviceId().longValue());
                if (null != fireWall) {
                    divertTacticsLogForm.setDeviceName(fireWall.getName());
                    firewallMap.put(divertTacticsLogForm.getDeviceId(), fireWall.getName());
                }
            }
            if (zoneMap.containsKey(divertTacticsLogForm.getZoneId())) {
                divertTacticsLogForm.setZoneDesc((String)zoneMap.get(divertTacticsLogForm.getZoneId()));
                continue;
            }
            ZoneInfoForm zoneInfoForms = this.zoneService.getZoneNOIpById(divertTacticsLogForm.getZoneId());
            if (null == zoneInfoForms) continue;
            divertTacticsLogForm.setZoneDesc("".equals(zoneInfoForms.getZoneDesc()) ? null : zoneInfoForms.getZoneDesc());
            zoneMap.put(divertTacticsLogForm.getZoneId(), zoneInfoForms.getZoneDesc());
        }
    }

    private void initDevicesComb() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.firewallList = this.aticDeviceService.getCleanDevice(currentUser.getUserID());
        if (null == this.firewallList) {
            this.firewallList = new ArrayList<AticDevice>();
        }
        Collections.sort(this.firewallList, comparator);
        AticDevice fireWall = new AticDevice();
        fireWall.setMoId(0L);
        fireWall.setName(this.getText("atic.public.query.all"));
        this.firewallList.add(0, fireWall);
        this.firewall = fireWall;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void setAticDeviceService(AticDeviceServiceImpl aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public void setDivertTacticsLog(IDivertTacticsLogService divertTacticsLog) {
        this.divertTacticsLog = divertTacticsLog;
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") && null == this.queryBean ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    public void setTotal(int total) {
        super.setTotal(total);
        this.getSession().setAttribute("total", (Object)total);
    }

    public String viewDivertLogRemark() {
        this.checkUltraVires(Long.valueOf(this.logId));
        List<DivertTacticsLogForm> forms = this.divertTacticsLog.getLogsByDivertTacticsLogIdS(this.logId);
        if (null != forms && !forms.isEmpty()) {
            this.divertLogRemark = forms.get(0).getRemark();
            if (this.divertLogRemark.matches("[0-9]+")) {
                this.divertLogRemark = this.getText("lego.err." + forms.get(0).getRemark());
            } else if (this.divertLogRemark.contains(".") && !this.divertLogRemark.contains(":") && !this.divertLogRemark.contains(" ")) {
                this.divertLogRemark = this.getText("atic.bis.divert.tactics.log.remark." + forms.get(0).getRemark());
            }
        }
        return "success";
    }

    private void checkUltraVires(Long id) {
        DivertTacticsLog oneDivertTacticsLog = this.divertTacticsLog.getLogDetail(id);
        if (null == oneDivertTacticsLog) {
            throw new LegoCheckedException(570506L);
        }
        Long deviceId = oneDivertTacticsLog.getDeviceId();
        Long zoneId = oneDivertTacticsLog.getZoneId();
        Long moId = ZoneBisUtil.getMoidByZoneid((Long)zoneId);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(deviceId);
        BisUtil.checkUserSecurity(deviceList);
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public List<DivertTacticsLogForm> getDivertTacticsLogFormList() {
        return this.divertTacticsLogFormList;
    }

    public DivertTacticsQueryBean getQueryBean() {
        return this.queryBean;
    }

    public void setQueryBean(DivertTacticsQueryBean queryBean) {
        this.queryBean = queryBean;
    }

    public AticDevice getFirewall() {
        return this.firewall;
    }

    public void setFirewall(AticDevice firewall) {
        this.firewall = firewall;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void setExportStart(Integer exportStart) {
        this.exportStart = exportStart;
    }

    public void setExportEnd(Integer exportEnd) {
        this.exportEnd = exportEnd;
    }

    public String getAllQueryDisplay() {
        return this.allQueryDisplay;
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public List<LangPair> getModeCombData() {
        return this.modeCombData;
    }

    public List<LangPair> getLogLevelCombData() {
        return this.logLevelCombData;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public String getIsQuery() {
        return this.isQuery;
    }

    public void setIsQuery(String isQuery) {
        this.isQuery = isQuery;
    }

    public void setDivertTacticsLogFormList(List<DivertTacticsLogForm> divertTacticsLogFormList) {
        this.divertTacticsLogFormList = divertTacticsLogFormList;
    }

    public Integer getExportStart() {
        return this.exportStart;
    }

    public Integer getExportEnd() {
        return this.exportEnd;
    }

    public ZoneInfoForm getZoneInfoForm() {
        return this.zoneInfoForm;
    }

    public void setZoneInfoForm(ZoneInfoForm zoneInfoForm) {
        this.zoneInfoForm = zoneInfoForm;
    }

    public List<ZoneInfoForm> getQueryZoneFormList() {
        return this.queryZoneFormList;
    }

    public void setQueryZoneFormList(List<ZoneInfoForm> queryZoneFormList) {
        this.queryZoneFormList = queryZoneFormList;
    }

    public String getDivertLogRemark() {
        return this.divertLogRemark;
    }

    public void setDivertLogRemark(String divertLogRemark) {
        this.divertLogRemark = divertLogRemark;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public boolean validateIdStr() {
        if (null == this.idStr) {
            return true;
        }
        String[] ids = this.idStr.split(",");
        long idTemp = 0L;
        for (int i = 0; i < ids.length; ++i) {
            try {
                idTemp = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"Integer format is error");
                return false;
            }
            if (idTemp > 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateQueryBeanDeviceId() {
        if (null != this.queryBean) {
            if (null == this.queryBean.getDeviceId()) {
                return true;
            }
            if (this.queryBean.getDeviceId() < 0L) {
                return false;
            }
        }
        return true;
    }

    public boolean validateQueryBeanZoneId() {
        if (null != this.queryBean) {
            if (null == this.queryBean.getZoneId()) {
                return true;
            }
            if (this.queryBean.getZoneId() < 0L) {
                return false;
            }
        }
        return true;
    }

    public boolean validateQueryBeanDivertIp() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getDivertIp()) || IPUtil.isIpv4((String)this.queryBean.getDivertIp()) || IPUtil.isIpv6((String)this.queryBean.getDivertIp());
    }

    public boolean validateQueryBeanStartTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getStartTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getStartTime());
    }

    public boolean validateQueryBeanEndTime() {
        if (null == this.queryBean) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.queryBean.getEndTime()) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.queryBean.getEndTime());
    }

    public boolean validateQueryBeanZoneDesc() {
        if (null == this.queryBean) {
            return true;
        }
        if (null == this.queryBean.getZoneDesc() || "".equals(this.queryBean.getZoneDesc().trim())) {
            return true;
        }
        if (this.queryBean.getZoneDesc().length() > 64) {
            return false;
        }
        if (this.queryBean.getZoneDesc().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
        return this.queryBean.getZoneDesc().matches(nameRegex);
    }

    public boolean validateQueryBeanDeviceName() {
        if (null == this.queryBean) {
            return true;
        }
        if (AticUtil.isNullForVpn((String)this.queryBean.getDeviceName())) {
            return true;
        }
        if (this.queryBean.getDeviceName().length() > 32) {
            return false;
        }
        if (this.queryBean.getDeviceName().trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return this.queryBean.getDeviceName().matches(nameRegex);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

