/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.DivertBlackhole;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DivertBlackholeDao
extends CommonDaoImpl {
    private static final long MILLISECONDS_PER_SEC = 60000L;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);

    public DivertBlackhole get(Long id) {
        String hql = "from DivertBlackhole where id = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (DivertBlackhole)result.get(0);
    }

    public void remove(Long id) {
        String hql = "delete from DivertBlackhole where id = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public boolean isExist(DivertBlackhole divertBlackhole) {
        String hql;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (divertBlackhole.getNexthopIP() == null) {
            hql = "from DivertBlackhole where id != ?0 and deviceId = ?1 and blackIP = ?2 and blackMask = ?3 and blackholeMode = ?4";
            param.put(0, divertBlackhole.getId() == null ? "-1" : divertBlackhole.getId().toString());
            param.put(1, divertBlackhole.getDeviceId().toString());
            param.put(2, divertBlackhole.getBlackIP());
            param.put(3, divertBlackhole.getBlackMask());
            param.put(4, divertBlackhole.getBlackholeMode().toString());
        } else {
            hql = "from DivertBlackhole where id != ?0 and deviceId = ?1 and blackIP = ?2 and blackMask = ?3 and nexthopIP = ?4 and blackholeMode = ?5";
            param.put(0, divertBlackhole.getId() == null ? "-1" : divertBlackhole.getId().toString());
            param.put(1, divertBlackhole.getDeviceId().toString());
            param.put(2, divertBlackhole.getBlackIP());
            param.put(3, divertBlackhole.getBlackMask());
            param.put(4, divertBlackhole.getNexthopIP());
            param.put(5, divertBlackhole.getBlackholeMode().toString());
        }
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public boolean isExistApi(DivertBlackhole divertBlackhole) {
        String hql = "from DivertBlackhole where id != ?0 and blackIP = ?1 and serviceProvider = ?2 and blackholeMode = ?3";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, divertBlackhole.getId() == null ? "-1" : divertBlackhole.getId().toString());
        param.put(1, divertBlackhole.getBlackIP());
        param.put(2, divertBlackhole.getServiceProvider());
        param.put(3, divertBlackhole.getBlackholeMode().toString());
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String blackIp;
        String blackMask;
        String blackholeType;
        String blackholeMode;
        String deviceId;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from DivertBlackhole where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String userId = conditionMap.get("currentUserId");
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        if (!AticUtil.isNull((String)userId) && !AticUtil.isNull((String)isAdmin) && isAdmin.equalsIgnoreCase("false")) {
            long uid = Long.parseLong(userId);
            hql = hql + " and (deviceId in (" + CheckChildrenMoUtil.getInstanse().getHql(uid) + ") or deviceId is null)";
        }
        if (!AticUtil.isNull((String)(deviceId = conditionMap.get("deviceId")))) {
            hql = hql + " and deviceId = ?" + index;
            queryMap.put(index++, deviceId);
        }
        if (!AticUtil.isNull((String)(blackholeMode = conditionMap.get("blackholeMode")))) {
            hql = hql + " and blackholeMode = ?" + index;
            queryMap.put(index++, blackholeMode);
        }
        if (!AticUtil.isNull((String)(blackholeType = conditionMap.get("blackholeType")))) {
            hql = hql + " and blackholeType = ?" + index;
            queryMap.put(index++, blackholeType);
        }
        if (!AticUtil.isNull((String)(blackMask = conditionMap.get("blackMask")))) {
            hql = hql + " and blackMask = ?" + index;
            queryMap.put(index++, blackMask);
        }
        if (!AticUtil.isNull((String)(blackIp = conditionMap.get("blackIP")))) {
            hql = hql + " and blackIP = ?" + index;
            queryMap.put(index, blackIp);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<DivertBlackhole> getDivertBlackholeByDeviceId(Long deviceId) {
        List<DivertBlackhole> result = new ArrayList<DivertBlackhole>();
        if (deviceId != null) {
            String hql = "from  DivertBlackhole where deviceId = ?0";
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            param.put(0, String.valueOf(deviceId));
            result = this.findByHql(hql, param);
        }
        return result;
    }

    public List<DivertBlackhole> getDivertByBlackHoleMode(Map<String, String> conditionMap) {
        String blackHoleMode;
        List<DivertBlackhole> result = new ArrayList<DivertBlackhole>();
        if (null != conditionMap && !AticUtil.isNull((String)(blackHoleMode = conditionMap.get("blackholeMode")))) {
            String[] blackHoleModes = blackHoleMode.split(",");
            StringBuffer hql = new StringBuffer();
            hql.append("from  DivertBlackhole where blackholeMode = ?0");
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            int index = 0;
            for (int i = 0; i < blackHoleModes.length; ++i) {
                if (0 != i) {
                    hql.append(" or blackholeMode = ?" + index);
                }
                param.put(index, blackHoleModes[i]);
                ++index;
            }
            String deviceIP = conditionMap.get("deviceId");
            if (!AticUtil.isNull((String)deviceIP)) {
                hql.append(" and deviceId = ?" + index);
                param.put(index, deviceIP);
            }
            result = this.findByHql(hql.toString(), param);
        }
        return result;
    }

    long convertSecToMilliseconds(int sec) {
        return (long)sec * 60000L;
    }

    public List<DivertBlackhole> getTimeoutDiversionList(Map<String, Integer> blackHoleTimeOutMap) {
        ArrayList<DivertBlackhole> result = new ArrayList<DivertBlackhole>();
        StringBuffer hqlBuffer = new StringBuffer("from DivertBlackhole where mode = 1 and createTime <= ?0");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        try {
            for (Map.Entry<String, Integer> key : blackHoleTimeOutMap.entrySet()) {
                List queryResult;
                Long time;
                if (String.valueOf(0).equals(key.getKey())) {
                    hqlBuffer.append(" and deviceId is not null ");
                    time = System.currentTimeMillis() - this.convertSecToMilliseconds(blackHoleTimeOutMap.get(key.getKey()));
                    param.put(0, time.toString());
                } else {
                    hqlBuffer = new StringBuffer("from DivertBlackhole where createTime <= ?0 and deviceId is null  and serviceProvider = ?1 ");
                    time = System.currentTimeMillis() - this.convertSecToMilliseconds(key.getValue());
                    param.put(0, time.toString());
                    param.put(1, key.getKey());
                }
                if (null == (queryResult = this.findByHql(hqlBuffer.toString(), param))) continue;
                result.addAll(queryResult);
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"get timeOut blackhole Policy error ");
        }
        return result;
    }

    public List<DivertBlackhole> isExist1(DivertBlackhole divertBlackhole) {
        String hql;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (divertBlackhole.getNexthopIP() == null) {
            hql = "from DivertBlackhole where id != ?0 and deviceId = ?1 and vpn = ?2 and blackholeMode = ?3";
            param.put(0, divertBlackhole.getId() == null ? "-1" : divertBlackhole.getId().toString());
            param.put(1, divertBlackhole.getDeviceId().toString());
            param.put(2, divertBlackhole.getVpn() == null ? "--" : divertBlackhole.getVpn());
            param.put(3, divertBlackhole.getBlackholeMode().toString());
        } else {
            hql = "from DivertBlackhole where id != ?0 and deviceId = ?1 and vpn = ?2 and nexthopIP = ?3 and blackholeMode = ?4";
            param.put(0, divertBlackhole.getId() == null ? "-1" : divertBlackhole.getId().toString());
            param.put(1, divertBlackhole.getDeviceId().toString());
            param.put(2, divertBlackhole.getVpn() == null ? "--" : divertBlackhole.getVpn());
            param.put(3, divertBlackhole.getNexthopIP());
            param.put(4, divertBlackhole.getBlackholeMode().toString());
        }
        List result = this.findByHql(hql, param);
        if (null == result) {
            return new ArrayList<DivertBlackhole>();
        }
        return result;
    }

    public List<DivertBlackhole> getEnableDiversionList() {
        ArrayList<DivertBlackhole> result = new ArrayList<DivertBlackhole>();
        String hql = "from DivertBlackhole where mode = 1 and blackholeType = 1 and blackholeMode = 2 ";
        List queryResult = this.findByHql(hql);
        if (null != queryResult) {
            result.addAll(queryResult);
        }
        return result;
    }
}

