/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.StartEndIp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DivertTacticsDao
extends CommonDaoImpl {
    public DivertTactics get(Long id) {
        String hql = "from DivertTactics where id = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (DivertTactics)result.get(0);
    }

    public DivertTactics getByNfaId(Long nfaId) {
        String hql = "from DivertTactics where nfaId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, nfaId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (DivertTactics)result.get(0);
    }

    public void remove(Long id) {
        String hql = "delete from DivertTactics where id = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteAll() {
        String hql = "delete from DivertTactics";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }

    public List<Long> getDistinctDevIds() {
        String hql = "select distinct deviceId from DivertTactics";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<Long>();
        }
        return result;
    }

    public boolean isExist(DivertTactics divertTactics) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp());
        String endIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp());
        String hql = "from DivertTactics where (id<>?0) and (deviceId=?1) and (LENGTH(startIp)=LENGTH(?2)) and (startIp<=?3 and endIp>=?4)";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, divertTactics.getId() == null ? "-1" : divertTactics.getId().toString());
        param.put(1, divertTactics.getDeviceId() == null ? "-1" : divertTactics.getDeviceId().toString());
        param.put(2, startIp);
        param.put(3, endIp);
        param.put(4, startIp);
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public DivertTactics getDivertWithSamePolicy(DivertTactics divertTactics) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp());
        String endIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp());
        String hql = "from DivertTactics where deviceId=?0 and (LENGTH(startIp)=LENGTH(?1)) and startIp=?2 and endIp=?3";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, divertTactics.getDeviceId() == null ? "-1" : divertTactics.getDeviceId().toString());
        param.put(1, startIp);
        param.put(2, startIp);
        param.put(3, endIp);
        List result = this.findByHql(hql, param);
        if (null != result && !result.isEmpty()) {
            return (DivertTactics)result.get(0);
        }
        return null;
    }

    public List<DivertTactics> getConflictDivert(DivertTactics divertTactics) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp());
        String endIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp());
        String hql = "from DivertTactics where (deviceId=?0) and (LENGTH(startIp)=LENGTH(?1)) and (startIp<=?2 and endIp>=?3)";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, divertTactics.getDeviceId() == null ? "-1" : divertTactics.getDeviceId().toString());
        param.put(1, startIp);
        param.put(2, endIp);
        param.put(3, startIp);
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getConflictDivert(DivertTactics divertTactics, int mask) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp());
        String endIp = IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp());
        String hql = "from DivertTactics where (deviceId=?0) and (LENGTH(startIp)=LENGTH(?1)) and (startIp<=?2 and endIp>=?3) and mask=?4";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, divertTactics.getDeviceId() == null ? "-1" : divertTactics.getDeviceId().toString());
        param.put(1, startIp);
        param.put(2, endIp);
        param.put(3, startIp);
        param.put(4, String.valueOf(mask));
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getAllDivertTacticsByZoneIp(String startZoneIp, String endZoneIp) {
        String startIp = IPUtil4Atic.convert2CompleteIp((String)startZoneIp);
        String endIp = IPUtil4Atic.convert2CompleteIp((String)endZoneIp);
        String hql = "from DivertTactics where (LENGTH(startIp)=LENGTH(?0)) and (startIp=?1 and endIp=?2)";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, startIp);
        param.put(1, startIp);
        param.put(2, endIp);
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getAllDivertTacticsByZoneIpList(List<StartEndIp> ipList) {
        List result;
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        if (null != ipList && !ipList.isEmpty()) {
            param.put(0, IPUtil4Atic.convert2CompleteIp((String)ipList.get(0).getStartIp()));
            param.put(1, IPUtil4Atic.convert2CompleteIp((String)ipList.get(0).getStartIp()));
            param.put(2, IPUtil4Atic.convert2CompleteIp((String)ipList.get(0).getEndIp()));
            hql.append("from DivertTactics where (LENGTH(startIp)=LENGTH(?0)) and ((startIp=?1 and endIp=?2)");
            if (ipList.size() > 1) {
                for (int i = 1; i < ipList.size(); ++i) {
                    int startIpIndex = 2 * i + 1;
                    int endIpIndex = 2 * i + 2;
                    String sql = " or (startIp=?" + startIpIndex + " and endIp=?" + endIpIndex + ")";
                    hql.append(sql);
                    param.put(startIpIndex, IPUtil4Atic.convert2CompleteIp((String)ipList.get(i).getStartIp()));
                    param.put(endIpIndex, IPUtil4Atic.convert2CompleteIp((String)ipList.get(i).getEndIp()));
                }
            }
            hql.append(" )");
        }
        if (null != (result = this.findByHql(hql.toString(), param))) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String divertStatus;
        String divertMode;
        String endTime;
        String startTime;
        String divertIp;
        String zoneId;
        String deviceId;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from DivertTactics where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String userId = conditionMap.get("currentUserId");
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        if (!AticUtil.isNull((String)userId) && !AticUtil.isNull((String)isAdmin) && "false".equalsIgnoreCase(isAdmin)) {
            long uid = Long.parseLong(userId);
            String authSql = CheckChildrenMoUtil.getInstanse().getHql(uid);
            hql = hql + " and deviceId in (" + authSql + ") and zoneId in (select zoneId from ZoneInfo where moId in (" + authSql + "))";
        }
        if (!AticUtil.isNull((String)(deviceId = conditionMap.get("deviceId"))) && !"0".equals(deviceId)) {
            hql = hql + " and deviceId = ?" + index;
            queryMap.put(index++, deviceId.trim());
        }
        if (!AticUtil.isNull((String)(zoneId = conditionMap.get("zoneId")))) {
            hql = hql + " and zoneId = ?" + index;
            queryMap.put(index++, zoneId.trim());
        }
        if (!AticUtil.isNull((String)(divertIp = conditionMap.get("divertIp")))) {
            divertIp = IPUtil4Atic.convert2CompleteIp((String)divertIp);
            hql = hql + " and startIp <= ?" + index;
            queryMap.put(index++, divertIp);
            hql = hql + " and endIp >= ?" + index;
            queryMap.put(index++, divertIp);
            hql = hql + " and LENGTH(endIp) = LENGTH(?" + index + ") ";
            queryMap.put(index++, divertIp);
        }
        if (!AticUtil.isNull((String)(startTime = conditionMap.get("startTime"))) && !"0".equals(startTime)) {
            hql = hql + " and createTime >= ?" + index;
            queryMap.put(index++, startTime.trim());
        }
        if (!AticUtil.isNull((String)(endTime = conditionMap.get("endTime"))) && !"0".equals(endTime)) {
            hql = hql + " and createTime <= ?" + index;
            queryMap.put(index++, endTime.trim());
        }
        if (!AticUtil.isNull((String)(divertMode = conditionMap.get("divertMode")))) {
            hql = hql + " and divertMode = ?" + index;
            queryMap.put(index++, divertMode.trim());
        }
        if (!AticUtil.isNull((String)(divertStatus = conditionMap.get("divertStatus")))) {
            hql = hql + " and divertStatus = ?" + index;
            queryMap.put(index++, divertStatus.trim());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<DivertTactics> getNoneStaticDivert(Long deviceId, Long zoneId, String divertIp) {
        String hql = "from DivertTactics where divertMode < 2 and deviceId=?0 and (divertIp=?1 or divertIp=?2)";
        String completeIp = IPUtil4Atic.convert2CompleteIp((String)divertIp);
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, divertIp);
        param.put(2, completeIp);
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getNoneStaticStartedDivert(Long deviceId) {
        String hql = "from DivertTactics where divertMode < 2 and divertStatus = 1 and deviceId = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getNoneStaticDivert(Long deviceId, Long zoneId, String startIp, Integer mask) {
        String hql = "from DivertTactics where divertMode<2 and deviceId=?0 and startIp=?1 and mask=?2";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String completeStartIp = IPUtil4Atic.convert2CompleteIp((String)startIp);
        param.put(0, deviceId.toString());
        param.put(1, completeStartIp);
        param.put(2, mask.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getDivertByIp(String startIp, String endIp) {
        if (startIp == null || endIp == null) {
            return new ArrayList<DivertTactics>();
        }
        String hql = "from DivertTactics where startIp >= ?0 and endIp <= ?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, IPUtil4Atic.convert2CompleteIp((String)startIp));
        param.put(1, IPUtil4Atic.convert2CompleteIp((String)endIp));
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getDivertStatusByIp(String startIp, String endIp) {
        if (startIp == null || endIp == null) {
            return new ArrayList<DivertTactics>();
        }
        String hql = "from DivertTactics where startIp <= ?0 and endIp >= ?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, IPUtil4Atic.convert2CompleteIp((String)startIp));
        param.put(1, IPUtil4Atic.convert2CompleteIp((String)endIp));
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public DivertTactics getDivertTacticsByZoneIp(Long deviceId, Long zoneId, String zoneIp) {
        if (AticUtil.isNull((String)zoneIp) || null == zoneId || null == deviceId) {
            return null;
        }
        String hql = "from DivertTactics where deviceId=?0 and zoneId=?1 and startIp <= ?2 and endIp >= ?3";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, zoneId.toString());
        param.put(2, IPUtil4Atic.convert2CompleteIp((String)zoneIp));
        param.put(3, IPUtil4Atic.convert2CompleteIp((String)zoneIp));
        List result = this.findByHql(hql, param);
        if (null != result && !result.isEmpty()) {
            return (DivertTactics)result.get(0);
        }
        return null;
    }

    public DivertTactics getDivertTacticsByZoneIp(Long deviceId, String zoneIp) {
        if (AticUtil.isNull((String)zoneIp) || null == deviceId) {
            return null;
        }
        String ip = IPUtil4Atic.convert2CompleteIp((String)zoneIp);
        String hql = "from DivertTactics where deviceId=?0 and startIp <= ?1 and endIp >= ?2";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, ip);
        param.put(2, ip);
        List result = this.findByHql(hql, param);
        if (null != result && !result.isEmpty()) {
            return (DivertTactics)result.get(0);
        }
        return null;
    }

    public List<DivertTactics> getDivertListByZoneId(Long zoneId) {
        if (zoneId == null) {
            return new ArrayList<DivertTactics>();
        }
        String hql = "from DivertTactics where zoneId=?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getDivertListByDeviceId(Long deviceId) {
        if (deviceId == null) {
            return new ArrayList<DivertTactics>();
        }
        String hql = "from DivertTactics where deviceId=?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getStaticDivertByZoneIdAndFirewallId(Long zoneId, Long deviceId) {
        if (deviceId == null || zoneId == null) {
            return new ArrayList<DivertTactics>();
        }
        String hql = "from DivertTactics where deviceId=?0 and zoneId=?1 and divertMode=2";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<DivertTactics> getDivertByZoneIdAndNeId(Long zoneId, Long deviceId) {
        if (deviceId == null || zoneId == null) {
            return new ArrayList<DivertTactics>();
        }
        String hql = "from DivertTactics where deviceId=?0 and zoneId=?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result != null) {
            return result;
        }
        return new ArrayList<DivertTactics>();
    }

    public List<String> getVpnNameByDevId(Long deviceId) {
        if (deviceId == null) {
            return new ArrayList<String>();
        }
        String hql = "select distinct vpnName from DivertTactics where deviceId=?0 and vpnName is not null and vpnName != ''";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<String>();
        }
        return result;
    }
}

