/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DivertTacticsLogDao
extends CommonDaoImpl {
    public DivertTacticsLog get(long id) {
        String hql = "from DivertTacticsLog where id = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        List logList = this.findByHql(hql, param);
        if (logList == null || logList.isEmpty()) {
            return null;
        }
        return (DivertTacticsLog)logList.get(0);
    }

    public void saveDivertLog(DivertTactics divertTactics, Integer operType, String remark, Integer level) {
        DivertTacticsLog divertLog = new DivertTacticsLog();
        divertLog.setLogTime(System.currentTimeMillis() / 1000L);
        divertLog.setDeviceId(divertTactics.getDeviceId());
        divertLog.setDivertIp(divertTactics.getDivertIp());
        divertLog.setMask(divertTactics.getMask());
        divertLog.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertLog.getStartIp()));
        divertLog.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertLog.getEndIp()));
        divertLog.setDivertMode(divertTactics.getDivertMode());
        divertLog.setOperType(operType);
        divertLog.setRemark(remark);
        divertLog.setLevel(level);
        this.save(divertLog);
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String clientIp;
        String operPerson;
        String level;
        String divertMode;
        String zoneId;
        String divertIp;
        String deviceId;
        String endTime;
        String startTime;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from DivertTacticsLog where (1=1) ";
        String hql4Count = "select count(* ) as rowCount ";
        int index = 0;
        String userId = conditionMap.get("currentUserId");
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        if (null != userId && isAdmin != null && isAdmin.equalsIgnoreCase("false")) {
            long uid = Long.parseLong(userId);
            String authHql = CheckChildrenMoUtil.getInstanse().getHql(uid);
            hql = hql + " and deviceId in (" + authHql + ") ";
            hql = hql + " and zoneId in (select zoneId from ZoneInfo where moId in (" + authHql + ")) ";
        }
        if (!AticUtil.isNull((String)(startTime = conditionMap.get("startTime"))) && !startTime.equals("0")) {
            hql = hql + " and logTime >= ?" + index;
            queryMap.put(index++, startTime.trim());
        }
        if (!AticUtil.isNull((String)(endTime = conditionMap.get("endTime"))) && !endTime.equals("0")) {
            hql = hql + " and logTime <= ?" + index;
            queryMap.put(index++, endTime.trim());
        }
        if (!AticUtil.isNull((String)(deviceId = conditionMap.get("deviceId"))) && !"0".equals(deviceId)) {
            hql = hql + " and deviceId = ?" + index;
            queryMap.put(index++, deviceId.trim());
        }
        if (!AticUtil.isNull((String)(divertIp = conditionMap.get("divertIp")))) {
            hql = hql + " and endIp >= ?" + index;
            queryMap.put(index++, divertIp.trim());
            hql = hql + " and startIp <= ?" + index;
            queryMap.put(index++, divertIp.trim());
        }
        if (!AticUtil.isNull((String)(zoneId = conditionMap.get("zoneId")))) {
            hql = hql + " and zoneId = ?" + index;
            queryMap.put(index++, zoneId.trim());
        }
        if (!AticUtil.isNull((String)(divertMode = conditionMap.get("divertMode")))) {
            hql = hql + " and divertMode = ?" + index;
            queryMap.put(index++, divertMode.trim());
        }
        if (!AticUtil.isNull((String)(level = conditionMap.get("level")))) {
            hql = hql + " and level = ?" + index;
            queryMap.put(index++, level.trim());
        }
        if (!AticUtil.isNull((String)(operPerson = conditionMap.get("operator")))) {
            hql = hql + " and operator = ?" + index;
            queryMap.put(index++, operPerson.trim());
        }
        if (!AticUtil.isNull((String)(clientIp = conditionMap.get("clientIp")))) {
            hql = hql + " and clientIp = ?" + index;
            queryMap.put(index++, clientIp.trim());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List logList = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(logList);
        return page;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public int betchDelete(Long endTime) {
        String hql = "delete from DivertTacticsLog where logTime <= ?0";
        return this.getHibernateTemplate().bulkUpdate(hql, new Object[]{endTime});
    }

    public int deleteAll() {
        String hql = "delete from DivertTacticsLog";
        return this.getHibernateTemplate().bulkUpdate(hql, new Object[0]);
    }

    public void deleteByDeviceId(Long deviceId) {
        String hql = "delete from DivertTacticsLog where deviceId = ?0";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public boolean queryAndDeleteLog(int total, int limit) {
        String hql = "select count(* ) as rowCount from DivertTacticsLog";
        long count = this.getTotalCount(hql);
        if (count > (long)total) {
            this.deleteByTime(limit);
            return true;
        }
        return false;
    }

    private void deleteByTime(int limit) {
        String hql = "from DivertTacticsLog where 1=1 order by logTime asc";
        List list = this.findPage(hql, limit, 1);
        if (null != list && !list.isEmpty()) {
            String delHql = "delete from DivertTacticsLog where id < ?0";
            this.updateByHql(delHql, new Object[]{((DivertTacticsLog)list.get(0)).getId()});
        }
    }
}

