/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.scheduler;

import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.ConfigBlackholeApiForm;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.service.IBlackholeNpService;
import com.hs.atic.sdk.bis.service.IConfigBlackholeService;
import com.hs.atic.sdk.bis.service.IDivertBlackholeService;
import com.hs.atic.zone.dao.ZoneIpDao;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDao;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.service.dao.BlackholeNpDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackholeTimeoutScheduler
extends Thread {
    Map<String, Integer> blackHoleTimeOutMap = new HashMap<String, Integer>();
    List<DivertBlackholeForm> divertBlackholeNpFormList = new ArrayList<DivertBlackholeForm>();
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private boolean start = false;
    private IConfigBlackholeService configBlackholeService;
    private IDivertBlackholeService blackholeService;
    private PageSizeConfigService pageSizeConfigService;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private ISysOptLog sysOptLogService;
    private IBlackholeNpService blackholeNpService;
    private ZoneIpDao zoneIpDao;
    private ZoneDeviceDao zoneDeviceDao;
    private BlackholeNpDao blackholeNpDao;

    @Override
    public void run() {
        while (this.start) {
            try {
                this.blackholeNpService.deleteCollectorFailedBlackholeNP();
                List<ConfigBlackholeApiForm> configBlackholeApiForms = this.configBlackholeService.getServiceProvider();
                List sysConfigs = this.pageSizeConfigService.findPageSizeNum("unblockTime");
                this.divertBlackholeNpFormList = this.blackholeNpService.blackholeNpByEnableStatus();
                if (!this.divertBlackholeNpFormList.isEmpty()) {
                    this.stopBlackholeNpTimeout();
                }
                if (null != sysConfigs && !sysConfigs.isEmpty()) {
                    Integer unBolockTime = Integer.valueOf(((PageSizeConfig)sysConfigs.get(0)).getSysValue());
                    this.blackHoleTimeOutMap.put(String.valueOf(0), unBolockTime);
                }
                if (null != configBlackholeApiForms && !configBlackholeApiForms.isEmpty()) {
                    for (ConfigBlackholeApiForm configBlackholeApi : configBlackholeApiForms) {
                        this.blackHoleTimeOutMap.put(configBlackholeApi.getServiceProvider(), configBlackholeApi.getUnblockTime());
                    }
                }
                if (!this.blackHoleTimeOutMap.isEmpty()) {
                    this.checkAndNotify();
                }
            }
            catch (Exception e1) {
                this.logger.error((Object)("blackhole timeout schedule error" + e1.getMessage()));
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("sleep get error." + e.getMessage()));
            }
        }
    }

    private void checkAndNotify() {
        List<DivertBlackholeForm> forms = this.blackholeService.getTimeoutDiversionList(this.blackHoleTimeOutMap);
        if (forms != null && !forms.isEmpty()) {
            for (DivertBlackholeForm divertBlackholeForm : forms) {
                if (2 == divertBlackholeForm.getBlackholeMode()) {
                    if (null != divertBlackholeForm.getBlackholeType() && 1 == divertBlackholeForm.getBlackholeType()) continue;
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(divertBlackholeForm.getDeviceId().longValue());
                    try {
                        if (null != device) {
                            divertBlackholeForm.setDeviceIP(device.getIpAddress());
                            Long collectId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
                            if (null == collectId) {
                                this.logger.error((Object)("The Device is not associated with a collector. Device Moid is " + device.getMoId()));
                                continue;
                            }
                            CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(collectId.longValue());
                            NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(collectorInfo.getIpAddress());
                            if (null != client) {
                                this.logger.info((Object)("BoardBlackHole, get collector " + collectorInfo.getIpAddress() + "."));
                                int severity = client.getSlotBlackholeAlarmSeverity(device.getIpAddress(), divertBlackholeForm.getBlackIP());
                                if (4 == severity) {
                                    this.logger.info((Object)("BoardBlackHole is alarming,device:" + device.getIpAddress() + ",blackIp" + divertBlackholeForm.getBlackIP() + "."));
                                    continue;
                                }
                            } else {
                                this.logger.warn((Object)("BoardBlackHole Get NotifyFaultSeverityRuleService interface failed, collector ip is " + collectorInfo.getIpAddress()));
                            }
                        }
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)"BoardBlackHole Get NotifyFaultSeverityRuleService interface failed!");
                        throw e;
                    }
                    catch (RemoteException e) {
                        this.logger.error((Object)("BoardBlackHole failed. " + e.getMessage()));
                    }
                }
                try {
                    this.blackholeService.stopAndDeleteDivertBlackhole(divertBlackholeForm, false);
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("stopAndDeleteDivertBlackhole in BlackholeTimeoutScheduler failed. LegoCheckedException: " + e.getMessage()));
                }
                catch (Exception e) {
                    this.logger.error((Object)("stopAndDeleteDivertBlackhole in BlackholeTimeoutScheduler failed. Exception: " + e.getMessage()));
                }
            }
        }
    }

    private void addOperaLog(DivertBlackholeForm returnForm) {
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        if (0 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.delete");
        } else if (1 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.delete.api");
        } else if (2 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.board.delete");
        } else {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.delete");
        }
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setResult(1);
        String blackIp = IPUtil.compressIPv6((String)returnForm.getBlackIP());
        if (1 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.dynamic.api.success");
            String isp = "atic.bis.blackhole.api.sp.ctcc";
            if ("CTCC".equals(returnForm.getServiceProvider())) {
                isp = "atic.bis.blackhole.api.sp.ctcc";
            }
            String[] paraDetail = new String[]{returnForm.getBlackIP(), returnForm.getBlackMask(), isp, returnForm.getVpn()};
            sysOptLogLego.setDetailPara(paraDetail);
        } else {
            sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.dynamic.success");
            String[] paraDetail = new String[]{blackIp, returnForm.getBlackMask(), returnForm.getDeviceIP(), returnForm.getVpn()};
            sysOptLogLego.setDetailPara(paraDetail);
        }
        sysOptLogLego.setTarget(blackIp);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(false));
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != this.sysOptLogService) {
            this.sysOptLogService.writeOptLog(sysOptLogLego);
        }
    }

    private void stopBlackholeNpTimeout() {
        DivertBlackholeForm returnForm = null;
        for (DivertBlackholeForm divertBlackholeForm : this.divertBlackholeNpFormList) {
            if (2 == divertBlackholeForm.getBlackholeMode()) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(divertBlackholeForm.getDeviceId().longValue());
                try {
                    if (null != device) {
                        Long collectId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
                        if (null == collectId) {
                            this.logger.error((Object)("BoardBlackHole NP Get NotifyFaultSeverityRuleService interface failed, collector id is not found in t_collector_device table  deviceId : " + device.getMoId()));
                            throw new LegoCheckedException("BoardBlackHole NP Get NotifyFaultSeverityRuleService interface failed cause of collectorId is not found in t_collector_device!");
                        }
                        CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(collectId.longValue());
                        NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(collectorInfo.getIpAddress());
                        if (null != client) {
                            String deviceIp = device.getIpAddress();
                            String zoneIp = divertBlackholeForm.getBlackIP();
                            Integer threshold = divertBlackholeForm.getBlackholeThreshold() * 1024;
                            this.logger.info((Object)("BoardBlackHole NP, get collector " + collectorInfo.getIpAddress() + "."));
                            boolean isBlackholeThresholdTransfinite = client.isBlackholeThresholdTransfinite(deviceIp, zoneIp, threshold);
                            if (isBlackholeThresholdTransfinite) {
                                this.logger.info((Object)("BoardBlackHole NP is alarming,device:" + device.getIpAddress() + ",blackIp" + divertBlackholeForm.getBlackIP() + "."));
                                continue;
                            }
                        } else {
                            this.logger.warn((Object)("BoardBlackHole NP Get NotifyFaultSeverityRuleService interface failed, collector ip is " + collectorInfo.getIpAddress()));
                        }
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"BoardBlackHole NP Get NotifyFaultSeverityRuleService interface failed!");
                }
                catch (RemoteException e) {
                    this.logger.error((Object)("BoardBlackHole NP failed." + e.getMessage()));
                }
            }
            try {
                returnForm = this.blackholeService.stopAndDeleteDivertBlackhole(divertBlackholeForm, false);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("stopAndDeleteDivertBlackhole in BlackholeTimeoutScheduler NP failed. LegoCheckedException: " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("stopAndDeleteDivertBlackhole in BlackholeTimeoutScheduler NP failed. Exception: " + e.getMessage()));
                continue;
            }
            this.addOperaLog(returnForm);
        }
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean isStart) {
        this.start = isStart;
    }

    public IDivertBlackholeService getBlackholeService() {
        return this.blackholeService;
    }

    public void setBlackholeService(IDivertBlackholeService blackholeService) {
        this.blackholeService = blackholeService;
    }

    public IConfigBlackholeService getConfigBlackholeService() {
        return this.configBlackholeService;
    }

    public void setConfigBlackholeService(IConfigBlackholeService configBlackholeService) {
        this.configBlackholeService = configBlackholeService;
    }

    public PageSizeConfigService getPageSizeConfigService() {
        return this.pageSizeConfigService;
    }

    public void setPageSizeConfigService(PageSizeConfigService pageSizeConfigService) {
        this.pageSizeConfigService = pageSizeConfigService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public void setSysOptLogService(ISysOptLog sysOptLogService) {
        this.sysOptLogService = sysOptLogService;
    }

    public IBlackholeNpService getBlackholeNpService() {
        return this.blackholeNpService;
    }

    public void setBlackholeNpService(IBlackholeNpService blackholeNpService) {
        this.blackholeNpService = blackholeNpService;
    }

    public ZoneIpDao getZoneIpDao() {
        return this.zoneIpDao;
    }

    public void setZoneIpDao(ZoneIpDao zoneIpDao) {
        this.zoneIpDao = zoneIpDao;
    }

    public ZoneDeviceDao getZoneDeviceDao() {
        return this.zoneDeviceDao;
    }

    public void setZoneDeviceDao(ZoneDeviceDao zoneDeviceDao) {
        this.zoneDeviceDao = zoneDeviceDao;
    }

    public BlackholeNpDao getBlackholeNpDao() {
        return this.blackholeNpDao;
    }

    public void setBlackholeNpDao(BlackholeNpDao blackholeNpDao) {
        this.blackholeNpDao = blackholeNpDao;
    }
}

