/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.scheduler;

import com.hs.atic.rmi.IpStateData;
import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.atic.util.IpStateDataBuffer;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import com.huawei.atic.policy.third.service.IDelDivertScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DelDivertScheduler
extends Thread
implements IDelDivertScheduler {
    protected static final String SERVICE_NAME = "IpStateService";
    protected static final long SLEEP_TIME = 100L;
    private static final int DELAY_TIME = 300000;
    private static final long REFRESHINTERVAL4STOPDIVERT_DELAYTIME = 10000L;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private List<IpStateData> startDataList = new ArrayList<IpStateData>();
    private Map<IpStateData, Long> stopDataList = new HashMap<IpStateData, Long>();
    private Map<IpStateData, Long> forceStopDataList = new HashMap<IpStateData, Long>();
    private ILogHoldTimeService logHoldTimeService;
    private int stopDivertDelayTime = 300000;
    private int forceStopDelayTime = 300000;
    private long initTimeOfstopDivertDelayTime;

    @Override
    public void run() {
        while (true) {
            try {
                this.refreshStopDivertDelayTime();
                this.checkLocalDataToBuffer();
            }
            catch (Exception e) {
                this.logger.error((Object)("notify ip fail. " + e.getMessage()));
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)("when sleep ,error happend. " + e1.getMessage()));
                continue;
            }
            break;
        }
    }

    private synchronized void checkLocalDataToBuffer() {
        ArrayList<IpStateData> result = new ArrayList<IpStateData>();
        result.addAll(this.startDataList);
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<IpStateData, Long> each : this.stopDataList.entrySet()) {
            if (currentTime - each.getValue() <= (long)this.stopDivertDelayTime) continue;
            result.add(each.getKey());
        }
        if (!result.isEmpty()) {
            this.logger.info((Object)("Divert policy. Data size = " + result.size() + ", content = " + result));
            IpStateDataBuffer.getInstance().addIpStateData(result);
            result.removeAll(this.startDataList);
            this.startDataList.clear();
            for (IpStateData data : result) {
                this.stopDataList.remove(data);
            }
        }
    }

    private synchronized void refreshStopDivertDelayTime() {
        try {
            if (System.currentTimeMillis() - this.initTimeOfstopDivertDelayTime > 10000L) {
                this.initTimeOfstopDivertDelayTime = System.currentTimeMillis();
                this.stopDivertDelayTime = ((LogHoldTimeForm)this.logHoldTimeService.findLogHoldTime().get(0)).getDivertDelayTime() * 1000;
            }
            Iterator<Map.Entry<IpStateData, Long>> iterator = this.forceStopDataList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IpStateData, Long> data = iterator.next();
                if (this.initTimeOfstopDivertDelayTime - this.forceStopDataList.get(data.getKey()) <= (long)this.forceStopDelayTime) continue;
                if (data.getKey().isAlarm() && data.getKey().getPolicy() != 9) {
                    this.startDataList.add(data.getKey());
                    this.stopDataList.remove(data.getKey());
                }
                iterator.remove();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("get devert delay time error." + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIpStateData(List<IpStateData> dataList) {
        DelDivertScheduler delDivertScheduler = this;
        synchronized (delDivertScheduler) {
            for (IpStateData data : dataList) {
                long currentTime = System.currentTimeMillis();
                if (data.isAlarm()) {
                    if (!this.forceStopDataList.containsKey(data)) {
                        this.startDataList.add(data);
                        this.stopDataList.remove(data);
                    } else {
                        this.logger.info((Object)"false");
                    }
                    if (data.getPolicy() == 9) {
                        this.forceStopDataList.put(data, currentTime);
                    }
                } else {
                    this.stopDataList.put(data, currentTime);
                    this.startDataList.remove(data);
                }
                if (!this.forceStopDataList.containsKey(data)) continue;
                long forceStopTime = this.forceStopDataList.get(data);
                this.forceStopDataList.remove(data);
                this.forceStopDataList.put(data, forceStopTime);
            }
        }
    }

    public ILogHoldTimeService getLogHoldTimeService() {
        return this.logHoldTimeService;
    }

    public void setLogHoldTimeService(ILogHoldTimeService logHoldTimeService) {
        this.logHoldTimeService = logHoldTimeService;
    }
}

