/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.DivertBlackholeDao;
import com.hs.atic.bis.model.DivertBlackhole;
import com.hs.atic.restful.client.NotifyBlackholeIp;
import com.hs.atic.restful.client.model.NotifyBlackholeForm;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.ConfigBlackholeApiForm;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.service.IConfigBlackholeService;
import com.hs.atic.sdk.bis.service.IDivertBlackholeService;
import com.hs.atic.util.AticDiversionUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.BlackholeAlarmHandler;
import com.hs.atic.util.CloudCleanUtil;
import com.hs.atic.util.DeviceProxy;
import com.hs.atic.util.DeviceProxyFactory;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.service.dao.BlackholeNpDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.device.model.ConfigBlackholeNp;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.DeviceCmdMessageManager;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.dao.DataAccessException;

public class DivertBlackholeServiceImpl
implements IDivertBlackholeService {
    private static final int RETRY_TIMES = 3;
    private static final String COMMAND_DEPLOY_DIVERT_BLACKHOLE_ID = "DEPLOY_DIVERT_BLACKHOLE";
    private static final String COMMAND_UNDEPLOY_DIVERT_BLACKHOLE_ID = "UNDEPLOY_DIVERT_BLACKHOLE";
    private static Set<Long> currentDeviceSet = new HashSet<Long>();
    private IConfigBlackholeService configBlackholeService;
    private IDataProtectService dataProtectService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private DivertBlackholeDao divertBlackholeDao;
    private IAticDeviceService aticDeviceService;
    private NotifyBlackholeIp notifyBlackholeIp;
    private BlackholeNpDao blackholeNpDao;
    private ISysOptLog sysOptLog;
    private BlackholeAlarmHandler blackholeAlarmHandler;

    private Integer cmdResult(String cmdResult) {
        return DeviceCmdMessageManager.getErrorCode((String)cmdResult);
    }

    private void batchDivertBlackholeFailed(long errorCode, String[] params, String detail, List<BatchOperation> deviceBoList) {
        if (this.isCollectionEmpty(deviceBoList)) {
            return;
        }
        for (BatchOperation bo : deviceBoList) {
            bo.setErrorCode(errorCode);
            bo.setDetailParam(params);
            bo.setOptDetail(detail);
        }
    }

    private Map<String, List<BatchOperation>> groupDivertBlackholesByDevice(BatchOperationResult result) {
        HashMap<String, List<BatchOperation>> groupMap = new HashMap<String, List<BatchOperation>>();
        List boList = result.getResult();
        int failed = 0;
        for (BatchOperation bo : boList) {
            Long id = bo.getTargetId();
            bo.setErrorCode(0L);
            DivertBlackholeForm divertBlackholeForm = null;
            try {
                divertBlackholeForm = this.getDivertBlackholeById(id);
                bo.setExtTargetId((Object)divertBlackholeForm);
                ArrayList<BatchOperation> bolist = new ArrayList<BatchOperation>();
                bolist.add(bo);
                groupMap.put(String.valueOf(bo.getTargetId()), bolist);
            }
            catch (LegoCheckedException e) {
                ++failed;
                bo.setErrorCode(e.getErrorCode());
                this.logger.error((Object)e.getMessage());
            }
            catch (DataAccessException e) {
                ++failed;
                bo.setErrorCode(571804L);
                this.logger.error((Object)e.getMessage());
            }
            catch (Exception e) {
                ++failed;
                bo.setErrorCode(571805L);
                this.logger.error((Object)e.getMessage());
            }
        }
        result.setFailCount(failed);
        return groupMap;
    }

    public void checkCmdResult(Integer errorCode, String cmdResult) {
        if (errorCode != 1) {
            if (errorCode == 571813) {
                throw new LegoCheckedException((long)errorCode.intValue(), new String[]{cmdResult});
            }
            throw new LegoCheckedException((long)errorCode.intValue());
        }
    }

    @Override
    public DivertBlackholeForm createDivertBlackhole(DivertBlackholeForm divertBlackholeForm) {
        if (null == divertBlackholeForm) {
            throw new LegoCheckedException(571809L);
        }
        try {
            AticDevice device;
            if (null != divertBlackholeForm.getDeviceId() && null == (device = this.aticDeviceService.getDeviceByMoid(divertBlackholeForm.getDeviceId().longValue()))) {
                this.logger.error((Object)("createDivertBlackhole failed, device is null. deviceId=" + divertBlackholeForm.getDeviceId() + ", blackIp=" + divertBlackholeForm.getBlackIP() + " ,blackMode" + divertBlackholeForm.getBlackholeMode()));
                throw new LegoCheckedException(571205L);
            }
            if (!this.isExist(divertBlackholeForm)) {
                divertBlackholeForm.setCreateTime(System.currentTimeMillis());
                DivertBlackholeForm retDivertBlackholeForm = this.saveDivertBlackhole(divertBlackholeForm);
                return retDivertBlackholeForm;
            }
            this.logger.error((Object)("the divert divertBlackhole is existed, blackIp=" + divertBlackholeForm.getBlackIP() + " ,blackMode" + divertBlackholeForm.getBlackholeMode()));
            throw new LegoCheckedException(571810L);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("createDivertBlackhole error: " + e.getMessage()));
            throw new LegoCheckedException(571804L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("createDivertBlackhole error: " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)("createDivertBlackhole exception: " + e.getMessage()));
            throw new LegoCheckedException(571805L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndDeleteDivertBlackholesForDelNeMsg(AticDevice device, List<DivertBlackholeForm> list) {
        if (this.isCollectionEmpty(list)) {
            this.logger.error((Object)"list is empty");
            return;
        }
        this.logger.info((Object)("stopAndDeleteDivertBlackholesForDelNeMsg-> device.getMoId()=" + device.getMoId() + ", DivertBlackholeForm size=" + list.size() + ", deviceIp=" + this.getcleanedMessage(device.getIpAddress())));
        DeviceProxy proxy = null;
        try {
            proxy = DeviceProxyFactory.createDeviceProxy(device.getMoId(), this.aticDeviceService);
            this.batchDeleteBlackholeForDelNeMsg(device, list, proxy, null);
        }
        catch (Exception e) {
            this.batchDeleteBlackholeForDelNeMsg(device, list, proxy, e);
            this.logger.error((Object)e.getMessage());
        }
        finally {
            this.closeProxyAndUnLockDevice(device.getMoId(), proxy);
        }
    }

    private String setLogForDelNeInitLevel(SysOptLog sysoptlog, DivertBlackholeForm stoptDivertBlackholeForm) {
        int level = SysoplogLevel.normal.getValue();
        String enableStatus = "atic.bis.blackhole.divert.unknown";
        if (null == stoptDivertBlackholeForm.getEnableStatus()) {
            level = SysoplogLevel.warning.getValue();
        }
        if (stoptDivertBlackholeForm.getEnableStatus() == 1) {
            enableStatus = "atic.bis.blackhole.divert.enable";
            level = SysoplogLevel.warning.getValue();
        }
        if (stoptDivertBlackholeForm.getEnableStatus() == 0) {
            enableStatus = "atic.bis.blackhole.divert.disable";
        }
        sysoptlog.setLevel(level);
        return enableStatus;
    }

    private void setLogForDelNEDetailForError(SysOptLog sysoptlog, String[] paraFailed, String[] paraSuccess, Exception[] exceptionArray) {
        Exception e1 = exceptionArray[1];
        Exception e2 = exceptionArray[2];
        if (e1 instanceof DataAccessException) {
            sysoptlog.setResult(0);
            paraFailed[5] = e1.getMessage();
            paraFailed[6] = "-";
        } else {
            long errorCode1;
            String detailmsg1 = "-";
            String detailmsg2 = "-";
            detailmsg1 = e1 instanceof LegoCheckedException ? ((errorCode1 = ((LegoCheckedException)((Object)e1)).getErrorCode()) == 571802L ? "-" : "lego.err." + errorCode1) : e1.getMessage();
            if (e2 != null) {
                if (e2 instanceof LegoCheckedException) {
                    long errorCode2 = ((LegoCheckedException)((Object)e2)).getErrorCode();
                    detailmsg2 = "lego.err." + errorCode2;
                } else {
                    detailmsg2 = e2.getMessage();
                }
                sysoptlog.setResult(0);
                paraFailed[5] = detailmsg1;
                paraFailed[6] = detailmsg2;
            } else {
                sysoptlog.setLevel(SysoplogLevel.warning.getValue());
                paraSuccess[5] = detailmsg1;
            }
        }
    }

    private void setLogForDelNeParam(Exception[] exceptionArray, AticDevice device, DivertBlackholeForm stoptDivertBlackholeForm, SysOptLog sysoptlog) {
        sysoptlog.setResult(1);
        Exception preException = exceptionArray[0];
        String enableStatus = this.setLogForDelNeInitLevel(sysoptlog, stoptDivertBlackholeForm);
        String[] paraFailed = new String[]{device.getName(), stoptDivertBlackholeForm.getBlackIP(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getNexthopIP(), enableStatus, "-", "-"};
        String[] paraSuccess = new String[]{device.getName(), stoptDivertBlackholeForm.getBlackIP(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getNexthopIP(), enableStatus, "-"};
        if (exceptionArray[1] != null) {
            LegoCheckedException le;
            this.setLogForDelNEDetailForError(sysoptlog, paraFailed, paraSuccess, exceptionArray);
            if (exceptionArray[1] instanceof LegoCheckedException && (le = (LegoCheckedException)((Object)exceptionArray[1])).getErrorCode() == 571813L) {
                sysoptlog.setDetail("atic.bis.blackhole.divert.operation.detail.cmd.failed");
                String cmdError = "-";
                if (le.getParameters() != null && le.getParameters().length > 0 && le.getParameters()[0] != null) {
                    cmdError = le.getParameters()[0];
                }
                paraFailed = new String[]{device.getName(), stoptDivertBlackholeForm.getBlackIP(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getNexthopIP(), enableStatus, cmdError.replaceAll("\r\n", " ")};
                sysoptlog.setDetailPara(paraFailed);
                return;
            }
        } else if (preException != null) {
            String detailmsgPre = "-";
            if (preException instanceof LegoCheckedException) {
                long errorCodePre = ((LegoCheckedException)((Object)preException)).getErrorCode();
                detailmsgPre = "lego.err." + errorCodePre;
            } else {
                detailmsgPre = preException.getMessage();
            }
            paraSuccess[5] = detailmsgPre;
        }
        if (sysoptlog.getResult() == 1) {
            sysoptlog.setDetail("atic.bis.blackhole.divert.operation.msg.delete.detail.success");
            sysoptlog.setDetailPara(paraSuccess);
        } else {
            sysoptlog.setDetail("atic.bis.blackhole.divert.operation.msg.delete.detail.failed");
            sysoptlog.setDetailPara(paraFailed);
        }
    }

    private void recordLogForDelNeMsg(Exception[] exceptionArray, DivertBlackholeForm stoptDivertBlackholeForm, AticDevice device) {
        try {
            String operation = "atic.bis.blackhole.divert.operation.msg.delete";
            SysOptLog sysoptlog = new SysOptLog();
            sysoptlog.setDate(new Date());
            sysoptlog.setModule("lego.dic.module.AticBis");
            sysoptlog.setOperation(operation);
            sysoptlog.setOperator("system");
            sysoptlog.setTarget("Device:" + device.getIpAddress());
            if (exceptionArray == null) {
                sysoptlog.setResult(0);
                sysoptlog.setLevel(SysoplogLevel.risk.getValue());
                String[] paraFailed = new String[]{device.getName(), stoptDivertBlackholeForm.getBlackIP(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getNexthopIP(), "atic.bis.blackhole.divert.unknown", "lego.err.571808", "-"};
                sysoptlog.setDetail("atic.bis.blackhole.divert.operation.msg.delete.detail.failed");
                sysoptlog.setDetailPara(paraFailed);
            } else {
                this.setLogForDelNeParam(exceptionArray, device, stoptDivertBlackholeForm, sysoptlog);
            }
            String terminalIp = "127.0.0.1";
            sysoptlog.setTerminalIp(terminalIp);
            this.sysOptLog.writeOptLog(sysoptlog);
        }
        catch (Exception t) {
            this.logger.error((Object)t.getMessage());
        }
    }

    private void addOperaLog(long errorCode, DivertBlackholeForm returnForm) {
        String[] paraDetail;
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        if (0 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.delete");
        } else if (1 == returnForm.getBlackholeMode() && returnForm.getMode() == 1) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.delete.api");
        } else if (1 == returnForm.getBlackholeMode() && returnForm.getMode() == 0) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.disable.api");
        } else if (2 == returnForm.getBlackholeMode()) {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.board.delete");
        } else {
            sysOptLogLego.setOperation("atic.bis.blackhole.divert.operation.delete");
        }
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        String blackIp = IPUtil.compressIPv6((String)returnForm.getBlackIP());
        if (errorCode == 0L) {
            sysOptLogLego.setResult(1);
            if (1 == returnForm.getBlackholeMode()) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.dynamic.api.success");
                String isp = "atic.bis.blackhole.api.sp.ctcc";
                if ("CTCC".equals(returnForm.getServiceProvider())) {
                    isp = "atic.bis.blackhole.api.sp.ctcc";
                }
                String[] paraDetail2 = new String[]{returnForm.getBlackIP(), returnForm.getBlackMask(), isp, returnForm.getVpn()};
                sysOptLogLego.setDetailPara(paraDetail2);
            } else {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.dynamic.success");
                paraDetail = new String[]{blackIp, returnForm.getBlackMask(), returnForm.getDeviceIP(), returnForm.getVpn()};
                sysOptLogLego.setDetailPara(paraDetail);
            }
        } else {
            sysOptLogLego.setResult(0);
            if (errorCode == 571801L || errorCode == 571804L || errorCode == 571810L || errorCode == 571818L || errorCode == 571813L || 571819L == errorCode || errorCode == 571217L) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail." + errorCode);
            } else if (571817L == errorCode) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail." + errorCode);
            } else if (514L == errorCode || 517L == errorCode) {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail.517");
            } else {
                sysOptLogLego.setDetail("atic.bis.blackhole.divert.operation.fail.other");
            }
            paraDetail = new String[]{blackIp, returnForm.getBlackMask(), returnForm.getDeviceIP(), returnForm.getVpn()};
            sysOptLogLego.setDetailPara(paraDetail);
        }
        sysOptLogLego.setTarget(blackIp);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(false));
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != this.sysOptLog) {
            this.sysOptLog.writeOptLog(sysOptLogLego);
        }
    }

    /*
     * Exception decompiling
     */
    private void batchDeleteBlackholeForDelNeMsg(AticDevice device, List<DivertBlackholeForm> list, DeviceProxy proxy, Exception preException) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public BatchOperationResult stopAndDeleteDivertBlackholes(List<BatchOperation> boList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void batchDeleteBlackholeNENotExist(List<BatchOperation> deviceBoList) {
        if (this.isCollectionEmpty(deviceBoList)) {
            return;
        }
        for (BatchOperation bo : deviceBoList) {
            DivertBlackholeForm divertBlackholeForm;
            if (null == bo || null == (divertBlackholeForm = (DivertBlackholeForm)bo.getExtTargetId())) continue;
            try {
                this.removeDivertBlackhole(divertBlackholeForm);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
        }
    }

    private Integer updateDivertPolicy(DivertBlackholeForm divertBlackholeForm) {
        divertBlackholeForm.setEnableTime(System.currentTimeMillis());
        divertBlackholeForm.setEnableStatus(divertBlackholeForm.getEnableStatus());
        divertBlackholeForm.setDetail("");
        DivertBlackhole divertBlackhole = this.divertBlackholeDao.get(divertBlackholeForm.getId());
        if (null == divertBlackhole) {
            throw new LegoCheckedException(571803L);
        }
        this.saveDivertBlackhole(divertBlackholeForm);
        return divertBlackholeForm.getEnableStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blackholeOperCompleted(DivertBlackholeForm divertBlackholeForm, int operType, Integer status, Integer errorCode) {
        divertBlackholeForm.setEnableTime(System.currentTimeMillis());
        divertBlackholeForm.setEnableStatus(status);
        divertBlackholeForm.setDetail(String.valueOf(errorCode));
        String deviceIP = divertBlackholeForm.getDeviceIP();
        String deviceName = divertBlackholeForm.getDeviceName();
        try {
            String operMsg = "stop divert blackhole : ";
            if (operType == 1) {
                operMsg = "start divert blackhole : ";
            }
            String msg = operMsg + divertBlackholeForm.getDeviceId() + ", " + divertBlackholeForm.getDeviceIP() + ", " + divertBlackholeForm.getDeviceName() + ", " + IPUtil.compressIPv6((String)divertBlackholeForm.getBlackIP()) + divertBlackholeForm.getBlackMask() + ", " + divertBlackholeForm.getNexthopIP() + ", " + divertBlackholeForm.getEnableStatus() + " compelete.  errorCode=" + errorCode;
            this.logger.info((Object)this.getcleanedMessage(msg));
        }
        finally {
            DivertBlackholeForm ret = this.saveDivertBlackhole(divertBlackholeForm);
            AticUtil.copyProperties((Object)ret, (Object)divertBlackholeForm);
            divertBlackholeForm.setDeviceIP(deviceIP);
            divertBlackholeForm.setDeviceName(deviceName);
        }
    }

    @Override
    public DivertBlackholeForm createAndDeployDivertBlackhole(DivertBlackholeForm divertBlackholeForm) {
        DivertBlackholeForm retDvertBlackholeForm = this.createDivertBlackhole(divertBlackholeForm);
        return this.startDivertBlackhole(retDvertBlackholeForm);
    }

    @Override
    public DivertBlackholeForm createAndDeployDivertBlackholeVty(DivertBlackholeForm divertBlackholeForm) {
        DivertBlackholeForm retDvertBlackholeForm = this.createDivertBlackhole(divertBlackholeForm);
        return this.startDivertBlackholeVty(retDvertBlackholeForm);
    }

    private int countNumberOf1(int number) {
        int count = 0;
        while (0 != number) {
            ++count;
            number &= number - 1;
        }
        return count;
    }

    private static boolean isNetmask(String netmask) {
        String mask = "^(255|254|252|248|240|224|192|128|0)\\.0\\.0\\.0|255\\.(255|254|252|248|240|224|192|128|0)\\.0\\.0|255\\.255\\.(255|254|252|248|240|224|192|128|0)\\.0|255\\.255\\.255\\.(255|254|252|248|240|224|192|128|0)$";
        Pattern pattern = Pattern.compile(mask);
        Matcher matcher = pattern.matcher(netmask);
        return matcher.matches();
    }

    private int mask2Length(String mask) {
        if (!DivertBlackholeServiceImpl.isNetmask(mask)) {
            return 0;
        }
        String[] ipArr = mask.split("\\.");
        return this.countNumberOf1(Integer.parseInt(ipArr[0])) + this.countNumberOf1(Integer.parseInt(ipArr[1])) + this.countNumberOf1(Integer.parseInt(ipArr[2])) + this.countNumberOf1(Integer.parseInt(ipArr[3]));
    }

    @Override
    public boolean isExist(DivertBlackholeForm divertBlackholeForm) {
        if (DivertBlackholeServiceImpl.isNetmask(divertBlackholeForm.getBlackMask())) {
            divertBlackholeForm.setBlackMask(this.mask2Length(divertBlackholeForm.getBlackMask()) + "");
        }
        DivertBlackhole divertBlackhole = new DivertBlackhole();
        AticUtil.copyProperties((Object)divertBlackholeForm, (Object)divertBlackhole);
        if (divertBlackholeForm.getBlackholeMode() == 0 || divertBlackholeForm.getBlackholeMode() == 2) {
            String[] subnetRange = IPUtil.getSubnetRange((String)divertBlackhole.getBlackIP(), (int)Integer.parseInt(divertBlackhole.getBlackMask()));
            List<DivertBlackhole> diverBlackholeByVpn = this.divertBlackholeDao.isExist1(divertBlackhole);
            for (DivertBlackhole blackhole : diverBlackholeByVpn) {
                List<String> blackholeList;
                String blackHoleMask = blackhole.getBlackMask();
                if (DivertBlackholeServiceImpl.isNetmask(blackHoleMask)) {
                    blackHoleMask = this.mask2Length(blackhole.getBlackMask()) + "";
                }
                String[] subnetRange2 = IPUtil.getSubnetRange((String)blackhole.getBlackIP(), (int)Integer.parseInt(blackHoleMask));
                List<String> newblackholeList = Arrays.asList(subnetRange);
                if (!newblackholeList.containsAll(blackholeList = Arrays.asList(subnetRange2)) || !blackholeList.containsAll(newblackholeList)) continue;
                return true;
            }
            return false;
        }
        try {
            return this.divertBlackholeDao.isExistApi(divertBlackhole);
        }
        catch (Exception e) {
            this.logger.error((Object)("isExist same Blackhole eror: " + e.getMessage()));
            return false;
        }
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        ArrayList<DivertBlackholeForm> divertBlackholeFormList = new ArrayList<DivertBlackholeForm>();
        Paging page = this.divertBlackholeDao.queryByPage(queryMap, start, pageSize);
        List divertBlackholeList = page.getData();
        if (!this.isCollectionEmpty(divertBlackholeList)) {
            for (DivertBlackhole divertBlackhole : divertBlackholeList) {
                DivertBlackholeForm form = (DivertBlackholeForm)AticUtil.copyProperties((Object)divertBlackhole, (Object)new DivertBlackholeForm());
                try {
                    if (null != divertBlackhole.getDeviceId()) {
                        AticDevice device = this.aticDeviceService.getDeviceByMoid(divertBlackhole.getDeviceId().longValue());
                        if (device != null) {
                            form.setDeviceName(device.getName());
                            form.setDeviceIP(device.getIpAddress());
                        }
                    } else {
                        form.setDeviceName("--");
                        form.setDeviceIP("--");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage());
                }
                divertBlackholeFormList.add(form);
            }
        }
        page.setData(divertBlackholeFormList);
        this.logger.info((Object)("query divert Blackhole list. size = " + divertBlackholeFormList.size()));
        return page;
    }

    private void removeDivertBlackhole(DivertBlackholeForm divertBlackholeForm) {
        if (null == divertBlackholeForm || null == divertBlackholeForm.getId()) {
            this.logger.error((Object)"can't delete DivertBlackhole by null id");
            return;
        }
        this.divertBlackholeDao.remove(divertBlackholeForm.getId());
    }

    private DivertBlackholeForm saveDivertBlackhole(DivertBlackholeForm divertBlackholeForm) {
        this.logger.info((Object)("save DivertBlackholeForm, balckIp=" + divertBlackholeForm.getBlackIP() + " ,blackMode=" + divertBlackholeForm.getBlackholeMode()));
        DivertBlackhole divertBlackhole = null == divertBlackholeForm.getId() ? new DivertBlackhole() : this.divertBlackholeDao.get(divertBlackholeForm.getId());
        divertBlackhole = (DivertBlackhole)AticUtil.copyProperties((Object)divertBlackholeForm, (Object)divertBlackhole);
        this.divertBlackholeDao.saveOrUpdate(divertBlackhole);
        DivertBlackholeForm ret = (DivertBlackholeForm)AticUtil.copyProperties((Object)divertBlackhole, (Object)divertBlackholeForm);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult startDivertBlackholes(List<BatchOperation> boList) {
        if (this.isCollectionEmpty(boList)) {
            throw new LegoCheckedException(571809L);
        }
        BatchOperationResult result = new BatchOperationResult();
        result.setResult(boList);
        Map<String, List<BatchOperation>> divertBlackholesMap = this.groupDivertBlackholesByDevice(result);
        int fail = result.getFailCount();
        Set<Map.Entry<String, List<BatchOperation>>> set = divertBlackholesMap.entrySet();
        for (Map.Entry<String, List<BatchOperation>> entry : set) {
            List<BatchOperation> deviceBoList = entry.getValue();
            try {
                for (BatchOperation bo : deviceBoList) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    DivertBlackholeForm divertBlackholeForm = (DivertBlackholeForm)bo.getExtTargetId();
                    String ip = divertBlackholeForm.getBlackIP();
                    String mask = divertBlackholeForm.getBlackMask();
                    if (null == divertBlackholeForm.getDeviceId()) {
                        String key = divertBlackholeForm.getServiceProvider();
                        ConfigBlackholeApiForm configBlackholeApiForm = this.configBlackholeService.getConfigApi(key);
                        String url = configBlackholeApiForm.getUrl();
                        StringBuffer accessKey = new StringBuffer("null");
                        if (null != configBlackholeApiForm.getUserName()) {
                            accessKey = new StringBuffer(configBlackholeApiForm.getUserName());
                        }
                        StringBuffer secretKey = new StringBuffer(this.dataProtectService.sdpDecrypt(configBlackholeApiForm.getPassword(), 0L));
                        String defendScope = configBlackholeApiForm.getDefendScope();
                        Integer unblockTime = configBlackholeApiForm.getUnblockTime();
                        params.put("ipMask", ip + "/" + mask);
                        params.put("unblockTime", String.valueOf(unblockTime * 60));
                        if (!"CTCC".equals(key)) continue;
                        params.put("zone", defendScope);
                        params.put("alias", configBlackholeApiForm.getCertAlias());
                        try {
                            if (this.isNotifyFirst()) {
                                this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                                this.sendBlackHoleIp(divertBlackholeForm, "block");
                            }
                            CloudCleanUtil.getInstance().enableCloudClean4CTCC(url, accessKey, secretKey, params);
                            divertBlackholeForm.setEnableStatus(1);
                            this.updateDivertPolicy(divertBlackholeForm);
                            if (this.isNotifyFirst()) continue;
                            this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                            this.sendBlackHoleIp(divertBlackholeForm, "block");
                        }
                        catch (LegoCheckedException e) {
                            this.batchDivertBlackholeFailed(e.getErrorCode(), e.getParameters(), e.getMessage(), deviceBoList);
                            fail += deviceBoList.size();
                            this.logger.error((Object)("enable CTCC fail: " + e.getMessage()));
                        }
                        catch (Exception e) {
                            this.batchDivertBlackholeFailed(571805L, null, e.getMessage(), deviceBoList);
                            fail += deviceBoList.size();
                            this.logger.error((Object)("enable CTCC fail: " + e.getMessage()));
                        }
                        continue;
                    }
                    Long deviceId = divertBlackholeForm.getDeviceId();
                    AticDevice device = this.checkNEByMoId(deviceId);
                    DeviceProxy proxy = null;
                    try {
                        proxy = DeviceProxyFactory.createDeviceProxy(deviceId, this.aticDeviceService);
                        if (bo.getErrorCode() > 0L) {
                            this.logger.error((Object)("bo has error.error code:" + bo.getErrorCode()));
                            continue;
                        }
                        try {
                            divertBlackholeForm.setDeviceIP(device.getIpAddress());
                            divertBlackholeForm.setDeviceName(device.getName());
                            if (this.isNotifyFirst()) {
                                this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                                this.sendBlackHoleIp(divertBlackholeForm, "block");
                            }
                            this.logger.info((Object)"begin to start divert blackhole.");
                            this.exeCmdStartDivertBlackhole(divertBlackholeForm, proxy);
                            this.logger.info((Object)"start divert blackhole success.");
                            if (this.isNotifyFirst()) continue;
                            this.sendBlackHoleIp(divertBlackholeForm, "block");
                        }
                        catch (LegoCheckedException e) {
                            ++fail;
                            bo.setErrorCode(e.getErrorCode());
                            bo.setDetailParam(e.getParameters());
                            this.logger.error((Object)e.getMessage());
                        }
                        catch (Exception e) {
                            ++fail;
                            bo.setErrorCode(571805L);
                            this.logger.error((Object)e.getMessage());
                        }
                    }
                    finally {
                        if (null == deviceId || null == proxy) continue;
                        this.closeProxyAndUnLockDevice(deviceId, proxy);
                    }
                }
            }
            catch (LegoCheckedException e) {
                this.batchDivertBlackholeFailed(e.getErrorCode(), e.getParameters(), e.getMessage(), deviceBoList);
                fail += deviceBoList.size();
                this.logger.error((Object)e.getMessage());
            }
            catch (RuntimeException e) {
                this.batchDivertBlackholeFailed(571805L, null, e.getMessage(), deviceBoList);
                fail += deviceBoList.size();
                this.logger.error((Object)e.getMessage());
            }
        }
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("Batch start DivertBlackhole result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DivertBlackholeForm stopAndDeleteDivertBlackhole(DivertBlackholeForm divertBlackholeForm, boolean isRestful) {
        if (null == divertBlackholeForm || null == divertBlackholeForm.getId()) {
            throw new LegoCheckedException(571809L);
        }
        DivertBlackholeForm stoptDivertBlackholeForm = this.getDivertBlackholeByIdWithoutNEInfo(divertBlackholeForm.getId());
        stoptDivertBlackholeForm.setDeviceIP(divertBlackholeForm.getDeviceIP());
        ZonePolicyApplyForm zonePolicyApplyForm = this.getZonePolicyForm(stoptDivertBlackholeForm);
        Long zoneId = zonePolicyApplyForm.getZoneId();
        if (null == divertBlackholeForm.getEnableStatus() || divertBlackholeForm.getEnableStatus() != 1) {
            if (2 == zonePolicyApplyForm.getBlackholeMode()) {
                this.sendBlackHoleIp(divertBlackholeForm, "unblock");
            }
            if (null == divertBlackholeForm.getDeviceId() && !"".equals(divertBlackholeForm.getServiceProvider()) && divertBlackholeForm.getMode() != 1) {
                this.logger.warn((Object)("this is static blackhole API, don't remove. divertBlackhole ip : " + divertBlackholeForm.getBlackIP()));
                return stoptDivertBlackholeForm;
            }
            if (!isRestful) {
                this.addOperaLog(0L, stoptDivertBlackholeForm);
            }
            this.removeDivertBlackhole(stoptDivertBlackholeForm);
            return stoptDivertBlackholeForm;
        }
        if (null != zonePolicyApplyForm.getBlackholeEnable() && zonePolicyApplyForm.getBlackholeEnable().booleanValue() && 2 == divertBlackholeForm.getBlackholeMode() && this.ipFlowBiggerBlackholeThreshold(zonePolicyApplyForm, divertBlackholeForm.getBlackIP())) {
            stoptDivertBlackholeForm.setCreateTime(System.currentTimeMillis());
            this.saveDivertBlackhole(stoptDivertBlackholeForm);
            this.sendBlackholeStartAlarm(stoptDivertBlackholeForm);
            this.addOperaLog(571819L, stoptDivertBlackholeForm);
            return stoptDivertBlackholeForm;
        }
        Long deviceId = stoptDivertBlackholeForm.getDeviceId();
        String serviceProvider = stoptDivertBlackholeForm.getServiceProvider();
        if (null == deviceId && !"".equals(serviceProvider)) {
            String ip = stoptDivertBlackholeForm.getBlackIP();
            ConfigBlackholeApiForm configBlackholeApiForm = this.configBlackholeService.getConfigApi(serviceProvider);
            String url = configBlackholeApiForm.getUrl();
            StringBuffer accessKey = new StringBuffer("null");
            if (null != configBlackholeApiForm.getUserName()) {
                accessKey = new StringBuffer(configBlackholeApiForm.getUserName());
            }
            StringBuffer secretKey = new StringBuffer(this.dataProtectService.sdpDecrypt(configBlackholeApiForm.getPassword(), 0L));
            if ("CTCC".equals(serviceProvider)) {
                try {
                    stoptDivertBlackholeForm.setServiceProvider(serviceProvider);
                    stoptDivertBlackholeForm.setDeviceIP("--");
                    stoptDivertBlackholeForm.setDeviceName("--");
                    stoptDivertBlackholeForm.setZoneId(zoneId);
                    if (this.isNotifyReleaseFirst()) {
                        this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                    }
                    CloudCleanUtil.getInstance();
                    CloudCleanUtil.disableCloudClean4CTCC(url, accessKey, secretKey, ip, configBlackholeApiForm.getCertAlias());
                    if (!this.isNotifyReleaseFirst()) {
                        this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                    }
                    divertBlackholeForm.setEnableStatus(0);
                    if (divertBlackholeForm.getMode() == 1) {
                        this.logger.info((Object)("timeout, this is dynamic blackhole API, remove it. ip : " + stoptDivertBlackholeForm.getBlackIP()));
                        this.removeDivertBlackhole(stoptDivertBlackholeForm);
                    } else {
                        this.logger.info((Object)("timeout, this is static blackhole API, only update it. ip : " + stoptDivertBlackholeForm.getBlackIP()));
                        this.updateDivertPolicy(divertBlackholeForm);
                    }
                    if (!isRestful) {
                        this.addOperaLog(0L, stoptDivertBlackholeForm);
                    }
                    this.sendBlackholeAPIAlarm(stoptDivertBlackholeForm, true);
                }
                catch (LegoCheckedException e) {
                    this.sendBlackholeAPIAlarm(stoptDivertBlackholeForm, true);
                    this.sendBlackholeAPIAlarm(stoptDivertBlackholeForm, false);
                    this.logger.error((Object)("stopAndDeleteDivertBlackhole CTCC error." + e.getMessage()));
                }
                catch (Exception e) {
                    this.sendBlackholeAPIAlarm(stoptDivertBlackholeForm, true);
                    this.sendBlackholeAPIAlarm(stoptDivertBlackholeForm, false);
                    this.logger.error((Object)("stopAndDeleteDivertBlackhole CTCC fail." + e.getMessage()));
                }
            }
        } else {
            try {
                AticDevice device = this.checkNEByMoId(stoptDivertBlackholeForm.getDeviceId());
                stoptDivertBlackholeForm.setDeviceIP(device.getIpAddress());
                stoptDivertBlackholeForm.setDeviceName(device.getName());
                stoptDivertBlackholeForm.setServiceProvider("--");
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 571811L) {
                    try {
                        this.removeDivertBlackhole(stoptDivertBlackholeForm);
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)e.getMessage());
                    }
                }
                throw e;
            }
            boolean canDeploy = true;
            int deployTimes = 0;
            while (canDeploy) {
                this.logger.info((Object)("DeployTimes = " + ++deployTimes));
                canDeploy = false;
                DeviceProxy proxy = null;
                try {
                    if (this.isNotifyReleaseFirst()) {
                        this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                    }
                    proxy = DeviceProxyFactory.createDeviceProxy(stoptDivertBlackholeForm.getDeviceId(), this.aticDeviceService);
                    boolean isDel = true;
                    this.exeCmdStopSingleDivertBlackhole(stoptDivertBlackholeForm, proxy, isDel);
                    if (!this.isNotifyReleaseFirst()) {
                        this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                    }
                    if (!isRestful) {
                        this.addOperaLog(0L, stoptDivertBlackholeForm);
                    }
                    this.sendBlackholeAlarm(stoptDivertBlackholeForm, true);
                    DivertBlackholeForm divertBlackholeForm2 = stoptDivertBlackholeForm;
                    this.closeProxyAndUnLockDevice(stoptDivertBlackholeForm.getDeviceId(), proxy);
                    return divertBlackholeForm2;
                }
                catch (Throwable throwable) {
                    try {
                        this.closeProxyAndUnLockDevice(stoptDivertBlackholeForm.getDeviceId(), proxy);
                        throw throwable;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)e.getMessage());
                        if (!isRestful) {
                            this.addOperaLog(e.getErrorCode(), stoptDivertBlackholeForm);
                        }
                        if (deployTimes >= 3) {
                            this.sendBlackholeAlarm(stoptDivertBlackholeForm, false);
                            throw e;
                        }
                        canDeploy = true;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error((Object)("Failed to undeploy and need retry, Failed times = " + deployTimes));
                        }
                        this.logger.info((Object)("Failed to undeploy and need retry, Failed times = " + deployTimes));
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage());
                        if (!isRestful) {
                            this.addOperaLog(1L, stoptDivertBlackholeForm);
                        }
                        if (deployTimes >= 3) {
                            this.sendBlackholeAlarm(stoptDivertBlackholeForm, false);
                            throw new LegoCheckedException(571805L, (Throwable)e);
                        }
                        canDeploy = true;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error((Object)("Failed to undeploy and need retry, Failed times = " + deployTimes));
                        }
                        this.logger.info((Object)("Failed to undeploy and need retry, Failed times = " + deployTimes));
                    }
                }
            }
        }
        return stoptDivertBlackholeForm;
    }

    private boolean ipFlowBiggerBlackholeThreshold(ZonePolicyApplyForm zonePolicyApplyForm, String blackholeIp) {
        List deviceForms = zonePolicyApplyForm.getZoneDeviceForms();
        Long blackholeThreashold = zonePolicyApplyForm.getBlackholeThreshold();
        HashMap<Long, CollectorInfo> collectorMap = new HashMap<Long, CollectorInfo>();
        for (ZoneDeviceForm devForm : deviceForms) {
            DataStatService client;
            Long collectId = this.collectorDeviceService.getCollectorIdByDevId(devForm.getDeviceId());
            if (null == collectId) {
                this.logger.warn((Object)("ipFlowBiggerBlackholeThreshold error for: collector id is not found in t_collector_device table, deviceId : " + devForm.getDeviceId()));
                continue;
            }
            CollectorInfo collectorInfo = (CollectorInfo)collectorMap.get(collectId);
            if (null == collectorInfo) {
                collectorInfo = this.collectorService.getCollectorInfo(collectId.longValue());
                if (null == collectorInfo) continue;
                collectorMap.put(collectId, collectorInfo);
            }
            if (null == (client = this.collectorRMIProxy.getDataStatService(collectorInfo.getIpAddress()))) {
                this.logger.warn((Object)("get collector service failed! collector ip:" + collectorInfo.getIpAddress()));
                continue;
            }
            try {
                Long ipInFlow = client.get70secIpInboundInFLow(devForm.getDeviceIp(), blackholeIp, devForm.getDdosType(), zonePolicyApplyForm.getZoneId().longValue());
                if (ipInFlow == null || ipInFlow <= blackholeThreashold) continue;
                this.logger.warn((Object)("The blackhole cannot stop when timeout because of ipInflow>blackholeThreashold, ipInfolow=" + ipInFlow + ", blackholeThreadshold=" + blackholeThreashold + ", blackholeIp=" + blackholeIp + "deviceIP=" + devForm.getDeviceIp() + ", deviceType=" + devForm.getDdosType() + ", zoneId=" + zonePolicyApplyForm.getZoneId()));
                return true;
            }
            catch (RemoteException e) {
                this.logger.error((Object)("get70secIpInboundInFLow error from collcetor " + collectorInfo.getIpAddress() + ", blackholeIp=" + blackholeIp + ", e.getMessage=" + e.getMessage()));
            }
        }
        return false;
    }

    private void sendBlackholeAPIAlarm(DivertBlackholeForm stoptDivertBlackholeForm, boolean isSuccess) {
        IConfigBlackholeService service = (IConfigBlackholeService)ServiceContext.getInstance().getService("configBlackholeService", IConfigBlackholeService.class);
        ConfigBlackholeApiForm configApi = service.getConfigApi(stoptDivertBlackholeForm.getServiceProvider());
        int unBlockTime = configApi.getUnblockTime();
        String isp = configApi.getServiceProvider();
        if (isSuccess) {
            this.blackholeAlarmHandler.clearBlackholeAPIAlarm(stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getZoneId(), unBlockTime, isp);
        } else {
            this.blackholeAlarmHandler.disableBlackholeAPIFailedAlarm(stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getDeviceId(), unBlockTime, isp);
        }
    }

    private void sendBlackholeAlarm(DivertBlackholeForm stoptDivertBlackholeForm, boolean isSuccess) {
        if (isSuccess) {
            String zoneName = AticDiversionUtil.getZoneInfoByIpMask(stoptDivertBlackholeForm.getBlackIP(), Integer.parseInt(stoptDivertBlackholeForm.getBlackMask()));
            if (2 == stoptDivertBlackholeForm.getBlackholeMode()) {
                if (null != stoptDivertBlackholeForm.getBlackholeType() && stoptDivertBlackholeForm.getBlackholeType() == 1) {
                    String npIp = stoptDivertBlackholeForm.getBlackIP() + "/" + stoptDivertBlackholeForm.getBlackMask();
                    Map divertBlackholeNpMap = this.blackholeNpDao.blackholeNpByEnableStatus();
                    ConfigBlackholeNp configBlackholeNp = (ConfigBlackholeNp)divertBlackholeNpMap.get(npIp);
                    this.blackholeAlarmHandler.blackholeNpAlarmBoardClear(stoptDivertBlackholeForm, configBlackholeNp);
                } else {
                    this.blackholeAlarmHandler.blackholeAlarmBoardClear(stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getDeviceId());
                }
            } else {
                this.blackholeAlarmHandler.blackholeAlarmClear(zoneName, stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), IPUtil.compressIPv6((String)stoptDivertBlackholeForm.getBlackIP()) + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getDeviceId());
            }
        } else {
            String zoneName = AticDiversionUtil.getZoneInfoByIpMask(stoptDivertBlackholeForm.getBlackIP(), Integer.parseInt(stoptDivertBlackholeForm.getBlackMask()));
            if (2 == stoptDivertBlackholeForm.getBlackholeMode()) {
                if (null == stoptDivertBlackholeForm.getBlackholeType() || stoptDivertBlackholeForm.getBlackholeType() != 1) {
                    this.blackholeAlarmHandler.blackholeAlarmBoardReportStopFailed(stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getDeviceId());
                }
            } else {
                this.blackholeAlarmHandler.blackholeAlarmReportStopFailed(zoneName, stoptDivertBlackholeForm.getDeviceName(), IPUtil.compressIPv6((String)stoptDivertBlackholeForm.getBlackIP()) + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getDeviceId());
            }
        }
    }

    private void sendBlackholeStartAlarm(DivertBlackholeForm stoptDivertBlackholeForm) {
        String zoneName = AticDiversionUtil.getZoneInfoByIpMask(stoptDivertBlackholeForm.getBlackIP(), Integer.parseInt(stoptDivertBlackholeForm.getBlackMask()));
        if (2 == stoptDivertBlackholeForm.getBlackholeMode()) {
            if (null != stoptDivertBlackholeForm.getBlackholeType() && stoptDivertBlackholeForm.getBlackholeType() == 1) {
                String npIp = stoptDivertBlackholeForm.getBlackIP() + "/" + stoptDivertBlackholeForm.getBlackMask();
                Map divertBlackholeNpMap = this.blackholeNpDao.blackholeNpByEnableStatus();
                ConfigBlackholeNp configBlackholeNp = (ConfigBlackholeNp)divertBlackholeNpMap.get(npIp);
                this.blackholeAlarmHandler.blackholeNpAlarmBoardReport(stoptDivertBlackholeForm, configBlackholeNp);
            } else {
                this.blackholeAlarmHandler.blackholeAlarmBoardReport(stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getDeviceId());
            }
        } else {
            this.blackholeAlarmHandler.blackholeAlarmReport(zoneName, stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getDeviceId());
        }
    }

    @Override
    public DivertBlackholeForm stopAndDeleteDivertBlackholeVty(DivertBlackholeForm divertBlackholeForm) {
        if (null == divertBlackholeForm || null == divertBlackholeForm.getId()) {
            throw new LegoCheckedException(571809L);
        }
        DivertBlackholeForm stoptDivertBlackholeForm = this.getDivertBlackholeByIdWithoutNEInfo(divertBlackholeForm.getId());
        ZonePolicyApplyForm zonePolicyApplyForm = this.getZonePolicyForm(divertBlackholeForm);
        if (null == divertBlackholeForm.getEnableStatus() || divertBlackholeForm.getEnableStatus() != 1) {
            if (2 == zonePolicyApplyForm.getBlackholeMode()) {
                this.sendBlackHoleIp(divertBlackholeForm, "unblock");
            }
            this.removeDivertBlackhole(stoptDivertBlackholeForm);
            return stoptDivertBlackholeForm;
        }
        Long deviceId = stoptDivertBlackholeForm.getDeviceId();
        String serviceProvider = stoptDivertBlackholeForm.getServiceProvider();
        if (null == deviceId && !"".equals(serviceProvider)) {
            String ip = stoptDivertBlackholeForm.getBlackIP();
            ConfigBlackholeApiForm configBlackholeApiForm = this.configBlackholeService.getConfigApi(serviceProvider);
            String url = configBlackholeApiForm.getUrl();
            StringBuffer accessKey = new StringBuffer("null");
            if (null != configBlackholeApiForm.getUserName()) {
                accessKey = new StringBuffer(configBlackholeApiForm.getUserName());
            }
            StringBuffer secretKey = new StringBuffer(this.dataProtectService.sdpDecrypt(configBlackholeApiForm.getPassword(), 0L));
            if ("CTCC".equals(serviceProvider)) {
                try {
                    if (this.isNotifyReleaseFirst()) {
                        this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                        this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                    }
                    CloudCleanUtil.getInstance();
                    CloudCleanUtil.disableCloudClean4CTCC(url, accessKey, secretKey, ip, configBlackholeApiForm.getCertAlias());
                    if (!this.isNotifyReleaseFirst()) {
                        this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                        this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                    }
                    divertBlackholeForm.setEnableStatus(0);
                    this.removeDivertBlackhole(stoptDivertBlackholeForm);
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)("stopAndDeleteDivertBlackhole CTCC error." + e.getMessage()));
                }
                catch (Exception e) {
                    this.logger.error((Object)("stopAndDeleteDivertBlackhole CTCC fail." + e.getMessage()));
                }
            }
        } else {
            try {
                AticDevice device = this.checkNEByMoId(stoptDivertBlackholeForm.getDeviceId());
                stoptDivertBlackholeForm.setDeviceIP(device.getIpAddress());
                stoptDivertBlackholeForm.setDeviceName(device.getName());
                stoptDivertBlackholeForm.setServiceProvider("--");
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 571811L) {
                    try {
                        this.removeDivertBlackhole(stoptDivertBlackholeForm);
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)e.getMessage());
                    }
                }
                throw e;
            }
            try {
                if (this.isNotifyReleaseFirst()) {
                    this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                }
                boolean isDel = true;
                this.exeCmdStopSingleDivertBlackholeVty(stoptDivertBlackholeForm, isDel);
                if (!this.isNotifyReleaseFirst()) {
                    this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                }
                return stoptDivertBlackholeForm;
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571804L, (Throwable)e);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571805L, (Throwable)e);
            }
        }
        return stoptDivertBlackholeForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchOperationResult stopDivertBlackholes(List<BatchOperation> boList) {
        if (this.isCollectionEmpty(boList)) {
            throw new LegoCheckedException(571809L);
        }
        BatchOperationResult result = new BatchOperationResult();
        result.setResult(boList);
        Map<String, List<BatchOperation>> divertBlackholesMap = this.groupDivertBlackholesByDevice(result);
        int fail = result.getFailCount();
        Set<Map.Entry<String, List<BatchOperation>>> set = divertBlackholesMap.entrySet();
        for (Map.Entry<String, List<BatchOperation>> entry : set) {
            List<BatchOperation> deviceBoList = entry.getValue();
            try {
                for (BatchOperation bo : deviceBoList) {
                    DivertBlackholeForm divertBlackholeForm = (DivertBlackholeForm)bo.getExtTargetId();
                    String ip = divertBlackholeForm.getBlackIP();
                    String key = divertBlackholeForm.getServiceProvider();
                    ConfigBlackholeApiForm configBlackholeApiForm = this.configBlackholeService.getConfigApi(key);
                    String url = configBlackholeApiForm.getUrl();
                    StringBuffer accessKey = new StringBuffer("null");
                    if (null != configBlackholeApiForm.getUserName()) {
                        accessKey = new StringBuffer(configBlackholeApiForm.getUserName());
                    }
                    StringBuffer secretKey = new StringBuffer(this.dataProtectService.sdpDecrypt(configBlackholeApiForm.getPassword(), 0L));
                    ZonePolicyApplyForm zonePolicyApplyForm = this.getZonePolicyForm(divertBlackholeForm);
                    if ("CTCC".equals(key)) {
                        try {
                            if (this.isNotifyReleaseFirst() && (1 != divertBlackholeForm.getMode() || 2 != zonePolicyApplyForm.getBlackholeMode())) {
                                this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                                this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                            }
                            CloudCleanUtil.getInstance();
                            CloudCleanUtil.disableCloudClean4CTCC(url, accessKey, secretKey, ip, configBlackholeApiForm.getCertAlias());
                            if (!(this.isNotifyReleaseFirst() || 1 == divertBlackholeForm.getMode() && 2 == zonePolicyApplyForm.getBlackholeMode())) {
                                this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                                this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                            }
                            divertBlackholeForm.setEnableStatus(0);
                            this.updateDivertPolicy(divertBlackholeForm);
                        }
                        catch (LegoCheckedException e) {
                            this.batchDivertBlackholeFailed(e.getErrorCode(), e.getParameters(), e.getMessage(), deviceBoList);
                            fail += deviceBoList.size();
                            this.logger.error((Object)"disable CTCC error");
                        }
                        catch (Exception e) {
                            this.batchDivertBlackholeFailed(571805L, null, e.getMessage(), deviceBoList);
                            fail += deviceBoList.size();
                            this.logger.error((Object)"disable CTCC fail");
                        }
                        continue;
                    }
                    Long deviceId = divertBlackholeForm.getDeviceId();
                    AticDevice device = this.checkNEByMoId(deviceId);
                    DeviceProxy proxy = null;
                    try {
                        proxy = DeviceProxyFactory.createDeviceProxy(deviceId, this.aticDeviceService);
                        if (bo.getErrorCode() > 0L) {
                            this.logger.error((Object)"bo has error");
                            continue;
                        }
                        try {
                            if (this.isNotifyReleaseFirst() && (1 != divertBlackholeForm.getMode() || 2 != zonePolicyApplyForm.getBlackholeMode())) {
                                this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                            }
                            divertBlackholeForm.setDeviceIP(device.getIpAddress());
                            divertBlackholeForm.setDeviceName(device.getName());
                            boolean isDel = false;
                            this.exeCmdStopSingleDivertBlackhole(divertBlackholeForm, proxy, isDel);
                            if (this.isNotifyReleaseFirst() || 1 == divertBlackholeForm.getMode() && 2 == zonePolicyApplyForm.getBlackholeMode()) continue;
                            this.sendBlackHoleIp(divertBlackholeForm, "unblock");
                        }
                        catch (DataAccessException e) {
                            ++fail;
                            bo.setErrorCode(571804L);
                            this.logger.error((Object)e.getMessage());
                        }
                        catch (LegoCheckedException e) {
                            ++fail;
                            bo.setErrorCode(e.getErrorCode());
                            bo.setDetailParam(e.getParameters());
                            this.logger.error((Object)e.getMessage());
                        }
                        catch (Exception e) {
                            ++fail;
                            bo.setErrorCode(571805L);
                            this.logger.error((Object)e.getMessage());
                        }
                    }
                    finally {
                        this.closeProxyAndUnLockDevice(deviceId, proxy);
                    }
                }
            }
            catch (LegoCheckedException e) {
                this.batchDivertBlackholeFailed(e.getErrorCode(), e.getParameters(), e.getMessage(), deviceBoList);
                fail += deviceBoList.size();
                this.logger.error((Object)e.getMessage());
            }
            catch (RuntimeException e) {
                this.batchDivertBlackholeFailed(571805L, null, e.getMessage(), deviceBoList);
                fail += deviceBoList.size();
                this.logger.error((Object)e.getMessage());
            }
        }
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("Batch stop DivertBlackhole result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    private void exeCmdStopSingleDivertBlackhole(DivertBlackholeForm stoptDivertBlackholeForm, DeviceProxy proxy, boolean isDel) {
        block11: {
            Integer errorCode = 0;
            LegoCheckedException exception = null;
            Integer enableStatusDB = null;
            try {
                enableStatusDB = this.updateDivertPolicy(stoptDivertBlackholeForm);
                String command = null;
                command = 2 == stoptDivertBlackholeForm.getBlackholeMode() ? AticDiversionUtil.getDivertBoardBlackholeCommand(stoptDivertBlackholeForm, COMMAND_UNDEPLOY_DIVERT_BLACKHOLE_ID) : AticDiversionUtil.getDivertBlackholeCommand(stoptDivertBlackholeForm, COMMAND_UNDEPLOY_DIVERT_BLACKHOLE_ID);
                this.logger.info((Object)("undeploy command is " + this.getcleanedMessage(command)));
                String cmdResult = proxy.executeCommand(command);
                this.logger.info((Object)("undeploy cmdResult is " + cmdResult));
                errorCode = this.cmdResult(cmdResult);
                this.logger.info((Object)("undeploy command result errorCode  is " + errorCode));
                this.checkCmdResult(errorCode, cmdResult);
                this.logger.info((Object)("start to clear blachole divert alarm. stoptDivertBlackholeForm:" + this.getcleanedMessage(stoptDivertBlackholeForm.toString())));
                this.sendBlackholeAlarm(stoptDivertBlackholeForm, true);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 571802L) {
                    errorCode = 1;
                    this.logger.warn((Object)e.getMessage());
                    break block11;
                }
                if (isDel && errorCode == 571814) {
                    errorCode = 1;
                    this.logger.warn((Object)e.getMessage());
                    break block11;
                }
                errorCode = Integer.valueOf(String.valueOf(e.getErrorCode()));
                exception = e;
                throw exception;
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage());
                errorCode = 571804;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
                errorCode = 571805;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            finally {
                Integer enableStatus = this.resetDivertBlackholeStatus(errorCode, false, enableStatusDB);
                this.blackholeOperCompleted(stoptDivertBlackholeForm, 2, enableStatus, errorCode);
                if (isDel && (errorCode == 1 || errorCode == 571811)) {
                    this.removeDivertBlackhole(stoptDivertBlackholeForm);
                }
            }
        }
    }

    private void exeCmdStopSingleDivertBlackholeVty(DivertBlackholeForm stoptDivertBlackholeForm, boolean isDel) {
        block15: {
            Integer errorCode = 0;
            LegoCheckedException exception = null;
            Integer enableStatusDB = null;
            try {
                enableStatusDB = this.updateDivertPolicy(stoptDivertBlackholeForm);
                String command = null;
                command = 2 == stoptDivertBlackholeForm.getBlackholeMode() ? AticDiversionUtil.getDivertBoardBlackholeCommand(stoptDivertBlackholeForm, COMMAND_UNDEPLOY_DIVERT_BLACKHOLE_ID) : AticDiversionUtil.getDivertBlackholeCommand(stoptDivertBlackholeForm, COMMAND_UNDEPLOY_DIVERT_BLACKHOLE_ID);
                this.logger.info((Object)("undeploy command is " + this.getcleanedMessage(command)));
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add("return");
                cmdList.add("system");
                cmdList.add(command);
                String cmdResult = (String)CmdUtil.execCmds((long)stoptDivertBlackholeForm.getDeviceId(), cmdList).get(2);
                this.logger.info((Object)("undeploy cmdResult is " + cmdResult));
                errorCode = this.cmdResult(cmdResult);
                this.logger.info((Object)("undeploy command result errorCode  is " + errorCode));
                this.checkCmdResult(errorCode, cmdResult);
                this.logger.info((Object)("start to clear blachole divert alarm. stoptDivertBlackholeForm:" + this.getcleanedMessage(stoptDivertBlackholeForm.toString())));
                String zoneName = AticDiversionUtil.getZoneInfoByIpMask(stoptDivertBlackholeForm.getBlackIP(), Integer.parseInt(stoptDivertBlackholeForm.getBlackMask()));
                if (2 == stoptDivertBlackholeForm.getBlackholeMode()) {
                    if (null != stoptDivertBlackholeForm.getBlackholeType() && stoptDivertBlackholeForm.getBlackholeType() == 1) {
                        String npIp = stoptDivertBlackholeForm.getBlackIP() + "/" + stoptDivertBlackholeForm.getBlackMask();
                        Map divertBlackholeNpMap = this.blackholeNpDao.blackholeNpByEnableStatus();
                        ConfigBlackholeNp configBlackholeNp = (ConfigBlackholeNp)divertBlackholeNpMap.get(npIp);
                        this.blackholeAlarmHandler.blackholeNpAlarmBoardClear(stoptDivertBlackholeForm, configBlackholeNp);
                    } else {
                        this.blackholeAlarmHandler.blackholeAlarmBoardClear(stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getDeviceId());
                    }
                } else {
                    this.blackholeAlarmHandler.blackholeAlarmClear(zoneName, stoptDivertBlackholeForm.getDeviceName(), stoptDivertBlackholeForm.getDeviceIP(), stoptDivertBlackholeForm.getBlackIP() + '/' + stoptDivertBlackholeForm.getBlackMask(), stoptDivertBlackholeForm.getVpn(), stoptDivertBlackholeForm.getDeviceId());
                }
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 571802L) {
                    errorCode = 1;
                    this.logger.warn((Object)e.getMessage());
                    break block15;
                }
                if (isDel && errorCode == 571814) {
                    errorCode = 1;
                    this.logger.warn((Object)e.getMessage());
                    break block15;
                }
                errorCode = Integer.valueOf(String.valueOf(e.getErrorCode()));
                exception = e;
                throw exception;
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage());
                errorCode = 571804;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
                errorCode = 571805;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            finally {
                Integer enableStatus = this.resetDivertBlackholeStatus(errorCode, false, enableStatusDB);
                this.blackholeOperCompleted(stoptDivertBlackholeForm, 2, enableStatus, errorCode);
                if (isDel && (errorCode == 1 || errorCode == 571811)) {
                    this.removeDivertBlackhole(stoptDivertBlackholeForm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCurrentDevice(Long deviceId) {
        Set<Long> set = currentDeviceSet;
        synchronized (set) {
            currentDeviceSet.remove(deviceId);
        }
    }

    private AticDevice checkNEByMoId(Long deviceId) {
        if (null == deviceId) {
            throw new LegoCheckedException(571812L);
        }
        AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null == device) {
            throw new LegoCheckedException(571811L);
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DivertBlackholeForm stopSingleDivertBlackhole(DivertBlackholeForm divertBlackholeForm) {
        if (null == divertBlackholeForm || null == divertBlackholeForm.getId()) {
            throw new LegoCheckedException(571809L);
        }
        DivertBlackholeForm stoptDivertBlackholeForm = null;
        stoptDivertBlackholeForm = this.getDivertBlackholeByIdWithoutNEInfo(divertBlackholeForm.getId());
        AticDevice device = this.checkNEByMoId(stoptDivertBlackholeForm.getDeviceId());
        stoptDivertBlackholeForm.setDeviceIP(device.getIpAddress());
        stoptDivertBlackholeForm.setDeviceName(device.getName());
        DeviceProxy proxy = null;
        try {
            proxy = DeviceProxyFactory.createDeviceProxy(stoptDivertBlackholeForm.getDeviceId(), this.aticDeviceService);
            boolean isDel = false;
            this.exeCmdStopSingleDivertBlackhole(stoptDivertBlackholeForm, proxy, isDel);
            DivertBlackholeForm divertBlackholeForm2 = stoptDivertBlackholeForm;
            this.closeProxyAndUnLockDevice(stoptDivertBlackholeForm.getDeviceId(), proxy);
            return divertBlackholeForm2;
        }
        catch (Throwable throwable) {
            try {
                this.closeProxyAndUnLockDevice(stoptDivertBlackholeForm.getDeviceId(), proxy);
                throw throwable;
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571804L, (Throwable)e);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571805L, (Throwable)e);
            }
        }
    }

    private DivertBlackholeForm getDivertBlackholeByIdWithoutNEInfo(Long id) {
        DivertBlackhole divertBlackhole = this.divertBlackholeDao.get(id);
        if (null == divertBlackhole) {
            throw new LegoCheckedException(571803L);
        }
        DivertBlackholeForm divertBlackholeForm = (DivertBlackholeForm)AticUtil.copyProperties((Object)divertBlackhole, (Object)new DivertBlackholeForm());
        return divertBlackholeForm;
    }

    @Override
    public DivertBlackholeForm getDivertBlackholeById(Long id) {
        DivertBlackhole divertBlackhole = this.divertBlackholeDao.get(id);
        if (null == divertBlackhole) {
            throw new LegoCheckedException(571803L);
        }
        DivertBlackholeForm divertBlackholeForm = (DivertBlackholeForm)AticUtil.copyProperties((Object)divertBlackhole, (Object)new DivertBlackholeForm());
        try {
            Long deviceId = divertBlackhole.getDeviceId();
            if (null != deviceId) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                divertBlackholeForm.setDeviceName(device.getName());
                divertBlackholeForm.setDeviceIP(device.getIpAddress());
            } else {
                divertBlackholeForm.setDeviceIP("--");
                divertBlackholeForm.setBlackMask(divertBlackhole.getBlackMask());
                divertBlackholeForm.setServiceProvider(divertBlackhole.getServiceProvider());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        return divertBlackholeForm;
    }

    private Integer resetDivertBlackholeStatus(Integer errorCode, boolean isEnableDivertBlackhole, Integer enableStatusDB) {
        Integer enableStatus = null;
        enableStatus = errorCode == 1 ? (isEnableDivertBlackhole ? Integer.valueOf(1) : Integer.valueOf(0)) : (isEnableDivertBlackhole && errorCode == 571801 ? Integer.valueOf(1) : (!isEnableDivertBlackhole && errorCode == 571802 ? Integer.valueOf(0) : (errorCode == 571814 ? Integer.valueOf(0) : enableStatusDB)));
        return enableStatus;
    }

    private String getcleanedMessage(String message) {
        if (null == message) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void exeCmdStartDivertBlackhole(DivertBlackholeForm startDivertBlackholeForm, DeviceProxy proxy) {
        block9: {
            Integer errorCode = 0;
            LegoCheckedException exception = null;
            Integer enableStatusDB = null;
            try {
                enableStatusDB = this.updateDivertPolicy(startDivertBlackholeForm);
                String command = null;
                command = 2 == startDivertBlackholeForm.getBlackholeMode() ? AticDiversionUtil.getDivertBoardBlackholeCommand(startDivertBlackholeForm, COMMAND_DEPLOY_DIVERT_BLACKHOLE_ID) : AticDiversionUtil.getDivertBlackholeCommand(startDivertBlackholeForm, COMMAND_DEPLOY_DIVERT_BLACKHOLE_ID);
                this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
                String cmdResult = proxy.executeCommand(command);
                this.logger.info((Object)("deploy cmdResult is " + this.getcleanedMessage(cmdResult)));
                errorCode = this.cmdResult(cmdResult);
                this.logger.info((Object)("deploy command result errorCode  is " + errorCode));
                this.checkCmdResult(errorCode, cmdResult);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 571801L) {
                    errorCode = 1;
                    this.logger.warn((Object)e.getMessage());
                    break block9;
                }
                errorCode = Integer.valueOf(String.valueOf(e.getErrorCode()));
                exception = e;
                throw exception;
            }
            catch (DataAccessException e) {
                errorCode = 571804;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            catch (Exception e) {
                errorCode = 571805;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            finally {
                Integer enableStatus = this.resetDivertBlackholeStatus(errorCode, true, enableStatusDB);
                this.blackholeOperCompleted(startDivertBlackholeForm, 1, enableStatus, errorCode);
            }
        }
    }

    private void exeCmdStartDivertBlackholeVty(DivertBlackholeForm startDivertBlackholeForm) {
        block9: {
            Integer errorCode = 0;
            LegoCheckedException exception = null;
            Integer enableStatusDB = null;
            try {
                enableStatusDB = this.updateDivertPolicy(startDivertBlackholeForm);
                String command = null;
                command = 2 == startDivertBlackholeForm.getBlackholeMode() ? AticDiversionUtil.getDivertBoardBlackholeCommand(startDivertBlackholeForm, COMMAND_DEPLOY_DIVERT_BLACKHOLE_ID) : AticDiversionUtil.getDivertBlackholeCommand(startDivertBlackholeForm, COMMAND_DEPLOY_DIVERT_BLACKHOLE_ID);
                this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add("return");
                cmdList.add("system");
                cmdList.add(command);
                String cmdResult = (String)CmdUtil.execCmds((long)startDivertBlackholeForm.getDeviceId(), cmdList).get(2);
                this.logger.info((Object)("deploy cmdResult is " + this.getcleanedMessage(cmdResult)));
                errorCode = this.cmdResult(cmdResult);
                this.logger.info((Object)("deploy command result errorCode  is " + errorCode));
                this.checkCmdResult(errorCode, cmdResult);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 571801L) {
                    errorCode = 1;
                    this.logger.warn((Object)e.getMessage());
                    break block9;
                }
                errorCode = Integer.valueOf(String.valueOf(e.getErrorCode()));
                exception = e;
                throw exception;
            }
            catch (DataAccessException e) {
                errorCode = 571804;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            catch (Exception e) {
                errorCode = 571805;
                exception = new LegoCheckedException((long)errorCode.intValue(), (Throwable)e);
                throw exception;
            }
            finally {
                Integer enableStatus = this.resetDivertBlackholeStatus(errorCode, true, enableStatusDB);
                this.blackholeOperCompleted(startDivertBlackholeForm, 1, enableStatus, errorCode);
            }
        }
    }

    private void closeProxyAndUnLockDevice(Long deviceId, DeviceProxy proxy) {
        try {
            try {
                if (proxy != null) {
                    proxy.close();
                }
            }
            finally {
                DivertBlackholeServiceImpl.removeCurrentDevice(deviceId);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DivertBlackholeForm startDivertBlackhole(DivertBlackholeForm divertBlackholeForm) {
        AticDevice device;
        Long deviceId;
        DivertBlackholeForm startDivertBlackholeForm;
        block22: {
            if (null == divertBlackholeForm || null == divertBlackholeForm.getId()) {
                throw new LegoCheckedException(571809L);
            }
            startDivertBlackholeForm = null;
            DeviceProxy proxy = null;
            try {
                startDivertBlackholeForm = this.getDivertBlackholeByIdWithoutNEInfo(divertBlackholeForm.getId());
                deviceId = startDivertBlackholeForm.getDeviceId();
                if (null == deviceId) {
                    String serviceProvider = startDivertBlackholeForm.getServiceProvider();
                    HashMap<String, String> params = new HashMap<String, String>();
                    String ip = startDivertBlackholeForm.getBlackIP();
                    String mask = startDivertBlackholeForm.getBlackMask();
                    ConfigBlackholeApiForm configBlackholeApiForm = this.configBlackholeService.getConfigApi(serviceProvider);
                    String url = configBlackholeApiForm.getUrl();
                    StringBuffer accessKey = new StringBuffer("null");
                    if (null != configBlackholeApiForm.getUserName()) {
                        accessKey = new StringBuffer(configBlackholeApiForm.getUserName());
                    }
                    StringBuffer secretKey = new StringBuffer(this.dataProtectService.sdpDecrypt(configBlackholeApiForm.getPassword(), 0L));
                    String defendScope = configBlackholeApiForm.getDefendScope();
                    Integer unblockTime = configBlackholeApiForm.getUnblockTime();
                    params.put("ipMask", ip + "/" + mask);
                    params.put("unblockTime", String.valueOf(unblockTime * 60));
                    if (!"CTCC".equals(serviceProvider)) break block22;
                    params.put("zone", defendScope);
                    params.put("alias", configBlackholeApiForm.getCertAlias());
                    try {
                        ZonePolicyApplyForm zonePolicyApplyForm = this.getZonePolicyForm(divertBlackholeForm);
                        startDivertBlackholeForm.setDynamicBlackholeMode(zonePolicyApplyForm.getBlackholeMode());
                        if (this.isNotifyFirst()) {
                            this.sendBlackHoleIp(divertBlackholeForm, "block");
                        }
                        if (0 == divertBlackholeForm.getMode() || 1 == zonePolicyApplyForm.getBlackholeMode() || 2 == zonePolicyApplyForm.getBlackholeMode() && !divertBlackholeForm.isFlowTrigger()) {
                            CloudCleanUtil.getInstance().enableCloudClean4CTCC(url, accessKey, secretKey, params);
                            divertBlackholeForm.setEnableStatus(1);
                        }
                        if (!this.isNotifyFirst()) {
                            this.sendBlackHoleIp(divertBlackholeForm, "block");
                        }
                        this.updateDivertPolicy(divertBlackholeForm);
                        break block22;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)("enable CTCC fail." + e.getMessage()));
                        throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("enable CTCC fail." + e.getMessage()));
                        throw new LegoCheckedException(571805L, (Throwable)e);
                    }
                }
                device = this.checkNEByMoId(deviceId);
                startDivertBlackholeForm.setDeviceIP(device.getIpAddress());
                startDivertBlackholeForm.setDeviceName(device.getName());
                startDivertBlackholeForm.setServiceProvider("--");
                ZonePolicyApplyForm zonePolicyApplyForm = this.getZonePolicyForm(divertBlackholeForm);
                startDivertBlackholeForm.setDynamicBlackholeMode(zonePolicyApplyForm.getBlackholeMode());
                try {
                    if (this.isNotifyFirst()) {
                        this.sendBlackHoleIp(divertBlackholeForm, "block");
                    }
                    this.logger.info((Object)("zonePolicyApplyForm : " + zonePolicyApplyForm));
                    if (0 == divertBlackholeForm.getMode() || 1 == zonePolicyApplyForm.getBlackholeMode() || 2 == zonePolicyApplyForm.getBlackholeMode() && !divertBlackholeForm.isFlowTrigger()) {
                        proxy = DeviceProxyFactory.createDeviceProxy(deviceId, this.aticDeviceService);
                        this.exeCmdStartDivertBlackhole(startDivertBlackholeForm, proxy);
                    }
                    if (!this.isNotifyFirst()) {
                        this.sendBlackHoleIp(divertBlackholeForm, "block");
                    }
                    this.closeProxyAndUnLockDevice(deviceId, proxy);
                }
                catch (Throwable throwable) {
                    this.closeProxyAndUnLockDevice(deviceId, proxy);
                    throw throwable;
                }
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571804L, (Throwable)e);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)e.getMessage());
                throw e;
            }
            catch (RuntimeException e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571805L, (Throwable)e);
            }
        }
        if (null == startDivertBlackholeForm.getDeviceId()) {
            startDivertBlackholeForm.setDeviceIP("--");
            startDivertBlackholeForm.setDeviceId(null);
            startDivertBlackholeForm.setDeviceName("--");
            startDivertBlackholeForm.setEnableStatus(divertBlackholeForm.getEnableStatus());
        } else {
            try {
                deviceId = startDivertBlackholeForm.getDeviceId();
                device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                startDivertBlackholeForm.setDeviceName(device.getName());
                startDivertBlackholeForm.setDeviceIP(device.getIpAddress());
                startDivertBlackholeForm.setEnableStatus(divertBlackholeForm.getEnableStatus());
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"aticDeviceService.getDeviceByMoid error");
            }
        }
        return startDivertBlackholeForm;
    }

    @Override
    public DivertBlackholeForm startDivertBlackholeVty(DivertBlackholeForm divertBlackholeForm) {
        DivertBlackholeForm startDivertBlackholeForm;
        block14: {
            if (null == divertBlackholeForm || null == divertBlackholeForm.getId()) {
                throw new LegoCheckedException(571809L);
            }
            startDivertBlackholeForm = null;
            try {
                startDivertBlackholeForm = this.getDivertBlackholeByIdWithoutNEInfo(divertBlackholeForm.getId());
                Long deviceId = startDivertBlackholeForm.getDeviceId();
                if (null == deviceId) {
                    String serviceProvider = startDivertBlackholeForm.getServiceProvider();
                    HashMap<String, String> params = new HashMap<String, String>();
                    String ip = startDivertBlackholeForm.getBlackIP();
                    String mask = startDivertBlackholeForm.getBlackMask();
                    ConfigBlackholeApiForm configBlackholeApiForm = this.configBlackholeService.getConfigApi(serviceProvider);
                    String url = configBlackholeApiForm.getUrl();
                    StringBuffer accessKey = new StringBuffer("null");
                    if (null != configBlackholeApiForm.getUserName()) {
                        accessKey = new StringBuffer(configBlackholeApiForm.getUserName());
                    }
                    StringBuffer secretKey = new StringBuffer(this.dataProtectService.sdpDecrypt(configBlackholeApiForm.getPassword(), 0L));
                    String defendScope = configBlackholeApiForm.getDefendScope();
                    Integer unblockTime = configBlackholeApiForm.getUnblockTime();
                    params.put("ipMask", ip + "/" + mask);
                    params.put("unblockTime", String.valueOf(unblockTime * 60));
                    if (!"CTCC".equals(serviceProvider)) break block14;
                    params.put("zone", defendScope);
                    params.put("alias", configBlackholeApiForm.getCertAlias());
                    try {
                        if (this.isNotifyFirst()) {
                            this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                            this.sendBlackHoleIp(divertBlackholeForm, "block");
                        }
                        CloudCleanUtil.getInstance().enableCloudClean4CTCC(url, accessKey, secretKey, params);
                        if (!this.isNotifyFirst()) {
                            this.logger.info((Object)("mode: " + divertBlackholeForm.getMode()));
                            this.sendBlackHoleIp(divertBlackholeForm, "block");
                        }
                        divertBlackholeForm.setEnableStatus(1);
                        this.updateDivertPolicy(divertBlackholeForm);
                        break block14;
                    }
                    catch (LegoCheckedException e) {
                        this.logger.error((Object)("enable CTCC fail." + e.getMessage()));
                        throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("enable CTCC fail." + e.getMessage()));
                        throw new LegoCheckedException(571805L, (Throwable)e);
                    }
                }
                AticDevice device = this.checkNEByMoId(deviceId);
                startDivertBlackholeForm.setDeviceIP(device.getIpAddress());
                startDivertBlackholeForm.setDeviceName(device.getName());
                startDivertBlackholeForm.setServiceProvider("--");
                if (this.isNotifyFirst()) {
                    this.sendBlackHoleIp(divertBlackholeForm, "block");
                }
                this.exeCmdStartDivertBlackholeVty(startDivertBlackholeForm);
                if (!this.isNotifyFirst()) {
                    this.sendBlackHoleIp(divertBlackholeForm, "block");
                }
            }
            catch (DataAccessException e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571804L, (Throwable)e);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)e.getMessage());
                throw e;
            }
            catch (RuntimeException e) {
                this.logger.error((Object)e.getMessage());
                throw new LegoCheckedException(571805L, (Throwable)e);
            }
        }
        return startDivertBlackholeForm;
    }

    public List<DivertBlackholeForm> getDivertBlackholeFormByDeviceId(Long deviceId) {
        ArrayList<DivertBlackholeForm> result = new ArrayList<DivertBlackholeForm>();
        if (deviceId == null) {
            this.logger.warn((Object)"param deviceId is null.");
            return result;
        }
        List<DivertBlackhole> list = this.divertBlackholeDao.getDivertBlackholeByDeviceId(deviceId);
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (DivertBlackhole divertBlackhole : list) {
            DivertBlackholeForm form = (DivertBlackholeForm)AticUtil.copyProperties((Object)divertBlackhole, (Object)new DivertBlackholeForm());
            result.add(form);
        }
        return result;
    }

    @Override
    public List<DivertBlackholeForm> getDivertByBlackHoleMode(Map<String, String> conditionMap) {
        ArrayList<DivertBlackholeForm> result = new ArrayList<DivertBlackholeForm>();
        if (null == conditionMap) {
            this.logger.warn((Object)"param blackHoleModes is null.");
            return result;
        }
        List<DivertBlackhole> list = this.divertBlackholeDao.getDivertByBlackHoleMode(conditionMap);
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (DivertBlackhole divertBlackhole : list) {
            DivertBlackholeForm form = (DivertBlackholeForm)AticUtil.copyProperties((Object)divertBlackhole, (Object)new DivertBlackholeForm());
            result.add(form);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteBlackholesForDelNeMsgWithTryMax(AticDevice firewall, List<DivertBlackholeForm> result) {
        try {
            boolean retry = false;
            int count = 0;
            int max = 10;
            do {
                if (count > max) {
                    this.logger.error((Object)("deleteBlackholesForDelNeMsg-> firewallName:" + this.getcleanedMessage(firewall.getName()) + "firewall ip:" + this.getcleanedMessage(firewall.getIpAddress()) + " try max times " + count));
                    for (DivertBlackholeForm stoptDivertBlackholeForm : result) {
                        this.recordLogForDelNeMsg(null, stoptDivertBlackholeForm, firewall);
                    }
                } else {
                    try {
                        ++count;
                        this.stopAndDeleteDivertBlackholesForDelNeMsg(firewall, result);
                        return;
                    }
                    catch (LegoCheckedException e) {
                        if (e.getErrorCode() != 571808L) continue;
                        this.logger.error((Object)("deleteBlackholesForDelNeMsg-> device busy now ,need retry,current count=" + count));
                        retry = true;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error((Object)e.getMessage());
                        }
                    }
                }
            } while (retry);
            return;
        }
        catch (Exception t) {
            this.logger.error((Object)t.getMessage());
        }
    }

    @Override
    public void respondMsgDelDevice(List<AticDeviceForm> deviceList) {
        this.logger.info((Object)"respondMsgDelDevice");
        for (AticDeviceForm device : deviceList) {
            try {
                if (null == device) continue;
                this.logger.info((Object)("respondMsgDelDevice->deviceId:" + device.getMoId()));
                List<DivertBlackholeForm> result = this.getDivertBlackholeFormByDeviceId(device.getMoId());
                if (result.isEmpty()) continue;
                if (device.getDeviceType() == 1) {
                    AticDevice aticDevice = new AticDevice();
                    AticUtil.copyProperties((Object)device, (Object)aticDevice);
                    this.deleteBlackholesForDelNeMsgWithTryMax(aticDevice, result);
                    continue;
                }
                this.logger.warn((Object)" neObject==null || neObject not instanceof ANTI_DDOS_DEVICE");
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    public List<DivertBlackholeForm> getTimeoutDiversionList(Map<String, Integer> blackHoleTimeOutMap) {
        ArrayList<DivertBlackholeForm> result = new ArrayList<DivertBlackholeForm>();
        List<DivertBlackhole> dbs = this.divertBlackholeDao.getTimeoutDiversionList(blackHoleTimeOutMap);
        for (DivertBlackhole db : dbs) {
            DivertBlackholeForm form = (DivertBlackholeForm)AticUtil.copyProperties((Object)db, (Object)new DivertBlackholeForm());
            result.add(form);
        }
        return result;
    }

    @Override
    public List<DivertBlackholeForm> getEnableDiversionList() {
        ArrayList<DivertBlackholeForm> result = new ArrayList<DivertBlackholeForm>();
        List<DivertBlackhole> dbs = this.divertBlackholeDao.getEnableDiversionList();
        for (DivertBlackhole db : dbs) {
            DivertBlackholeForm form = (DivertBlackholeForm)AticUtil.copyProperties((Object)db, (Object)new DivertBlackholeForm());
            String blackIPAndMask = form.getBlackIP() + "/" + form.getBlackMask();
            form.setBlackIPAndMask(blackIPAndMask);
            result.add(form);
        }
        return result;
    }

    @Override
    public DivertBlackholeForm removeBlackholeNpOfDeployFail(DivertBlackholeForm startDivertBlackholeForm) {
        this.removeDivertBlackhole(startDivertBlackholeForm);
        return startDivertBlackholeForm;
    }

    private boolean isCollectionEmpty(Collection coll) {
        return null == coll || coll.isEmpty();
    }

    private void sendBlackHoleIp(DivertBlackholeForm divertBlackholeForm, String type) {
        ZonePolicyApplyForm zonePolicyApplyForm = this.getZonePolicyForm(divertBlackholeForm);
        this.logger.info((Object)("blackhole ip : " + divertBlackholeForm.getBlackIP() + " , blackhole mode: " + divertBlackholeForm.getMode() + " , blackhole notify enable is " + zonePolicyApplyForm.getBlackholeNotifyEnable()));
        this.logger.info((Object)("isTraffic : " + divertBlackholeForm.isFlowTrigger()));
        if (0 == divertBlackholeForm.getMode() && this.isNotifyStatic()) {
            this.notify(divertBlackholeForm, type);
        } else if (1 == divertBlackholeForm.getMode() && "block".equals(type) && divertBlackholeForm.isFlowTrigger()) {
            if (zonePolicyApplyForm.getBlackholeNotifyEnable() == 1) {
                this.notify(divertBlackholeForm, type);
            }
        } else if (1 == divertBlackholeForm.getMode() && "unblock".equals(type) && zonePolicyApplyForm.getBlackholeNotifyEnable() == 1) {
            this.notify(divertBlackholeForm, type);
        }
    }

    private void notify(DivertBlackholeForm divertBlackholeForm, String type) {
        String blackIP = divertBlackholeForm.getBlackIP();
        String blackMask = divertBlackholeForm.getBlackMask();
        ArrayList<String> ipList = new ArrayList<String>();
        ArrayList<String> maskList = new ArrayList<String>();
        if (IPUtil.isIpv4((String)blackIP)) {
            if ("32".equals(blackMask)) {
                ipList.add(blackIP);
            } else {
                maskList.add(blackIP + "/" + blackMask);
            }
        } else if (IPUtil.isIpv6((String)blackIP)) {
            if ("128".equals(blackMask)) {
                ipList.add(blackIP);
            } else {
                maskList.add(blackIP + "/" + blackMask);
            }
        }
        String logTime = this.getUnblockTime(divertBlackholeForm);
        String enableTime = this.getEnableTime(divertBlackholeForm);
        String blackholeType = this.getBlackholeType(divertBlackholeForm);
        NotifyBlackholeForm form = new NotifyBlackholeForm(ipList, maskList, type, blackholeType, logTime, enableTime);
        this.notifyBlackholeIp.sendBlackholeIp(form);
    }

    private String getEnableTime(DivertBlackholeForm divertBlackholeForm) {
        String enableTimeStr = "";
        Long enableTime = divertBlackholeForm.getEnableTime();
        if (null == enableTime) {
            enableTime = System.currentTimeMillis();
            Date date = new Date(enableTime);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            enableTimeStr = format.format(date);
        } else {
            enableTimeStr = divertBlackholeForm.getEnableTimeStr();
        }
        return enableTimeStr;
    }

    private String getBlackholeType(DivertBlackholeForm divertBlackholeForm) {
        String blackholeType = "blackhole";
        if (1 == divertBlackholeForm.getBlackholeMode()) {
            blackholeType = "blackholeAPI";
        }
        if (2 == divertBlackholeForm.getBlackholeMode()) {
            blackholeType = "blackholeNp";
        }
        return blackholeType;
    }

    private String getUnblockTime(DivertBlackholeForm divertBlackholeForm) {
        String logTime = "--";
        Integer blackholeTime = divertBlackholeForm.getBlackholeTime();
        if (blackholeTime > 0) {
            logTime = blackholeTime.toString();
        } else {
            if (0 == divertBlackholeForm.getBlackholeMode()) {
                return logTime;
            }
            List<DivertBlackholeForm> divertBlackholeNpFormList = this.getEnableDiversionList();
            Map divertBlackholeNpMap = this.blackholeNpDao.blackholeNpByEnableStatus();
            for (DivertBlackholeForm form : divertBlackholeNpFormList) {
                if (!form.getBlackIPAndMask().equals(divertBlackholeForm.getBlackIP() + "/" + divertBlackholeForm.getBlackMask())) continue;
                ConfigBlackholeNp configBlackholeNp = (ConfigBlackholeNp)divertBlackholeNpMap.get(form.getBlackIPAndMask());
                logTime = configBlackholeNp.getTimeLong().toString();
                return logTime;
            }
            if ("CTCC".equals(divertBlackholeForm.getServiceProvider())) {
                List<ConfigBlackholeApiForm> configBlackholeApiForms = this.configBlackholeService.getServiceProvider();
                if (null != configBlackholeApiForms && !configBlackholeApiForms.isEmpty()) {
                    logTime = configBlackholeApiForms.get(0).getUnblockTime().toString();
                }
            } else {
                PageSizeConfigService pageSizeConfigService = (PageSizeConfigService)ServiceContext.getInstance().getService("pageSizeConfigService", PageSizeConfigService.class);
                List sysConfigs = pageSizeConfigService.findPageSizeNum("unblockTime");
                if (null != sysConfigs && !sysConfigs.isEmpty()) {
                    Integer unBolockTime = Integer.valueOf(((PageSizeConfig)sysConfigs.get(0)).getSysValue());
                    logTime = unBolockTime.toString();
                }
            }
        }
        return logTime;
    }

    private ZonePolicyApplyForm getZonePolicyForm(DivertBlackholeForm divertBlackholeForm) {
        String blackIP = divertBlackholeForm.getBlackIP();
        String blackMask = divertBlackholeForm.getBlackMask();
        Long zoneId = divertBlackholeForm.getZoneId();
        if (null == blackMask || "".equals(blackMask)) {
            blackMask = IPUtil.isIpv4((String)blackIP) ? "32" : "128";
        }
        IZonePolicyApplyService zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        ZonePolicyApplyForm zonePolicyApplyForm = new ZonePolicyApplyForm();
        if (null != zoneId) {
            zonePolicyApplyForm = (ZonePolicyApplyForm)zonePolicyApplyService.query((Object)zoneId);
            if (null == zonePolicyApplyForm) {
                zonePolicyApplyForm = new ZonePolicyApplyForm();
                zonePolicyApplyForm.setBlackholeMode(Integer.valueOf(1));
            }
        } else {
            zonePolicyApplyForm.setBlackholeMode(Integer.valueOf(1));
        }
        this.logger.info((Object)("is notify : " + zonePolicyApplyForm.getBlackholeNotifyEnable()));
        return zonePolicyApplyForm;
    }

    private boolean isNotifyFirst() {
        return "1".equals(this.notifyBlackholeIp.getNotifyTime());
    }

    private boolean isNotifyReleaseFirst() {
        return "1".equals(this.notifyBlackholeIp.getNotifyReleaseTime());
    }

    private boolean isNotifyStatic() {
        return "2".equals(this.notifyBlackholeIp.getNotifyStaticBlackhole());
    }

    public BlackholeAlarmHandler getBlackholeAlarmHandler() {
        return this.blackholeAlarmHandler;
    }

    public void setBlackholeAlarmHandler(BlackholeAlarmHandler blackholeAlarmHandler) {
        this.blackholeAlarmHandler = blackholeAlarmHandler;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public IConfigBlackholeService getConfigBlackholeService() {
        return this.configBlackholeService;
    }

    public void setConfigBlackholeService(IConfigBlackholeService configBlackholeService) {
        this.configBlackholeService = configBlackholeService;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public DivertBlackholeDao getDivertBlackholeDao() {
        return this.divertBlackholeDao;
    }

    public void setDivertBlackholeDao(DivertBlackholeDao divertBlackholeDao) {
        this.divertBlackholeDao = divertBlackholeDao;
    }

    public BlackholeNpDao getBlackholeNpDao() {
        return this.blackholeNpDao;
    }

    public void setBlackholeNpDao(BlackholeNpDao blackholeNpDao) {
        this.blackholeNpDao = blackholeNpDao;
    }

    public NotifyBlackholeIp getNotifyBlackholeIp() {
        return this.notifyBlackholeIp;
    }

    public void setNotifyBlackholeIp(NotifyBlackholeIp notifyBlackholeIp) {
        this.notifyBlackholeIp = notifyBlackholeIp;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }
}

