/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.bis.util.BisConstants;
import com.hs.atic.sdk.bis.service.IDivertLogStorage;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.file.util.FileFactory;
import com.hs.lego.core.sdk.file.util.FileUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DivertLogStorage
implements IDivertLogStorage {
    private static final int TIME_SECONDS = 1000;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private I18nMrg i18nMrg;
    private Locale locale = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logExport(List<DivertTacticsLog> logList, String fileType, String lang, File tempFile, String fileNameTmp, int serialNum) {
        this.locale = null != lang && "en".equals(lang) ? new Locale(lang) : new Locale("zh", "CN");
        String type = fileType;
        List<String> column = this.getColumn();
        FileUtil fileUtil = null;
        try {
            String downloadPath = tempFile.getCanonicalPath() + File.separator + fileNameTmp;
            fileUtil = FileFactory.getFileUtil((String)type);
            if (null != fileUtil) {
                fileUtil.fileSet("", column, downloadPath + serialNum);
                if (null != lang && "en".equals(lang)) {
                    fileUtil.setStrChar("UTF-8");
                } else {
                    fileUtil.setStrChar("GBK");
                }
                List<List<String>> sysLog = this.logToStrWithId(logList);
                fileUtil.writeFile(sysLog, "detail" + File.separator);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("write file error." + e.getMessage()));
        }
        finally {
            try {
                if (null != fileUtil) {
                    fileUtil.closeFile();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"write file error");
            }
        }
    }

    private List<List<String>> logToStrWithId(List<DivertTacticsLog> lstLog) {
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        HashMap<Long, String> firewallMap = new HashMap<Long, String>();
        HashMap<Long, String> zoneMap = new HashMap<Long, String>();
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (DivertTacticsLog divertTacticsLog : lstLog) {
            if (null == divertTacticsLog.getDeviceId()) continue;
            if (firewallMap.containsKey(divertTacticsLog.getDeviceId())) {
                divertTacticsLog.setDeviceName((String)firewallMap.get(divertTacticsLog.getDeviceId()));
            } else {
                AticDevice fireWall = aticDeviceService.getDeviceByMoid(divertTacticsLog.getDeviceId().longValue());
                if (null != fireWall) {
                    divertTacticsLog.setDeviceName(fireWall.getName());
                    firewallMap.put(divertTacticsLog.getDeviceId(), fireWall.getName());
                }
            }
            if (BisConstants.ADD_DIVERT_ZONE_ID.equals(divertTacticsLog.getZoneId())) {
                divertTacticsLog.setZoneDesc("--");
                continue;
            }
            if (zoneMap.containsKey(divertTacticsLog.getZoneId())) {
                divertTacticsLog.setZoneDesc((String)zoneMap.get(divertTacticsLog.getZoneId()));
            } else {
                ZoneInfoForm zoneInfoForms = zoneService.getZoneNOIpById(divertTacticsLog.getZoneId());
                if (null != zoneInfoForms) {
                    divertTacticsLog.setZoneDesc("".equals(zoneInfoForms.getZoneDesc()) ? null : zoneInfoForms.getZoneDesc());
                    zoneMap.put(divertTacticsLog.getZoneId(), zoneInfoForms.getZoneDesc());
                }
            }
            List<String> tempLst = this.getOptLogString(divertTacticsLog);
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private List<String> getOptLogString(DivertTacticsLog divertTacticsLog) {
        ArrayList<String> tempLst = new ArrayList<String>();
        tempLst.add(divertTacticsLog.getDeviceName());
        tempLst.add(divertTacticsLog.getZoneDesc());
        tempLst.add(divertTacticsLog.getDivertIp());
        tempLst.add(divertTacticsLog.getMask() + "");
        tempLst.add(divertTacticsLog.getVpnName());
        tempLst.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(divertTacticsLog.getLogTime() * 1000L * 1L)));
        tempLst.add(divertTacticsLog.getOperator());
        tempLst.add(divertTacticsLog.getClientIp());
        tempLst.add(this.getDiveretLogOperTypeMap().get(divertTacticsLog.getOperType()));
        tempLst.add(this.getDiveretLogResultsMap().get(divertTacticsLog.getResult()));
        tempLst.add(this.getDivertModeMap().get(divertTacticsLog.getDivertMode()));
        tempLst.add(this.getLogLevelMap().get(divertTacticsLog.getLevel()));
        tempLst.add(this.processRemark(divertTacticsLog.getRemark()));
        return tempLst;
    }

    private String processRemark(String remark) {
        if (!AticUtil.isNull((String)remark)) {
            if (remark.contains(".") && !remark.contains(":") && !remark.contains(" ")) {
                return this.getText("atic.bis.divert.tactics.log.remark." + remark);
            }
            if (remark.matches("[0-9]+")) {
                return this.getText("lego.err." + remark);
            }
        }
        return remark;
    }

    private Map<Integer, String> getDiveretLogOperTypeMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(BisConstants.DIVERT_LOG_OPER_TYPE_CREATE, this.getText("atic.bis.divert.tactics.operate.type.create"));
        data.put(BisConstants.DIVERT_LOG_OPER_TYPE_START, this.getText("atic.bis.divert.tactics.operate.type.start"));
        data.put(BisConstants.DIVERT_LOG_OPER_TYPE_STOP, this.getText("atic.bis.divert.tactics.operate.type.stop"));
        data.put(BisConstants.DIVERT_LOG_OPER_TYPE_DELETE, this.getText("atic.bis.divert.tactics.operate.type.delete"));
        data.put(BisConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL, this.getText("atic.bis.divert.tactics.operate.type.delete.all"));
        data.put(AticConstants.DIVERT_LOG_OPER_TYPE_CREATE_REST, this.getText("atic.bis.divert.tactics.operate.type.create.restful"));
        data.put(AticConstants.DIVERT_LOG_OPER_TYPE_START_REST, this.getText("atic.bis.divert.tactics.operate.type.start.restful"));
        data.put(AticConstants.DIVERT_LOG_OPER_TYPE_STOP_REST, this.getText("atic.bis.divert.tactics.operate.type.stop.restful"));
        data.put(AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_REST, this.getText("atic.bis.divert.tactics.operate.type.delete.restful"));
        data.put(AticConstants.DIVERT_LOG_OPER_TYPE_DELETE_ALL_REST, this.getText("atic.bis.divert.tactics.operate.type.delete.all.restful"));
        return data;
    }

    private Map<Integer, String> getDiveretLogResultsMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(0, this.getText("atic.bis.divert.tactics.log.result.fail"));
        data.put(1, this.getText("atic.bis.divert.tactics.log.result.success"));
        return data;
    }

    private Map<Integer, String> getLogLevelMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(1, this.getText("atic.bis.divert.tactics.log.level.danger"));
        data.put(2, this.getText("atic.bis.divert.tactics.log.level.general"));
        data.put(3, this.getText("atic.bis.divert.tactics.log.level.warning"));
        data.put(4, this.getText("atic.bis.divert.tactics.log.level.info"));
        return data;
    }

    private Map<Integer, String> getDivertModeMap() {
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(1, this.getText("atic.bis.divert.tactics.divert.mode.manually"));
        data.put(0, this.getText("atic.bis.divert.tactics.divert.mode.auto"));
        data.put(2, this.getText("atic.bis.divert.tactics.divert.mode.static"));
        return data;
    }

    private List<String> getColumn() {
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("atic.bis.divert.tactics.device"));
        column.add(this.getText("atic.bis.divert.choose.zone"));
        column.add(this.getText("atic.bis.divert.tactics.ip"));
        column.add(this.getText("atic.bis.divert.tactics.mask"));
        column.add(this.getText("atic.bis.divert.tactics.vpn"));
        column.add(this.getText("atic.bis.divert.tactics.log.operate.time"));
        column.add(this.getText("atic.bis.divert.tactics.log.operate.person"));
        column.add(this.getText("atic.bis.divert.tactics.log.operate.clientIp"));
        column.add(this.getText("atic.bis.divert.tactics.log.operate.type"));
        column.add(this.getText("atic.bis.divert.tactics.log.result"));
        column.add(this.getText("atic.bis.divert.tactics.divert.mode"));
        column.add(this.getText("atic.bis.divert.tactics.log.level"));
        column.add(this.getText("atic.bis.divert.tactics.log.remark"));
        return column;
    }

    public I18nMrg getI18nMrg() {
        return this.i18nMrg;
    }

    public void setI18nMrg(I18nMrg i18nMrg) {
        this.i18nMrg = i18nMrg;
    }

    private String getText(String key) {
        return this.i18nMrg.getString(key, this.locale);
    }
}

