/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.DivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertLogStorage;
import com.hs.atic.sdk.bis.service.IDivertTacticsLogService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.atic.device.model.AticDeviceForm;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DivertTacticsLogServiceImpl
implements IDivertTacticsLogService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private DivertTacticsLogDao divertTacticsLogDao;
    private ISysOptLog sysOptLog;
    private IDivertLogStorage divertLogStorage;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.divertTacticsLogDao.queryByPage(queryMap, start, pageSize);
        ArrayList<DivertTacticsLogForm> divertLogFormList = new ArrayList<DivertTacticsLogForm>();
        for (DivertTacticsLog divertTacticsLog : page.getData()) {
            divertLogFormList.add((DivertTacticsLogForm)AticUtil.copyProperties((Object)divertTacticsLog, (Object)new DivertTacticsLogForm()));
        }
        page.setData(divertLogFormList);
        this.logger.info((Object)("query divert tactics log list. size = " + divertLogFormList.size()));
        return page;
    }

    @Override
    public void respondMsgDelDevice(List<AticDeviceForm> deviceList) {
        for (AticDeviceForm device : deviceList) {
            this.logger.info((Object)("delete divert tactics  log while deleting firewall id = " + device.getMoId()));
            this.divertTacticsLogDao.deleteByDeviceId(device.getMoId());
        }
    }

    @Override
    public int deleteLog(Long endTime) {
        return this.divertTacticsLogDao.betchDelete(endTime);
    }

    public DivertTacticsLogDao getDivertTacticsLogDao() {
        return this.divertTacticsLogDao;
    }

    public void setDivertTacticsLogDao(DivertTacticsLogDao divertTacticsLogDao) {
        this.divertTacticsLogDao = divertTacticsLogDao;
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public IDivertLogStorage getDivertLogStorage() {
        return this.divertLogStorage;
    }

    public void setDivertLogStorage(IDivertLogStorage divertLogStorage) {
        this.divertLogStorage = divertLogStorage;
    }

    @Override
    public List<DivertTacticsLogForm> getLogsByDivertTacticsLogIdS(String logIds) {
        ArrayList<DivertTacticsLogForm> divertLogFormList = new ArrayList<DivertTacticsLogForm>();
        if (null == logIds || logIds.equals("")) {
            return null;
        }
        String[] logs = logIds.split(",");
        for (int i = 0; i < logs.length; ++i) {
            try {
                Long id = Long.valueOf(logs[i]);
                DivertTacticsLogForm divertTacticsLogForm = this.getById(id);
                if (null == divertTacticsLogForm) continue;
                divertLogFormList.add(divertTacticsLogForm);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Numberformat exception id = " + logs[i] + ". " + e.getMessage()));
            }
        }
        return divertLogFormList;
    }

    private DivertTacticsLogForm getById(Long id) {
        if (null == id) {
            this.logger.error((Object)"divert tactics log by id. Id is null");
            return null;
        }
        DivertTacticsLog divertTacticsLog = this.divertTacticsLogDao.get(id);
        if (null == divertTacticsLog) {
            this.logger.warn((Object)"divert tactics log by id, result is null");
            return null;
        }
        DivertTacticsLogForm divertTacticsLogForm = (DivertTacticsLogForm)AticUtil.copyProperties((Object)divertTacticsLog, (Object)new DivertTacticsLogForm());
        this.logger.info((Object)("get divertTacticsLogForm info by id successfuly. Id is : " + id));
        return divertTacticsLogForm;
    }

    @Override
    public DivertTacticsLog getLogDetail(Long logId) {
        DivertTacticsLog divertTacticsLog = this.divertTacticsLogDao.get(logId);
        if (null == divertTacticsLog) {
            this.logger.warn((Object)"divert tactics log by id, result is null");
            return null;
        }
        return divertTacticsLog;
    }

    @Override
    public void transLog2File(int totalNum, StringBuffer sBufQObj, String fileType, String lang, File tempFileDir, String tempfileName) {
        if (totalNum > 5000) {
            int count = totalNum / 5000;
            if (0 != totalNum % 5000) {
                ++count;
            }
            this.transLogMultipleFile(count, sBufQObj, fileType, lang, tempFileDir, tempfileName);
        } else {
            Paging paging = null;
            paging = this.queryLogByStorage(sBufQObj.toString(), 0, 5000);
            List list = paging.getData();
            if (null != this.divertLogStorage) {
                try {
                    this.divertLogStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, 1);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception error." + e.getMessage()));
                }
            }
        }
    }

    private void transLogMultipleFile(int count, StringBuffer sBufQObj, String fileType, String lang, File tempFileDir, String tempfileName) {
        Paging paging = null;
        for (int i = 0; i < count; ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)("InterruptedException: " + e1.getMessage()));
            }
            paging = this.queryLogByStorage(sBufQObj.toString(), i * 5000 + 1, 5000);
            List list = paging.getData();
            if (null == this.divertLogStorage) continue;
            try {
                this.divertLogStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, i);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception error: " + e.getMessage()));
            }
        }
    }

    public Paging queryLogByStorage(String hql, int iStart, int iLength) {
        Paging roPaging = new Paging();
        List lstOptLogMo = new ArrayList();
        try {
            lstOptLogMo = this.divertTacticsLogDao.findPage(hql, iStart, iLength);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        StringBuffer sBufTotle = new StringBuffer("select count(*) from DivertTacticsLog ");
        roPaging.setData(lstOptLogMo);
        roPaging.setCount((int)this.divertTacticsLogDao.getTotalCount(sBufTotle.toString()));
        return roPaging;
    }

    @Override
    public int getCountByHql(long endTime) {
        StringBuffer sBufTotle = new StringBuffer("select count(*) from DivertTacticsLog where logTime < " + endTime);
        return (int)this.divertTacticsLogDao.getTotalCount(sBufTotle.toString());
    }
}

