/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.OutboundDivertTacticsLogDao;
import com.hs.atic.bis.model.OutboundDivertTacticsLog;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IOutboundDivertLogStorage;
import com.hs.atic.sdk.bis.service.IOutboundDivertTacticsLogService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.file.util.FileZip;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LogStorageUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OutboundDivertTacticsLogServiceImpl
implements IOutboundDivertTacticsLogService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private OutboundDivertTacticsLogDao outboundDivertTacticsLogDao;
    private ISysOptLog sysOptLog;
    private IOutboundDivertLogStorage outboundDivertLogStorage;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.outboundDivertTacticsLogDao.queryByPage(queryMap, start, pageSize);
        ArrayList<OutboundDivertTacticsLogForm> outboundDivertLogFormList = new ArrayList<OutboundDivertTacticsLogForm>();
        for (OutboundDivertTacticsLog outboundDivertTacticsLog : page.getData()) {
            outboundDivertLogFormList.add((OutboundDivertTacticsLogForm)AticUtil.copyProperties((Object)outboundDivertTacticsLog, (Object)new OutboundDivertTacticsLogForm()));
        }
        page.setData(outboundDivertLogFormList);
        this.logger.info((Object)("query outbound divert tactics log list. size = " + outboundDivertLogFormList.size()));
        return page;
    }

    @Override
    public int deleteLog(Long endTime) {
        return this.outboundDivertTacticsLogDao.betchDelete(endTime);
    }

    public OutboundDivertTacticsLogDao getOutboundDivertTacticsLogDao() {
        return this.outboundDivertTacticsLogDao;
    }

    public void setOutboundDivertTacticsLogDao(OutboundDivertTacticsLogDao outboundDivertTacticsLogDao) {
        this.outboundDivertTacticsLogDao = outboundDivertTacticsLogDao;
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public IOutboundDivertLogStorage getOutboundDivertLogStorage() {
        return this.outboundDivertLogStorage;
    }

    public void setOutboundDivertLogStorage(IOutboundDivertLogStorage outboundDivertLogStorage) {
        this.outboundDivertLogStorage = outboundDivertLogStorage;
    }

    @Override
    public List<OutboundDivertTacticsLogForm> getOutboundLogsByDivertTacticsLogIdS(String logIds) {
        ArrayList<OutboundDivertTacticsLogForm> outboundDivertLogFormList = new ArrayList<OutboundDivertTacticsLogForm>();
        if (null == logIds || logIds.equals("")) {
            return null;
        }
        String[] logs = logIds.split(",");
        for (int i = 0; i < logs.length; ++i) {
            try {
                Long id = Long.valueOf(logs[i]);
                OutboundDivertTacticsLogForm outboundDivertTacticsLogForm = this.getById(id);
                if (null == outboundDivertTacticsLogForm) continue;
                outboundDivertLogFormList.add(outboundDivertTacticsLogForm);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Numberformat exception id = " + logs[i] + ". " + e.getMessage()));
            }
        }
        return outboundDivertLogFormList;
    }

    private OutboundDivertTacticsLogForm getById(Long id) {
        if (null == id) {
            this.logger.error((Object)"outbound divert tactics log by id. Id is null");
            return null;
        }
        OutboundDivertTacticsLog outbouddivertTacticsLog = this.outboundDivertTacticsLogDao.get(id);
        if (null == outbouddivertTacticsLog) {
            this.logger.warn((Object)"outbound divert tactics log by id, result is null");
            return null;
        }
        OutboundDivertTacticsLogForm outboundDivertTacticsLogForm = (OutboundDivertTacticsLogForm)AticUtil.copyProperties((Object)outbouddivertTacticsLog, (Object)new OutboundDivertTacticsLogForm());
        this.logger.info((Object)("get outboundDivertTacticsLogForm info by id successfuly. Id is : " + id));
        return outboundDivertTacticsLogForm;
    }

    @Override
    public OutboundDivertTacticsLog getLogDetail(Long logId) {
        OutboundDivertTacticsLog outboundDivertTacticsLog = this.outboundDivertTacticsLogDao.get(logId);
        if (null == outboundDivertTacticsLog) {
            this.logger.warn((Object)"outbound divert tactics log by id, result is null");
            return null;
        }
        return outboundDivertTacticsLog;
    }

    @Override
    public String transferLog(String fileType, long endTime, String lang, String filePath) {
        String dateTime;
        if (!LogStorageUtil.hasEnoughMemory()) {
            return "";
        }
        this.sysOptLog.judgingCapacity("divert_log_bk");
        this.logger.info((Object)"outbound transferLog begin");
        int totalNum = this.getCountByHql(endTime);
        if (totalNum <= 0) {
            this.writeOptLogNoFile();
            return "lego.dic.warningaralm.noexist";
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
        String tempfileName = dateTime = dateFormat.format(date);
        String currentPath = AticInstallUtil.getInstance().getAticInstallPath();
        LogStorageUtil.createDirectory((String)(currentPath + File.separator + "datastorage"));
        this.logger.info((Object)("create directory path:" + File.separator + "datastorage"));
        currentPath = currentPath + File.separator + filePath;
        LogStorageUtil.createDirectory((String)currentPath);
        File tempFileDir = new File(currentPath + File.separator + tempfileName);
        this.logger.info((Object)("create temp directory path:" + File.separator + tempfileName + File.separator + "outboundDivertLog"));
        File tempFileDir1 = new File(currentPath + File.separator + tempfileName + File.separator + "outboundDivertLog");
        LogStorageUtil.createDirectory((String)(currentPath + File.separator + tempfileName + File.separator + "outboundDivertLog"));
        StringBuffer sBufQObj = new StringBuffer("FROM OutboundDivertTacticsLog where logTime < " + endTime);
        this.transLog2File(totalNum, sBufQObj, fileType, lang, tempFileDir1, tempfileName);
        try {
            FileZip.zip((String)(currentPath + File.separator + tempfileName), (String)(currentPath + File.separator + tempfileName + ".zip"), (String)tempfileName);
            FileZip.getInstance().deleteFile(tempFileDir);
        }
        catch (Exception e) {
            this.logger.error((Object)("zip file error." + e.getMessage()));
        }
        this.deleteLog(endTime);
        this.writetTransferLog(endTime, currentPath, tempfileName, totalNum);
        return tempfileName + ".zip";
    }

    @Override
    public void transLog2File(int totalNum, StringBuffer sBufQObj, String fileType, String lang, File tempFileDir, String tempfileName) {
        if (totalNum > 5000) {
            int count = totalNum / 5000;
            if (0 != totalNum % 5000) {
                ++count;
            }
            this.transLogMultipleFile(count, sBufQObj, fileType, lang, tempFileDir, tempfileName);
        } else {
            Paging paging = null;
            paging = this.queryLogByStorage(sBufQObj.toString(), 0, 5000);
            List list = paging.getData();
            if (null != this.outboundDivertLogStorage) {
                try {
                    this.outboundDivertLogStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, 1);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception error." + e.getMessage()));
                }
            }
        }
    }

    private void transLogMultipleFile(int count, StringBuffer sBufQObj, String fileType, String lang, File tempFileDir, String tempfileName) {
        Paging paging = null;
        for (int i = 0; i < count; ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)("InterruptedException: " + e1.getMessage()));
            }
            paging = this.queryLogByStorage(sBufQObj.toString(), i * 5000 + 1, 5000);
            List list = paging.getData();
            if (null == this.outboundDivertLogStorage) continue;
            try {
                this.outboundDivertLogStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, i);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception error. " + e.getMessage()));
            }
        }
    }

    public Paging queryLogByStorage(String hql, int iStart, int iLength) {
        String sQueryCondition = "";
        Paging roPaging = new Paging();
        List lstOptLogMo = new ArrayList();
        try {
            lstOptLogMo = this.outboundDivertTacticsLogDao.findPage(hql, iStart, iLength);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OutboundDivertTacticsLog ");
        sBufTotle.append(sQueryCondition);
        roPaging.setData(lstOptLogMo);
        roPaging.setCount((int)this.outboundDivertTacticsLogDao.getTotalCount(sBufTotle.toString()));
        return roPaging;
    }

    @Override
    public int getCountByHql(long endTime) {
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OutboundDivertTacticsLog where logTime < " + endTime);
        return (int)this.outboundDivertTacticsLogDao.getTotalCount(sBufTotle.toString());
    }

    private void writeOptLogNoFile() {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.sys.sysLog.operLog");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.dic.warningaralm.noexist");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.sysOptLog");
        oOptLog.setResult(1);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        this.sysOptLog.writeOptLog(oOptLog);
    }

    private void writetTransferLog(long endTime, String currentPath, String tempfileName, int totalNum) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.sys.sysLog.operLog");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.ver.storage.sysOptLog");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.sysOptLog");
        oOptLog.setResult(1);
        oOptLog.setTerminalIp("127.0.0.1");
        Date da = new Date(endTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dt = df.format(da);
        String filePathTemp = currentPath + File.separator + tempfileName + ".zip";
        filePathTemp = filePathTemp.replace("\\", File.separator);
        String[] para = new String[]{dt, "" + totalNum, filePathTemp};
        oOptLog.setDetailPara(para);
        oOptLog.setOperator("system");
        this.sysOptLog.writeOptLog(oOptLog);
    }
}

