/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.entity.blackhole.ConfigBlackholeNpEntity;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.IpStateData;
import com.hs.atic.rmi.IpStateService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.util.BlackholeDataBuffer;
import com.hs.atic.util.IpStateDataBuffer;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class IpStateServiceImpl
extends UnicastRemoteObject
implements IpStateService {
    private static final long serialVersionUID = -5369351118431799665L;
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);

    public IpStateServiceImpl() throws RemoteException {
    }

    public IpStateServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
    }

    @Override
    public void notifyIpState(List<IpStateData> datas) throws RemoteException {
        if (null == datas || datas.isEmpty()) {
            this.logger.error((Object)"notifyIpState datas is null");
            return;
        }
        this.logger.info((Object)("IP state is changed. Receive:" + datas.size() + "divert trafffic content is :" + datas));
        if (datas.size() > 10000) {
            this.logger.error((Object)"notifyIpState list size too long");
            return;
        }
        IpStateDataBuffer ipStateDataBuffer = IpStateDataBuffer.getInstance();
        ipStateDataBuffer.addIpStateData(datas);
    }

    @Override
    public void notifyBlackHoleDivert(List<IpStateData> datas) throws RemoteException {
        if (null == datas || datas.isEmpty()) {
            this.logger.error((Object)"notifyBlackHoleDivert datas is null");
            return;
        }
        this.logger.info((Object)("dynamic blackhole divert incoming. Receive:" + datas.size() + ", blackhole divert content is :" + datas));
        if (datas.size() > 10000) {
            this.logger.error((Object)"notifyIpState list size too long");
            return;
        }
        BlackholeDataBuffer blackholeDataBuffer = BlackholeDataBuffer.getInstance();
        blackholeDataBuffer.addIpStateData(datas);
    }

    @Override
    public void notifyBlackHoleNpCommend(List<ConfigBlackholeNpEntity> blackholeNpFormList) throws RemoteException {
        if (null == blackholeNpFormList || blackholeNpFormList.isEmpty()) {
            this.logger.info((Object)"ConfigBlackholeNpEntity blackholeNpFormList is null");
            return;
        }
        this.logger.info((Object)("blackholeNpFormList data size : " + blackholeNpFormList.size()));
        if (blackholeNpFormList.size() > 10000) {
            this.logger.info((Object)"notifyDiskSpaceAlert data size to long");
            return;
        }
        ArrayList<BlackholeNpForm> blackholeNpList = new ArrayList<BlackholeNpForm>();
        for (ConfigBlackholeNpEntity blackholeNpEntity : blackholeNpFormList) {
            BlackholeNpForm blackholeNpForm = new BlackholeNpForm();
            blackholeNpForm.setId(blackholeNpEntity.getId());
            blackholeNpForm.setNpIp(blackholeNpEntity.getNpIp());
            blackholeNpForm.setTimeLong(blackholeNpEntity.getTimeLong());
            blackholeNpForm.setBlackholeThreshold(blackholeNpEntity.getBlackholeThreshold());
            blackholeNpForm.setDeviceIp(blackholeNpEntity.getDeviceIp());
            this.logger.info((Object)("IpStateServiceImpl notifyBlackHoleNpCommend  BlackholeNpForm [npIp=" + blackholeNpForm.getNpIp() + ", timeLong=" + blackholeNpForm.getTimeLong() + ", blackholeThreshold=" + blackholeNpForm.getBlackholeThreshold() + ", deviceIp=" + blackholeNpForm.getDeviceIp() + "]"));
            blackholeNpList.add(blackholeNpForm);
        }
        IpStateDataBuffer ipStateDataBuffer = IpStateDataBuffer.getInstance();
        ipStateDataBuffer.addBlackholeNpFormList(blackholeNpList);
    }
}

