/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.service.IDateTableFileService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.DeviceProxy;
import com.hs.atic.util.DeviceProxyFactory;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.service.IVpnDeviceService;
import com.huawei.atic.secne.sdk.common.StringUtils;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.ddos.restful.model.RestErrorInfo;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AticDiversionUtil {
    private static final int ONE_THOUSAND = 1000;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private static List<Integer> codeList = new ArrayList<Integer>();

    public static List<String> getDivertTacticsCommandAsList(DivertTactics divertTactics, String cmdId) {
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        commands.add("system-view");
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID(cmdId);
        HashMap<String, String> params = new HashMap<String, String>();
        String vpnName = divertTactics.getVpnName();
        if (!AticUtil.isNullForVpn((String)vpnName)) {
            tmpCmdParam.setCmdID("VPN" + cmdId);
            params.put("vpnName", vpnName);
            if (IPUtil.isIpv4((String)divertTactics.getDivertIp())) {
                params.put("vpnType", "vpn-instance");
            } else {
                params.put("vpnType", "vpn6-instance");
            }
        }
        params.put("divertIp", divertTactics.getDivertIp());
        params.put("mask", divertTactics.getMask().toString());
        tmpCmdParam.setParams(params);
        paramList.add(tmpCmdParam);
        commands.addAll(new CommandAPI().doTranslate("conf/aticCommands.xml", "divertTactics", paramList));
        return commands;
    }

    public static String getDivertBlackholeCommand(DivertBlackholeForm divertBlackholeForm, String cmdId) {
        String ipAddress = divertBlackholeForm.getBlackIP();
        String ipMask = divertBlackholeForm.getBlackMask();
        String postfix = "";
        ArrayList commands = new ArrayList();
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        HashMap<String, String> params = new HashMap<String, String>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID(cmdId);
        if (IPUtil.isIpv4((String)divertBlackholeForm.getBlackIP())) {
            if (IPUtil4Atic.isIpv4Mask((String)ipMask)) {
                String[] srcIpRange = IPUtil.getSubnetRange((String)divertBlackholeForm.getBlackIP(), (int)Integer.parseInt(divertBlackholeForm.getBlackMask()));
                ipAddress = srcIpRange[0];
                ipMask = IPUtil4Atic.mask2ipMask((String)ipMask);
            } else if (ipMask.length() >= 3) {
                String[] srcIpRange = IPUtil.getSubnetRange((String)divertBlackholeForm.getBlackIP(), (int)IPUtil4Atic.maskStr2InetMask((String)divertBlackholeForm.getBlackMask()));
                ipAddress = srcIpRange[0];
            }
            postfix = "IPV4";
        } else {
            if (IPUtil4Atic.isIpv6Mask((String)ipMask)) {
                String[] srcIpRange = IPUtil.getSubnetRange((String)divertBlackholeForm.getBlackIP(), (int)Integer.parseInt(divertBlackholeForm.getBlackMask()));
                ipAddress = srcIpRange[0];
                ipMask = divertBlackholeForm.getBlackMask();
            }
            postfix = "IPV6";
        }
        if (!AticUtil.isNull((String)divertBlackholeForm.getVpn()) && !"--".equals(divertBlackholeForm.getVpn())) {
            params.put("vpnInstance", divertBlackholeForm.getVpn());
        }
        params.put("blackIP", ipAddress);
        params.put("blackMask", ipMask);
        params.put("nexthopIP", "NULL 0");
        tmpCmdParam.setParams(params);
        paramList.add(tmpCmdParam);
        commands.addAll(new CommandAPI().doTranslate("conf/aticCommands.xml", "divertBlackhole" + postfix, paramList));
        return (String)commands.get(0);
    }

    public static String getDivertBoardBlackholeCommand(DivertBlackholeForm divertBlackholeForm, String cmdId) {
        String ipAddress = divertBlackholeForm.getBlackIP();
        String ipMask = divertBlackholeForm.getBlackMask();
        ArrayList commands = new ArrayList();
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        HashMap<String, String> params = new HashMap<String, String>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID(cmdId);
        if (IPUtil.isIpv4((String)divertBlackholeForm.getBlackIP())) {
            if (IPUtil4Atic.isIpv4Mask((String)ipMask)) {
                String[] srcIpRange = IPUtil.getSubnetRange((String)divertBlackholeForm.getBlackIP(), (int)Integer.parseInt(divertBlackholeForm.getBlackMask()));
                ipAddress = srcIpRange[0];
                ipMask = IPUtil4Atic.mask2ipMask((String)ipMask);
            } else if (ipMask.length() >= 3) {
                String[] srcIpRange = IPUtil.getSubnetRange((String)divertBlackholeForm.getBlackIP(), (int)IPUtil4Atic.maskStr2InetMask((String)divertBlackholeForm.getBlackMask()));
                ipAddress = srcIpRange[0];
            }
        }
        params.put("blackIP", ipAddress);
        params.put("blackMask", ipMask);
        params.put("cir", "0");
        tmpCmdParam.setParams(params);
        paramList.add(tmpCmdParam);
        commands.addAll(new CommandAPI().doTranslate("conf/aticCommands.xml", "divertBlackholeInterfaceBoard", paramList));
        return (String)commands.get(0);
    }

    public static List<String> getDivertCommandAsList(List<DivertTactics> divertTacticsList, String cmdId) {
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        for (DivertTactics divertTactics : divertTacticsList) {
            AticDiversionUtil.setDivertIp(divertTactics);
            CmdParam tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID(cmdId);
            ServiceContext serviceContext = ServiceContext.getInstance();
            IZoneService zoneService = (IZoneService)serviceContext.getService("zoneService", IZoneService.class);
            String devVpn = "";
            if (zoneService.getById(divertTactics.getZoneId()).getZoneType() == 1) {
                IVpnDeviceService vpnDeviceService = (IVpnDeviceService)ServiceContext.getInstance().getService("vpnDeviceService", IVpnDeviceService.class);
                if (vpnDeviceService.isVpnExcluded(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128))) continue;
                if (!vpnDeviceService.isVpnIncluded(divertTactics.getDeviceId(), divertTactics.getZoneId())) {
                    LOG.info((Object)("IP is not in include list. Ip is " + divertTactics.getDivertIp()));
                } else {
                    devVpn = AticDiversionUtil.getDevVpn(divertTactics, vpnDeviceService);
                }
            }
            AticDiversionUtil.addToParamList(cmdId, paramList, divertTactics, tmpCmdParam, devVpn);
        }
        commands.addAll(new CommandAPI().doTranslate("conf/aticCommands.xml", "divertTactics", paramList));
        return commands;
    }

    public static String getDivertCommand(DivertTactics divertTactics, String cmdId) {
        AticDiversionUtil.setDivertIp(divertTactics);
        ArrayList commands = new ArrayList();
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID(cmdId);
        ServiceContext serviceContext = ServiceContext.getInstance();
        IZoneService zoneService = (IZoneService)serviceContext.getService("zoneService", IZoneService.class);
        String devVpn = "";
        if (null != zoneService.getById(divertTactics.getZoneId()) && zoneService.getById(divertTactics.getZoneId()).getZoneType() == 1) {
            IVpnDeviceService vpnDeviceService = (IVpnDeviceService)ServiceContext.getInstance().getService("vpnDeviceService", IVpnDeviceService.class);
            if (vpnDeviceService.isVpnExcluded(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128))) {
                return "";
            }
            if (!vpnDeviceService.isVpnIncluded(divertTactics.getDeviceId(), divertTactics.getZoneId())) {
                LOG.info((Object)("IP is not in include list. Ip is " + divertTactics.getDivertIp()));
            } else {
                devVpn = AticDiversionUtil.getDevVpn(divertTactics, vpnDeviceService);
            }
        }
        AticDiversionUtil.addToParamList(cmdId, paramList, divertTactics, tmpCmdParam, devVpn);
        commands.addAll(new CommandAPI().doTranslate("conf/aticCommands.xml", "divertTactics", paramList));
        return (String)commands.get(0);
    }

    public static String calcDivertVPN(DivertTactics divertTactics) {
        AticDiversionUtil.setDivertIp(divertTactics);
        ServiceContext serviceContext = ServiceContext.getInstance();
        IZoneService zoneService = (IZoneService)serviceContext.getService("zoneService", IZoneService.class);
        String devVpn = "";
        if (null != zoneService.getById(divertTactics.getZoneId()) && zoneService.getById(divertTactics.getZoneId()).getZoneType() == 1) {
            devVpn = AticDiversionUtil.getDevVpn(divertTactics);
        }
        AticDiversionUtil.setVpnName(divertTactics, devVpn);
        return devVpn;
    }

    private static Map<String, String> initVpnCmdParams(DivertTactics divertTactics, CmdParam tmpCmdParam, String cmdId, String vpnName) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!"".equals(vpnName)) {
            tmpCmdParam.setCmdID("VPN" + cmdId);
            params.put("vpnName", vpnName);
            if (IPUtil.isIpv4((String)divertTactics.getDivertIp())) {
                params.put("vpnType", "vpn-instance");
                params.put("ipType", "ip");
            } else {
                params.put("vpnType", "vpn6-instance");
                params.put("ipType", "ipv6");
            }
        } else if (IPUtil.isIpv4((String)divertTactics.getDivertIp())) {
            params.put("ipType", "ip");
        } else {
            params.put("ipType", "ipv6");
        }
        divertTactics.setVpnName(vpnName);
        params.put("divertIp", divertTactics.getDivertIp());
        params.put("mask", divertTactics.getMask().toString());
        if (divertTactics.getNextHop() != null && !"".equals(divertTactics.getNextHop())) {
            params.put("next-hop", "next-hop");
            params.put("nextHop", divertTactics.getNextHop());
        }
        return params;
    }

    private static String validateRealVpnName(Long devId, String ip, Integer mask) {
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        List cmdResultStrs = aticDeviceService.getVpnListFromDevice(devId.longValue());
        if (null == cmdResultStrs) {
            return "";
        }
        for (int i = 0; i < cmdResultStrs.size(); ++i) {
            if (!AticDiversionUtil.isExistVpn(devId, ip, mask, (String)cmdResultStrs.get(i))) continue;
            return (String)cmdResultStrs.get(i);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isExistVpn(Long devId, String ip, Integer mask, String vpnName) {
        if (vpnName == null || vpnName.equals("")) {
            return false;
        }
        ArrayList commands = new ArrayList();
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        HashMap<String, String> params = new HashMap<String, String>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID("VPNCHECK");
        if (IPUtil.isIpv4((String)ip)) {
            params.put("ipType", "ip");
        } else if (IPUtil.isIpv6((String)ip)) {
            params.put("ipType", "ipv6");
        } else {
            LOG.info((Object)("ip type default is IPV4. ip: " + ip));
        }
        params.put("vpnName", vpnName);
        params.put("divertIp", ip);
        params.put("mask", mask.toString());
        tmpCmdParam.setParams(params);
        paramList.add(tmpCmdParam);
        commands.addAll(new CommandAPI().doTranslate("conf/aticCommands.xml", "divertTactics", paramList));
        String commandStr = (String)commands.get(0);
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        try (DeviceProxy proxy = null;){
            proxy = DeviceProxyFactory.createDeviceProxy(devId, aticDeviceService);
            LOG.info((Object)("vpncheck command is " + commandStr));
            String cmdResult = proxy.executeCommand(commandStr);
            if (cmdResult.contains("Route Flags: R - relay, D - download to fib") || cmdResult.contains("Summary Count ")) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static String getZoneInfoByIpMask(String ip, int mask) {
        String zoneName = null;
        IZoneService zoneService = ZoneReferUtil.getZoneService();
        Long zoneId = zoneService.getZoneIdByIpAndMask(ip, mask);
        if (null == zoneId) {
            zoneName = "--";
        } else {
            ZoneInfoForm zoneInfo = ZoneReferUtil.getById((Long)zoneId);
            zoneName = zoneInfo.getZoneName();
        }
        return zoneName;
    }

    public static int getRetryDivertSleepTime() {
        IDateTableFileService service = ZoneReferUtil.getDateTableFileService();
        int sleepTime = service.getRetryDivertSleepTime() * 1000;
        return sleepTime;
    }

    public static boolean isDeviceBusying(int statusCode, RestErrorInfo errorInfo) {
        if (codeList.contains(statusCode)) {
            return false;
        }
        if (null == errorInfo) {
            return false;
        }
        String errorMessage = errorInfo.getErrorMessage();
        return AticDiversionUtil.isBusy(errorMessage);
    }

    public static boolean isNumberLimitMax(int statusCode, RestErrorInfo errorInfo) {
        if (codeList.contains(statusCode)) {
            return false;
        }
        if (null == errorInfo) {
            return false;
        }
        String errorMessage = errorInfo.getErrorMessage();
        return !StringUtils.isEmpty((String)errorMessage) && errorMessage.contains("Error: The number of IP addresses of traffic diversion reaches limit already");
    }

    public static String parseIpFromErrorPath(String errorPath) {
        if (null != errorPath && errorPath.indexOf("ip-address:\"") > 1) {
            String firstStr = errorPath.substring(errorPath.indexOf("ip-address:\"") + 12);
            String[] str = firstStr.split("\"");
            return str[0];
        }
        return "";
    }

    private static void addToParamList(String cmdId, List<CmdParam> paramList, DivertTactics divertTactics, CmdParam tmpCmdParam, String devVpn) {
        Map<String, String> params = null;
        params = "".equals(devVpn) ? AticDiversionUtil.initVpnCmdParams(divertTactics, tmpCmdParam, cmdId, divertTactics.getVpnName()) : AticDiversionUtil.initVpnCmdParams(divertTactics, tmpCmdParam, cmdId, devVpn);
        tmpCmdParam.setParams(params);
        paramList.add(tmpCmdParam);
    }

    private static void setDivertIp(DivertTactics divertTactics) {
        if (divertTactics.getDivertIp().contains("/")) {
            divertTactics.setDivertIp(divertTactics.getDivertIp().split("/")[0]);
        }
    }

    private static String getDevVpn(DivertTactics divertTactics, IVpnDeviceService vpnDeviceService) {
        String vpnName = vpnDeviceService.getIncludedVpn(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128));
        if (AticDiversionUtil.isExistVpn(divertTactics.getDeviceId(), divertTactics.getDivertIp(), divertTactics.getMask(), vpnName)) {
            return vpnName;
        }
        return AticDiversionUtil.validateRealVpnName(divertTactics.getDeviceId(), divertTactics.getDivertIp(), divertTactics.getMask());
    }

    private static void setVpnName(DivertTactics divertTactics, String devVpn) {
        if (!"".equals(devVpn)) {
            divertTactics.setVpnName(devVpn);
        }
    }

    private static String getDevVpn(DivertTactics divertTactics) {
        String devVpn = "";
        IVpnDeviceService vpnDeviceService = ZoneReferUtil.getVpnDeviceService();
        if (vpnDeviceService.isVpnExcluded(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128))) {
            return null;
        }
        if (!vpnDeviceService.isVpnIncluded(divertTactics.getDeviceId(), divertTactics.getZoneId())) {
            LOG.info((Object)("IP is not in include list. Ip is " + divertTactics.getDivertIp()));
        } else {
            devVpn = AticDiversionUtil.getDevVpn(divertTactics, vpnDeviceService);
        }
        return devVpn;
    }

    private static boolean isBusy(String errorMessage) {
        return !StringUtils.isEmpty((String)errorMessage) && (errorMessage.contains("Info: The system is busy in collecting the current configuration. Please wait...") || errorMessage.contains("The system is busy in saving or comparing the current configuration. Please wait...") || errorMessage.contains("Info: The configuration is being recovering, please wait."));
    }

    static {
        codeList.add(200);
        codeList.add(201);
        codeList.add(204);
        codeList.add(403);
        codeList.add(414);
        codeList.add(401);
        codeList.add(408);
    }
}

