/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.sdk.bis.form.DivertBlackholeForm;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.ConfigBlackholeNp;
import java.util.List;

public class BlackholeAlarmHandler {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private IAlarmService alarmService;
    private PageSizeConfigService pageSizeConfigService;
    private IZoneService zoneService;
    private int defaultUnBolockTime = 0;

    public void blackholeAlarmReport(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240814");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmReport error: " + e.getMessage()));
        }
    }

    public void blackholeAlarmReportFailed(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240828");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmReport error: " + e.getMessage()));
        }
    }

    public void blackholeAlarmReportStopFailed(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240830");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmReport error: " + e.getMessage()));
        }
    }

    public void disableBlackholeAPIFailedAlarm(String zoneName, String deviceName, String divertIp, String vpn, String deviceIp, Long devId, int unBlockTime, String isp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[5];
            alarmParam[0] = deviceName;
            alarmParam[1] = deviceIp;
            alarmParam[2] = divertIp;
            alarmParam[3] = String.valueOf(unBlockTime) + " min";
            if ("CTCC".equals(isp)) {
                isp = "atic.bis.blackhole.api.sp.ctcc";
            }
            alarmParam[4] = isp;
            alarmObject.setAlarmId("0x0000000803240835");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName == null ? "--" : deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("disableBlackholeAPIFailedAlarm error, divertIp=" + divertIp + ", isp=" + isp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("disableBlackholeAPIFailedAlarm error: " + e.getMessage()));
        }
    }

    public void blackholeAlarmBoardReport(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmBoardReport error: " + e.getMessage()));
        }
    }

    public void blackholeAPIAlarm(String deviceName, String divertIp, String deviceIp, Long zoneId, int unblockTime, String isp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[6];
            alarmParam[0] = deviceName;
            alarmParam[1] = deviceIp;
            alarmParam[2] = divertIp;
            alarmParam[3] = String.valueOf(unblockTime) + " min";
            alarmParam[4] = "--";
            if ("CTCC".equals(isp)) {
                isp = "atic.bis.blackhole.api.sp.ctcc";
            }
            alarmParam[5] = isp;
            alarmObject.setAlarmId("0x0000000803240836");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(zoneId);
            String zoneName = "--";
            ZoneInfoForm form = null;
            if (null != zoneId) {
                form = this.zoneService.getZoneNOIpById(zoneId);
            }
            if (null != form) {
                zoneName = form.getZoneName();
            }
            alarmObject.setMoName(zoneName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAPIAlarm error, divertIp=" + divertIp + ", isp=" + isp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAPIAlarm error: " + e.getMessage()));
        }
    }

    public void blackholeAlarmBoardReportFailed(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240829");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmBoardReport error: " + e.getMessage()));
        }
    }

    public void enableBlackholeAPIFailedAlarm(String deviceName, String divertIp, String deviceIp, Long zoneId, int unBlockTime, String isp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[5];
            alarmParam[0] = deviceName;
            alarmParam[1] = deviceIp;
            alarmParam[2] = divertIp;
            alarmParam[3] = String.valueOf(unBlockTime) + " min";
            if ("CTCC".equals(isp)) {
                isp = "atic.bis.blackhole.api.sp.ctcc";
            }
            alarmParam[4] = isp;
            alarmObject.setAlarmId("0x0000000803240834");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(zoneId);
            String zoneName = "--";
            ZoneInfoForm form = null;
            if (null != zoneId) {
                form = this.zoneService.getZoneNOIpById(zoneId);
            }
            if (null != form) {
                zoneName = form.getZoneName();
            }
            alarmObject.setMoName(zoneName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("enableBlackholeAPIFailedAlarm error, divertIp=" + divertIp + ", isp=" + isp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("enableBlackholeAPIFailedAlarm error: " + e.getMessage()));
        }
    }

    public void blackholeAlarmBoardReportStopFailed(String deviceName, String divertIp, String deviceIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240831");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmBoardReport error: " + e.getMessage()));
        }
    }

    public void blackholeNpAlarmBoardReport(DivertBlackholeForm divertBlackhole, ConfigBlackholeNp configBlackholeNp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{divertBlackhole.getDeviceName(), divertBlackhole.getDeviceIP(), divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask(), String.valueOf(configBlackholeNp.getTimeLong()) + " min", "com.hs.atic.alart.blackhole.confirm.stepbystep"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(divertBlackhole.getDeviceId());
            alarmObject.setMoName(divertBlackhole.getDeviceName());
            alarmObject.setMoIp(divertBlackhole.getDeviceIP());
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport Np error, divertIp=" + divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask() + ", deviceIp=" + divertBlackhole.getDeviceIP() + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmBoardReport error: " + e.getMessage()));
        }
    }

    public void blackholeNpAlarmBoardClear(DivertBlackholeForm divertBlackhole, ConfigBlackholeNp configBlackholeNp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{divertBlackhole.getDeviceName(), divertBlackhole.getDeviceIP(), divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask(), String.valueOf(configBlackholeNp.getTimeLong()) + " min", "com.hs.atic.alart.blackhole.confirm.stepbystep"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(divertBlackhole.getDeviceId());
            alarmObject.setMoName(divertBlackhole.getDeviceName());
            alarmObject.setMoIp(divertBlackhole.getDeviceIP());
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardReport Np error, divertIp=" + divertBlackhole.getBlackIP() + "/" + divertBlackhole.getBlackMask() + ", deviceIp=" + divertBlackhole.getDeviceIP() + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("divertStopAlarm  error: " + e.getMessage()));
        }
    }

    private void findBlackHoleWhiteTime() {
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("unblockTime");
        this.defaultUnBolockTime = null != sysConfigs && !sysConfigs.isEmpty() ? Integer.parseInt(((PageSizeConfig)sysConfigs.get(0)).getSysValue()) : 30;
    }

    public void blackholeAlarmClear(String zoneName, String deviceName, String deviceIp, String divertIp, String vpn, Long devId) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{zoneName, deviceName, deviceIp, divertIp, vpn, "--"};
            alarmObject.setAlarmId("0x0000000803240814");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmClear error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmClear  error: " + e.getMessage()));
        }
    }

    public void blackholeAlarmBoardClear(String deviceName, String deviceIp, String divertIp, Long devId) {
        try {
            this.findBlackHoleWhiteTime();
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[]{deviceName, deviceIp, divertIp, String.valueOf(this.defaultUnBolockTime) + " min", "--"};
            alarmObject.setAlarmId("0x0000000803240827");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("blackholeAlarmBoardClear error, divertIp=" + divertIp + ", deviceIp=" + deviceIp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("blackholeAlarmBoardClear  error: " + e.getMessage()));
        }
    }

    public void clearBlackholeAPIAlarm(String deviceName, String deviceIp, String divertIp, Long zoneId, int unBlockTime, String isp) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            String[] alarmParam = new String[6];
            alarmParam[0] = deviceName;
            alarmParam[1] = deviceIp;
            alarmParam[2] = divertIp;
            alarmParam[3] = String.valueOf(unBlockTime) + " min";
            alarmParam[4] = "--";
            if ("CTCC".equals(isp)) {
                isp = "atic.bis.blackhole.api.sp.ctcc";
            }
            alarmParam[5] = isp;
            alarmObject.setAlarmId("0x0000000803240836");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(zoneId);
            String zoneName = "--";
            ZoneInfoForm form = null;
            if (null != zoneId) {
                form = this.zoneService.getZoneNOIpById(zoneId);
            }
            if (null != form) {
                zoneName = form.getZoneName();
            }
            alarmObject.setMoName(zoneName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("clearBlackholeAPIAlarm error, divertIp=" + divertIp + ", isp=" + isp + ". " + e.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("clearBlackholeAPIAlarm  error: " + e.getMessage()));
        }
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public PageSizeConfigService getPageSizeConfigService() {
        return this.pageSizeConfigService;
    }

    public void setPageSizeConfigService(PageSizeConfigService pageSizeConfigService) {
        this.pageSizeConfigService = pageSizeConfigService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public int getDefaultUnBolockTime() {
        return this.defaultUnBolockTime;
    }

    public void setDefaultUnBolockTime(int defaultUnBolockTime) {
        this.defaultUnBolockTime = defaultUnBolockTime;
    }
}

