/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.sdk.bis.form.BlackholeWhiteTimeForm;
import com.hs.atic.sdk.bis.service.IBlackHoleWhiteTimeService;
import com.hs.atic.util.BlackholeWhiteTimeDataBuffer;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class BlackholeWhiteThread
extends Thread {
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_BLACKHOLE);
    private boolean start = false;
    private List<BlackholeWhiteTimeForm> delBWhiteData = new ArrayList<BlackholeWhiteTimeForm>();
    private PageSizeConfigService pageSizeConfigService;
    private IBlackHoleWhiteTimeService blackHoleWhiteTimeService;
    private long defaultWhiteTime = 0L;
    private BlackholeWhiteTimeDataBuffer blackholeWhiteTimeDataBuffer;

    public boolean isExistWhiteTimeList(String ip) {
        List<BlackholeWhiteTimeForm> blackholeWhiteTimeForms;
        if (null == this.blackholeWhiteTimeDataBuffer) {
            this.blackholeWhiteTimeDataBuffer = BlackholeWhiteTimeDataBuffer.getInstance();
        }
        if ((blackholeWhiteTimeForms = this.blackholeWhiteTimeDataBuffer.getIpStateData()).isEmpty()) {
            return false;
        }
        for (BlackholeWhiteTimeForm blackholeWhiteTimeForm : blackholeWhiteTimeForms) {
            if (!blackholeWhiteTimeForm.getBlackholeIp().trim().equals(ip.trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.blackholeWhiteTimeDataBuffer = BlackholeWhiteTimeDataBuffer.getInstance();
        this.blackholeWhiteTimeDataBuffer.addIpStateData(this.blackHoleWhiteTimeService.getAllBWhiteTimeList());
        while (this.start) {
            try {
                List<BlackholeWhiteTimeForm> bForms = this.blackholeWhiteTimeDataBuffer.getIpStateData();
                if (!bForms.isEmpty()) {
                    this.findBlackHoleWhiteTime();
                    this.checkWhiteTimeOut(bForms);
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("blackholeWhiteThread error: " + e.getMessage()));
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e1) {
                this.logger.error((Object)e1.getMessage());
            }
        }
    }

    private void checkWhiteTimeOut(List<BlackholeWhiteTimeForm> blackholeWhiteTimeForms) {
        long time = System.currentTimeMillis();
        for (BlackholeWhiteTimeForm blackholeWhiteTimeForm : blackholeWhiteTimeForms) {
            if (-1L == blackholeWhiteTimeForm.getWhiteTime()) {
                if (time - blackholeWhiteTimeForm.getStopTime() < 60000L * this.defaultWhiteTime) continue;
                this.delBWhiteData.add(blackholeWhiteTimeForm);
                continue;
            }
            if (time - blackholeWhiteTimeForm.getStopTime() < blackholeWhiteTimeForm.getWhiteTime() * 60L * 1000L) continue;
            this.delBWhiteData.add(blackholeWhiteTimeForm);
        }
        if (!this.delBWhiteData.isEmpty()) {
            this.blackholeWhiteTimeDataBuffer.removeIpStateDate(this.delBWhiteData);
            this.blackHoleWhiteTimeService.batchDeleteBWhiteTime(this.delBWhiteData);
            this.delBWhiteData.clear();
        }
    }

    private void findBlackHoleWhiteTime() {
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("whiteTime");
        this.defaultWhiteTime = null != sysConfigs && !sysConfigs.isEmpty() ? Long.parseLong(((PageSizeConfig)sysConfigs.get(0)).getSysValue()) : 30L;
    }

    public PageSizeConfigService getPageSizeConfigService() {
        return this.pageSizeConfigService;
    }

    public void setPageSizeConfigService(PageSizeConfigService pageSizeConfigService) {
        this.pageSizeConfigService = pageSizeConfigService;
    }

    public long getDefaultWhiteTime() {
        return this.defaultWhiteTime;
    }

    public void setDefaultWhiteTime(long defaultWhiteTime) {
        this.defaultWhiteTime = defaultWhiteTime;
    }

    public IBlackHoleWhiteTimeService getBlackHoleWhiteTimeService() {
        return this.blackHoleWhiteTimeService;
    }

    public void setBlackHoleWhiteTimeService(IBlackHoleWhiteTimeService blackHoleWhiteTimeService) {
        this.blackHoleWhiteTimeService = blackHoleWhiteTimeService;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public BlackholeWhiteTimeDataBuffer getBlackholeWhiteTimeDataBuffer() {
        return this.blackholeWhiteTimeDataBuffer;
    }

    public void setBlackholeWhiteTimeDataBuffer(BlackholeWhiteTimeDataBuffer blackholeWhiteTimeDataBuffer) {
        this.blackholeWhiteTimeDataBuffer = blackholeWhiteTimeDataBuffer;
    }
}

