/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hs.atic.highdefense.util.RestInvoker;
import com.hs.atic.system.service.SysConfigManagerImpl;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.ProxyInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.restful.util.HttpsConnection;
import com.restful.util.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;

public class CloudCleanUtil {
    public static final String CLOUD_CLEAN_SP_CTCC = "CTCC";
    public static final String CLOUD_CLEAN_SP_HWCLOUD_CTCC = "HW_CLOUD_CTCC";
    public static final String CLOUD_CLEAN_METHOD_CTCC_ENABLE = "blockIP";
    public static final String CLOUD_CLEAN_METHOD_CTCC_DISABLE = "unblockIP";
    public static final String CLOUD_CLEAN_METHOD_CTCC_ACCOUNT = "getAccountInfo";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private static final CloudCleanUtil INSTANCE = new CloudCleanUtil();

    public static CloudCleanUtil getInstance() {
        return INSTANCE;
    }

    public void enableCloudClean4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, Map<String, String> params) {
        boolean notOperatableException = false;
        boolean hwCloudCCTCEnabled = Boolean.parseBoolean(CloudCleanUtil.getHWCloudConfig().get("enabled").toString());
        String ip = params.get("ipMask");
        if (null != params.get("ipMask")) {
            ip = ip.split("/")[0];
        }
        String paramStr = "[\"" + ip + "\"," + params.get("zone") + "," + params.get("unblockTime") + "]";
        String json = CloudCleanUtil.getInstance().connectRestful4CTCC(targetURL, accessKey, secretKey, CLOUD_CLEAN_METHOD_CTCC_ENABLE, paramStr, params.get("alias"));
        if (CloudCleanUtil.validateResult(json)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            try {
                Map obj1 = (Map)mapper.readValue(json, Map.class);
                if (obj1.containsKey("result")) {
                    Map obj2 = (Map)obj1.get("result");
                    List array = (List)obj2.get("errorList");
                    if (null != array && !array.isEmpty()) {
                        Map obj3 = (Map)array.get(0);
                        if (403 == Integer.parseInt(obj3.get("code").toString()) && hwCloudCCTCEnabled) {
                            notOperatableException = true;
                            logger.error((Object)"CTCC error code: 403 - no right to operate ");
                        }
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, hwCloudCCTCEnabled, Integer.parseInt(obj3.get("code").toString()), "");
                        logger.info((Object)("enableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj3.get("code").toString())));
                    }
                } else if (obj1.containsKey("error")) {
                    Map obj4 = (Map)obj1.get("error");
                    if (403 == Integer.parseInt(obj4.get("code").toString()) && hwCloudCCTCEnabled) {
                        notOperatableException = true;
                        logger.error((Object)"CTCC error code: 403 - no right to operate ");
                    }
                    CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, hwCloudCCTCEnabled, Integer.parseInt(obj4.get("code").toString()), "");
                    logger.info((Object)("enableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj4.get("code").toString())));
                } else {
                    logger.error((Object)("enableCloudClean4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(json)));
                    if (obj1.containsKey("code")) {
                        String code = obj1.get("code").toString();
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(code));
                    }
                }
            }
            catch (IOException io) {
                logger.error((Object)("json format error:" + io.getMessage()));
            }
        } else {
            throw new LegoCheckedException(571961L);
        }
        if (notOperatableException) {
            paramStr = "[\"" + params.get("ipMask") + "\"," + params.get("zone") + "," + params.get("unblockTime") + "]";
            json = CloudCleanUtil.handleHWCloudCTCCRequest(targetURL, CLOUD_CLEAN_METHOD_CTCC_ENABLE, paramStr);
            CloudCleanUtil.handleHWCloudCTCCReponse(CLOUD_CLEAN_SP_HWCLOUD_CTCC, json);
        }
    }

    public static void disableCloudClean4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String params, String alias) {
        String json;
        String paramStr;
        boolean hwCloudCCTCEnabled;
        boolean notOperatableException;
        block13: {
            notOperatableException = false;
            hwCloudCCTCEnabled = Boolean.parseBoolean(CloudCleanUtil.getHWCloudConfig().get("enabled").toString());
            paramStr = "[\"" + params + "\"]";
            json = CloudCleanUtil.getInstance().connectRestful4CTCC(targetURL, accessKey, secretKey, CLOUD_CLEAN_METHOD_CTCC_DISABLE, paramStr, alias);
            if (CloudCleanUtil.validateResult(json)) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
                mapper.disableDefaultTyping();
                try {
                    Map jsonObject = (Map)mapper.readValue(json, Map.class);
                    if (jsonObject.containsKey("code")) {
                        String code;
                        logger.info((Object)("jsonObject : " + jsonObject));
                        if (jsonObject.containsKey("result")) {
                            Map obj4 = (Map)jsonObject.get("result");
                            logger.info((Object)("obj4 : " + obj4));
                            if (obj4.containsKey("errorList")) {
                                List jsonArray = (List)obj4.get("errorList");
                                logger.info((Object)("jsonArray : " + jsonArray));
                                if (null != jsonArray && !jsonArray.isEmpty()) {
                                    Map obj5 = (Map)jsonArray.get(0);
                                    logger.info((Object)("obj5 : " + obj5));
                                    if (obj5.containsKey("code") && 409 == Integer.parseInt(obj5.get("code").toString())) {
                                        logger.warn((Object)("this blackhole is disabled. param : " + params));
                                        return;
                                    }
                                }
                            }
                        }
                        if (403 == Integer.parseInt(code = jsonObject.get("code").toString()) && hwCloudCCTCEnabled) {
                            notOperatableException = true;
                            logger.error((Object)"CTCC error code: 403 - no right to operate ");
                        }
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, hwCloudCCTCEnabled, Integer.parseInt(code), "");
                        logger.info((Object)("disableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(code)));
                        break block13;
                    }
                    if (jsonObject.containsKey("error")) {
                        Map obj4 = (Map)jsonObject.get("error");
                        if (403 == Integer.parseInt(obj4.get("code").toString()) && hwCloudCCTCEnabled) {
                            notOperatableException = true;
                            logger.error((Object)"CTCC error code: 403 - no right to operate ");
                        }
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, hwCloudCCTCEnabled, Integer.parseInt(obj4.get("code").toString()), "");
                        logger.info((Object)("disableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj4.get("code").toString())));
                        break block13;
                    }
                    logger.error((Object)("disableCloudClean4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(json)));
                }
                catch (IOException io) {
                    logger.error((Object)("json format error:" + io.getMessage()));
                }
            } else {
                throw new LegoCheckedException(571961L);
            }
        }
        if (hwCloudCCTCEnabled && notOperatableException) {
            json = CloudCleanUtil.handleHWCloudCTCCRequest(targetURL, CLOUD_CLEAN_METHOD_CTCC_DISABLE, paramStr);
            CloudCleanUtil.handleHWCloudCTCCReponse(CLOUD_CLEAN_SP_HWCLOUD_CTCC, json);
        }
    }

    private static Properties getHWCloudConfig() {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = CloudCleanUtil.class.getResourceAsStream("/hwCloudCTCC.properties");
            props.load(is);
        }
        catch (IOException e) {
            logger.error((Object)"File open error");
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Stream close error");
                }
            }
        }
        return props;
    }

    public Map<String, String> getAccountInfo4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String alias) {
        HashMap<String, String> accountInfo;
        block6: {
            accountInfo = null;
            String json = this.connectRestful4CTCC(targetURL, accessKey, secretKey, CLOUD_CLEAN_METHOD_CTCC_ACCOUNT, "", alias);
            if (CloudCleanUtil.validateResult(json)) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
                mapper.disableDefaultTyping();
                try {
                    Map obj1 = (Map)mapper.readValue(json, Map.class);
                    if (obj1.containsKey("code")) {
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj1.get("code").toString()));
                        Map obj2 = (Map)obj1.get("result");
                        Map obj3 = (Map)obj2.get("account");
                        String name = obj3.containsKey("name") ? obj3.get("name").toString() : "";
                        String amount = obj3.containsKey("amount") ? obj3.get("amount").toString() : "";
                        String remainAmount = obj3.containsKey("remainAmount") ? obj3.get("remainAmount").toString() : "";
                        String remainChannel = obj3.containsKey("remainChannel") ? obj3.get("remainChannel").toString() : "";
                        accountInfo = new HashMap<String, String>();
                        accountInfo.put("name", name);
                        accountInfo.put("amount", amount);
                        accountInfo.put("remainAmount", remainAmount);
                        accountInfo.put("remainChannel", remainChannel);
                        logger.info((Object)("getAccountInfo4CTCC, name=" + CloudCleanUtil.getcleanedMessage(name) + ", amount=" + amount + ", remainAmount=" + remainAmount + ", remainChannel=" + CloudCleanUtil.getcleanedMessage(remainChannel)));
                        break block6;
                    }
                    if (obj1.containsKey("error")) {
                        Map obj4 = (Map)obj1.get("error");
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(obj4.get("code").toString()));
                        logger.info((Object)("getAccountInfo4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj4.get("code").toString())));
                        break block6;
                    }
                    logger.error((Object)("getAccountInfo4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(json)));
                }
                catch (IOException io) {
                    logger.error((Object)("json format error:" + io.getMessage()));
                }
            } else {
                throw new LegoCheckedException(571961L);
            }
        }
        return accountInfo;
    }

    private String connectRestful4CTCC(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String method, String params, String alias) {
        String result = null;
        InputStream in = null;
        int statusCode = -1;
        if (!targetURL.startsWith("https")) {
            throw new LegoCheckedException(571974L);
        }
        if (StringUtils.isEmpty((CharSequence)params)) {
            params = "[]";
        }
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        ProxyInfo proxyInfo = CloudCleanUtil.getProxyInfo();
        HttpHost proxy = null;
        if (null != proxyInfo && !StringUtils.isEmpty((CharSequence)proxyInfo.getProxy()) && proxyInfo.getPort() > 0) {
            proxy = new HttpHost(proxyInfo.getProxy(), proxyInfo.getPort(), "http");
        }
        BasicCredentialsProvider credsProvider = null;
        DefaultProxyRoutePlanner routePlanner = null;
        if (null != proxyInfo && !StringUtils.isEmpty((CharSequence)proxyInfo.getUserDomain()) && !StringUtils.isEmpty((CharSequence)proxyInfo.getPwd())) {
            credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(proxyInfo.getUserDomain(), proxyInfo.getPwd()));
        }
        if (null != proxy && credsProvider == null) {
            routePlanner = new DefaultProxyRoutePlanner(proxy);
        }
        try {
            Map<String, String> authInfo = CloudCleanUtil.buildAuthInfo4CTCC(accessKey, secretKey, method, params);
            HttpPost postMethod = new HttpPost(targetURL);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            postMethod.setConfig(globalConfig);
            postMethod.setHeader("Content-type", "text/json");
            postMethod.setHeader("Json-Rpc-Tonce", authInfo.get("tonce"));
            postMethod.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
            sslcontext.init(null, new TrustManager[]{new HttpsConnection.HttpsConnectionX509TrustManager(alias)}, new SecureRandom());
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, AticConstants.getHttpSslSupportCiphersuites(), SSLConnectionSocketFactory.getDefaultHostnameVerifier()));
            if (null != routePlanner) {
                httpClientBuilder = httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            }
            if (null != credsProvider) {
                httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            if (null != proxy) {
                httpClientBuilder = httpClientBuilder.setProxy(proxy);
            }
            httpClient = httpClientBuilder.build();
            String json = "{\"method\":\"" + method + "\",\"params\":" + params + "}";
            logger.info((Object)("connectRestful4CTCC json is:" + json));
            StringEntity myEntity = new StringEntity(json, ContentType.create((String)"text/plain", (String)"UTF-8"));
            postMethod.setEntity((HttpEntity)myEntity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestful4CTCC, statusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB, "utf-8");
            }
            logger.info((Object)("connectRestful4CTCC, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (SSLException e) {
            logger.error((Object)("CloudClean diversion connectRestful4CTCC SSLException e" + e.getMessage()));
            long errorId = 0L;
            errorId = e.getMessage().contains("9600100") ? 9600100L : (e.getMessage().contains("9600200") ? 9600200L : (e.getMessage().contains("9600300") ? 9600300L : 9600400L));
            throw new LegoCheckedException(errorId);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (ClientProtocolException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("LegoCheckedException error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error((Object)"connectRestful4CTCC error");
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestful4CTCC error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"connectRestful4CTCC close in error");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)"httpClient close in error");
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)"response close in error");
                }
            }
        }
        return result;
    }

    private static String handleHWCloudCTCCRequest(String targetURL, String method, String params) {
        String hwCloudCTCCResult = "";
        try {
            String hwTargetUrl = "";
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            String httpMethod = "";
            if (CLOUD_CLEAN_METHOD_CTCC_ENABLE.equals(method)) {
                hwTargetUrl = "/v1/{domain_id}/dpp/block-ip";
                String[] paramArray = params.split(",");
                if (paramArray.length <= 2) {
                    logger.error((Object)("input params " + params + " is not in correct format!"));
                    return hwCloudCTCCResult;
                }
                paramsMap.put("ip", paramArray[0].substring(2, paramArray[0].length() - 1));
                String zone = paramArray[1].substring(0, paramArray[1].length());
                paramsMap.put("zone", CloudCleanUtil.getCTCCZoneName(zone));
                int durationInSeconds = Integer.parseInt(paramArray[2].substring(0, paramArray[2].length() - 1)) * 60;
                paramsMap.put("duration", String.valueOf(durationInSeconds));
                httpMethod = "POST";
                hwCloudCTCCResult = CloudCleanUtil.connectHWCloudCTCC(hwTargetUrl, paramsMap, httpMethod);
            } else if (CLOUD_CLEAN_METHOD_CTCC_DISABLE.equals(method)) {
                hwTargetUrl = "/v1/{domain_id}/dpp/unblock-ip?ip={ip}&observe={true}";
                paramsMap.put("ip", params.substring(2, params.length() - 2));
                paramsMap.put("observe", "true");
                httpMethod = "POST";
                hwCloudCTCCResult = CloudCleanUtil.connectHWCloudCTCC(hwTargetUrl, paramsMap, httpMethod);
            }
            logger.info((Object)("HW Cloud CTCC Response:" + hwCloudCTCCResult));
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)"params not in correct format.");
        }
        catch (LegoCheckedException lex) {
            String err = lex.getMessage();
            hwCloudCTCCResult = err.substring(err.indexOf("{"), err.indexOf("}") + 1);
            logger.error((Object)("hwCloudCTCCResult:" + hwCloudCTCCResult));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        return hwCloudCTCCResult;
    }

    private static String getCTCCZoneName(String cTCCZoneId) {
        String zoneName = "";
        switch (cTCCZoneId) {
            case "1": {
                zoneName = "CT_Backbone_All";
                break;
            }
            case "2": {
                zoneName = "CT_Backbone_DomesticExchangeEdge";
                break;
            }
            case "3": {
                zoneName = "CT_Backbone_InternationalExchangeEdge";
                break;
            }
            case "4": {
                zoneName = "CT_Backbone_ExchangeEdge";
                break;
            }
            default: {
                logger.error((Object)"input CTCC zone Id is not correct!");
            }
        }
        return zoneName;
    }

    private static void handleHWCloudCTCCReponse(String serviceProvider, String response) {
        logger.info((Object)("response:" + response));
        if (CloudCleanUtil.validateResult(response)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            try {
                Map obj1 = (Map)mapper.readValue(response, Map.class);
                if (obj1.containsKey("code")) {
                    CloudCleanUtil.dealStatusCode(serviceProvider, Integer.parseInt(obj1.get("code").toString()));
                } else if (obj1.containsKey("error_description")) {
                    logger.info((Object)("error_code:" + obj1.get("error_code").toString()));
                    logger.info((Object)("error_description:" + obj1.get("error_description").toString()));
                    CloudCleanUtil.dealStatusCode(serviceProvider, true, 0, obj1.get("error_code").toString());
                    logger.info((Object)("enableCloudClean4CTCC, statusCode=" + CloudCleanUtil.getcleanedMessage(obj1.get("error_code").toString())));
                } else {
                    logger.error((Object)("enableCloudClean4CTCC can't parse response, response=" + CloudCleanUtil.getcleanedMessage(response)));
                    if (obj1.containsKey("code")) {
                        String code = obj1.get("code").toString();
                        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_CTCC, Integer.parseInt(code));
                    }
                }
            }
            catch (IOException io) {
                logger.error((Object)("json format error:" + io.getMessage()));
            }
        }
    }

    private static ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = null;
        try {
            String json = ((SysConfigManagerImpl)ServiceContext.getInstance().getService("sysConfigMgr", SysConfigManagerImpl.class)).getSystemValue("huaweiCloudIdentity");
            if (null == json) {
                return proxyInfo;
            }
            proxyInfo = (ProxyInfo)JSONUtil.getInstance().fromJSON(json, ProxyInfo.class);
            String userDomain = StringUtils.isEmpty((CharSequence)proxyInfo.getUserDomain()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getUserDomain());
            String pwd = StringUtils.isEmpty((CharSequence)proxyInfo.getPwd()) ? "" : EncryptData.getInstanse().decryptdata(proxyInfo.getPwd());
            proxyInfo.setUserDomain(userDomain);
            proxyInfo.setPwd(pwd);
            if (StringUtils.isEmpty((CharSequence)userDomain) || StringUtils.isEmpty((CharSequence)pwd)) {
                return proxyInfo;
            }
            proxyInfo.setUserDomain(userDomain);
            proxyInfo.setPwd(pwd);
        }
        catch (IOException e) {
            logger.error((Object)"proxyInfo json error");
        }
        return proxyInfo;
    }

    private static String connectHWCloudCTCC(String targetUrl, Map<String, Object> params, String method) {
        String result = "";
        if (params == null || StringUtils.isEmpty((CharSequence)targetUrl) || StringUtils.isEmpty((CharSequence)method)) {
            logger.error((Object)"input arugment is empty.");
            return "input arugment is empty.";
        }
        int retryThreeTimes = 3;
        try {
            String bodyJson = new ObjectMapper().writeValueAsString(params);
            switch (method) {
                case "POST": {
                    if (targetUrl.contains("{ip}")) {
                        targetUrl = targetUrl.replace("{ip}", params.get("ip").toString());
                    }
                    if (targetUrl.contains("{true}")) {
                        targetUrl = targetUrl.replace("{true}", params.get("observe").toString());
                    }
                    logger.info((Object)("targetUrl: " + targetUrl));
                    logger.info((Object)("bodyJson: " + bodyJson));
                    result = RestInvoker.post((String)targetUrl, (String)bodyJson, (int)retryThreeTimes);
                    break;
                }
            }
        }
        catch (LegoCheckedException lex) {
            throw lex;
        }
        catch (IOException io) {
            logger.error((Object)("json format error:" + io.getMessage()));
        }
        catch (Exception ex) {
            throw ex;
        }
        return result;
    }

    private static Map<String, String> buildAuthInfo4CTCC(StringBuffer accessKey, StringBuffer secretKey, String method, String params) {
        HashMap<String, String> authInfo = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() * 1000L);
        StringBuffer signature = new StringBuffer();
        signature.append("tonce=").append(timestamp).append("&accesskey=").append(accessKey).append("&method=").append(method).append("&params=").append(params);
        String hmacStr = CloudCleanUtil.hmac256(signature, secretKey);
        String auth = CloudCleanUtil.getBASE64(accessKey + ":" + hmacStr);
        authInfo.put("tonce", timestamp);
        authInfo.put("auth", auth);
        return authInfo;
    }

    private static String hmac256(StringBuffer macData, StringBuffer macKey) {
        String result = null;
        Mac hmac = null;
        try {
            hmac = Mac.getInstance("HmacSHA256");
            byte[] secretByte = macKey.toString().getBytes("UTF-8");
            byte[] dataBytes = macData.toString().getBytes("UTF-8");
            SecretKeySpec secret = new SecretKeySpec(secretByte, "HMACSHA256");
            hmac.init(secret);
            byte[] doFinal = hmac.doFinal(dataBytes);
            byte[] hexB = new Hex().encode(doFinal);
            result = new String(hexB, "utf-8");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        return result;
    }

    private static void dealStatusCode(String sp, int code) {
        CloudCleanUtil.dealStatusCode(sp, false, code, null);
    }

    private static void dealStatusCode(String sp, boolean hwCloudCCTCEnabled, int code, String message) {
        logger.info((Object)("return code: " + code + ", message: " + message));
        if (-1 == code) {
            throw new LegoCheckedException(571971L);
        }
        if (200 == code) {
            return;
        }
        if (CLOUD_CLEAN_SP_CTCC.equals(sp)) {
            if (405 == code) {
                throw new LegoCheckedException(571964L);
            }
            if (401 == code) {
                throw new LegoCheckedException(571961L);
            }
            if (403 == code) {
                throw new LegoCheckedException(571962L);
            }
            if (404 == code) {
                throw new LegoCheckedException(571963L);
            }
            if (410 == code) {
                throw new LegoCheckedException(571965L);
            }
            if (415 == code) {
                throw new LegoCheckedException(571966L);
            }
            if (420 == code) {
                throw new LegoCheckedException(571967L);
            }
            if (205 == code) {
                throw new LegoCheckedException(571969L);
            }
            if (500 == code) {
                throw new LegoCheckedException(571968L);
            }
            if (430 == code) {
                throw new LegoCheckedException(571970L);
            }
            throw new LegoCheckedException(571968L);
        }
        if (CLOUD_CLEAN_SP_HWCLOUD_CTCC.equals(sp)) {
            if (message.contains("AAD.1101")) {
                throw new LegoCheckedException(577002L);
            }
            if (message.contains("AAD.1120")) {
                throw new LegoCheckedException(577003L);
            }
            if (message.contains("DPP.5301")) {
                throw new LegoCheckedException(577005L);
            }
            if (message.contains("DPP.5304")) {
                throw new LegoCheckedException(577006L);
            }
            if (message.contains("DPP.5400")) {
                logger.error((Object)577004);
                throw new LegoCheckedException(577001L);
            }
            if (message.contains("DPP.5401")) {
                throw new LegoCheckedException(577007L);
            }
            if (message.contains("DPP.5402")) {
                logger.error((Object)"ATIC\u3000error code:577008");
                throw new LegoCheckedException(577001L);
            }
            if (message.contains("DPP.5403")) {
                logger.error((Object)"ATIC\u3000error code:577009");
                throw new LegoCheckedException(577001L);
            }
            if (message.contains("DPP.5404")) {
                logger.error((Object)"ATIC\u3000error code:577010");
                throw new LegoCheckedException(577001L);
            }
            if (message.contains("DPP.5405")) {
                throw new LegoCheckedException(577011L);
            }
            if (message.contains("DPP.5406")) {
                throw new LegoCheckedException(577012L);
            }
            if (message.contains("DPP.5407")) {
                throw new LegoCheckedException(577013L);
            }
            if (message.contains("DPP.5408")) {
                throw new LegoCheckedException(577014L);
            }
            if (message.contains("DPP.5409")) {
                throw new LegoCheckedException(577015L);
            }
            if (message.contains("AAD.1200")) {
                throw new LegoCheckedException(577016L);
            }
            throw new LegoCheckedException(577001L);
        }
    }

    private static String getBASE64(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Base64.encodeBase64((byte[])str.getBytes("utf-8")), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    private static boolean validateResult(String json) {
        boolean result = false;
        if (null != json) {
            if ((json = json.trim()).startsWith("{") && json.endsWith("}") && json.contains(":")) {
                result = true;
            } else {
                logger.error((Object)("validateResult, json content is illegal, json=" + CloudCleanUtil.getcleanedMessage(json)));
                throw new LegoCheckedException(571971L);
            }
        }
        return result;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

