/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.comm.south.ssh.Ssh2Connector;
import com.huawei.atic.comm.south.telnet.TelnetConnector;
import com.huawei.atic.south.model.TelnetPara;

public class DeviceProxy {
    private static final long RESPONSE_TIME_OUT = 15L;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION);
    private Ssh2Connector sconn;
    private TelnetConnector tconn;
    private TelnetPara telPoto;

    public DeviceProxy(TelnetPara telPoto) {
        this.telPoto = telPoto;
    }

    public TelnetPara getTelPoto() {
        return this.telPoto;
    }

    public void setTelPoto(TelnetPara telPoto) {
        this.telPoto = telPoto;
    }

    public String executeCommand(String command) {
        String strRetVal = null;
        try {
            this.logger.info((Object)("execute command is " + this.getcleanedMessage(command)));
            if (null != this.tconn) {
                strRetVal = this.tconn.executeCommand(command);
            } else if (null != this.sconn) {
                strRetVal = this.sconn.executeCommand(command);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("@execCommand ERROR:" + e.getMessage()));
        }
        return strRetVal;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void close() {
        if (null != this.sconn) {
            this.logger.info((Object)"@execTelnet,EXE CLI close Telnet connected");
            this.sconn.close();
            this.sconn = null;
        }
        if (null != this.tconn) {
            this.logger.info((Object)"@execTelnet,EXE CLI close Telnet connected");
            this.tconn.close();
            this.tconn = null;
        }
    }

    public void getConnector() {
        try {
            boolean isSsh = false;
            if (null == this.telPoto) {
                this.logger.info((Object)"@execCmd,Telnet paras not config");
                throw new LegoCheckedException(660010L);
            }
            if (0 == this.telPoto.getProtocolType()) {
                this.logger.info((Object)"@execCmd,prepare use TELNET exec");
                isSsh = false;
            } else {
                this.logger.info((Object)"@execCmd,prepare use SSH exec");
                isSsh = true;
            }
            if (isSsh) {
                this.sconn = this.getSshConn(this.telPoto);
                this.sconn.executeCommand("system-view");
            } else {
                this.tconn = this.getTelnetConn(this.telPoto);
                this.tconn.executeCommand("system-view");
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("@execTelnet,EXE CLI ERROR,LegoCheckedException:" + e.getMessage()));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)("@execTelnet,EXE CLI ERROR:" + e1.getMessage()));
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
    }

    private Ssh2Connector getSshConn(TelnetPara telPotos) {
        Ssh2Connector conn = new Ssh2Connector();
        String host = telPotos.getNode().getIpAddress();
        String username = telPotos.getLoginUser();
        StringBuffer password = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPotos.getLoginPwd());
        long loginTimeOut = telPotos.getLoginTimeout();
        int port = telPotos.getPort();
        long timeOut = 15L;
        this.logger.info((Object)("@execCmd,SSH port : " + telPotos.getPort()));
        try {
            conn.setHostKey(telPotos.getHostKey());
            conn.connect(host, port, username, password, loginTimeOut, timeOut);
            this.logger.info((Object)"@execCmd,SSH connect sueccess");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("@execCmd,Can not connect device by SSH! \n LegoCheckedException:" + e.getMessage()));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)("@execCmd,Can not connect device by SSH! \n" + e1.getMessage()));
            throw new LegoCheckedException(660010L, (Throwable)e1);
        }
        return conn;
    }

    private TelnetConnector getTelnetConn(TelnetPara telPotos) {
        TelnetConnector conn = new TelnetConnector();
        String host = telPotos.getNode().getIpAddress();
        String username = telPotos.getLoginUser();
        StringBuffer password = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPotos.getLoginPwd());
        int authMode = telPotos.getAuthMode();
        long loginTimeOut = telPotos.getLoginTimeout();
        int port = telPotos.getPort();
        long timeOut = 15L;
        this.logger.info((Object)("@execCmd,Telnet port : " + telPotos.getPort()));
        try {
            conn.connect(host, port, authMode, username, password, loginTimeOut, timeOut);
            this.logger.info((Object)"@execCmd,Telnet connect success");
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("@execCmd,Can not connected by Telnet!\n" + e.getMessage()));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)("@execCmd,Can not connect device by Telnet!" + e1.getMessage()));
            throw new LegoCheckedException(660010L, (Throwable)e1);
        }
        return conn;
    }

    public Ssh2Connector getSconn() {
        return this.sconn;
    }

    public void setSconn(Ssh2Connector sconn) {
        this.sconn = sconn;
    }

    public TelnetConnector getTconn() {
        return this.tconn;
    }

    public void setTconn(TelnetConnector tconn) {
        this.tconn = tconn;
    }
}

