/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.alarm.entity.AlarmDevInfo;
import com.hs.atic.alarm.entity.AlarmZoneInfo;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.sdk.bis.form.OutboundDivertTacticsForm;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.IpStateDataBuffer;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;

public class DivertAlarmHandler {
    private static Map<Long, AlarmZoneInfo> zoneCache = new HashMap<Long, AlarmZoneInfo>();
    private static Map<String, AlarmDevInfo> deviceCache = new HashMap<String, AlarmDevInfo>();
    private static final int OUTBOUND_DIVERT_BLOCK = 1;
    private static final int OUTBOUND_DIVERT_LIMIT = 2;
    private static final int OUTBOUND_DIVERT_REDIRECT = 3;
    private static final String DIVER_CONFIG_PATH = File.separator + "vsm_conf" + File.separator + "diver" + File.separator + "diver.xml";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private IAlarmService alarmService;
    private IZoneService zoneService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IAticDeviceService aticDeviceService;
    private boolean divertAlarmSwitch = false;

    public DivertAlarmHandler() {
        this.logger.error((Object)"divertAlarmHandler getDivertAlarmConfig");
        this.getDivertAlarmConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDivertAlarmConfig() {
        String diverConfigPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + DIVER_CONFIG_PATH;
        Properties properties = new Properties();
        FileInputStream iStream = null;
        boolean isOpen = false;
        this.logger.error((Object)(" FilePath " + File.separator + DIVER_CONFIG_PATH));
        try {
            iStream = new FileInputStream(diverConfigPath);
            properties.loadFromXML(iStream);
            isOpen = Boolean.parseBoolean(properties.getProperty("atic.diverAlarm.isOpen"));
        }
        catch (FileNotFoundException e) {
            isOpen = false;
            this.logger.error((Object)" FileNotFoundException error");
        }
        catch (InvalidPropertiesFormatException e) {
            isOpen = false;
            this.logger.error((Object)" InvalidPropertiesFormatException error");
        }
        catch (IOException e) {
            isOpen = false;
            this.logger.error((Object)" IOException error");
        }
        finally {
            this.divertAlarmSwitch = isOpen;
            if (null != iStream) {
                try {
                    ((InputStream)iStream).close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"inputStream close error");
                }
            }
        }
    }

    private String[] assembleDivertAlert(DivertTactics divertTactics, String deviceIp) {
        if (null == divertTactics) {
            return new String[6];
        }
        try {
            String divertModeStr;
            Integer divertMode;
            String[] param = new String[6];
            String deviceName = divertTactics.getDeviceName();
            long zoneId = divertTactics.getZoneId();
            String zoneIp = divertTactics.getDivertIp();
            String zoneName = "";
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(zoneId);
            if (null != zoneInfo) {
                zoneName = zoneInfo.getZoneName();
            }
            if (null == (divertMode = divertTactics.getDivertMode())) {
                divertMode = 0;
            }
            switch (divertMode) {
                case 1: {
                    divertModeStr = "com.hs.atic.alart.divert.mode.manual";
                    break;
                }
                case 2: {
                    divertModeStr = "com.hs.atic.alart.divert.mode.static";
                    break;
                }
                default: {
                    divertModeStr = "com.hs.atic.alart.divert.mode.auto";
                }
            }
            param[0] = zoneName;
            param[1] = zoneIp;
            param[2] = deviceName;
            param[3] = deviceIp;
            param[4] = divertModeStr;
            param[5] = null == divertTactics.getVpnName() || "".equals(divertTactics.getVpnName()) ? "--" : divertTactics.getVpnName();
            return param;
        }
        catch (Exception e) {
            this.logger.error((Object)("assembleDivertAlert error, " + e.getMessage()));
            return new String[5];
        }
    }

    private AlarmZoneInfo getZoneFromCache(long zoneId) {
        if (zoneCache.containsKey(zoneId)) {
            return zoneCache.get(zoneId);
        }
        ZoneInfoForm form = this.zoneService.getZoneNOIpById(Long.valueOf(zoneId));
        if (null != form) {
            AlarmZoneInfo info = new AlarmZoneInfo();
            info.setMoId(form.getMoId().longValue());
            info.setZoneType(form.getZoneType().intValue());
            info.setZoneName(form.getZoneDesc());
            ZonePolicyApplyForm applyForm = this.zonePolicyApplyService.queryByZoneId(Long.valueOf(zoneId));
            if (null == applyForm) {
                info.setDefendMode(0);
            } else {
                info.setDefendMode(applyForm.getDefendMode().intValue());
            }
            zoneCache.put(zoneId, info);
            return info;
        }
        return null;
    }

    public void divertAlarmStart(DivertTactics divertTactics, String deviceIp) {
        try {
            if (!this.divertAlarmSwitch) {
                this.logger.info((Object)("start diver :zone id is " + divertTactics.getZoneId()));
                return;
            }
            String[] alarmParam = this.assembleDivertAlert(divertTactics, deviceIp);
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x0000000803240803");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            Integer divertMode = divertTactics.getDivertMode();
            if (null == divertMode) {
                divertMode = 0;
            }
            if (divertMode == 1 || divertMode == 2) {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            } else {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MINOR);
            }
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(divertTactics.getZoneId());
            if (null == zoneInfo) {
                this.logger.error((Object)("alarm is dropped for zone is null! zone id is :" + divertTactics.getZoneId()));
                return;
            }
            alarmObject.setMoId(Long.valueOf(zoneInfo.getMoId()));
            AlarmDevInfo device = this.getDeviceFromCache(deviceIp);
            if (null != device) {
                alarmObject.setExtendMoId(device.getMoId());
            } else {
                alarmObject.setExtendMoId(Long.valueOf(0L));
            }
            alarmObject.setMoName(zoneInfo.getZoneName());
            alarmObject.setMoIp(divertTactics.getDivertIp());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("divertAlarmStart error:" + this.getcleanedMessage(divertTactics.toString())));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("divertAlarmStart error: " + e.getMessage()));
        }
    }

    public void divertAlarmResume(DivertTactics divertTactics, String deviceIp) {
        try {
            if (!this.divertAlarmSwitch) {
                this.logger.info((Object)("resume diver : zone id is " + divertTactics.getZoneId()));
                return;
            }
            String[] alarmParam = this.assembleDivertAlert(divertTactics, deviceIp);
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x0000000803240803");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setAlertTime(System.currentTimeMillis());
            Integer divertMode = divertTactics.getDivertMode();
            if (null == divertMode) {
                divertMode = 0;
            }
            if (divertMode == 1 || divertMode == 2) {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            } else {
                alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MINOR);
            }
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(divertTactics.getZoneId());
            if (null == zoneInfo) {
                this.logger.error((Object)("alarm is dropped for zone is null, zoneId=" + divertTactics.getZoneId()));
                return;
            }
            alarmObject.setMoId(Long.valueOf(zoneInfo.getMoId()));
            alarmObject.setMoName(zoneInfo.getZoneName());
            alarmObject.setMoIp(divertTactics.getDivertIp());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("divertAlarmResume error:" + this.getcleanedMessage(divertTactics.toString())));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("divertStopAlarm error: " + e.getMessage()));
        }
    }

    public void divertAlarmStartFailed(DivertTactics divertTactics, String deviceIp) {
        try {
            String[] alarmParam = this.assembleDivertAlert(divertTactics, deviceIp);
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x0000000803240806");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(divertTactics.getZoneId());
            if (null == zoneInfo) {
                this.logger.error((Object)("alarm is dropped for zone is null! zone id is :" + divertTactics.getZoneId()));
                return;
            }
            alarmObject.setMoId(Long.valueOf(zoneInfo.getMoId()));
            Long deviceId = 0L;
            AlarmDevInfo device = this.getDeviceFromCache(deviceIp);
            if (null != device) {
                deviceId = device.getMoId();
            }
            alarmObject.setExtendMoId(deviceId);
            alarmObject.setMoName(zoneInfo.getZoneName());
            alarmObject.setMoIp(divertTactics.getDivertIp());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("divertAlarmStart error:" + this.getcleanedMessage(divertTactics.toString())));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("divertAlarmStart error: " + e.getMessage()));
        }
    }

    public void divertAlarmStopFailed(DivertTactics divertTactics, String deviceIp) {
        try {
            String[] alarmParam = this.assembleDivertAlert(divertTactics, deviceIp);
            AticAlarmObject alarmObject = new AticAlarmObject();
            alarmObject.setAlarmId("0x0000000803240821");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(divertTactics.getZoneId());
            if (null == zoneInfo) {
                this.logger.error((Object)("alarm is dropped for zone is null! zone id is :" + divertTactics.getZoneId()));
                return;
            }
            alarmObject.setMoId(Long.valueOf(zoneInfo.getMoId()));
            Long deviceId = 0L;
            AlarmDevInfo device = this.getDeviceFromCache(deviceIp);
            if (null != device) {
                deviceId = device.getMoId();
            }
            alarmObject.setExtendMoId(deviceId);
            alarmObject.setMoName(zoneInfo.getZoneName());
            alarmObject.setMoIp(divertTactics.getDivertIp());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                this.logger.error((Object)("divertAlarmStopFailed error:" + this.getcleanedMessage(divertTactics.toString())));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("divertAlarmStopFailed error: " + e.getMessage()));
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String getActionDesc(Integer action) {
        String actionDesc = "--";
        if (null == action) {
            return actionDesc;
        }
        switch (action) {
            case 1: {
                actionDesc = "com.hs.atic.alart.outbound.divert.block";
                break;
            }
            case 2: {
                actionDesc = "com.hs.atic.alart.outbound.divert.limit";
                break;
            }
            case 3: {
                actionDesc = "com.hs.atic.alart.outbound.divert.redirect";
                break;
            }
            default: {
                actionDesc = "--";
            }
        }
        return actionDesc;
    }

    public void divertOutboundAlarmStart(OutboundDivertTacticsForm outboundForm) {
        if (!this.divertAlarmSwitch) {
            this.logger.info((Object)("start diver :zone id is " + outboundForm.getZoneId()));
            return;
        }
        this.createDivertOutboundAlarm(outboundForm, "0x0000000803240824", FaultEnum.AlarmSeverity.MINOR, true);
    }

    public void divertOutboundAlarmResume(OutboundDivertTacticsForm outboundForm) {
        if (!this.divertAlarmSwitch) {
            this.logger.info((Object)("resume diver :zone id is " + outboundForm.getZoneId()));
            return;
        }
        this.createDivertOutboundAlarm(outboundForm, "0x0000000803240824", FaultEnum.AlarmSeverity.MINOR, false);
    }

    public void divertOutboundAlarmStartFailed(OutboundDivertTacticsForm outboundForm) {
        this.createDivertOutboundAlarm(outboundForm, "0x0000000803240825", FaultEnum.AlarmSeverity.MAJOR, true);
    }

    public void divertOutboundAlarmResumeFailed(OutboundDivertTacticsForm outboundForm) {
        this.createDivertOutboundAlarm(outboundForm, "0x0000000803240826", FaultEnum.AlarmSeverity.MAJOR, true);
    }

    private void createDivertOutboundAlarm(OutboundDivertTacticsForm outboundForm, String alarmId, FaultEnum.AlarmSeverity alertLevel, boolean isAlarm) {
        if (null == outboundForm) {
            this.logger.error((Object)("create outbound divert alarm error for outboundForm is null. alarm type=" + this.getcleanedMessage(alarmId)));
            return;
        }
        String[] alarmParam = this.assembleDivertOutboundAlert(outboundForm);
        AticAlarmObject alarmObject = new AticAlarmObject();
        alarmObject.setAlarmId(alarmId);
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setAlertLevel(alertLevel);
        alarmObject.setAlertTime(System.currentTimeMillis());
        alarmObject.setIsAlarm(Boolean.valueOf(isAlarm));
        alarmObject.setMoId(outboundForm.getZoneId());
        alarmObject.setExtendMoId(outboundForm.getDeviceId());
        alarmObject.setMoIp(outboundForm.getSourceIp());
        alarmObject.setMoName(outboundForm.getZoneDesc());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            this.logger.error((Object)("divertOutboundAlarmStart error for " + alarmId + "." + this.getcleanedMessage(outboundForm.toString())));
        }
    }

    private String[] assembleDivertOutboundAlert(OutboundDivertTacticsForm outboundForm) {
        String[] params = new String[6];
        params[0] = outboundForm.getZoneDesc();
        params[1] = outboundForm.getSourceIp();
        params[2] = outboundForm.getProtocolDesc();
        int action = outboundForm.getAction();
        params[3] = this.getActionDesc(action);
        Long threshold = outboundForm.getThreshold();
        params[4] = null != threshold && 0L != threshold && 2 == action ? String.valueOf(threshold) + "Mbps" : "--";
        String nextHop = outboundForm.getNextHop();
        params[5] = null != nextHop && !nextHop.isEmpty() && 3 == action ? nextHop : "--";
        return params;
    }

    private AlarmDevInfo getDeviceFromCache(String deviceIp) {
        if (deviceCache.containsKey(deviceIp)) {
            return deviceCache.get(deviceIp);
        }
        AticDevice device = null;
        if (null != this.aticDeviceService) {
            device = this.aticDeviceService.getDeviceByIp(deviceIp);
        }
        if (null != device) {
            AlarmDevInfo info = new AlarmDevInfo();
            info.setDevName(device.getName());
            info.setMoId(Long.valueOf(device.getMoId()));
            deviceCache.put(deviceIp, info);
            return info;
        }
        return null;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
        IpStateDataBuffer.getInstance().setAlarmService(alarmService);
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

