/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.bis.dao.DivertTacticsDao;
import com.hs.atic.bis.dao.DivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.DivertData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.service.IVpnDeviceService;
import com.huawei.atic.device.model.AticDevice;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DivertByRestThread
extends Thread {
    private static final int TEN_THOUSAND = 10000;
    private static final int FIVE_MILLION = 5000000;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private List<DivertData> nowProcessing = new ArrayList<DivertData>();
    private List<DivertTacticsForm> needDeployProcessing = new ArrayList<DivertTacticsForm>();
    private AticDevice device;
    private DivertTacticsLogDao divertTacticsLogDao;
    private DivertTacticsDao divertTacticsDao;
    private IDivertTacticsService divertTacticsService;
    private ISysOptLog sysLogService;
    private int action;

    public DivertByRestThread(AticDevice device, DivertTacticsLogDao divertTacticsLogDao, DivertTacticsDao divertTacticsDao, IDivertTacticsService divertTacticsService, int action) {
        this.setName("DivertByRestThread_" + device.getIpAddress() + "_action_" + action + "_" + System.currentTimeMillis());
        this.device = device;
        this.divertTacticsLogDao = divertTacticsLogDao;
        this.divertTacticsDao = divertTacticsDao;
        this.divertTacticsService = divertTacticsService;
        this.action = action;
        this.logger.info((Object)("construct a restful divert thread, threadName=" + this.getName()));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<DivertData> list = this.nowProcessing;
        synchronized (list) {
            this.logger.info((Object)("Restful divert thread start, threadName=" + this.getName() + ", dataSize=" + this.nowProcessing.size()));
        }
        try {
            this.startOrStopDivertFromQueue();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        this.logger.info((Object)("Restful divert thread end, threadName=" + this.getName()));
    }

    private void startOrStopDivertFromQueue() {
        List<DivertData> result = this.getBatchData();
        this.logger.info((Object)("begin to process, policy=" + this.action + ", result.size=" + result.size()));
        long startTime = System.currentTimeMillis();
        if (result.isEmpty()) {
            return;
        }
        try {
            if (9 == this.action) {
                this.stopDivert(result);
                this.logger.info((Object)("begin to process, policy=" + this.action + ", stopDivert(result) use time=" + (System.currentTimeMillis() - startTime)));
                startTime = System.currentTimeMillis();
                if (!this.needDeployProcessing.isEmpty()) {
                    int replayNum = result.get(0).getReplayNum();
                    this.logger.info((Object)("divert mode is auto, stop them, needDeployProcessing.size=" + this.needDeployProcessing.size()));
                    this.divertTacticsService.stopAndDelDivertTacticsByRestful(this.needDeployProcessing, true, replayNum);
                }
                this.logger.info((Object)("begin to process, policy=" + this.action + ", stopAndDelDivertTacticsByRestful() use time=" + (System.currentTimeMillis() - startTime)));
            } else {
                this.startDivert(result);
                this.logger.info((Object)("begin to process, policy=" + this.action + ", startDivert(result) total use time=" + (System.currentTimeMillis() - startTime)));
                startTime = System.currentTimeMillis();
                if (!this.needDeployProcessing.isEmpty()) {
                    int replayNum = result.get(0).getReplayNum();
                    this.logger.info((Object)("divert mode is auto, start them, needDeployProcessing.size=" + this.needDeployProcessing.size()));
                    this.divertTacticsService.deployAndSaveDivertTacticsByRestful(this.needDeployProcessing, replayNum, true);
                }
                this.logger.info((Object)("begin to process, policy=" + this.action + ", deployAndSaveDivertTacticsByRestful() total use time=" + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)e.getMessage());
            String remark = "firewall.exception";
            if (this.divertTacticsLogDao.queryAndDeleteLog(5000000, 10000)) {
                this.writeSyslog(result.get(0).getDevDivert(), 10000);
            }
            for (DivertData divertData : result) {
                this.divertTacticsLogDao.saveDivertLog(divertData.getDevDivert(), divertData.getPolicy(), remark, 3);
            }
        }
    }

    private void writeSyslog(DivertTactics divertTactics, int limit) {
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.divert.tactics.log.auto.delete");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(divertTactics.getClientIp());
        sysLog.setTarget("atic.bis.divert.tactics.log.auto.tactics.divertlog");
        sysLog.setTargetLocal(Boolean.valueOf(true));
        sysLog.setOperator(divertTactics.getOperator());
        sysLog.setDetail("atic.bis.divert.tactics.log.auto.delete.success");
        String[] para = new String[]{String.valueOf(limit)};
        sysLog.setDetailPara(para);
        sysLog.setResult(1);
        this.sysLogService.writeOptLog(sysLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DivertData> getBatchData() {
        List<DivertData> list = this.nowProcessing;
        synchronized (list) {
            ArrayList<DivertData> result = new ArrayList<DivertData>();
            result.addAll(this.nowProcessing);
            this.nowProcessing.clear();
            return result;
        }
    }

    private void startDivert(List<DivertData> divertDataList) {
        for (DivertData divertData : divertDataList) {
            DivertTactics divertTactics = divertData.getDevDivert();
            long deviceId = divertTactics.getDeviceId();
            String zoneIp = divertTactics.getDivertIp();
            this.logger.info((Object)("startDivert, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneIp=" + zoneIp));
            DivertTactics divertInDB = this.divertTacticsDao.getDivertTacticsByZoneIp(deviceId, zoneIp);
            if (null != divertInDB) {
                if (divertInDB.getDivertStatus() == 0 && divertTactics.getDivertMode() == 0 && divertInDB.getDivertMode() != 2) {
                    this.logger.info((Object)("start exist off divert , deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneIp=" + divertTactics.getDivertIp() + ", RAM divertMode =" + divertTactics.getDivertMode() + ", DB divertMode =" + divertInDB.getDivertMode() + ", divertStatus=" + divertInDB.getDivertStatus()));
                } else {
                    this.logger.info((Object)("Repeated divert task and return, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneIp=" + divertTactics.getDivertIp() + ", RAM divertMode =" + divertTactics.getDivertMode() + ", DB divertMode =" + divertInDB.getDivertMode() + ", divertStatus=" + divertInDB.getDivertStatus()));
                    continue;
                }
            }
            divertTactics.setOperator("system");
            String clientIp = System.getProperty("nms.server.host");
            divertTactics.setClientIp(clientIp);
            if (null != divertTactics.getDivertMode() && 0 == divertTactics.getDivertMode()) {
                DivertTacticsForm form = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                this.needDeployProcessing.add(form);
                continue;
            }
            this.logger.info((Object)"divert mode is manual, just save it.");
            IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
            if (zoneService.getById(divertTactics.getZoneId()).getZoneType() == 1) {
                IVpnDeviceService vpnDeviceService = (IVpnDeviceService)ServiceContext.getInstance().getService("vpnDeviceService", IVpnDeviceService.class);
                if (vpnDeviceService.isVpnExcluded(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128))) {
                    this.logger.info((Object)"divert mode is manual, just save it.");
                } else if (!vpnDeviceService.isVpnIncluded(divertTactics.getDeviceId(), divertTactics.getZoneId())) {
                    this.logger.info((Object)"divert mode is manual, just save it.");
                } else {
                    String vpnName = vpnDeviceService.getIncludedVpn(divertTactics.getDeviceId(), divertTactics.getZoneId(), divertTactics.getDivertIp(), Integer.valueOf(IPUtil.isIpv4((String)divertTactics.getDivertIp()) ? 32 : 128));
                    divertTactics.setVpnName(vpnName);
                }
            }
            divertTactics.setDivertStatus(0);
            DivertTacticsForm form = new DivertTacticsForm();
            AticUtil.copyProperties((Object)divertTactics, (Object)form);
            this.divertTacticsService.saveDivertTactics(form);
            DivertTacticsLogForm divertTacticsLogForm = new DivertTacticsLogForm();
            divertTacticsLogForm.setZoneId(divertTactics.getZoneId());
            divertTacticsLogForm.setDeviceId(divertTactics.getDeviceId());
            divertTacticsLogForm.setDivertIp(divertTactics.getDivertIp());
            divertTacticsLogForm.setOperator(divertTactics.getOperator());
            divertTacticsLogForm.setClientIp(divertTactics.getClientIp());
            String[] ipRange = IPUtil.getSubnetRange((String)divertTactics.getDivertIp(), (int)divertTactics.getMask());
            if (ipRange != null && ipRange.length == 2) {
                divertTacticsLogForm.setStartIp(ipRange[0]);
                divertTacticsLogForm.setEndIp(ipRange[1]);
            }
            divertTacticsLogForm.setMask(divertTactics.getMask());
            divertTacticsLogForm.setLogTime(System.currentTimeMillis() / 1000L);
            divertTacticsLogForm.setDivertMode(divertTactics.getDivertMode());
            if (null != divertTactics.getVpnName() && !divertTactics.getVpnName().isEmpty()) {
                divertTacticsLogForm.setVpnName(divertTactics.getVpnName());
            } else {
                divertTacticsLogForm.setVpnName("--");
            }
            this.divertTacticsService.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE_REST, 4, 1, "");
        }
    }

    private void stopDivert(List<DivertData> divertDataList) {
        for (DivertData divertData : divertDataList) {
            DivertTactics divertTactics = divertData.getDevDivert();
            String zoneIp = divertTactics.getDivertIp();
            this.logger.info((Object)("stopDivert, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneId=" + divertTactics.getZoneId() + ", zoneIp=" + zoneIp));
            DivertTactics divertInDB = this.divertTacticsDao.getDivertTacticsByZoneIp(divertTactics.getDeviceId(), zoneIp);
            if (divertInDB == null) {
                this.logger.info((Object)("Cannot find divertTask and return, deviceIp=" + this.getcleanedMessage(this.device.getIpAddress()) + ", zoneId=" + divertTactics.getZoneId() + ", zoneIp=" + zoneIp));
                continue;
            }
            if (divertInDB.getDivertMode() == 2) continue;
            divertInDB.setOperator("system");
            String clientIp = System.getProperty("nms.server.host");
            divertInDB.setClientIp(clientIp);
            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertInDB, (Object)new DivertTacticsForm());
            if (1 == divertTacticsForm.getDivertStatus()) {
                this.needDeployProcessing.add(divertTacticsForm);
            } else if (0 == divertTacticsForm.getDivertMode()) {
                this.divertTacticsService.tellToStopAlarm(divertTacticsForm);
            }
            if (0 != divertTacticsForm.getDivertStatus()) continue;
            this.divertTacticsService.removeDivertTacticsByRestful(divertTacticsForm);
            this.logger.info((Object)("remove the divert : " + divertTactics + " by thread."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDivertData(List<DivertData> divertDataList) {
        this.logger.info((Object)("Add divertDataList to nowProcessing, size=" + divertDataList.size()));
        List<DivertData> list = this.nowProcessing;
        synchronized (list) {
            this.nowProcessing.addAll(divertDataList);
        }
    }

    public AticDevice getDevice() {
        return this.device;
    }

    public void setDevice(AticDevice device) {
        this.device = device;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }
}

