/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.rmi.IpStateData;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class IpStateDataBuffer {
    private static IpStateDataBuffer instance;
    private static final int TASK_MAX_SIZE = 10000;
    private static final int ALARM_STOP_SIZE = 8000;
    private static final int BATCH_SIZE = 40;
    private static List<IpStateData> ipStateList;
    private static List<BlackholeNpForm> blackholeNpFormList;
    private static ReentrantLock lock;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_DIVERT);
    private boolean dropAlarmWarn = false;
    private IAlarmService alarmService;

    private IpStateDataBuffer() {
    }

    public static IpStateDataBuffer getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new IpStateDataBuffer();
            }
            IpStateDataBuffer ipStateDataBuffer = instance;
            return ipStateDataBuffer;
        }
        finally {
            lock.unlock();
        }
    }

    private AticAlarmObject generateDropDiverLogAlarm(boolean curState) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        try {
            String[] param = new String[]{String.valueOf(ipStateList.size()), String.valueOf(10000)};
            alarmObject.setMoId(Long.valueOf(1L));
            alarmObject.setMoName("system");
            alarmObject.setIsAlarm(Boolean.valueOf(curState));
            alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MAJOR);
            alarmObject.setAlarmId("0x0000000803240843");
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setAlarmParam(param);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("generateCycleAlarm error!! " + e.getMessage()));
        }
        return alarmObject;
    }

    private void sendDorpAlarmWarn(boolean curState) {
        try {
            AticAlarmObject alarmObject = this.generateDropDiverLogAlarm(curState);
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            this.logger.error((Object)("sendDorpAlarmWarn: " + e.getMessage()));
        }
        this.logger.error((Object)("sendDorpAlarmWarn warn state [ " + curState + " ]."));
    }

    private void checkDropAlarmWarn(boolean curState) {
        if (curState) {
            if (!this.dropAlarmWarn) {
                this.dropAlarmWarn = true;
                this.sendDorpAlarmWarn(curState);
            }
        } else if (this.dropAlarmWarn && ipStateList.size() < 8000) {
            this.dropAlarmWarn = false;
            this.sendDorpAlarmWarn(curState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIpStateData(List<IpStateData> list) {
        lock.lock();
        try {
            boolean curState = false;
            for (IpStateData data : list) {
                if (ipStateList.size() < 10000) {
                    ipStateList.add(data);
                    continue;
                }
                curState = true;
                this.logger.error((Object)"The size of buffer has exceed 10000, drop some divert task.");
                break;
            }
            this.checkDropAlarmWarn(curState);
        }
        finally {
            lock.unlock();
        }
    }

    public List<IpStateData> getIpStateData() {
        lock.lock();
        try {
            ArrayList<IpStateData> result = new ArrayList<IpStateData>(ipStateList.size());
            if (ipStateList.size() > 40) {
                result.addAll(ipStateList.subList(0, 40));
                ipStateList.subList(0, 40).clear();
            } else {
                result.addAll(ipStateList);
                ipStateList.clear();
            }
            ArrayList<IpStateData> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlackholeNpFormList(List<BlackholeNpForm> list) {
        lock.lock();
        try {
            for (BlackholeNpForm blackholeNpForm : list) {
                if (blackholeNpFormList.size() < 10000) {
                    blackholeNpFormList.add(blackholeNpForm);
                    continue;
                }
                this.logger.error((Object)"The size of buffer has exceed 10000, drop some blackhole np form task.");
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public List<BlackholeNpForm> getBlackholeNpFormList() {
        lock.lock();
        try {
            ArrayList<BlackholeNpForm> result = new ArrayList<BlackholeNpForm>(40);
            if (blackholeNpFormList.size() > 40) {
                result.addAll(blackholeNpFormList.subList(0, 40));
                blackholeNpFormList.subList(0, 40).clear();
            } else {
                result.addAll(blackholeNpFormList);
                blackholeNpFormList.clear();
            }
            ArrayList<BlackholeNpForm> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    public void clearAllDivertList() {
        lock.lock();
        try {
            ipStateList.clear();
            this.logger.warn((Object)"Clear all divert by user.");
        }
        finally {
            lock.unlock();
        }
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    static {
        ipStateList = new ArrayList<IpStateData>(10000);
        blackholeNpFormList = new ArrayList<BlackholeNpForm>();
        lock = new ReentrantLock();
    }
}

