/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.diversion.third.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DivertTacticsCmdMessageManager {
    private static final Map<String, Integer> CMD_MSG_MAP = new LinkedHashMap<String, Integer>();

    private DivertTacticsCmdMessageManager() {
    }

    public static Integer getErrorCode(List<String> cmdResult) {
        if (CollectionUtils.isNotEmpty(cmdResult)) {
            return DivertTacticsCmdMessageManager.getErrorCodeByMessage(cmdResult);
        }
        return 570503;
    }

    private static Integer getErrorCodeByMessage(List<String> cmdResult) {
        for (String errorMessage : cmdResult) {
            for (Map.Entry<String, Integer> entry : CMD_MSG_MAP.entrySet()) {
                String messageKey = entry.getKey();
                if (!errorMessage.contains(messageKey)) continue;
                return entry.getValue();
            }
        }
        return 1;
    }

    public static Integer getErrorCode(String errorMessage) {
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            return DivertTacticsCmdMessageManager.getErrorCodeFromMap(errorMessage);
        }
        return 570503;
    }

    private static Integer getErrorCodeFromMap(String errorMessage) {
        for (Map.Entry<String, Integer> entry : CMD_MSG_MAP.entrySet()) {
            String messageKey = entry.getKey();
            if (!errorMessage.contains(messageKey)) continue;
            return entry.getValue();
        }
        return 1;
    }

    static {
        CMD_MSG_MAP.put("Error: Invalid IP address", 571208);
        CMD_MSG_MAP.put("Error: The number of IP addresses of traffic diversion reaches limit already", 571209);
        CMD_MSG_MAP.put("Error: Please specify IP address of next hop first", 571210);
        CMD_MSG_MAP.put("Error: Traffic IP addresses conflict", 571211);
        CMD_MSG_MAP.put("Error: The IP address does not exist", 1);
        CMD_MSG_MAP.put("Error: The specified route does not exist", 1);
        CMD_MSG_MAP.put("Error: The route already exists.", 1);
        CMD_MSG_MAP.put("Error: This traffic diversion policy does not exist", 571212);
        CMD_MSG_MAP.put("Route-Distinguisher has not been set to this VPN-Instance", 571214);
        CMD_MSG_MAP.put("The specified VPN-Instance does not exist", 571215);
        CMD_MSG_MAP.put("The static route of this policy is the same as an existing one", 571216);
        CMD_MSG_MAP.put("Error:", 570503);
        CMD_MSG_MAP.put("Info: The system is busy in collecting the current configuration. Please wait...", 571217);
        CMD_MSG_MAP.put("The system is busy in saving or comparing the current configuration. Please wait...", 571217);
        CMD_MSG_MAP.put("Info: The configuration is being recovering, please wait.", 600001);
    }
}

