/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.flowspec.bgp;

import com.hs.atic.bis.model.FlowSpecBGP;
import com.hs.atic.bis.model.FlowSpecBGPPeer;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.flowspec.bgp.FlowSpecCfg;
import com.huawei.atic.flowspec.bgp.FlowSpecUtil;
import com.huawei.atic.flowspec.bgp.model.FlowSpecDivert;
import com.huawei.atic.flowspec.bgp.model.JsonInfo;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.restful.util.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class FlowSpecBuffer {
    private static FlowSpecBuffer instance = new FlowSpecBuffer();
    private FlowSpecBGP flowSpecBGP = new FlowSpecBGP();
    private List<FlowSpecBGPPeer> flowSpecBGPPeerList = new CopyOnWriteArrayList<FlowSpecBGPPeer>();
    private Map<Long, FlowSpecDivert> flowSpecDivertMap = new ConcurrentHashMap<Long, FlowSpecDivert>();
    private ReentrantLock lock = new ReentrantLock();
    private AtomicInteger count = new AtomicInteger(0);
    private int flowSpecNeighborMaxNum;
    private int flowSpecRuleMaxNum;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_FLOWSPEC);

    private FlowSpecBuffer() {
    }

    public static FlowSpecBuffer getInstance() {
        return instance;
    }

    public void init() {
        List<FlowSpecDivert> flowSpecDivert;
        List<FlowSpecBGPPeer> flowSpecBGPPeer;
        FlowSpecBGP flowSpec;
        this.flowSpecNeighborMaxNum = FlowSpecCfg.getFlowSpecNeighborMaxNum();
        this.flowSpecRuleMaxNum = FlowSpecCfg.getFlowSpecRuleMaxNum();
        while (true) {
            try {
                flowSpec = FlowSpecUtil.getFlowSpecBGPInDB();
                flowSpecBGPPeer = FlowSpecUtil.getFlowSpecBGPPeerInDB();
                flowSpecDivert = FlowSpecUtil.getFlowSpecDivertSInDB();
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("init flowspec with error" + e.getMessage()));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    this.logger.error((Object)("sleep error." + ex.getMessage()));
                }
                continue;
            }
            break;
        }
        this.setFlowSpecBGP(flowSpec);
        this.addFlowSpecBGPPeer(flowSpecBGPPeer);
        this.addFlowSpecDivert(flowSpecDivert);
        this.logger.error((Object)"FlowSpecBuffer init success");
    }

    public FlowSpecBGP getFlowSpecBGP() {
        this.lock.lock();
        try {
            FlowSpecBGP flowSpecBGP = this.flowSpecBGP;
            return flowSpecBGP;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setFlowSpecBGP(FlowSpecBGP bgp) {
        this.lock.lock();
        try {
            this.flowSpecBGP = null != bgp ? bgp : new FlowSpecBGP();
            this.increase();
            Result result = new Result();
            JsonInfo jInfo = new JsonInfo();
            result.setStatusCode(200);
            jInfo.setResultCode(0);
            jInfo.setErrDesc("ok");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            Result result2 = result;
            return result2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addFlowSpecBGPPeer(List<FlowSpecBGPPeer> list) {
        if (null == list) {
            this.logger.warn((Object)"addFlowSpecBGPPeerList is null.");
            return;
        }
        for (FlowSpecBGPPeer data : list) {
            if (this.flowSpecBGPPeerList.size() < this.flowSpecNeighborMaxNum) {
                this.flowSpecBGPPeerList.add(data);
                continue;
            }
            this.logger.error((Object)("The size of buffer has exceed " + this.flowSpecNeighborMaxNum + ", drop some blackhole task."));
            break;
        }
    }

    public Result addFlowSpecBGPPeer(FlowSpecBGPPeer data) {
        Result result = new Result();
        JsonInfo jInfo = new JsonInfo();
        if (null == data) {
            this.logger.error((Object)"BGP Peer is NULL.");
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Data is null");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        String peerIP = data.getPeerIp();
        if (!FlowSpecUtil.checkIp(peerIP)) {
            this.logger.error((Object)("Peer IP of BGP Peer is illegal, peerIP = " + peerIP));
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Data is invalid");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        if (this.flowSpecBGPPeerList.size() < this.flowSpecNeighborMaxNum) {
            boolean hasObject = false;
            int size = this.flowSpecBGPPeerList.size();
            for (int i = 0; i < size; ++i) {
                FlowSpecBGPPeer bgpPeer = this.flowSpecBGPPeerList.get(i);
                if (!FlowSpecUtil.isIpEquals(peerIP, bgpPeer.getPeerIp())) continue;
                bgpPeer.setPeerAs(data.getPeerAs());
                bgpPeer.setRouterType(data.getRouterType());
                hasObject = true;
                break;
            }
            if (!hasObject) {
                this.flowSpecBGPPeerList.add(data);
            }
            this.increase();
            result.setStatusCode(200);
            jInfo.setResultCode(0);
            jInfo.setErrDesc("ok");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
        } else {
            this.logger.error((Object)("The size of BGP Peer has exceed " + this.flowSpecNeighborMaxNum + ", drop FlowSpecBGPPeer data."));
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Quantity over limit");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
        }
        return result;
    }

    public Result removeFlowSpecBGPPeer(FlowSpecBGPPeer data) {
        Result result = new Result();
        JsonInfo jInfo = new JsonInfo();
        if (null == data) {
            this.logger.error((Object)"BGP Peer is null.");
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Data is null");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        String peerIP = data.getPeerIp();
        if (!FlowSpecUtil.checkIp(peerIP)) {
            this.logger.error((Object)("Peer IP of BGP Peer is illegal, peerIP = " + peerIP));
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Data is invalid");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        int size = this.flowSpecBGPPeerList.size();
        for (int i = 0; i < size; ++i) {
            FlowSpecBGPPeer bgpPeer = this.flowSpecBGPPeerList.get(i);
            if (!FlowSpecUtil.isIpEquals(bgpPeer.getPeerIp(), peerIP)) continue;
            this.flowSpecBGPPeerList.remove(i);
            this.increase();
            result.setStatusCode(200);
            jInfo.setResultCode(0);
            jInfo.setErrDesc("ok");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        result.setStatusCode(400);
        jInfo.setResultCode(1);
        jInfo.setErrDesc("No data exists");
        result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
        return result;
    }

    public List<FlowSpecBGPPeer> getFlowSpecBGPPeer() {
        return this.flowSpecBGPPeerList;
    }

    private void addFlowSpecDivert(List<FlowSpecDivert> list) {
        if (null == list) {
            this.logger.warn((Object)"Information is null.");
            return;
        }
        for (FlowSpecDivert data : list) {
            if (this.flowSpecDivertMap.size() < this.flowSpecRuleMaxNum) {
                this.flowSpecDivertMap.put(data.getRuleId(), data);
                continue;
            }
            this.logger.error((Object)("The size of Outbound divert has exceed " + this.flowSpecRuleMaxNum + ", drop some FlowSpecDivert."));
            break;
        }
    }

    public Result addFlowSpecDivert(FlowSpecDivert data) {
        Result result = new Result();
        JsonInfo jInfo = new JsonInfo();
        if (null == data || null == data.getRuleId()) {
            this.logger.warn((Object)"FlowSpecDivert is null or ruleId is null.");
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Data is null");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        if (this.flowSpecDivertMap.size() < this.flowSpecRuleMaxNum) {
            this.flowSpecDivertMap.put(data.getRuleId(), data);
            this.increase();
            result.setStatusCode(200);
            jInfo.setResultCode(0);
            jInfo.setErrDesc("ok");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        this.logger.error((Object)("The size of buffer has exceed " + this.flowSpecRuleMaxNum + ", drop blackhole task."));
        result.setStatusCode(400);
        jInfo.setResultCode(1);
        jInfo.setErrDesc("Quantity over limit");
        result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
        return result;
    }

    public Result removeFlowSpecDivert(FlowSpecDivert data) {
        Result result = new Result();
        JsonInfo jInfo = new JsonInfo();
        if (null == data || null == data.getRuleId()) {
            this.logger.warn((Object)"FlowSpecDivert is null or ruleId is null.");
            result.setStatusCode(400);
            jInfo.setResultCode(1);
            jInfo.setErrDesc("Data is null");
            result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
            return result;
        }
        FlowSpecDivert divert = this.flowSpecDivertMap.get(data.getRuleId());
        if (null != divert) {
            this.flowSpecDivertMap.remove(data.getRuleId());
            this.increase();
        }
        result.setStatusCode(200);
        jInfo.setResultCode(0);
        jInfo.setErrDesc("ok");
        result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
        return result;
    }

    public Result removeAllFlowSpecDivert() {
        this.flowSpecDivertMap.clear();
        this.increase();
        Result result = new Result();
        JsonInfo jInfo = new JsonInfo();
        result.setStatusCode(200);
        jInfo.setResultCode(0);
        jInfo.setErrDesc("ok");
        result.setJson(JSONUtil.getInstance().toJSONString((Object)jInfo));
        return result;
    }

    public List<FlowSpecDivert> getFlowSpecDivertList() {
        Collection<FlowSpecDivert> valueCollection = this.flowSpecDivertMap.values();
        ArrayList<FlowSpecDivert> valueList = new ArrayList<FlowSpecDivert>(valueCollection);
        return valueList;
    }

    private void increase() {
        this.count.incrementAndGet();
    }

    public int getCountAndSet() {
        return this.count.getAndSet(0);
    }
}

