/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.flowspec.bgp;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FlowSpecCfg {
    public static final int SUCCESS = 200;
    public static final int FAIL = 400;
    public static final int JSON_SUCCESS = 0;
    public static final int JSON_FAIL = 1;
    public static final String JSON_DESC_OK = "ok";
    public static final String JSON_DESC_IS_NULL = "Data is null";
    public static final String JSON_DESC_IS_INVALID = "Data is invalid";
    public static final String JSON_DESC_OVER_LIMIT = "Quantity over limit";
    public static final String JSON_DESC_NO_EXISTS = "No data exists";
    public static final String NUMBER_REGEX = "^[1-9]+[0-9]*$";
    private static final int FLOW_SPEC_NEIGHBOR_MAX_NUM_DEFAULT = 500;
    private static final int FLOW_SPEC_RULE_MAX_NUM_DEFAULT = 2048;
    private static final String CONF_SAMPLE_FILE_PATH = "ConfSampleFilePath";
    private static final String EXABGP_PID_FILE_PATH = "ExaBGPPidFilePath";
    private static final String FLOW_SPEC_NEIGHBOR_MAX_NUM = "FlowSpecNeighborMaxNum";
    private static final String FLOW_SPEC_RULE_MAX_NUM = "FlowSpecRuleMaxNum";
    private static final String FLOWSPEC_CFG = "/flowSpec.properties";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_DIVERSION_FLOWSPEC);
    private static Properties props = new Properties();

    private static String getPropertyValue(String key) {
        if (key == null || "".equals(key)) {
            throw new LegoCheckedException("cannot get value from key(" + key + ") in file.");
        }
        return props.getProperty(key);
    }

    public static String getConfSampleFilePath() {
        return FlowSpecCfg.getPropertyValue(CONF_SAMPLE_FILE_PATH);
    }

    public static String getExaBGPPidFilePath() {
        return FlowSpecCfg.getPropertyValue(EXABGP_PID_FILE_PATH);
    }

    public static int getFlowSpecNeighborMaxNum() {
        int value = 500;
        String maxFileSize = null;
        try {
            maxFileSize = FlowSpecCfg.getPropertyValue(FLOW_SPEC_NEIGHBOR_MAX_NUM);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("getFlowSpecNeighborMaxNum, happen error." + e.getMessage()));
            return value;
        }
        if (null == maxFileSize) {
            return value;
        }
        if (FlowSpecCfg.isMatcheNumber(maxFileSize.trim())) {
            value = Integer.parseInt(maxFileSize);
        }
        return value;
    }

    public static int getFlowSpecRuleMaxNum() {
        int value = 2048;
        String maxFileSize = null;
        try {
            maxFileSize = FlowSpecCfg.getPropertyValue(FLOW_SPEC_RULE_MAX_NUM);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("getFlowSpecRuleMaxNum, happen error." + e.getMessage()));
            return value;
        }
        if (null == maxFileSize) {
            return value;
        }
        if (FlowSpecCfg.isMatcheNumber(maxFileSize.trim())) {
            value = Integer.parseInt(maxFileSize);
        }
        return value;
    }

    public static boolean isMatcheNumber(String info) {
        try {
            Pattern p = Pattern.compile(NUMBER_REGEX);
            Matcher m = p.matcher(info);
            return m.find();
        }
        catch (Exception e) {
            LOGGER.error((Object)("isMatcheNumber error." + e.getMessage()));
            return false;
        }
    }

    static {
        InputStream is = null;
        try {
            is = FlowSpecCfg.class.getResourceAsStream(FLOWSPEC_CFG);
            props.load(is);
        }
        catch (IOException e) {
            LOGGER.error((Object)"File open error");
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Stream close error");
                }
            }
        }
    }
}

